/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.field;

import com.ibm.im.ims.workbench.controller.editor.ResourceEditorController;
import com.ibm.im.ims.workbench.controller.field.EditFieldController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.LogicalChildModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SysRelFieldModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ManageFieldsController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SegmentModel origSegmentModel;
    private SegmentModel clonedSegmentModel;
    private boolean hasBeenEdited = false;
    private boolean fieldDeleted = false;
    private FieldModel origFieldBeingEdited;
    private String origMapName;
    private String origCaseName;
    private int firstLevel = 1;
    private List<List<String>> redefinesGrpList;
    private boolean isReadOnly;
    public static String COMMON_FIELDS = WorkbenchModelBundle.getNoXlatLabel().getString("MANAGE_MAPPING_1");
    private static List<String> dependOnFieldDatatypes = Arrays.asList(DBDConstants.DECIMAL.toString(), DBDConstants.BYTE.toString(), DBDConstants.UBYTE.toString(), DBDConstants.SHORT.toString(), DBDConstants.USHORT.toString(), DBDConstants.INT.toString(), DBDConstants.UINT.toString(), DBDConstants.LONG.toString(), DBDConstants.ULONG.toString(), DBDConstants.PACKEDDECIMAL.toString(), DBDConstants.ZONEDDECIMAL.toString());

    public ManageFieldsController(SegmentModel segmentModel, ResourceEditorController reController, boolean isReadOnly) throws ModelException {
        this.origSegmentModel = segmentModel;
        this.clonedSegmentModel = new SegmentModel(segmentModel);
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Vector<FieldModel> getFreshFieldList(String mapName, String caseName) throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        if (mapName != null && mapName.equals(COMMON_FIELDS)) {
            retVal = this.clonedSegmentModel.getFieldList(false, true);
        } else if (mapName != null && !mapName.isEmpty()) {
            MappingModel mappingModel = this.clonedSegmentModel.getMapping(mapName);
            if (caseName != null && !caseName.isEmpty()) {
                MappingCaseModel caseModel = mappingModel.getMappingCaseModel(caseName);
                retVal = caseModel.getFieldList(true);
            }
        }
        Vector<FieldModel> sysRelFieldList = this.clonedSegmentModel.getSysRelFieldList();
        if (sysRelFieldList != null) {
            retVal.addAll(sysRelFieldList);
        }
        return retVal;
    }

    public Vector<FieldModel> getTopLevelFieldList(String mapName, String caseName) throws ModelException {
        Vector<FieldModel> fieldList = null;
        if (mapName.equals(COMMON_FIELDS)) {
            fieldList = this.clonedSegmentModel.getTopLevelFieldList();
        } else {
            MappingCaseModel mapCaseModel = this.clonedSegmentModel.getMappingCase(mapName, caseName);
            fieldList = mapCaseModel.getTopLevelFieldList();
        }
        return fieldList;
    }

    public SegmentModel getSegmentModelClone() {
        return this.clonedSegmentModel;
    }

    public FieldModel getFieldModel(String fieldAlias, String mappingName, String caseName) throws ModelException {
        Vector<FieldModel> fields = this.getFreshFieldList(mappingName, caseName);
        int j = 0;
        while (j < fields.size()) {
            FieldModel currField = fields.get(j);
            String currAlias = currField.getName();
            if (currAlias == null) {
                currAlias = "";
            }
            if (fieldAlias != null && fieldAlias.equals(currAlias)) {
                return currField;
            }
            ++j;
        }
        return null;
    }

    public String getLastChildOfField(String parentFieldAlias, String mapName, String caseName) throws ModelException {
        Vector<FieldModel> fieldList;
        String retVal = null;
        if (mapName.equals(COMMON_FIELDS)) {
            fieldList = this.clonedSegmentModel.getFieldList(false, true);
        } else {
            MappingCaseModel mapCaseModel = this.clonedSegmentModel.getMappingCase(mapName, caseName);
            fieldList = mapCaseModel.getFieldList(false);
        }
        FieldModel parentFieldModel = SegmentModel.getFieldWithAlias(fieldList, parentFieldAlias);
        Vector<FieldModel> childFields = parentFieldModel.getChildFields();
        if (childFields != null && !childFields.isEmpty()) {
            FieldModel lastChild = childFields.lastElement();
            retVal = lastChild.getName();
        }
        return retVal;
    }

    public FieldModel createNewFieldModelForAdd() {
        this.origFieldBeingEdited = null;
        return new FieldModelImpl();
    }

    public Iterator<MappingModel> getMappingList() {
        return this.clonedSegmentModel.getMappingList();
    }

    public FieldModel getFieldCloneForEdit(String fieldAlias, String mappingName, String caseName) throws ModelException {
        this.origMapName = mappingName;
        this.origCaseName = caseName;
        this.origFieldBeingEdited = this.getFieldModel(fieldAlias, mappingName, caseName);
        if (this.origFieldBeingEdited instanceof SysRelFieldModel) {
            return new SysRelFieldModel((SysRelFieldModel)this.origFieldBeingEdited);
        }
        return new FieldModelImpl((FieldModelImpl)this.origFieldBeingEdited);
    }

    public void replaceOrigFieldWithClone(String mappingName, String caseName, FieldModel clonedFieldModel) throws ModelException {
        FieldModel parentField = clonedFieldModel.getParentField();
        if (parentField == null) {
            this.replaceOrigTopLevelFieldWithClone(mappingName, caseName, clonedFieldModel);
        } else {
            this.replaceOrigSubFieldWithClone(mappingName, caseName, clonedFieldModel);
        }
        this.removeFieldFromClonedSegmentModel(this.origFieldBeingEdited, mappingName, caseName);
        if (!this.origFieldBeingEdited.getName().equals(clonedFieldModel.getName())) {
            Iterator<MappingModel> mapIter = this.clonedSegmentModel.getMappingList();
            while (mapIter.hasNext()) {
                MappingModel mappingModel = mapIter.next();
                if (!mappingModel.getDependingOnField().equals(this.origFieldBeingEdited.getName())) continue;
                mappingModel.setDependingOnField(clonedFieldModel.getName());
            }
        }
        this.hasBeenEdited = true;
    }

    private void replaceOrigTopLevelFieldWithClone(String mappingName, String caseName, FieldModel clonedFieldModel) throws ModelException {
        if (mappingName != null && !mappingName.isEmpty() && caseName != null && !caseName.isEmpty()) {
            this.clonedSegmentModel.replaceTopLevelMapField(this.origFieldBeingEdited, clonedFieldModel, mappingName, caseName);
        } else {
            this.clonedSegmentModel.replaceTopLevelField(this.origFieldBeingEdited, clonedFieldModel);
        }
    }

    private void replaceOrigSubFieldWithClone(String mappingName, String caseName, FieldModel clonedFieldModel) throws ModelException {
        if (mappingName != null && !mappingName.isEmpty() && caseName != null && !caseName.isEmpty()) {
            this.clonedSegmentModel.getMappingCase(mappingName, caseName).addField(clonedFieldModel);
        } else {
            this.clonedSegmentModel.addField(clonedFieldModel);
        }
    }

    public void removeFieldFromClonedSegmentModel(FieldModel removeField, String mappingName, String caseName) {
        if (mappingName != this.origMapName || caseName != this.origCaseName) {
            this.clonedSegmentModel.removeField(removeField, this.origMapName, this.origCaseName);
        } else {
            this.clonedSegmentModel.removeField(removeField, mappingName, caseName);
        }
    }

    public void addNewField(String mappingName, String caseName, FieldModel newField) throws ModelException {
        if (mappingName != null && !mappingName.isEmpty() && caseName != null && !caseName.isEmpty()) {
            this.clonedSegmentModel.getMappingCase(mappingName, caseName).addField(newField);
        } else {
            this.clonedSegmentModel.addField(newField);
        }
        this.hasBeenEdited = true;
    }

    public void removeField(String[] removeFieldStrs, String mappingName, String caseName) throws ModelException {
        if (removeFieldStrs != null && removeFieldStrs.length > 0) {
            ArrayList<FieldModel> selectedFields = new ArrayList<FieldModel>(removeFieldStrs.length);
            int i = 0;
            while (i < removeFieldStrs.length) {
                String fieldAlias = removeFieldStrs[i];
                FieldModel currField = this.getFieldModel(fieldAlias, mappingName, caseName);
                if (currField != null) {
                    selectedFields.add(currField);
                }
                ++i;
            }
            i = 0;
            while (i < selectedFields.size()) {
                FieldModel currField = (FieldModel)selectedFields.get(i);
                this.clonedSegmentModel.removeField(currField, mappingName, caseName);
                this.fieldDeleted = true;
                ++i;
            }
        }
        this.clonedSegmentModel.clearStartInfo(mappingName, caseName);
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public boolean fieldDeleted() {
        return this.fieldDeleted;
    }

    private boolean validateFields(Vector<FieldModel> fieldList) throws InvalidInputException, ModelException {
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            DBDConstants appDataType = currField.getAppDatatype();
            if (appDataType != null && (appDataType.equals((Object)DBDConstants.STRUCT) || appDataType.equals((Object)DBDConstants.ARRAY)) && (currField.getChildFields() == null || currField.getChildFields().isEmpty())) {
                Object[] inserts = new Object[2];
                inserts[0] = currField.getName();
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MANAGEFIELDS_CNTRL_ERR0R01", inserts));
            }
            ++i;
        }
        return true;
    }

    public void performFinish() throws ModelException {
        this.origSegmentModel.removeAllFields();
        Vector<FieldModel> fieldList = this.clonedSegmentModel.getTopLevelFieldList();
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            this.origSegmentModel.addField(currField);
            ++i;
        }
        Vector<FieldModel> sysRelFieldList = this.clonedSegmentModel.getSysRelFieldList();
        int i2 = 0;
        while (i2 < sysRelFieldList.size()) {
            FieldModel currField = sysRelFieldList.get(i2);
            this.origSegmentModel.addField(currField);
            ++i2;
        }
        this.origSegmentModel.getFieldList(true, true);
        this.origSegmentModel.clearMappingList();
        Iterator<MappingModel> mappingIt = this.clonedSegmentModel.getMappingList();
        while (mappingIt.hasNext()) {
            this.origSegmentModel.addNewMappingModel(mappingIt.next());
        }
    }

    public void validateImsNameAndAliasInput(FieldModel clonedFieldModel) throws ModelException, InvalidInputException {
        FieldModel existingField = this.clonedSegmentModel.getUnmappedFieldWithDupImsNameOrAlias(clonedFieldModel, this.origFieldBeingEdited);
        if (existingField == null) {
            this.clonedSegmentModel.checkMappedFieldWithDupImsNameOrAlias(clonedFieldModel, this.origFieldBeingEdited);
        }
        if (existingField == null) {
            existingField = this.clonedSegmentModel.getSysRelFieldWithDupImsNameOrAlias(clonedFieldModel, this.origFieldBeingEdited);
        }
        if (existingField != null) {
            String editedImsName = clonedFieldModel.getImsName();
            String existingImsName = existingField.getImsName();
            if (editedImsName != null && existingImsName != null && !editedImsName.isEmpty() && !existingImsName.isEmpty() && editedImsName.equals(existingImsName)) {
                Object[] inserts = new Object[]{existingField.getName()};
                String[] attrs = new String[]{"IMS_NAME"};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_6", inserts), attrs);
            }
            String editedAlias = clonedFieldModel.getName();
            String existingAlias = existingField.getName();
            if (editedAlias != null && existingAlias != null && !editedAlias.isEmpty() && !existingAlias.isEmpty() && editedAlias.equals(existingAlias)) {
                Object[] inserts = new Object[]{existingField.getName()};
                String[] attrs = new String[]{"ALIAS"};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_5", inserts), attrs);
            }
        }
    }

    public InvalidInputException validateDependsOn(FieldModel clonedFieldModel, String mapName, String caseName, EditFieldController efController, Object newValue) throws ModelException {
        String dependsOnField;
        InvalidInputException retVal = null;
        if (!ManageFieldsController.canFieldBeDependedOn(clonedFieldModel, DBDConstants.fromValue((String)newValue)) && (dependsOnField = this.getDependsOnField(clonedFieldModel, mapName, caseName)) != null) {
            Object[] inserts = new Object[]{clonedFieldModel.getName(), dependsOnField};
            retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_25", inserts));
        }
        return retVal;
    }

    public InvalidInputException validateDependsOnAndAppDataType(FieldModel clonedFieldModel, String mapName, String caseName, Object newValue) throws ModelException {
        String dependsOnField;
        InvalidInputException retVal = null;
        Integer scale = Integer.valueOf((String)newValue);
        if (!ManageFieldsController.canFieldBeDependedOn(scale, clonedFieldModel.getAppDatatype()) && (dependsOnField = this.getDependsOnField(clonedFieldModel, mapName, caseName)) != null) {
            Object[] inserts = new Object[]{clonedFieldModel.getName(), dependsOnField};
            retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_25", inserts));
        }
        return retVal;
    }

    public InvalidInputException validateChangeArrayStructDatatype(FieldModel clonedFieldModel, String mapName, String caseName, EditFieldController efController, Object newValue) throws ModelException {
        InvalidInputException retVal = null;
        String appDataType = (String)newValue;
        if (!(clonedFieldModel.getChildFields() == null || clonedFieldModel.getChildFields().isEmpty() || appDataType.equals(DBDConstants.ARRAY.toString()) || appDataType.equals(DBDConstants.STRUCT.toString()))) {
            retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_28"));
        }
        return retVal;
    }

    public InvalidInputException validateSecondaryIndex(FieldModel fieldModel) {
        InvalidInputException retVal = null;
        String fieldName = fieldModel.getImsName();
        SegmentModel rootSegmentModel = this.origSegmentModel.getDbdModel().getRootSegment();
        if (this.isSecondaryIndexSearchField(rootSegmentModel, fieldName)) {
            fieldModel.setIMSFieldSelected(true);
            Object[] inserts = new Object[]{fieldModel.getImsNameOrAlias()};
            if (inserts[0] == null || ((String)inserts[0]).isEmpty()) {
                inserts[0] = fieldName;
            }
            retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_26", inserts));
        }
        return retVal;
    }

    private boolean isSecondaryIndexSearchField(SegmentModel segmentModel, String fieldName) {
        List<SegmentModel> segmentList;
        boolean retVal = false;
        List<LogicalChildModel> lchildList = segmentModel.getLogicalChildList();
        if (lchildList != null) {
            ListIterator<LogicalChildModel> lchildIter = lchildList.listIterator();
            while (lchildIter.hasNext()) {
                LogicalChildModel currentLchild = lchildIter.next();
                if (!this.foundSearchField(currentLchild, fieldName)) continue;
                retVal = true;
                break;
            }
        }
        if (!retVal && (segmentList = segmentModel.getChildSegments()) != null) {
            ListIterator<SegmentModel> segIter = segmentList.listIterator();
            while (segIter.hasNext()) {
                SegmentModel currentSegment = segIter.next();
                if (!this.isSecondaryIndexSearchField(currentSegment, fieldName)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private boolean foundSearchField(LogicalChildModel lchildModel, String fieldName) {
        boolean retVal = false;
        List<String> srchList = lchildModel.getSearch();
        if (srchList != null) {
            for (String srch : srchList) {
                if (!srch.equals(fieldName)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public static boolean canFieldBeDependedOn(FieldModel fieldModel, DBDConstants dataType) {
        boolean retVal = dependOnFieldDatatypes.contains(dataType.name());
        Integer scale = fieldModel.getScale();
        if (retVal && dataType.equals((Object)DBDConstants.DECIMAL) && (scale == null || scale > 0)) {
            retVal = false;
        }
        return retVal;
    }

    public static boolean canFieldBeDependedOn(Integer scale, DBDConstants dataType) {
        boolean retVal = dependOnFieldDatatypes.contains(dataType.name());
        if (retVal && dataType.equals((Object)DBDConstants.DECIMAL) && (scale == null || scale > 0)) {
            retVal = false;
        }
        return retVal;
    }

    private String getDependsOnField(FieldModel fieldModel, String mapName, String caseName) throws ModelException {
        String retVal = null;
        Vector<FieldModel> fieldList = this.getFreshFieldList(mapName, caseName);
        if (fieldList != null) {
            String fieldName = this.getOriginalFieldAlias();
            for (FieldModel currentField : fieldList) {
                String currentFieldName = currentField.getName();
                String currentDependsOn = currentField.getDependsOn();
                if (currentFieldName.equals(fieldName) || currentDependsOn == null || !currentDependsOn.equals(fieldName)) continue;
                retVal = currentFieldName;
                break;
            }
        }
        return retVal;
    }

    public void validateSeqInput(FieldModel clonedFieldModel) throws InvalidInputException, ModelException {
        FieldModel existingSeqField;
        DBDConstants seqVal = clonedFieldModel.getSeqType();
        if (seqVal != null && (existingSeqField = this.clonedSegmentModel.getSecondSeqField(this.origFieldBeingEdited)) != null) {
            Object[] inserts = new Object[]{existingSeqField.getImsNameOrAlias()};
            String[] attrs = new String[]{"SEQUENCE"};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("IOGWB0074", inserts), attrs);
        }
    }

    public void validateCKField(FieldModel clonedFieldModel) throws InvalidInputException, ModelException {
        int concatKeyLength;
        int length;
        int start;
        if (clonedFieldModel.getImsName() != null && clonedFieldModel.getImsName().startsWith("/CK") && (start = clonedFieldModel.getStartPos()) + (length = clonedFieldModel.getBytes()) - 1 > (concatKeyLength = this.getConcatenatedKeyLength(this.origSegmentModel, 0))) {
            Object[] inserts = new Object[]{start, length, clonedFieldModel.getImsName(), concatKeyLength};
            String[] attrs = new String[]{"START", "LENGTH"};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_38", inserts), attrs);
        }
    }

    public InvalidInputException validateFieldPartOfRedefinesGroup(FieldModel fieldModel) throws ModelException {
        InvalidInputException retVal = null;
        Vector<FieldModel> allFields = this.getFreshFieldList(this.origMapName, this.origCaseName);
        List<List<String>> redefinesGroupList = this.buildRedefinesGroupList(allFields);
        if (redefinesGroupList != null) {
            String[] currRedefinesGrp = this.getRedefinesGroup(fieldModel.getName(), redefinesGroupList);
            boolean inQuestionIsRedefined = false;
            if (currRedefinesGrp != null) {
                String nameInQuestion = fieldModel.getName();
                int i = 0;
                while (i < currRedefinesGrp.length) {
                    FieldModel currFieldModel = this.getFieldModel(currRedefinesGrp[i], this.origMapName, this.origCaseName);
                    if (nameInQuestion.equals(currFieldModel.getRedefines())) {
                        inQuestionIsRedefined = true;
                        break;
                    }
                    ++i;
                }
                if (inQuestionIsRedefined) {
                    Object[] inserts = new Object[]{nameInQuestion};
                    retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_15", inserts));
                }
            }
        }
        return retVal;
    }

    private int getConcatenatedKeyLength(SegmentModel segmentModel, int keyLength) throws ModelException {
        if (segmentModel != null) {
            FieldModel sequenceField = segmentModel.getSeqField();
            if (sequenceField != null) {
                keyLength += sequenceField.getBytes();
            }
            return this.getConcatenatedKeyLength(segmentModel.getParent(), keyLength);
        }
        return keyLength;
    }

    public void validateDependson(FieldModel currentFldModel) throws InvalidInputException {
        String dependsOnStr;
        DBDConstants adt = currentFldModel.getAppDatatype();
        if (adt == DBDConstants.ARRAY && (dependsOnStr = currentFldModel.getDependsOn()) != null && !dependsOnStr.isEmpty() && this.isRedefiningFld(currentFldModel)) {
            String[] attrs = new String[]{"DEPENDSON"};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_19"), attrs);
        }
    }

    private boolean isRedefiningFld(FieldModel currentFldModel) {
        if (currentFldModel != null) {
            if (currentFldModel.getRedefines() != null) {
                return true;
            }
            FieldModel parentFldModel = currentFldModel.getParentField();
            if (this.isRedefiningFld(parentFldModel)) {
                return true;
            }
        }
        return false;
    }

    public String getOriginalFieldAlias() {
        String retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = this.origFieldBeingEdited.getName();
        }
        return retVal;
    }

    public String getOriginalFieldImsName() {
        String retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = this.origFieldBeingEdited.getImsName();
        }
        return retVal;
    }

    public String getOriginalMapName() {
        String retVal = "";
        if (this.origMapName != null) {
            retVal = this.origMapName;
        }
        return retVal;
    }

    public String getOriginalCaseName() {
        return this.origCaseName;
    }

    public String getOriginalParentName() {
        FieldModel parentField;
        String retVal = "";
        if (this.origFieldBeingEdited != null && (parentField = this.origFieldBeingEdited.getParentField()) != null) {
            retVal = parentField.getName();
        }
        return retVal;
    }

    public String getOriginalFollowsField() {
        String retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = this.origFieldBeingEdited.getStartAfter();
        }
        return retVal;
    }

    public String getOriginalStartPos() {
        String retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = String.valueOf(this.origFieldBeingEdited.getStartPos());
        }
        return retVal;
    }

    public String getOriginalAlias() {
        String retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = this.origFieldBeingEdited.getName();
        }
        return retVal;
    }

    public DBDConstants getOriginalDataType() {
        DBDConstants retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = this.origFieldBeingEdited.getAppDatatype();
        }
        return retVal;
    }

    private void validateDependsonPos(Vector<FieldModel> fieldList) throws InvalidInputException, ModelException {
        int i = 0;
        while (i < fieldList.size()) {
            String dependedonFldName;
            FieldModel currField = fieldList.get(i);
            DBDConstants appDataType = currField.getAppDatatype();
            if (appDataType != null && appDataType.equals((Object)DBDConstants.ARRAY) && (dependedonFldName = currField.getDependsOn()) != null && !dependedonFldName.isEmpty()) {
                boolean found = false;
                String dArrayFieldName = currField.getName();
                int j = 0;
                while (j < fieldList.size() && !found) {
                    FieldModel checkingField = fieldList.get(j);
                    if (checkingField.getName().equals(dependedonFldName)) {
                        found = true;
                    } else if (checkingField.getName().equals(dArrayFieldName)) {
                        found = true;
                        Object[] inserts = new Object[]{dependedonFldName, currField.getImsNameOrAlias()};
                        String[] attrs = new String[]{"DEPENDSON"};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_18", inserts), attrs);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static boolean isFieldDynamicLength(FieldModel fld) {
        DBDConstants appDataType = fld.getAppDatatype();
        if (appDataType != null) {
            Integer minOccurs = fld.getMinOccurs();
            Integer maxOccurs = fld.getMaxOccurs();
            if (fld.getAppDatatype().equals((Object)DBDConstants.ARRAY) && minOccurs != null && maxOccurs != null && minOccurs.intValue() != maxOccurs.intValue()) {
                return true;
            }
            if ((fld.getAppDatatype().equals((Object)DBDConstants.STRUCT) || fld.getAppDatatype().equals((Object)DBDConstants.ARRAY)) && fld.getMaxBytes() > 0) {
                return true;
            }
        }
        return false;
    }

    public void semanticCheck(Vector<FieldModel> allFields) throws InvalidInputException, ModelException {
        this.validateFields(allFields);
        this.validateDependsonPos(allFields);
        this.validateTopLevelFieldsSize(allFields);
        this.validateIMSFieldWithStartInfo(allFields);
    }

    private void validateTopLevelFieldsSize(Vector<FieldModel> allFields) throws ModelException, InvalidInputException {
        Vector<FieldModel> topLevelFields = this.getSegmentModelClone().getTopLevelFieldList();
        int lengthSegmentModel = this.clonedSegmentModel.getMaxBytes();
        int i = 0;
        while (i < topLevelFields.size()) {
            FieldModel curField = (FieldModel)topLevelFields.get(i);
            if (curField.getStartPos() != 0) {
                int startPos;
                int currentFieldSize = this.getSize(curField);
                int lengthSoFar = currentFieldSize + (startPos = curField.getStartPos()) - 1;
                if (lengthSegmentModel < lengthSoFar) {
                    Object[] inserts = new Object[]{curField.getName(), lengthSoFar, lengthSegmentModel, this.clonedSegmentModel.getName()};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MANAGEFIELDS_CNTRL_ERR0R02", inserts), 4);
                }
                if (curField.getMaxBytes() > 0) {
                    ArrayList<FieldModel> tailFields = new ArrayList<FieldModel>();
                    this.getTopLevelTailFields(topLevelFields, tailFields, curField.getName(), i);
                    int j = 0;
                    while (j < tailFields.size()) {
                        FieldModel curTailField = (FieldModel)tailFields.get(j);
                        int size = -1;
                        boolean isBytes = true;
                        if (curTailField.getBytes() > 0) {
                            size = curTailField.getBytes();
                        } else {
                            size = curTailField.getMaxBytes();
                            isBytes = false;
                        }
                        if (size + lengthSoFar > lengthSegmentModel) {
                            Object[] inserts_tail = new Object[]{curTailField.getName(), String.valueOf(size), this.clonedSegmentModel.getName(), String.valueOf(lengthSegmentModel), isBytes ? WorkbenchModelBundle.getError().getString("INFOR_BYTE") : WorkbenchModelBundle.getError().getString("INFOR_MAXBYTE")};
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)WorkbenchModelBundle.getError().getString("EISRC25"), (String)WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_35", inserts_tail));
                            break;
                        }
                        lengthSoFar += size;
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void getTopLevelTailFields(List<FieldModel> topLevelFields, List<FieldModel> tailFields, String name, int curPos) {
        int i = curPos + 1;
        while (i < topLevelFields.size()) {
            curPos = i;
            FieldModel curField = topLevelFields.get(i);
            if (curField.getStartAfter() != null && curField.getStartAfter().equals(name)) {
                tailFields.add(curField);
                name = curField.getName();
                break;
            }
            ++i;
        }
        if (curPos + 1 >= topLevelFields.size()) {
            return;
        }
        this.getTopLevelTailFields(topLevelFields, tailFields, name, curPos);
    }

    public int getSize(FieldModel field) {
        if (field == null) {
            return -1;
        }
        return field.getBytes() > 0 ? field.getBytes() : field.getMaxBytes();
    }

    public String[] addStartAfterFields(String[] selectedFields, String mapName, String caseName) throws ModelException {
        FieldModel firstField;
        Vector<String> updatedFieldList = new Vector<String>();
        updatedFieldList.add(selectedFields[0]);
        if (mapName.equals(COMMON_FIELDS)) {
            firstField = this.clonedSegmentModel.getFieldWithAlias(selectedFields[0], null);
        } else {
            MappingCaseModel mapCaseModel = this.clonedSegmentModel.getMappingCase(mapName, caseName);
            firstField = mapCaseModel.getFieldWithAlias(selectedFields[0], null);
        }
        if (firstField != null) {
            this.addStartAfterFieldsToSubSequenceMoveFields(updatedFieldList, firstField);
        }
        this.addSelectedFields(updatedFieldList, selectedFields);
        return updatedFieldList.toArray(new String[updatedFieldList.size()]);
    }

    private void addSelectedFields(Vector<String> updatedFieldList, String[] selectedFields) {
        int i = 1;
        while (i < selectedFields.length) {
            String currentFieldName = selectedFields[i];
            if (!updatedFieldList.contains(currentFieldName)) {
                updatedFieldList.add(currentFieldName);
            }
            ++i;
        }
    }

    private void addStartAfterFieldsToSubSequenceMoveFields(Vector<String> updatedFieldList, FieldModel fieldModel) throws ModelException {
        FieldModel parentField = fieldModel.getParentField();
        String headFieldName = fieldModel.getName();
        Vector<FieldModel> peerFields = null;
        peerFields = parentField != null ? fieldModel.getChildFields() : this.clonedSegmentModel.getTopLevelFieldList();
        Vector<FieldModel> localStartAfterFields = new Vector<FieldModel>();
        if (peerFields != null) {
            FieldModel currentField;
            int i = 0;
            while (i < peerFields.size()) {
                currentField = peerFields.get(i);
                String startAfter = currentField.getStartAfter();
                if (startAfter != null && startAfter.equals(headFieldName)) {
                    updatedFieldList.add(currentField.getName());
                    localStartAfterFields.add(currentField);
                }
                ++i;
            }
            i = 0;
            while (i < localStartAfterFields.size()) {
                currentField = (FieldModel)localStartAfterFields.get(i);
                this.addStartAfterFieldsToSubSequenceMoveFields(updatedFieldList, currentField);
                ++i;
            }
        }
    }

    public void validateMoveOrRemoveFieldsSelection(String[] selectedItems, String mapName, String caseName, String actionType) throws ModelException, InvalidInputException {
        FieldModel firstField;
        List<FieldModel> topLevelFields = null;
        String firstFieldAlias = selectedItems[0];
        if (firstFieldAlias != null && !firstFieldAlias.isEmpty() && (firstField = this.getFieldModel(firstFieldAlias, mapName, caseName)) != null) {
            int baseLevel;
            if (mapName != null && mapName.equals(COMMON_FIELDS)) {
                topLevelFields = this.clonedSegmentModel.getTopLevelFieldList();
                if (firstField.getParentField() == null) {
                    this.validateControlField(selectedItems, topLevelFields, firstField, actionType);
                }
            } else if (mapName != null && !mapName.isEmpty()) {
                MappingModel mappingModel = this.clonedSegmentModel.getMapping(mapName);
                if (caseName != null && !caseName.isEmpty()) {
                    MappingCaseModel caseModel = mappingModel.getMappingCaseModel(caseName);
                    Vector<FieldModel> mapCaseFields = caseModel.getFieldList(true);
                    topLevelFields = this.getMapCaseTopLevelFields(mapCaseFields);
                }
            }
            if ((baseLevel = this.getFieldLevel(firstFieldAlias, topLevelFields, this.firstLevel)) == 0 && !firstField.isSysRelField()) {
                Object[] inserts = new Object[]{firstFieldAlias};
                String[] attrs = new String[]{""};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
            }
            FieldModel baseParent = firstField.getParentField();
            Vector<FieldModel> basePeerFields = baseParent != null ? baseParent.getChildFields() : topLevelFields;
            String[] basePeerList = new String[basePeerFields.size()];
            int i = 0;
            while (i < basePeerFields.size()) {
                basePeerList[i] = ((FieldModel)basePeerFields.get(i)).getName();
                ++i;
            }
            List<List<String>> redefinesGroupList = this.buildRedefinesGroupList(basePeerFields);
            this.validateRedefinesGroup(firstFieldAlias, redefinesGroupList, selectedItems, actionType);
            int j = 1;
            while (j < selectedItems.length) {
                FieldModel selectedField;
                String selectedFieldAlias = selectedItems[j];
                if (selectedFieldAlias != null && !selectedFieldAlias.isEmpty() && (selectedField = this.getFieldModel(selectedFieldAlias, mapName, caseName)) != null) {
                    int currLevel = this.getFieldLevel(selectedFieldAlias, topLevelFields, this.firstLevel);
                    if (currLevel == 0) {
                        Object[] inserts = new Object[]{selectedFieldAlias};
                        String[] attrs = new String[]{""};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
                    }
                    FieldModel currParent = selectedField.getParentField();
                    List<FieldModel> currPeerFields = currParent != null ? currParent.getChildFields() : topLevelFields;
                    this.validateMoveOrRemoveField(currLevel, selectedField, baseLevel, basePeerList, currPeerFields, selectedItems, redefinesGroupList, actionType);
                }
                ++j;
            }
        }
    }

    private void validateControlField(String[] selectedItems, List<FieldModel> topFieldModels, FieldModel firstField, String actionType) throws ModelException, InvalidInputException {
        int firstFieldLocation = topFieldModels.indexOf(firstField);
        if (firstFieldLocation >= 0) {
            int i = firstFieldLocation;
            while (i < topFieldModels.size()) {
                String currentFieldName = topFieldModels.get(i).getName();
                int j = 0;
                while (j < selectedItems.length) {
                    String mapName;
                    if (currentFieldName.equals(selectedItems[j]) && (mapName = this.getMapDependsOnThisField(currentFieldName)) != null) {
                        String[] attrs = new String[]{};
                        Object[] inserts = new Object[]{currentFieldName, actionType.equals("MOVE") ? WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED") : WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED"), mapName};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_5", inserts), attrs, 12);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private String getMapDependsOnThisField(String fieldName) {
        String retVal = null;
        Iterator<MappingModel> mapIter = this.clonedSegmentModel.getMappingList();
        while (mapIter.hasNext()) {
            MappingModel mapModel = mapIter.next();
            String controlFieldName = mapModel.getDependingOnField();
            if (!controlFieldName.equals(fieldName)) continue;
            retVal = mapModel.getName();
            break;
        }
        return retVal;
    }

    private void validateRedefinesGroup(String selectedFieldAlias, List<List<String>> redefinesGroupList, String[] selectedItems, String actionType) throws InvalidInputException {
        String[] redefinesGroup = this.getRedefinesGroup(selectedFieldAlias, redefinesGroupList);
        if (redefinesGroup != null) {
            int i = 0;
            while (i < redefinesGroup.length) {
                String currFieldName = redefinesGroup[i];
                if (!this.isFieldInList(currFieldName, selectedItems)) {
                    Object[] inserts = new Object[3];
                    inserts[0] = selectedFieldAlias;
                    if (actionType.equals("MOVE")) {
                        inserts[1] = WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED");
                        inserts[2] = WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVING");
                    } else {
                        inserts[1] = WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED");
                        inserts[2] = WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVING");
                    }
                    String[] attrs = new String[]{""};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_2", inserts), attrs, 12);
                }
                ++i;
            }
        }
    }

    public String[] getRedefinesGroup(String selectedFieldAlias, List<List<String>> redefinesGroupList) {
        List<Object> currRedefinesGrp = new ArrayList();
        int i = 0;
        while (i < redefinesGroupList.size()) {
            currRedefinesGrp = redefinesGroupList.get(i);
            if (currRedefinesGrp != null) {
                String[] fieldList = new String[currRedefinesGrp.size()];
                if (selectedFieldAlias != null && this.isFieldInList(selectedFieldAlias, fieldList = currRedefinesGrp.toArray(fieldList))) {
                    return fieldList;
                }
            }
            ++i;
        }
        return null;
    }

    public List<List<String>> buildRedefinesGroupList(List<FieldModel> currPeerFields) {
        if (this.redefinesGrpList == null) {
            this.redefinesGrpList = new ArrayList<List<String>>();
            List<Object> currRedefinesGrp = new ArrayList();
            int i = 0;
            while (i < currPeerFields.size()) {
                FieldModel currField = currPeerFields.get(i);
                String currFieldName = currField.getName();
                String redefinedFldName = currField.getRedefines();
                if (redefinedFldName != null && !redefinedFldName.isEmpty()) {
                    boolean found = false;
                    int j = 0;
                    while (j < this.redefinesGrpList.size() && !found) {
                        currRedefinesGrp = this.redefinesGrpList.get(j);
                        if (currRedefinesGrp != null) {
                            String[] fieldList = new String[currRedefinesGrp.size()];
                            if (this.isFieldInList(redefinedFldName, fieldList = currRedefinesGrp.toArray(fieldList))) {
                                found = true;
                                if (!this.isFieldInList(currFieldName, fieldList)) {
                                    currRedefinesGrp.add(currFieldName);
                                }
                            }
                        }
                        ++j;
                    }
                    if (!found) {
                        ArrayList<String> newRedefinesGrp = new ArrayList<String>();
                        newRedefinesGrp.add(currFieldName);
                        newRedefinesGrp.add(redefinedFldName);
                        this.redefinesGrpList.add(newRedefinesGrp);
                    }
                }
                ++i;
            }
        }
        return this.redefinesGrpList;
    }

    public void clearRedefineGroups() {
        this.redefinesGrpList = null;
    }

    private List<FieldModel> getMapCaseTopLevelFields(List<FieldModel> allFields) {
        Vector<FieldModel> topLevelFieldList = new Vector<FieldModel>();
        int baseLevel = this.getFieldLevel(allFields.get(0).getName(), allFields, this.firstLevel);
        int i = 0;
        while (i < allFields.size()) {
            FieldModel currField = allFields.get(i);
            int currFieldLevel = this.getFieldLevel(allFields.get(i).getName(), allFields, this.firstLevel);
            if (currFieldLevel == baseLevel) {
                topLevelFieldList.add(currField);
            }
            ++i;
        }
        return topLevelFieldList;
    }

    private void validateMoveOrRemoveField(int currFieldLevel, FieldModel selectedField, int baseLevel, String[] basePeerList, List<FieldModel> currPeerFields, String[] selectedItems, List<List<String>> redefinesGroupList, String actionType) throws ModelException, InvalidInputException {
        String selectedFieldName = selectedField.getName();
        if (currFieldLevel == baseLevel) {
            if (!this.isFieldInList(selectedFieldName, basePeerList)) {
                Object[] inserts = new Object[3];
                inserts[0] = selectedFieldName;
                inserts[1] = actionType.equals("MOVE") ? WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED") : WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED");
                String[] attrs = new String[]{""};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_3", inserts), attrs, 12);
            }
            this.validateRedefinesGroup(selectedFieldName, redefinesGroupList, selectedItems, actionType);
        } else if (currFieldLevel > baseLevel) {
            int currLevel = currFieldLevel;
            FieldModel currField = selectedField;
            do {
                currField = currField.getParentField();
            } while (--currLevel > baseLevel && currField != null);
            String baseAncestorName = currField.getName();
            if (!this.isFieldInList(baseAncestorName, basePeerList)) {
                Object[] inserts = new Object[3];
                inserts[0] = selectedFieldName;
                inserts[2] = selectedItems[0];
                inserts[1] = actionType.equals("MOVE") ? WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED") : WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED");
                String[] attrs = new String[]{""};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_3", inserts), attrs, 12);
            }
            if (!this.allAncestorstoBaselevelSelected(currFieldLevel, baseLevel, selectedField, selectedItems)) {
                String baseParent = this.getBaseParentField(currFieldLevel, baseLevel, selectedField);
                Object[] inserts = new Object[3];
                inserts[0] = selectedFieldName;
                inserts[2] = baseParent;
                inserts[1] = actionType.equals("MOVE") ? WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED") : WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED");
                String[] attrs = new String[]{""};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_1", inserts), attrs, 12);
            }
            int i = 0;
            while (i < currPeerFields.size()) {
                String currFieldName = currPeerFields.get(i).getName();
                if (!this.isFieldInList(currFieldName, selectedItems)) {
                    FieldModel parentField = selectedField.getParentField();
                    Object[] inserts = new Object[3];
                    inserts[0] = parentField.getName();
                    inserts[1] = actionType.equals("MOVE") ? WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED") : WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED");
                    String[] attrs = new String[]{""};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_4", inserts), attrs, 12);
                }
                ++i;
            }
        } else if (currFieldLevel < baseLevel) {
            Object[] inserts = new Object[3];
            inserts[0] = selectedFieldName;
            inserts[2] = selectedItems[0];
            inserts[1] = actionType.equals("MOVE") ? WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_MOVED") : WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_REMOVED");
            String[] attrs = new String[]{""};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("MNG_FIELD_WIZ_3", inserts), attrs, 12);
        }
    }

    private String getBaseParentField(int currLevel, int baseLevel, FieldModel currentField) {
        while (currLevel > baseLevel) {
            String parentFieldName;
            FieldModel parentField = currentField.getParentField();
            if (parentField == null || (parentFieldName = parentField.getName()) == null || parentFieldName.isEmpty()) continue;
            currentField = parentField;
            --currLevel;
        }
        return currentField.getName();
    }

    private boolean allAncestorstoBaselevelSelected(int currLevel, int baseLevel, FieldModel selectedField, String[] selectedItems) throws ModelException {
        boolean retVal = false;
        while (currLevel > baseLevel) {
            String parentFieldName;
            FieldModel parentField = selectedField.getParentField();
            if (parentField == null || (parentFieldName = parentField.getName()) == null || parentFieldName.isEmpty()) continue;
            if (!this.isFieldInList(parentFieldName, selectedItems)) {
                return retVal;
            }
            selectedField = parentField;
            --currLevel;
        }
        retVal = true;
        return retVal;
    }

    private boolean isFieldInList(String fieldName, String[] fieldList) {
        boolean found = false;
        int i = 0;
        while (i < fieldList.length && !found) {
            if (fieldName.equals(fieldList[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    private int getFieldLevel(String selectedFieldName, List<FieldModel> topLevelFields, int level) {
        for (FieldModel fld : topLevelFields) {
            if (fld.getName().equals(selectedFieldName)) {
                return level;
            }
            DBDConstants appDataType = fld.getAppDatatype();
            if (appDataType == null || !fld.getAppDatatype().equals((Object)DBDConstants.ARRAY) && !fld.getAppDatatype().equals((Object)DBDConstants.STRUCT)) continue;
            ++level;
            Vector<FieldModel> childFields = fld.getChildFields();
            if (childFields == null) continue;
            int currLevel = this.getFieldLevel(selectedFieldName, childFields, level);
            if (currLevel != 0) {
                return currLevel;
            }
            --level;
        }
        return 0;
    }

    public void validateIMSFieldWithStartInfo(Vector<FieldModel> allFields) throws InvalidInputException {
        for (FieldModel fm : allFields) {
            if (!fm.isIMSField()) continue;
            String startAfter = fm.getStartAfter();
            int relStart = fm.getRelativeStart();
            String problemField = null;
            if (startAfter != null && !startAfter.isEmpty()) {
                problemField = "FOLLOWS";
            } else if (relStart > 0) {
                problemField = "REL_START";
            }
            if (problemField == null) continue;
            Object[] inserts = new Object[]{fm.getImsName()};
            String[] attrs = new String[]{"IMS_FIELD"};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_33", inserts), attrs);
        }
    }
}

