/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.field;

import com.ibm.im.ims.workbench.controller.field.IModelChangeListener;
import com.ibm.im.ims.workbench.controller.field.ManageSenfldsController;
import com.ibm.im.ims.workbench.controller.field.ModelChangeEvent;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class EditSenfldController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManageSenfldsController msfController;
    private String actionType;
    private SenfieldModel senfldModel;
    public static final String EDIT = "EDIT";
    public static final String ADD = "ADD";
    private List<IModelChangeListener> modelChangeListeners = new ArrayList<IModelChangeListener>();
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String START = "START";
    private boolean isReadOnly;

    public EditSenfldController(SenfieldModel senfld, ManageSenfldsController msfController, String actionType, boolean isReadOnly) throws ModelException {
        this.actionType = actionType;
        this.msfController = msfController;
        this.senfldModel = actionType.equals(ADD) ? msfController.createNewSenfldModelForAdd() : msfController.getSenfieldCloneForEdit(senfld);
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getName() {
        return this.senfldModel.getName();
    }

    public void setName(String name) throws ModelException, CoreException {
        boolean valueChanged = false;
        if (name != null && !name.equals(this.senfldModel.getName())) {
            valueChanged = true;
        }
        String dbdName = null;
        int periodIx = name.indexOf(".");
        String fieldName = null;
        if (periodIx != -1) {
            dbdName = name.substring(0, periodIx);
            fieldName = name.substring(periodIx + 1);
            this.senfldModel.setName(fieldName);
        } else {
            this.senfldModel.setName(name);
            fieldName = name;
        }
        if (valueChanged) {
            int newStartPos = 0;
            SegmentModel segModel = this.senfldModel.getSegmentModel();
            if (segModel.getDBDAccessType() == DBDConstants.LOGICAL) {
                if (segModel.hasSegmentSource()) {
                    FieldModel fieldModel = segModel.getLogicalSourceSegment().getFieldWithImsNameOrAlias(fieldName);
                    this.senfldModel.setFieldModel(fieldModel);
                    newStartPos = fieldModel.getStartPos();
                } else if (segModel.hasConcatenatedSegmentSource()) {
                    SegmentModel lchildSeg = segModel.getLChildSourceSegment();
                    SegmentModel targetParentSeg = segModel.getTargetParentSourceSegment();
                    DBDConstants lchildSourceData = segModel.getLogicalChildSourceData();
                    DBDConstants targetParentSourceData = segModel.getTargetParentSourceData();
                    if (lchildSourceData == DBDConstants.Y) {
                        if (dbdName.equals(lchildSeg.getDbdName())) {
                            FieldModel fieldModel = lchildSeg.getFieldWithImsNameOrAlias(fieldName);
                            this.senfldModel.setFieldModel(fieldModel);
                            newStartPos = fieldModel.getStartPos();
                        } else if (dbdName.equals(targetParentSeg.getDbdName())) {
                            FieldModel fieldModel = targetParentSeg.getFieldWithImsNameOrAlias(fieldName);
                            this.senfldModel.setFieldModel(fieldModel);
                            newStartPos = fieldModel.getStartPos() + lchildSeg.getMaxBytes();
                        }
                    } else if (targetParentSourceData == DBDConstants.Y && dbdName.equals(targetParentSeg.getDbdName())) {
                        FieldModel fieldModel = targetParentSeg.getFieldWithImsNameOrAlias(fieldName);
                        this.senfldModel.setFieldModel(fieldModel);
                        newStartPos = fieldModel.getStartPos();
                    }
                }
            } else {
                newStartPos = this.senfldModel.getFieldModel().getStartPos();
            }
            this.senfldModel.setStart(newStartPos);
            String[] attrs = new String[]{START};
            this.notifyListeners(attrs);
        }
    }

    private void notifyListeners(ModelChangeEvent event) {
        for (IModelChangeListener listener : this.modelChangeListeners) {
            listener.handleModelChange(event);
        }
    }

    public void notifyListeners(String[] attrs) {
        ModelChangeEvent changeEvent = new ModelChangeEvent(attrs);
        this.notifyListeners(changeEvent);
    }

    public void notifyListeners(String attr) {
        String[] attrs = new String[]{attr};
        this.notifyListeners(attrs);
    }

    public void addModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void setRemarks(String remarks) {
        this.senfldModel.setRemarks(remarks);
    }

    public String getRemarks() {
        String retVal = this.senfldModel.getRemarks();
        if (retVal == null) {
            retVal = "";
        }
        return retVal;
    }

    public String getStart() {
        int startInt = this.senfldModel.getStart();
        String retVal = startInt == 0 ? "" : Integer.toString(startInt);
        return retVal;
    }

    public void setStart(String startPosStr) throws InvalidInputException {
        block4: {
            if (startPosStr != null && !startPosStr.isEmpty()) {
                try {
                    int startInt = Integer.parseInt(startPosStr);
                    this.senfldModel.setStart(startInt);
                    if (startInt < 1) {
                        Object[] attrs = new String[]{START};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_SENFLD_WIZ_2", attrs));
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] attrs = new String[]{START};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_SENFLD_WIZ_2", attrs));
                }
            }
            this.senfldModel.setStart(0);
        }
    }

    public DBDConstants getReplace() {
        return this.senfldModel.getReplace();
    }

    public void setReplace(String value) {
        this.senfldModel.setReplace(DBDConstants.fromValue(value.substring(0, 1)));
    }

    public String[] getIMSFieldNames() throws ModelException, CoreException {
        String[] retVal;
        block11: {
            SegmentModel segModel;
            block9: {
                int i;
                String dbdName;
                block10: {
                    retVal = null;
                    segModel = this.senfldModel.getSegmentModel();
                    if (segModel.getDBDAccessType() != DBDConstants.LOGICAL) break block9;
                    segModel.setProjectName(this.msfController.getProjectName());
                    if (!segModel.hasSegmentSource()) break block10;
                    List<FieldModel> imsFields = null;
                    imsFields = segModel.getLogicalSourceSegment().getIMSFields();
                    if (imsFields == null) break block11;
                    int numIMSFields = imsFields.size();
                    retVal = new String[numIMSFields];
                    int i2 = 0;
                    while (i2 < numIMSFields) {
                        retVal[i2] = imsFields.get(i2).getImsName();
                        ++i2;
                    }
                    break block11;
                }
                if (!segModel.hasConcatenatedSegmentSource()) break block11;
                int totalNumFields = 0;
                List<FieldModel> lchildSourceIMSFields = null;
                if (segModel.getLogicalChildSourceData() == DBDConstants.Y && (lchildSourceIMSFields = segModel.getLChildSourceSegment().getIMSFields()) != null) {
                    totalNumFields = lchildSourceIMSFields.size();
                }
                List<FieldModel> targetParentSourceIMSFields = null;
                if (segModel.getTargetParentSourceData() == DBDConstants.Y && (targetParentSourceIMSFields = segModel.getTargetParentSourceSegment().getIMSFields()) != null) {
                    totalNumFields += targetParentSourceIMSFields.size();
                }
                retVal = new String[totalNumFields];
                int nextAvailIndex = 0;
                if (lchildSourceIMSFields != null) {
                    dbdName = segModel.getLChildSourceSegment().getDbdName();
                    i = 0;
                    while (i < lchildSourceIMSFields.size()) {
                        retVal[i] = dbdName + "." + lchildSourceIMSFields.get(i).getImsName();
                        ++i;
                    }
                    nextAvailIndex = lchildSourceIMSFields.size();
                }
                if (targetParentSourceIMSFields != null) {
                    dbdName = segModel.getTargetParentSourceSegment().getDbdName();
                    i = 0;
                    while (i < targetParentSourceIMSFields.size()) {
                        retVal[nextAvailIndex] = dbdName + "." + targetParentSourceIMSFields.get(i).getImsName();
                        ++nextAvailIndex;
                        ++i;
                    }
                }
                break block11;
            }
            List<FieldModel> imsFields = null;
            imsFields = segModel.getIMSFields();
            if (imsFields != null) {
                int numIMSFields = imsFields.size();
                retVal = new String[numIMSFields];
                int i = 0;
                while (i < numIMSFields) {
                    retVal[i] = imsFields.get(i).getImsName();
                    ++i;
                }
            }
        }
        return retVal;
    }

    public void validateRequiredFields(String[] attrsToCheck) throws ModelException, InvalidInputException {
        int i = 0;
        while (i < attrsToCheck.length) {
            block9: {
                String currAttr;
                block8: {
                    currAttr = attrsToCheck[i];
                    String nameStr = this.senfldModel.getName();
                    if (!currAttr.equals(ALL) && !currAttr.equals(NAME)) break block8;
                    if (nameStr == null || nameStr.isEmpty()) {
                        Object[] attrs = new String[]{NAME};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_SENFLD_WIZ_3", attrs));
                    }
                    if (currAttr.equals(NAME)) break block9;
                }
                int startInt = this.senfldModel.getStart();
                if (currAttr.equals(ALL) || currAttr.equals(START)) {
                    if (startInt == 0) {
                        Object[] attrs = new String[]{START};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_SENFLD_WIZ_4", attrs));
                    }
                    if (currAttr.equals(START)) {
                        // empty if block
                    }
                }
            }
            ++i;
        }
    }

    public void semanticCheck() throws InvalidInputException, ModelException {
        this.validateDuplicateSenfld();
    }

    private void validateDuplicateSenfld() throws InvalidInputException, ModelException {
        ArrayList<SenfieldModel> existingSenflds = this.msfController.getSenseg().getSenfields();
        Iterator<SenfieldModel> iter = existingSenflds.iterator();
        SenfieldModel OrigSenfldBeingEdited = this.msfController.getOrigSenfldBeingEdited();
        while (iter.hasNext()) {
            SenfieldModel existingSenfld = iter.next();
            if (OrigSenfldBeingEdited == existingSenfld || !existingSenfld.equals(this.senfldModel)) continue;
            Object[] inserts = new Object[]{this.senfldModel.getName()};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_SENFLD_WIZ_1", inserts));
        }
    }

    public void performFinish() throws ModelException {
        if (this.actionType.equals(ADD)) {
            this.msfController.addNewSenfld(this.senfldModel);
        } else {
            this.msfController.replaceOrigSenfldWithClone(this.senfldModel);
        }
    }
}

