/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.field;

import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.workbench.controller.field.IModelChangeListener;
import com.ibm.im.ims.workbench.controller.field.ManageFieldsController;
import com.ibm.im.ims.workbench.controller.field.ModelChangeEvent;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SysRelFieldModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class EditFieldController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManageFieldsController mfController;
    private String actionType;
    private FieldModel fieldModel;
    private String mapName;
    private String caseName;
    private SegmentModel segmentModel;
    private boolean hasBeenEdited = false;
    private String[] fieldNames;
    private boolean isReadOnly;
    public static final String EDIT = "EDIT";
    public static final String ADD = "ADD";
    public static final String MOVE = "MOVE";
    public static final String NONE = "NONE";
    public static final String ALL = "ALL";
    public static final String CONTAINER_NAME = "CONTAINER_NAME";
    public static final String CASE_NAME = "CASE_NAME";
    public static final String PARENT = "PARENT";
    public static final String FOLLOWSBUTTON = "FOLLOWSBUTTON";
    public static final String FOLLOWS = "FOLLOWS";
    public static final String STARTBUTTON = "STARTBUTTON";
    public static final String START = "START";
    public static final String IMS_FIELD = "IMS_FIELD";
    public static final String USERDEFINED_FIELD = "USERDEFINED_FIELD";
    public static final String IMS_NAME = "IMS_NAME";
    public static final String ALIAS = "ALIAS";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String LENGTH = "LENGTH";
    public static final String APP_DATATYPE = "APP_DATATYPE";
    public static final String PHY_DATATYPE = "PHY_DATATYPE";
    public static final String PATTERN = "PATTERN";
    public static final String PRECISION = "PRECISION";
    public static final String SCALE = "SCALE";
    public static final String IS_SIGNED = "IS_SIGNED";
    public static final String MIN_OCCURS = "MIN_OCCURS";
    public static final String MAX_OCCURS = "MAX_OCCURS";
    public static final String DEPENDSON = "DEPENDSON";
    public static final String USER_CONV = "USER_CONV";
    public static final String XML_SCHEMA = "XML_SCHEMA";
    public static final String OVERFLOW_SEGM = "OVERFLOW_SEGM";
    public static final String REDEFINES = "REDEFINES";
    public static final String REMARKS = "REMARKS";
    public static final String FIELD_TYPE = "FIELD_TYPE";
    public static final String ENCODING = "ENCODING";
    public static final String MAP_NAME = "MAP_NAME";
    public static final String REL_START = "REL_START";
    public static String COMMON_FIELDS = WorkbenchModelBundle.getNoXlatLabel().getString("MANAGE_MAPPING_1");
    private List<IModelChangeListener> modelChangeListeners = new ArrayList<IModelChangeListener>();
    private HashMap<String, Integer> lengthMap = new HashMap();

    public EditFieldController(String fieldAliasName, String mapName, String caseName, ManageFieldsController mfController, String actionType) throws ModelException {
        this.mfController = mfController;
        this.mapName = mapName;
        this.caseName = caseName;
        this.segmentModel = mfController.getSegmentModelClone();
        this.actionType = actionType;
        this.isReadOnly = mfController.isReadOnly();
        this.fieldModel = actionType.equals(ADD) ? mfController.createNewFieldModelForAdd() : mfController.getFieldCloneForEdit(fieldAliasName, mapName, caseName);
        this.initFieldType();
        this.initPhysDatatype();
        this.initStartInfo(fieldAliasName);
        this.initLengthMap();
    }

    public EditFieldController(String[] fieldAliasNames, String mapName, String caseName, ManageFieldsController mfController) throws ModelException {
        this.mfController = mfController;
        this.mapName = mapName;
        this.caseName = caseName;
        this.segmentModel = mfController.getSegmentModelClone();
        this.actionType = MOVE;
        this.fieldNames = fieldAliasNames;
        this.fieldModel = mfController.getFieldCloneForEdit(this.fieldNames[0], mapName, caseName);
        this.initFieldType();
        this.initPhysDatatype();
        this.initStartInfo(null);
        this.initLengthMap();
    }

    private void initPhysDatatype() {
        DBDConstants physDatatype = this.fieldModel.getPhysicalDataType();
        if (physDatatype == null) {
            String userTypeConverterStr = this.fieldModel.getUserTypeConverter();
            if (userTypeConverterStr == null || userTypeConverterStr.isEmpty()) {
                this.fieldModel.setUserSelected(false);
            } else {
                this.fieldModel.setUserSelected(true);
            }
        } else {
            this.fieldModel.setUserSelected(false);
        }
    }

    private void initStartInfo(String selectedFieldStr) throws ModelException {
        FieldModel selectedField = null;
        if (selectedFieldStr != null) {
            selectedField = this.mfController.getFieldModel(selectedFieldStr, this.mapName, this.caseName);
        }
        if (this.actionType.equals(ADD)) {
            if (selectedField == null) {
                Vector<FieldModel> topLevelFields = this.mfController.getTopLevelFieldList(this.mapName, this.caseName);
                if (topLevelFields.isEmpty()) {
                    this.setStartAfterSelected(false);
                    this.fieldModel.setStartPos(1);
                } else {
                    this.setStartAfterSelected(true);
                    this.fieldModel.setStartAfter(topLevelFields.get(topLevelFields.size() - 1).getName());
                }
            } else {
                DBDConstants adt = selectedField.getAppDatatype();
                String selectedFieldName = selectedField.getName();
                if (adt == DBDConstants.ARRAY || adt == DBDConstants.STRUCT) {
                    this.fieldModel.setParentField(selectedField);
                    String lastChildStr = this.mfController.getLastChildOfField(selectedFieldName, this.mapName, this.caseName);
                    this.setStartAfterSelected(true);
                    if (lastChildStr == null) {
                        this.fieldModel.setStartAfter(NONE);
                    } else {
                        this.fieldModel.setStartAfter(lastChildStr);
                    }
                } else {
                    this.setStartAfterSelected(true);
                    this.fieldModel.setStartAfter(selectedFieldName);
                    this.fieldModel.setParentField(selectedField.getParentField());
                }
            }
        } else {
            String redefinesStr = this.fieldModel.getRedefines();
            if (redefinesStr != null && !redefinesStr.isEmpty()) {
                this.setStartAfterSelected(true);
                this.fieldModel.setStartAfter(redefinesStr);
                this.fieldModel.setStartPos(0);
            } else {
                String startAfterName = this.getPrevFieldName();
                FieldModel parentField = this.fieldModel.getParentField();
                if (parentField != null) {
                    if (startAfterName == null || startAfterName.isEmpty()) {
                        startAfterName = NONE;
                    }
                    this.fieldModel.setStartAfter(startAfterName);
                    this.setStartAfterSelected(true);
                } else {
                    String startAfterStr = this.fieldModel.getStartAfter();
                    if (startAfterStr != null && !startAfterStr.isEmpty()) {
                        this.setStartAfterSelected(true);
                    } else {
                        this.setStartAfterSelected(false);
                    }
                }
            }
        }
    }

    private void initFieldType() {
        String fieldImsName = this.fieldModel.getImsName();
        if (fieldImsName != null && !fieldImsName.isEmpty()) {
            this.fieldModel.setIMSFieldSelected(true);
        } else {
            this.fieldModel.setIMSFieldSelected(false);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public boolean isInputNumeric(String inputString) throws InvalidInputException {
        try {
            Integer.parseInt(inputString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isInputHasSpaces(String inputString) throws InvalidInputException {
        return inputString.indexOf(" ") > -1;
    }

    public String getStartPos() {
        return String.valueOf(this.fieldModel.getStartPos());
    }

    public String getPrevFieldName() throws ModelException {
        String retVal = "";
        List<FieldModel> fieldList = this.getFieldList();
        if (fieldList != null) {
            String fieldName = this.fieldModel.getName();
            String parentFieldName = this.getParentField();
            for (FieldModel currentFieldModel : fieldList) {
                FieldModel currentParentFieldModel = currentFieldModel.getParentField();
                String currentParentField = "";
                String currentFieldName = currentFieldModel.getName();
                if (currentParentFieldModel != null) {
                    currentParentField = currentParentFieldModel.getName();
                }
                if (currentParentField != parentFieldName) continue;
                if (currentFieldName.equals(fieldName)) break;
                retVal = currentFieldName;
            }
        }
        return retVal;
    }

    public String getRelativeStart() {
        return String.valueOf(this.fieldModel.getRelativeStart());
    }

    public String getStartAfter() {
        return this.fieldModel.getStartAfter();
    }

    public boolean isSysRelField() {
        return this.fieldModel.isSysRelField();
    }

    public DBDConstants getSeqType() {
        return this.fieldModel.getSeqType();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParentField(String parentFieldName) throws InvalidInputException, ModelException {
        boolean valueChanged = false;
        FieldModel parent = this.fieldModel.getParentField();
        if (parent != null && !parentFieldName.equals(parent.getName()) || parent == null && parentFieldName != null && !parentFieldName.isEmpty()) {
            valueChanged = true;
        }
        if (parentFieldName != null && !parentFieldName.isEmpty()) {
            FieldModel parentField = this.segmentModel.getFieldWithAlias(parentFieldName, null);
            if (parentField == null) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_PARENT")};
                String[] attrs = new String[]{PARENT};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
            }
            this.fieldModel.setParentField(parentField);
        } else {
            this.fieldModel.setParentField(null);
        }
        if (valueChanged) {
            this.fieldModel.setStartAfterSelected(true);
            this.fieldModel.setStartAfter("");
            this.fieldModel.setStartPos(0);
            String[] attrs = new String[]{START, REDEFINES};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setPattern(String datePattern) throws InvalidInputException {
        this.fieldModel.setPattern(datePattern);
        if (datePattern != null && !datePattern.isEmpty()) {
            try {
                new SimpleDateFormat(datePattern);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] attrs = new String[]{PATTERN};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC50"), attrs);
            }
        }
        this.hasBeenEdited = true;
    }

    public void setIsSigned(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            if (!value.equalsIgnoreCase("YES") && !value.equalsIgnoreCase("NO")) {
                Object[] inserts = new Object[]{value, WorkbenchModelBundle.getLabel().getString("WB025A")};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts));
            }
            this.fieldModel.setIsSigned(value);
        }
        this.hasBeenEdited = true;
    }

    public void setIsPureDBCS(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            this.fieldModel.setIsDbcs(value);
        }
        this.hasBeenEdited = true;
    }

    public String getParentField() {
        FieldModel parentFieldModel = this.fieldModel.getParentField();
        if (parentFieldModel != null) {
            return parentFieldModel.getName();
        }
        return "";
    }

    public String getPattern() {
        return this.fieldModel.getPattern();
    }

    public String getDependsOn() {
        return this.fieldModel.getDependsOn();
    }

    public void setDependsOn(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            this.mfController.validateDependson(this.fieldModel);
            this.fieldModel.setDependsOn(value);
        } else {
            this.fieldModel.setDependsOn(null);
        }
        this.hasBeenEdited = true;
    }

    public Integer getMinOccurs() {
        return this.fieldModel.getMinOccurs();
    }

    public List<FieldModel> getDependsOnCandidates() throws ModelException {
        ArrayList<FieldModel> depOnCandidates = new ArrayList<FieldModel>();
        List<FieldModel> fieldList = this.getFieldList();
        for (FieldModel fm : fieldList) {
            FieldModel pfm;
            if (fm.getName().equals(this.fieldModel.getName())) break;
            if ((fm.getAppDatatype() == null || !ManageFieldsController.canFieldBeDependedOn(fm, fm.getAppDatatype())) && (fm.getPhysicalDataType() == null || !ManageFieldsController.canFieldBeDependedOn(fm, fm.getPhysicalDataType())) || (pfm = fm.getParentField()) != null && pfm.getAppDatatype() == DBDConstants.ARRAY) continue;
            depOnCandidates.add(fm);
        }
        return depOnCandidates;
    }

    public void setMinOccurs(String minOccurs) throws InvalidInputException {
        if (minOccurs != null && !minOccurs.isEmpty()) {
            try {
                int minOccursInt = Integer.parseInt(minOccurs);
                this.fieldModel.setMinOccurs(minOccursInt);
                if (minOccursInt < 0) {
                    Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS")};
                    String[] attrs = new String[]{MIN_OCCURS};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC57", inserts), attrs);
                }
                this.setDependsOnIfNeeded();
                this.hasBeenEdited = true;
            }
            catch (NumberFormatException numberFormatException) {
                Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS")};
                String[] attrs = new String[]{MIN_OCCURS};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC57", inserts), attrs);
            }
        }
    }

    public void setMaxOccurs(String maxOccurs) throws InvalidInputException {
        if (maxOccurs != null && !maxOccurs.isEmpty()) {
            try {
                int maxOccursInt = Integer.parseInt(maxOccurs);
                this.fieldModel.setMaxOccurs(maxOccursInt);
                if (maxOccursInt < 1) {
                    String[] attrs = new String[]{MAX_OCCURS};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_8"), attrs);
                }
                this.setDependsOnIfNeeded();
                this.hasBeenEdited = true;
            }
            catch (NumberFormatException numberFormatException) {
                String[] attrs = new String[]{MAX_OCCURS};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_8"), attrs);
            }
        }
    }

    public Integer getMaxOccurs() {
        return this.fieldModel.getMaxOccurs();
    }

    public void setStartPos(String startPosStr) throws InvalidInputException {
        DBDConstants pdt;
        boolean valueChanged;
        block7: {
            valueChanged = false;
            if (startPosStr != null && !startPosStr.isEmpty()) {
                try {
                    int startInt = Integer.parseInt(startPosStr);
                    if (this.fieldModel.getStartPos() != startInt) {
                        valueChanged = true;
                    }
                    this.fieldModel.setStartPos(startInt);
                    this.fieldModel.setStartAfter(null);
                    this.fieldModel.setRelativeStart(0);
                    this.setStartAfterSelected(false);
                    String origImsName = this.mfController.getOriginalFieldImsName();
                    String inputImsName = this.fieldModel.getImsName();
                    if (startInt != 0 && (origImsName != null && origImsName.startsWith("/SX") || inputImsName != null && inputImsName.startsWith("/SX"))) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_51"));
                    }
                    if (startInt < 0) {
                        Object[] inserts = new String[]{Integer.toString(this.segmentModel.getMaxBytes()), this.segmentModel.getName()};
                        String[] attrs = new String[]{START};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_1", inserts), attrs);
                    }
                    break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] inserts = new String[]{Integer.toString(this.segmentModel.getMaxBytes()), this.segmentModel.getName()};
                    String[] attrs = new String[]{START};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_1", inserts), attrs);
                }
            }
            this.fieldModel.setStartPos(-1);
        }
        if (valueChanged && this.fieldModel.getStartPos() == 0 && (pdt = this.fieldModel.getPhysicalDataType()) == DBDConstants.XML_CLOB) {
            this.fieldModel.setBytes(0);
            this.fieldModel.setOverflow("");
            String[] attrs = new String[]{OVERFLOW_SEGM, LENGTH};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setStartAfter(String startAfterStr) throws InvalidInputException, ModelException {
        boolean valueChanged = false;
        String currStartAfter = this.fieldModel.getStartAfter();
        if (currStartAfter != null && !currStartAfter.equals(startAfterStr)) {
            valueChanged = true;
        }
        if (startAfterStr != null && !startAfterStr.isEmpty()) {
            if (!startAfterStr.equals(NONE)) {
                this.fieldModel.setStartAfter(startAfterStr);
                if (this.isFieldExisted(startAfterStr) == null) {
                    Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER")};
                    String[] attrs = new String[]{START};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
                }
            } else {
                this.fieldModel.setStartAfter(DBDConstants.NONE.toString());
            }
            this.fieldModel.setStartPos(0);
            this.fieldModel.setRelativeStart(0);
        } else {
            this.fieldModel.setStartAfter("");
        }
        if (valueChanged) {
            String[] attrs = new String[]{REDEFINES};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    private FieldModel isFieldExisted(String fieldName) throws ModelException {
        List<FieldModel> fieldList = this.getFieldList();
        if (fieldList != null) {
            for (FieldModel currentFieldModel : fieldList) {
                if (!currentFieldModel.getName().equals(fieldName)) continue;
                return currentFieldModel;
            }
        }
        return null;
    }

    public void setPrecision(String precisionStr) throws InvalidInputException {
        String[] attrs;
        boolean valueChanged;
        block6: {
            valueChanged = false;
            if (precisionStr != null && !precisionStr.isEmpty()) {
                attrs = new String[]{PRECISION};
                try {
                    int precisionInt = Integer.parseInt(precisionStr);
                    Integer currPrecisionInt = this.fieldModel.getPrecision();
                    if (currPrecisionInt == null || currPrecisionInt != precisionInt) {
                        valueChanged = true;
                    }
                    this.fieldModel.setPrecision(precisionStr);
                    if (precisionInt < 1) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC42"), attrs);
                    }
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC42"), attrs);
                }
            }
            this.fieldModel.setPrecision("-1");
        }
        if (valueChanged) {
            this.fieldModel.setBytes(this.calculateLengthForDecimal(this.fieldModel.getPrecision()));
            attrs = new String[]{LENGTH};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setScale(String scalseStr) throws InvalidInputException {
        block4: {
            if (scalseStr != null && !scalseStr.isEmpty()) {
                String[] attrs = new String[]{SCALE};
                try {
                    int scaleInt = Integer.parseInt(scalseStr);
                    this.fieldModel.setScale(scalseStr);
                    if (scaleInt < 0) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC46"), attrs);
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC46"), attrs);
                }
            }
            this.fieldModel.setScale("-1");
        }
        this.hasBeenEdited = true;
    }

    private int calculateLengthForDecimal(int precisionInt) {
        DBDConstants adt;
        int retVal = precisionInt;
        DBDConstants pdt = this.fieldModel.getPhysicalDataType();
        if (pdt == DBDConstants.PACKEDDECIMAL) {
            retVal = (precisionInt + 2) / 2;
        } else if (pdt == DBDConstants.BINARY && (adt = this.fieldModel.getAppDatatype()) == DBDConstants.DECIMAL) {
            retVal = precisionInt < 5 ? 2 : (precisionInt > 4 && precisionInt < 10 ? 4 : 8);
        }
        return retVal;
    }

    public String getBytes() {
        return Integer.toString(this.fieldModel.getBytes());
    }

    public void setBytes(String lengthStr) throws InvalidInputException {
        if (lengthStr != null && !lengthStr.isEmpty()) {
            try {
                int lengthInt = Integer.parseInt(lengthStr);
                this.fieldModel.setBytes(lengthInt);
                this.checkDataTypeLength(lengthStr);
                DBDConstants appDatatype = this.fieldModel.getAppDatatype();
                if (appDatatype != null && appDatatype != DBDConstants.ARRAY && appDatatype != DBDConstants.STRUCT && appDatatype != DBDConstants.DECIMAL && this.fieldModel.isIMSField() && (lengthInt < 1 || lengthInt > 255)) {
                    String[] attrs = new String[]{LENGTH};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC44"), attrs);
                }
                this.hasBeenEdited = true;
            }
            catch (NumberFormatException numberFormatException) {
                String[] attrs = new String[]{LENGTH};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC44"), attrs);
            }
        } else {
            this.fieldModel.setBytes(0);
        }
    }

    private void checkDataTypeLength(String fieldLength) throws InvalidInputException {
        DBDConstants dataType = this.fieldModel.getPhysicalDataType();
        boolean isPdt = true;
        if (dataType == null || dataType.value().isEmpty()) {
            dataType = this.fieldModel.getAppDatatype();
            isPdt = false;
        }
        if (dataType != null && !dataType.value().isEmpty()) {
            if (dataType.equals((Object)DBDConstants.BIT) || dataType.equals((Object)DBDConstants.BYTE)) {
                if (!fieldLength.equals("1")) {
                    Object[] inserts = new String[]{fieldLength, dataType.value(), "1"};
                    if (isPdt) {
                        String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                    }
                    String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
                }
            } else if (dataType.equals((Object)DBDConstants.SHORT)) {
                if (!fieldLength.equals("2")) {
                    Object[] inserts = new String[]{fieldLength, dataType.value(), "2"};
                    if (isPdt) {
                        String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                    }
                    String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
                }
            } else if (dataType.equals((Object)DBDConstants.FLOAT) || dataType.equals((Object)DBDConstants.INT)) {
                if (!fieldLength.equals("4")) {
                    Object[] inserts = new String[]{fieldLength, dataType.value(), "4"};
                    if (isPdt) {
                        String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                    }
                    String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
                }
            } else if ((dataType.equals((Object)DBDConstants.DOUBLE) || dataType.equals((Object)DBDConstants.LONG)) && !fieldLength.equals("8")) {
                Object[] inserts = new String[]{fieldLength, dataType.value(), "8"};
                if (isPdt) {
                    String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                }
                String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
            }
        }
    }

    public boolean isDynamicArray() {
        return this.fieldModel.getAppDatatype() != null && this.fieldModel.getAppDatatype().equals((Object)DBDConstants.ARRAY) && this.fieldModel.getDependsOn() != null && !this.fieldModel.getDependsOn().isEmpty();
    }

    public void setImsName(String nameInputString) throws InvalidInputException {
        boolean valueChanged = false;
        String currImsName = this.fieldModel.getImsName();
        if (currImsName != null && !currImsName.equals(nameInputString)) {
            valueChanged = true;
        }
        this.fieldModel.setImsName(nameInputString);
        boolean isSXField = nameInputString.startsWith("/SX");
        boolean isCKField = nameInputString.startsWith("/CK");
        String origImsName = this.mfController.getOriginalFieldImsName();
        String[] attrs = new String[]{IMS_NAME};
        if (this.isInputHasSpaces(nameInputString)) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB010A")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_3", inserts), attrs);
        }
        if (nameInputString.length() > 8 || !this.isValidName(nameInputString, false)) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB010A")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC54", inserts), attrs);
        }
        if (origImsName != null && origImsName.startsWith("/SX") && !isSXField || origImsName != null && origImsName.startsWith("/CK") && !isCKField) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_52"), attrs);
        }
        if (!(!isSXField && !isCKField || this.fieldModel.getParentField() == null && this.fieldModel.isIMSFieldSelected() && this.mapName.equals(COMMON_FIELDS))) {
            Object[] inserts = new String[]{nameInputString};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_37", inserts), attrs);
        }
        if (valueChanged && (isSXField || isCKField)) {
            if (isSXField) {
                this.fieldModel.setStartPos(0);
            }
            this.fieldModel.setBytes(0);
            if (isCKField) {
                this.fieldModel.setPhysicalDataType(null);
                this.fieldModel.setUserTypeConverer(null);
            }
            this.fieldModel.setStartAfter(null);
            this.fieldModel.setRelativeStart(0);
            this.setStartAfterSelected(false);
            String[] nofityAttrs = new String[]{START, APP_DATATYPE, PHY_DATATYPE};
            this.notifyListeners(nofityAttrs);
        }
        this.hasBeenEdited = true;
    }

    private boolean isValidName(String nameInputString, boolean isExternalName) {
        if (isExternalName) {
            return !Utility.hasSpecialChar(nameInputString, isExternalName) && !Utility.hasReservedSQLKeywords(nameInputString) || nameInputString.startsWith("/SX") || nameInputString.startsWith("/CK");
        }
        return !Utility.hasSpecialChar(nameInputString, isExternalName) || nameInputString.startsWith("/SX") || nameInputString.startsWith("/CK");
    }

    public String getRemarks() {
        return this.fieldModel.getRemarks();
    }

    public void setAppDatatype(DBDConstants value) throws InvalidInputException, ModelException {
        try {
            if (this.fieldModel.getAppDatatype() == null || !this.fieldModel.getAppDatatype().equals((Object)value)) {
                this.fieldModel.setAppDatatype(value);
                this.updateModelForAppDataTypeChange();
                if (value != DBDConstants.ARRAY) {
                    this.fieldModel.setDependsOn("");
                    this.fieldModel.setMinOccurs(0);
                    this.fieldModel.setMaxBytes(0);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WB017A"), value.value()};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts));
        }
        this.hasBeenEdited = true;
    }

    public void checkStartPosZero() throws InvalidInputException {
        if (this.getStartPos().equals("0") && (this.getAppDatatype() == null || !this.getAppDatatype().equals((Object)DBDConstants.XML))) {
            String[] attrs = new String[]{APP_DATATYPE};
            Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WB342")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_34", inserts), attrs);
        }
    }

    public void setRemarks(String value) throws InvalidInputException {
        this.fieldModel.setRemarks(value);
        String invalidCharacter = Utility.getInvalidRemarksCharacter(value);
        if (invalidCharacter != null) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB019A"), invalidCharacter};
            String[] attrs = new String[]{REMARKS};
            Object errorMessage = WorkbenchModelBundle.getError().getString("EISRC11", inserts);
            if (invalidCharacter.equals("'")) {
                errorMessage = (String)errorMessage + " " + WorkbenchModelBundle.getError().getString("EISRC11A");
            }
            throw new InvalidInputException((String)errorMessage, attrs);
        }
        this.hasBeenEdited = true;
    }

    public void addNewProperty(String name, String value) {
        this.fieldModel.addNewProperty(name, value);
    }

    public void removeAllProperties() {
        this.fieldModel.removeAllProperties();
    }

    public void setEncoding(String value) throws InvalidInputException {
        String dummyStr = "dummy";
        try {
            if (value != null) {
                this.fieldModel.setEncoding(value);
                this.hasBeenEdited = true;
            }
            dummyStr.getBytes(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String[] attrs = new String[]{ENCODING};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC21"), attrs);
        }
        this.fieldModel.setEncoding(value);
        this.hasBeenEdited = true;
    }

    public void setPhysicalDataType(DBDConstants value) throws InvalidInputException {
        boolean valueChanged = false;
        try {
            DBDConstants oldValue = this.fieldModel.getPhysicalDataType();
            if (oldValue == null && this.fieldModel.isUserSelected()) {
                oldValue = DBDConstants.USER;
            }
            if (oldValue == null || !oldValue.equals((Object)value)) {
                valueChanged = true;
                this.fieldModel.setPhysicalDataType(value);
                this.validatePhysicalDataType(value);
                if (value == DBDConstants.USER) {
                    this.fieldModel.setUserSelected(true);
                    this.fieldModel.setPhysicalDataType(null);
                } else {
                    this.fieldModel.setUserSelected(false);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WB018A"), value.value()};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts));
        }
        if (valueChanged) {
            if (this.fieldModel.getPrecision() != null) {
                this.fieldModel.setBytes(this.calculateLengthForDecimal(this.fieldModel.getPrecision()));
            }
            String[] attrs = new String[]{LENGTH};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    private void validatePhysicalDataType(DBDConstants pdt) throws InvalidInputException {
        DBDConstants adt = this.fieldModel.getAppDatatype();
        String[] attrs = new String[]{PHY_DATATYPE};
        String[] notifyAttrs = new String[]{APP_DATATYPE};
        Object[] inserts = new String[5];
        if (pdt == null || pdt.value().isEmpty()) {
            if (adt.equals((Object)DBDConstants.DECIMAL) || adt.equals((Object)DBDConstants.OTHER) || adt.equals((Object)DBDConstants.XML)) {
                if (adt.equals((Object)DBDConstants.XML)) {
                    inserts[0] = DBDConstants.XML.value();
                    inserts[1] = DBDConstants.XML_CLOB.value();
                } else if (adt.equals((Object)DBDConstants.OTHER)) {
                    inserts[0] = DBDConstants.OTHER.value();
                    inserts[1] = DBDConstants.USER.value();
                } else {
                    inserts[0] = DBDConstants.DECIMAL.value();
                    inserts[1] = DBDConstants.PACKEDDECIMAL.value() + ", " + DBDConstants.ZONEDDECIMAL.value() + ", or " + DBDConstants.BINARY.value();
                }
                inserts[2] = this.fieldModel.getName();
                inserts[3] = WorkbenchModelBundle.getLabel().getString("WB344");
                inserts[4] = WorkbenchModelBundle.getLabel().getString("WB342");
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
            }
        } else {
            inserts[0] = pdt.value();
            if (pdt.equals((Object)DBDConstants.BLOB) || pdt.equals((Object)DBDConstants.CLOB)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BINARY)) {
                    this.fieldModel.setAppDatatype(DBDConstants.BINARY);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.BINARY)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BINARY) && !adt.equals((Object)DBDConstants.DECIMAL)) {
                    inserts[2] = this.fieldModel.getName();
                    inserts[1] = DBDConstants.BINARY.value() + " or " + DBDConstants.DECIMAL.value();
                    inserts[4] = WorkbenchModelBundle.getLabel().getString("WB344");
                    inserts[3] = WorkbenchModelBundle.getLabel().getString("WB342");
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
                }
            } else if (pdt.equals((Object)DBDConstants.BIT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BIT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.BIT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.BYTE)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BYTE)) {
                    this.fieldModel.setAppDatatype(DBDConstants.BYTE);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.CHAR)) {
                if (adt == null) {
                    this.fieldModel.setAppDatatype(DBDConstants.CHAR);
                    this.notifyListeners(notifyAttrs);
                } else if (!(adt.equals((Object)DBDConstants.CHAR) || adt.equals((Object)DBDConstants.DATE) || adt.equals((Object)DBDConstants.TIME) || adt.equals((Object)DBDConstants.TIMESTAMP))) {
                    inserts[1] = DBDConstants.CHAR.value() + ", " + DBDConstants.DATE.value() + ", " + DBDConstants.TIME.value() + ", " + DBDConstants.TIMESTAMP.value();
                    inserts[2] = this.fieldModel.getName();
                    inserts[3] = WorkbenchModelBundle.getLabel().getString("WB342");
                    inserts[4] = WorkbenchModelBundle.getLabel().getString("WB344");
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
                }
            } else if (pdt.equals((Object)DBDConstants.DOUBLE)) {
                if (adt == null || !adt.equals((Object)DBDConstants.DOUBLE)) {
                    this.fieldModel.setAppDatatype(DBDConstants.DOUBLE);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.FLOAT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.FLOAT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.FLOAT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.INT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.INT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.INT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.LONG)) {
                if (adt == null) {
                    this.fieldModel.setAppDatatype(DBDConstants.LONG);
                    this.notifyListeners(notifyAttrs);
                } else if (!(adt.equals((Object)DBDConstants.LONG) || adt.equals((Object)DBDConstants.DATE) || adt.equals((Object)DBDConstants.TIME) || adt.equals((Object)DBDConstants.TIMESTAMP))) {
                    inserts[1] = DBDConstants.LONG.value() + ", " + DBDConstants.DATE.value() + ", " + DBDConstants.TIME.value() + ", " + DBDConstants.TIMESTAMP.value();
                    inserts[2] = this.fieldModel.getName();
                    inserts[3] = WorkbenchModelBundle.getLabel().getString("WB342");
                    inserts[4] = WorkbenchModelBundle.getLabel().getString("WB344");
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
                }
            } else if (pdt.equals((Object)DBDConstants.PACKEDDECIMAL) || pdt.equals((Object)DBDConstants.ZONEDDECIMAL)) {
                if (adt == null || !adt.equals((Object)DBDConstants.DECIMAL)) {
                    this.fieldModel.setAppDatatype(DBDConstants.DECIMAL);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.SHORT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.SHORT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.SHORT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.USER)) {
                if (adt == null) {
                    this.fieldModel.setAppDatatype(DBDConstants.OTHER);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.XML_CLOB) && (adt == null || !adt.equals((Object)DBDConstants.XML))) {
                this.fieldModel.setAppDatatype(DBDConstants.XML);
                this.notifyListeners(notifyAttrs);
                this.updateModelForAppDataTypeChange();
            }
        }
        this.updateLengthValue();
    }

    public void clearPhysicalDataType() {
        this.fieldModel.setPhysicalDataType(null);
    }

    public void setName(String aliasInputString) throws InvalidInputException {
        this.fieldModel.setName(aliasInputString);
        String[] attrs = new String[]{ALIAS};
        if (this.isInputHasSpaces(aliasInputString)) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB211")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_3", inserts), attrs);
        }
        if (aliasInputString.length() > 128 || !this.isValidName(aliasInputString, true)) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB211")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC54A", inserts), attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setSequence(String seqInputString) throws InvalidInputException {
        if (seqInputString.equals("")) {
            this.fieldModel.setSeqType(null);
        } else if (seqInputString.substring(0, 1).equalsIgnoreCase("U")) {
            this.fieldModel.setSeqType(DBDConstants.U);
        } else if (seqInputString.substring(0, 1).equalsIgnoreCase("M")) {
            this.fieldModel.setSeqType(DBDConstants.M);
        } else {
            Object[] inserts = new String[]{seqInputString, WorkbenchModelBundle.getLabel().getString("WB011A")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts));
        }
        this.hasBeenEdited = true;
    }

    public void validateRequiredFields(String[] attrsToCheck) throws ModelException, InvalidInputException {
        int i = 0;
        while (i < attrsToCheck.length) {
            block31: {
                String[] attrs;
                String currAttr;
                block45: {
                    String xmlSchemaUrl;
                    block44: {
                        String userConv;
                        block43: {
                            DBDConstants isSigned;
                            Object[] inserts;
                            block42: {
                                Integer scale;
                                block41: {
                                    Integer precision;
                                    block40: {
                                        block39: {
                                            block38: {
                                                Integer maxOccurs;
                                                block37: {
                                                    Integer minOccurs;
                                                    block36: {
                                                        String patternStr;
                                                        block35: {
                                                            block34: {
                                                                block33: {
                                                                    block32: {
                                                                        block30: {
                                                                            currAttr = attrsToCheck[i];
                                                                            if (!currAttr.equals(ALL) && !currAttr.equals(CASE_NAME) || this.mapName.equals(ManageFieldsController.COMMON_FIELDS)) break block30;
                                                                            if (this.caseName == null || this.caseName.isEmpty()) {
                                                                                Object[] inserts2 = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_CASE")};
                                                                                String[] attrs2 = new String[]{CASE_NAME};
                                                                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts2), attrs2);
                                                                            }
                                                                            if (currAttr.equals(CASE_NAME)) break block31;
                                                                        }
                                                                        if (!currAttr.equals(ALL) && !currAttr.equals(START)) break block32;
                                                                        if (!this.fieldModel.isStartAfterSelected()) {
                                                                            int startPostion = this.fieldModel.getStartPos();
                                                                            if (startPostion < 0) {
                                                                                Object[] inserts3 = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_POSITION")};
                                                                                String[] attrs3 = new String[]{START};
                                                                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts3), attrs3);
                                                                            }
                                                                        } else {
                                                                            String startAfter = this.fieldModel.getStartAfter();
                                                                            if (startAfter == null || startAfter.isEmpty()) {
                                                                                Object[] inserts4 = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER")};
                                                                                String[] attrs4 = new String[]{START};
                                                                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts4), attrs4);
                                                                            }
                                                                        }
                                                                        if (currAttr.equals(START)) break block31;
                                                                    }
                                                                    if (!currAttr.equals(ALL) && !currAttr.equals(IMS_NAME)) break block33;
                                                                    String fieldName = this.fieldModel.getImsName();
                                                                    if (this.fieldModel.isIMSFieldSelected() && (fieldName == null || fieldName.isEmpty())) {
                                                                        Object[] inserts5 = new String[]{WorkbenchModelBundle.getLabel().getString("WB010A")};
                                                                        String[] attrs5 = new String[]{IMS_NAME};
                                                                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts5), attrs5);
                                                                    }
                                                                    if (currAttr.equals(IMS_NAME)) break block31;
                                                                }
                                                                if (!currAttr.equals(ALL) && !currAttr.equals(ALIAS)) break block34;
                                                                String fieldAlias = this.fieldModel.getAlias();
                                                                if (fieldAlias == null || fieldAlias.isEmpty()) {
                                                                    Object[] inserts6 = new String[]{WorkbenchModelBundle.getLabel().getString("WB211")};
                                                                    String[] attrs6 = new String[]{ALIAS};
                                                                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts6), attrs6);
                                                                }
                                                                if (currAttr.equals(ALIAS)) break block31;
                                                            }
                                                            if (!currAttr.equals(ALL) && !currAttr.equals(APP_DATATYPE)) break block35;
                                                            DBDConstants adt = this.fieldModel.getAppDatatype();
                                                            if (adt == null) {
                                                                Object[] inserts7 = new String[]{WorkbenchModelBundle.getLabel().getString("WB342")};
                                                                String[] attrs7 = new String[]{APP_DATATYPE};
                                                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts7), attrs7);
                                                            }
                                                            if (currAttr.equals(APP_DATATYPE)) break block31;
                                                        }
                                                        if (!currAttr.equals(ALL) && !currAttr.equals(PATTERN)) break block36;
                                                        DBDConstants adt = this.fieldModel.getAppDatatype();
                                                        if (!(adt != DBDConstants.DATE && adt != DBDConstants.TIME && adt != DBDConstants.TIMESTAMP || (patternStr = this.fieldModel.getPattern()) != null && !patternStr.isEmpty())) {
                                                            Object[] inserts8 = new String[]{WorkbenchModelBundle.getLabel().getString("WB022A")};
                                                            attrs = new String[]{PATTERN};
                                                            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts8), attrs);
                                                        }
                                                        if (currAttr.equals(PATTERN)) break block31;
                                                    }
                                                    if (!currAttr.equals(ALL) && !currAttr.equals(MIN_OCCURS)) break block37;
                                                    DBDConstants adt = this.fieldModel.getAppDatatype();
                                                    if (adt == DBDConstants.ARRAY && ((minOccurs = this.fieldModel.getMinOccurs()) == null || minOccurs < 0)) {
                                                        Object[] inserts9 = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS")};
                                                        attrs = new String[]{MIN_OCCURS};
                                                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts9), attrs);
                                                    }
                                                    if (currAttr.equals(MIN_OCCURS)) break block31;
                                                }
                                                if (!currAttr.equals(ALL) && !currAttr.equals(MAX_OCCURS)) break block38;
                                                DBDConstants adt = this.fieldModel.getAppDatatype();
                                                if (adt == DBDConstants.ARRAY && ((maxOccurs = this.fieldModel.getMaxOccurs()) == null || maxOccurs < 0)) {
                                                    Object[] inserts10 = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_MAX_OCCURS")};
                                                    attrs = new String[]{MAX_OCCURS};
                                                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts10), attrs);
                                                }
                                                if (currAttr.equals(MAX_OCCURS)) break block31;
                                            }
                                            if (!currAttr.equals(ALL) && !currAttr.equals(DEPENDSON)) break block39;
                                            DBDConstants adt = this.fieldModel.getAppDatatype();
                                            if (adt == DBDConstants.ARRAY) {
                                                String dependsOn;
                                                Integer minOccurs = this.fieldModel.getMinOccurs();
                                                Integer maxOccurs = this.fieldModel.getMaxOccurs();
                                                if (minOccurs != null && maxOccurs != null && maxOccurs > minOccurs && ((dependsOn = this.fieldModel.getDependsOn()) == null || dependsOn.isEmpty())) {
                                                    Object[] inserts11 = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_DEPENDS_ON")};
                                                    String[] attrs8 = new String[]{DEPENDSON};
                                                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts11), attrs8);
                                                }
                                            }
                                            if (currAttr.equals(DEPENDSON)) break block31;
                                        }
                                        if (!currAttr.equals(ALL) && !currAttr.equals(LENGTH)) break block40;
                                        DBDConstants adt = this.fieldModel.getAppDatatype();
                                        if (adt != null) {
                                            int fieldLength;
                                            if (!(adt.equals((Object)DBDConstants.ARRAY) || adt.equals((Object)DBDConstants.STRUCT) || adt == DBDConstants.XML && this.getStartPos().equals("0") || (fieldLength = this.fieldModel.getBytes()) > 0)) {
                                                Object[] inserts12 = new String[]{WorkbenchModelBundle.getLabel().getString("WB013A")};
                                                attrs = new String[]{LENGTH};
                                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts12), attrs);
                                            }
                                        } else {
                                            int fieldLength;
                                            String imsName = this.fieldModel.getImsName();
                                            if (imsName != null && imsName.startsWith("/CK") && (fieldLength = this.fieldModel.getBytes()) <= 0) {
                                                inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB013A")};
                                                String[] attrs9 = new String[]{LENGTH};
                                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs9);
                                            }
                                        }
                                        if (currAttr.equals(LENGTH)) break block31;
                                    }
                                    if (!currAttr.equals(ALL) && !currAttr.equals(PRECISION)) break block41;
                                    DBDConstants pdt = this.fieldModel.getPhysicalDataType();
                                    DBDConstants adt = this.fieldModel.getAppDatatype();
                                    if ((pdt == DBDConstants.PACKEDDECIMAL || pdt == DBDConstants.ZONEDDECIMAL || adt == DBDConstants.DECIMAL && pdt == DBDConstants.BINARY) && ((precision = this.fieldModel.getPrecision()) == null || precision == -1)) {
                                        inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB023A")};
                                        String[] attrs10 = new String[]{PRECISION};
                                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs10);
                                    }
                                    if (currAttr.equals(PRECISION)) break block31;
                                }
                                if (!currAttr.equals(ALL) && !currAttr.equals(SCALE)) break block42;
                                DBDConstants pdt = this.fieldModel.getPhysicalDataType();
                                DBDConstants adt = this.fieldModel.getAppDatatype();
                                if ((pdt == DBDConstants.PACKEDDECIMAL || pdt == DBDConstants.ZONEDDECIMAL || adt == DBDConstants.DECIMAL && pdt == DBDConstants.BINARY) && ((scale = this.fieldModel.getScale()) == null || scale == -1)) {
                                    inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB024A")};
                                    String[] attrs11 = new String[]{SCALE};
                                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs11);
                                }
                                if (currAttr.equals(SCALE)) break block31;
                            }
                            if (!currAttr.equals(ALL) && !currAttr.equals(IS_SIGNED)) break block43;
                            DBDConstants pdt = this.fieldModel.getPhysicalDataType();
                            DBDConstants adt = this.fieldModel.getAppDatatype();
                            if ((pdt == DBDConstants.PACKEDDECIMAL || pdt == DBDConstants.ZONEDDECIMAL || adt == DBDConstants.DECIMAL && pdt == DBDConstants.BINARY) && (isSigned = this.fieldModel.getIsSigned()) == null) {
                                inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB025A")};
                                String[] attrs12 = new String[]{IS_SIGNED};
                                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs12);
                            }
                            if (currAttr.equals(IS_SIGNED)) break block31;
                        }
                        if (!currAttr.equals(ALL) && !currAttr.equals(USER_CONV)) break block44;
                        if (this.fieldModel.isUserSelected() && ((userConv = this.fieldModel.getUserTypeConverter()) == null || userConv.isEmpty())) {
                            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB030A")};
                            String[] attrs13 = new String[]{USER_CONV};
                            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs13);
                        }
                        if (currAttr.equals(USER_CONV)) break block31;
                    }
                    if (!currAttr.equals(ALL) && !currAttr.equals(XML_SCHEMA)) break block45;
                    DBDConstants pdt = this.fieldModel.getPhysicalDataType();
                    if (pdt == DBDConstants.XML_CLOB && ((xmlSchemaUrl = this.fieldModel.getUrl()) == null || xmlSchemaUrl.isEmpty())) {
                        Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB028A")};
                        attrs = new String[]{XML_SCHEMA};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
                    }
                    if (currAttr.equals(XML_SCHEMA)) break block31;
                }
                if (currAttr.equals(ALL) || currAttr.equals(OVERFLOW_SEGM)) {
                    String overflowSegm;
                    DBDConstants pdt = this.fieldModel.getPhysicalDataType();
                    if (pdt == DBDConstants.XML_CLOB && !this.getStartPos().equals("0") && ((overflowSegm = this.fieldModel.getOverflow()) == null || overflowSegm.isEmpty())) {
                        Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB029A")};
                        attrs = new String[]{OVERFLOW_SEGM};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
                    }
                    if (currAttr.equals(OVERFLOW_SEGM)) {
                        // empty if block
                    }
                }
            }
            ++i;
        }
    }

    public void setIMSFieldSelected(boolean isIMSField) throws InvalidInputException {
        this.fieldModel.setIMSFieldSelected(isIMSField);
        this.hasBeenEdited = true;
    }

    public void setStartAfterSelected(boolean isStartAfter) {
        this.fieldModel.setStartAfterSelected(isStartAfter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setRedefines(String redfefinesVal) throws ModelException, InvalidInputException {
        if (redfefinesVal != null && !redfefinesVal.isEmpty()) {
            FieldModel priorField = this.isFieldExisted(redfefinesVal);
            if (priorField == null) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER")};
                String[] attrs = new String[]{START};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
            }
            boolean dynamicArrayExist = ManageFieldsController.isFieldDynamicLength(priorField);
            if (dynamicArrayExist) {
                Object[] inserts = new Object[]{priorField.getImsNameOrAlias()};
                String[] attrs = new String[]{REDEFINES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_11", inserts), attrs);
            }
            this.fieldModel.setRedefines(redfefinesVal);
        } else {
            this.fieldModel.setRedefines(null);
        }
        this.hasBeenEdited = true;
    }

    public String getRedefines() {
        return this.fieldModel.getRedefines();
    }

    public boolean isIMSFieldSelected() {
        return this.fieldModel.isIMSFieldSelected();
    }

    public boolean isStartAfterSelected() {
        return this.fieldModel.isStartAfterSelected();
    }

    public String getSegmentName() {
        String name = this.segmentModel.getImsName();
        if (name == null) {
            name = this.segmentModel.getName();
        }
        return name;
    }

    public List<FieldModel> getCaseFields(MappingCaseType mappingCaseType) {
        return this.segmentModel.getCaseFields(mappingCaseType);
    }

    public void setUserTypeConverer(String value) {
        this.fieldModel.setUserTypeConverer(value);
        this.hasBeenEdited = true;
    }

    public void setUrl(String value) {
        this.fieldModel.setUrl(value);
        this.hasBeenEdited = true;
    }

    public void setOverflow(String value) {
        this.fieldModel.setOverflow(value);
        this.hasBeenEdited = true;
    }

    public Vector<FieldModel> getTopLevelFieldList() throws ModelException {
        return this.segmentModel.getTopLevelFieldList();
    }

    public MappingModel getMappingModel(String mappingName) {
        return this.segmentModel.getMapping(mappingName);
    }

    public FieldModel getFieldModel(String fieldName) throws ModelException {
        return this.segmentModel.getFieldWithImsNameOrAlias(fieldName);
    }

    public FieldModel getFieldModel() {
        return this.fieldModel;
    }

    public SegmentModel getSegmentModel() {
        return this.segmentModel;
    }

    public Vector<FieldModel> getChildFields() {
        return this.fieldModel.getChildFields();
    }

    public Iterator<MappingModel> getMappingList() {
        return this.mfController.getMappingList();
    }

    public boolean isValidParent(FieldModel currentField) {
        FieldModel parentField;
        DBDConstants dataType;
        if (currentField != null && ((dataType = currentField.getAppDatatype()) == DBDConstants.STRUCT || dataType == DBDConstants.ARRAY) && (parentField = currentField.getParentField()) != null) {
            String parentName = parentField.getName();
            if (parentName.equals(this.fieldModel.getName())) {
                return false;
            }
            return this.isValidParent(parentField);
        }
        return true;
    }

    public void setUserSelected(boolean isUser) {
        this.fieldModel.setUserSelected(isUser);
        this.hasBeenEdited = true;
    }

    public boolean isUserSelected() {
        return this.fieldModel.isUserSelected();
    }

    public String getImsName() {
        return this.fieldModel.getImsName();
    }

    public String getName() {
        return this.fieldModel.getName();
    }

    public void setImsDatatype(DBDConstants value) {
        this.fieldModel.setImsDatatype(value);
        this.hasBeenEdited = true;
    }

    public DBDConstants getImsDatatype() {
        return this.fieldModel.getImsDatatype();
    }

    public DBDConstants getAppDatatype() {
        return this.fieldModel.getAppDatatype();
    }

    public DBDConstants getPhysicalDataType() {
        return this.fieldModel.getPhysicalDataType();
    }

    public String getUserTypeConverter() {
        return this.fieldModel.getUserTypeConverter();
    }

    public String getEncoding() {
        String encoding = this.fieldModel.getEncoding();
        if (encoding == null) {
            encoding = this.segmentModel.getEncoding();
        }
        if (encoding == null) {
            encoding = this.segmentModel.getDbdModel().getEncoding();
        }
        return encoding;
    }

    public DBDConstants getPureDBCS() {
        return this.fieldModel.getIsDbcs();
    }

    public Integer getPrecision() {
        return this.fieldModel.getPrecision();
    }

    public Integer getScale() {
        return this.fieldModel.getScale();
    }

    public DBDConstants getIsSigned() {
        return this.fieldModel.getIsSigned();
    }

    public String getUrl() {
        return this.fieldModel.getUrl();
    }

    public String getOverflow() {
        return this.fieldModel.getOverflow();
    }

    public int getPropertyListSize() {
        return this.fieldModel.getPropertyListSize();
    }

    public String getPropertyName(int pos) {
        return this.fieldModel.getPropertyName(pos);
    }

    public String getPropertyValue(int pos) {
        return this.fieldModel.getPropertyValue(pos);
    }

    public void semanticCheck() throws InvalidInputException, ModelException {
        this.mfController.validateSeqInput(this.fieldModel);
        this.mfController.validateImsNameAndAliasInput(this.fieldModel);
        this.mfController.validateCKField(this.fieldModel);
        this.validateStart();
        this.validateMinMaxOccurs();
        this.validateStaticToDynamicArray();
        this.validateRedefines();
        this.mfController.validateDependson(this.fieldModel);
        this.validateAppPhysDataTypes(this.fieldModel);
        this.validatePrecisionAndScale();
        this.validateXMLStartAndLength();
    }

    private void validateXMLStartAndLength() throws InvalidInputException {
        DBDConstants adt = this.fieldModel.getAppDatatype();
        if (adt == DBDConstants.XML) {
            int startPos = this.fieldModel.getStartPos();
            int length = this.fieldModel.getBytes();
            if (startPos > 0 && length <= 0) {
                String[] attrs = new String[]{START, LENGTH};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_45"), attrs);
            }
        }
    }

    private void validatePrecisionAndScale() throws InvalidInputException {
        Integer precisionInt = this.fieldModel.getPrecision();
        Integer scaleInt = this.fieldModel.getScale();
        if (precisionInt != null && scaleInt != null && scaleInt > precisionInt) {
            String[] attrs = new String[]{PRECISION, SCALE};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_36"), attrs);
        }
    }

    public void validateRedefines() throws InvalidInputException, ModelException {
        String redefinedFieldStr = this.fieldModel.getRedefines();
        if (redefinedFieldStr != null && !redefinedFieldStr.isEmpty()) {
            if (ManageFieldsController.isFieldDynamicLength(this.fieldModel)) {
                String[] attrs = new String[]{REDEFINES, DEPENDSON};
                Object[] inserts = new Object[]{this.fieldModel.getImsNameOrAlias()};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_20", inserts), attrs);
            }
            FieldModel redefinedField = this.mfController.getFieldModel(redefinedFieldStr, this.mapName, this.caseName);
            if (redefinedField.getMaxBytes() > 0) {
                String[] attrs = new String[]{REDEFINES, DEPENDSON};
                Object[] inserts = new Object[]{redefinedField.getImsNameOrAlias()};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_11", inserts), attrs);
            }
        }
    }

    private void validateStaticToDynamicArray() throws InvalidInputException, ModelException {
        Integer minOccurs = this.fieldModel.getMinOccurs();
        Integer maxOccurs = this.fieldModel.getMaxOccurs();
        if (minOccurs != null && maxOccurs != null && minOccurs.intValue() != maxOccurs.intValue() && this.fieldOrAncestorInRedefinesGroup(this.fieldModel)) {
            String[] attrs = new String[]{MIN_OCCURS, MAX_OCCURS, DEPENDSON};
            Object[] inserts = new Object[]{this.fieldModel.getName()};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_50", inserts), attrs);
        }
    }

    private boolean fieldOrAncestorInRedefinesGroup(FieldModel field) throws ModelException {
        if (field != null) {
            if (this.fieldIsInRedefinesGroup(field)) {
                return true;
            }
            FieldModel parentField = field.getParentField();
            if (parentField != null && this.fieldOrAncestorInRedefinesGroup(parentField)) {
                return true;
            }
        }
        return false;
    }

    private boolean fieldIsInRedefinesGroup(FieldModel field) throws ModelException {
        String[] currRedefinesGrp;
        Vector<FieldModel> allFields = this.mfController.getFreshFieldList(this.mapName, this.caseName);
        List<List<String>> redefinesGroupList = this.mfController.buildRedefinesGroupList(allFields);
        return redefinesGroupList != null && (currRedefinesGrp = this.mfController.getRedefinesGroup(field.getName(), redefinesGroupList)) != null;
    }

    private void validateStart() throws InvalidInputException {
        int startInt;
        if (!(this.fieldModel.isStartAfterSelected() || (startInt = this.fieldModel.getStartPos()) != 0 || this.getAppDatatype() != null && this.getAppDatatype().equals((Object)DBDConstants.XML) || this.getImsName() != null && this.getImsName().startsWith("/SX"))) {
            String[] attrs = new String[]{START, APP_DATATYPE};
            Object[] inserts = new Object[]{WorkbenchModelBundle.getLabel().getString("WB342")};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_34", inserts), attrs);
        }
    }

    public InvalidInputException validateAttrChangable(String attr, Object newValue) throws ModelException {
        InvalidInputException retVal = null;
        if (attr.equals(CONTAINER_NAME) || attr.equals(CASE_NAME) || attr.equals(PARENT) || attr.equals(FOLLOWSBUTTON) || attr.equals(STARTBUTTON) || attr.equals(FOLLOWS) || attr.equals(ALIAS) || attr.equals(REDEFINES) || attr.equals(START)) {
            String[] attrs = new String[]{};
            if (!this.actionType.equals(MOVE) && (retVal = this.mfController.validateFieldPartOfRedefinesGroup(this.fieldModel)) != null) {
                attrs = new String[]{CONTAINER_NAME, CASE_NAME, PARENT, START, ALIAS, REDEFINES};
            }
            if (retVal == null && attr.equals(STARTBUTTON) && this.fieldModel.getParentField() != null && (retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_29"))) != null) {
                attrs = new String[]{START};
            }
            if (retVal == null && attr.equals(PARENT) && (retVal = this.validateChangeXmlDataType(newValue, PARENT)) != null) {
                attrs = new String[]{PARENT};
            }
            if (retVal != null) {
                this.notifyListeners(attrs);
            }
        } else if (attr.equals(APP_DATATYPE)) {
            retVal = this.mfController.validateDependsOn(this.fieldModel, this.mapName, this.caseName, this, newValue);
            if (retVal == null) {
                retVal = this.mfController.validateChangeArrayStructDatatype(this.fieldModel, this.mapName, this.caseName, this, newValue);
            }
            if (retVal == null) {
                retVal = this.validateChangeXmlDataType(newValue, APP_DATATYPE);
            }
            if (retVal != null) {
                this.notifyListeners(APP_DATATYPE);
            }
        } else if (attr.equals(PHY_DATATYPE)) {
            retVal = this.validateChangeXmlDataType(newValue, PHY_DATATYPE);
            if (retVal == null) {
                retVal = this.mfController.validateDependsOn(this.fieldModel, this.mapName, this.caseName, this, newValue);
            }
            if (retVal != null) {
                this.notifyListeners(PHY_DATATYPE);
            }
        } else if (attr.equals(USERDEFINED_FIELD)) {
            retVal = this.mfController.validateSecondaryIndex(this.fieldModel);
            if (retVal != null) {
                this.notifyListeners(USERDEFINED_FIELD);
            }
        } else if (attr.equals(SCALE) && (retVal = this.mfController.validateDependsOnAndAppDataType(this.fieldModel, this.mapName, this.caseName, newValue)) != null) {
            this.notifyListeners(SCALE);
        }
        return retVal;
    }

    private InvalidInputException validateChangeXmlDataType(Object newValue, String attr) throws ModelException {
        InvalidInputException retVal = null;
        if (attr.equals(APP_DATATYPE)) {
            String appDataType = (String)newValue;
            if (this.fieldModel.getParentField() != null && appDataType.equals(DBDConstants.XML.value())) {
                retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_32"));
            }
        } else if (attr.equals(PHY_DATATYPE)) {
            String phyDataType = (String)newValue;
            if (this.fieldModel.getParentField() != null && phyDataType.equals(DBDConstants.XML_CLOB.value())) {
                retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_32"));
            }
        } else if (attr.equals(PARENT)) {
            String parentName = (String)newValue;
            if ((this.fieldModel.getAppDatatype() != null && this.fieldModel.getAppDatatype().equals((Object)DBDConstants.XML) || this.fieldModel.getPhysicalDataType() != null && this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.XML_CLOB)) && parentName != null && !parentName.isEmpty()) {
                retVal = new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_32"));
            }
        }
        return retVal;
    }

    public String getOriginalMapName() {
        return this.mfController.getOriginalMapName();
    }

    public String getOriginalCaseName() {
        return this.mfController.getOriginalCaseName();
    }

    public String getOriginalParentName() {
        return this.mfController.getOriginalParentName();
    }

    public String getOriginalFollowsField() {
        return this.mfController.getOriginalFollowsField();
    }

    public String getOriginalStartPos() {
        return this.mfController.getOriginalStartPos();
    }

    public String getOriginalAlias() {
        return this.mfController.getOriginalAlias();
    }

    public DBDConstants getOriginalDataType() {
        return this.mfController.getOriginalDataType();
    }

    public void validateAppPhysDataTypes(FieldModel clonedFieldModel) throws ModelException, InvalidInputException {
        DBDConstants appDataType = clonedFieldModel.getAppDatatype();
        DBDConstants physDataType = clonedFieldModel.getPhysicalDataType();
        if (physDataType != null && physDataType.equals((Object)DBDConstants.XML_CLOB) && clonedFieldModel.isIMSFieldSelected()) {
            String[] attrs = new String[]{FIELD_TYPE, PHY_DATATYPE};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_16"), attrs);
        }
        if (appDataType != null) {
            if ((appDataType.equals((Object)DBDConstants.ARRAY) || appDataType.equals((Object)DBDConstants.STRUCT)) && clonedFieldModel.isIMSFieldSelected()) {
                String[] attrs = new String[]{FIELD_TYPE, APP_DATATYPE};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_23"), attrs);
            }
            if (appDataType.equals((Object)DBDConstants.XML) && clonedFieldModel.isIMSFieldSelected()) {
                String[] attrs = new String[]{FIELD_TYPE, APP_DATATYPE};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_24"), attrs);
            }
        }
    }

    private void validateStaticFieldFits(FieldModel clonedFieldModel) throws InvalidInputException, ModelException {
        int startPosInt = clonedFieldModel.getStartPos();
        int segLength = this.segmentModel.getMaxBytes();
        if (startPosInt > 0 && startPosInt > segLength) {
            Object[] inserts = new String[]{Integer.toString(segLength), this.segmentModel.getName()};
            String[] attrs = new String[]{START};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_1", inserts), attrs);
        }
        DBDConstants appDatatype = clonedFieldModel.getAppDatatype();
        if (appDatatype != null && appDatatype != DBDConstants.ARRAY && appDatatype != DBDConstants.STRUCT) {
            int lengthInt = clonedFieldModel.getBytes();
            String fieldStartAfterName = clonedFieldModel.getStartAfter();
            if (fieldStartAfterName != null && !fieldStartAfterName.isEmpty()) {
                int startPos;
                FieldModel fieldStartAfter = this.segmentModel.getFieldWithAlias(fieldStartAfterName, null);
                if (fieldStartAfter != null && (fieldStartAfter.getChildFields() == null || fieldStartAfter.getChildFields().isEmpty()) && (startPos = fieldStartAfter.getStartPos() + this.mfController.getSize(fieldStartAfter)) + lengthInt - 1 > segLength) {
                    Object[] inserts = new String[]{Integer.toString(startPos + lengthInt - 1), Integer.toString(segLength), this.segmentModel.getName()};
                    String[] attrs = new String[]{START, LENGTH};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_2", inserts), attrs);
                }
            } else if (startPosInt + lengthInt - 1 > segLength) {
                Object[] inserts = new String[]{Integer.toString(startPosInt + lengthInt - 1), Integer.toString(segLength), this.segmentModel.getName()};
                String[] attrs = new String[]{START, LENGTH};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_2", inserts), attrs);
            }
        }
    }

    private void validateMinMaxOccurs() throws InvalidInputException {
        Integer minOccurs = this.fieldModel.getMinOccurs();
        Integer maxOccurs = this.fieldModel.getMaxOccurs();
        if (minOccurs != null && maxOccurs != null) {
            if (minOccurs.equals(maxOccurs)) {
                this.fieldModel.setDependsOn(null);
            } else if (minOccurs > maxOccurs) {
                String[] attrs = new String[]{MIN_OCCURS, MAX_OCCURS};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_9"), attrs);
            }
        }
    }

    public List<FieldModel> getFieldList() throws ModelException {
        MappingCaseModel mapCase;
        MappingModel map;
        Vector<FieldModel> fields = null;
        if (this.mapName == null || this.mapName.equals(ManageFieldsController.COMMON_FIELDS)) {
            fields = this.segmentModel.getFieldList(false, true);
        } else if (this.caseName != null && (map = this.segmentModel.getMapping(this.mapName)) != null && (mapCase = map.getMappingCaseModel(this.caseName)) != null) {
            fields = mapCase.getFieldList(true);
        }
        return fields;
    }

    public String getMaxBytes() {
        return Integer.toString(this.fieldModel.getMaxBytes());
    }

    public DBDConstants getAccessType() {
        return this.segmentModel.getDbdModel().getAccessType();
    }

    public boolean isFieldNameTaken(String fieldName) throws ModelException {
        List<FieldModel> fields = this.getFieldList();
        if (fields == null) {
            return true;
        }
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            if (this.fieldModel.getFieldType() != currField.getFieldType()) {
                String currIMSName = currField.getImsName();
                if (currIMSName == null) {
                    currIMSName = "";
                }
                if (currIMSName.equals(fieldName)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isAliasTaken(String alias) throws ModelException {
        List<FieldModel> fields = this.getFieldList();
        if (fields == null) {
            return true;
        }
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            if (this.fieldModel.getFieldType() != currField.getFieldType()) {
                String currAlias = currField.getName();
                if (currAlias == null) {
                    currAlias = "";
                }
                if (currAlias.equals(alias)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) throws InvalidInputException {
        boolean valueChanged = false;
        if (!mapName.equals(this.mapName)) {
            valueChanged = true;
        }
        if (!mapName.equals(ManageFieldsController.COMMON_FIELDS) && !mapName.equals(this.segmentModel.getImsName())) {
            Iterator<MappingModel> mappingModelIter = this.mfController.getMappingList();
            if (mappingModelIter != null) {
                while (mappingModelIter.hasNext()) {
                    MappingModel currentMap = mappingModelIter.next();
                    if (!currentMap.getName().equals(mapName)) continue;
                    this.mapName = mapName;
                }
            }
        } else if (mapName.equals(ManageFieldsController.COMMON_FIELDS) || mapName.equals(this.segmentModel.getImsName())) {
            this.mapName = mapName;
        } else {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_CONTAINER")};
            String[] attrs = new String[]{CONTAINER_NAME};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
        }
        if (valueChanged) {
            this.caseName = "";
            this.fieldModel.setParentField(null);
            this.fieldModel.setStartAfterSelected(true);
            this.fieldModel.setStartAfter("");
            this.fieldModel.setStartPos(0);
            String[] attrs = new String[]{CASE_NAME, PARENT, START, REDEFINES};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public void setCaseName(String caseName) throws InvalidInputException {
        boolean caseModelFound = false;
        boolean valueChanged = false;
        if (!caseName.equals(this.caseName)) {
            valueChanged = true;
        }
        if (caseName == null || caseName.isEmpty()) {
            this.caseName = null;
        } else {
            Iterator<MappingModel> mappingModelIter = this.mfController.getMappingList();
            while (mappingModelIter.hasNext()) {
                MappingModel currentMap = mappingModelIter.next();
                MappingCaseModel caseModel = currentMap.getMappingCaseModel(caseName);
                if (caseModel == null) continue;
                this.caseName = caseName;
                caseModelFound = true;
            }
            if (!caseModelFound) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_CASE")};
                String[] attrs = new String[]{CASE_NAME};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
            }
        }
        if (valueChanged) {
            this.fieldModel.setParentField(null);
            this.fieldModel.setStartAfterSelected(true);
            this.fieldModel.setStartAfter("");
            this.fieldModel.setStartPos(0);
            String[] attrs = new String[]{PARENT, START, REDEFINES};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public void performFinish() throws ModelException {
        String imsName = this.fieldModel.getImsName();
        if (imsName != null && (imsName.startsWith("/SX") || imsName.startsWith("/CK"))) {
            FieldModel origField = this.fieldModel;
            this.fieldModel = new SysRelFieldModel();
            this.fieldModel.setImsName(origField.getImsName());
            this.fieldModel.setName(origField.getName());
            this.fieldModel.setBytes(origField.getBytes());
            this.fieldModel.setStartPos(origField.getStartPos());
            this.fieldModel.setRemarks(origField.getRemarks());
        }
        this.clearInvalidDatatypeAttrs();
        if (this.actionType.equals(ADD)) {
            this.mfController.addNewField(this.mapName, this.caseName, this.fieldModel);
        } else {
            List<FieldModel> subsequentFields = null;
            if (this.actionType.equals(MOVE)) {
                subsequentFields = this.getSubsequentMoveFields();
            }
            this.mfController.replaceOrigFieldWithClone(this.mapName, this.caseName, this.fieldModel);
            if (this.actionType.equals(MOVE)) {
                this.moveSubSequentFields(this.fieldModel, subsequentFields);
            }
        }
        this.segmentModel.clearStartInfo(this.mapName, this.caseName);
        this.mfController.clearRedefineGroups();
    }

    private List<FieldModel> getSubsequentMoveFields() throws ModelException {
        ArrayList<FieldModel> subsequentFields = new ArrayList<FieldModel>(this.fieldNames.length - 1);
        int i = 1;
        while (i < this.fieldNames.length) {
            String fieldName = this.fieldNames[i];
            subsequentFields.add(this.mfController.getFieldModel(fieldName, this.mfController.getOriginalMapName(), this.mfController.getOriginalCaseName()));
            ++i;
        }
        return subsequentFields;
    }

    private void moveSubSequentFields(FieldModel fieldModel, List<FieldModel> subsequentFields) throws ModelException {
        String prevFieldName = fieldModel.getName();
        int i = 0;
        while (i < subsequentFields.size()) {
            FieldModel currSubsequentField = subsequentFields.get(i);
            if (currSubsequentField != null && !this.isChildOfFieldModel(fieldModel, currSubsequentField.getName())) {
                currSubsequentField.setStartPos(0);
                currSubsequentField.setRelativeStart(0);
                currSubsequentField.setStartAfter(prevFieldName);
                currSubsequentField.setParentField(fieldModel.getParentField());
                this.mfController.removeFieldFromClonedSegmentModel(currSubsequentField, this.mfController.getOriginalMapName(), this.mfController.getOriginalCaseName());
                this.mfController.addNewField(this.mapName, this.caseName, currSubsequentField);
                this.removeSubsequentChildren(currSubsequentField, subsequentFields);
                fieldModel = currSubsequentField;
                prevFieldName = currSubsequentField.getName();
            }
            ++i;
        }
    }

    private boolean isChildOfFieldModel(FieldModel parentField, String fieldName) {
        boolean retVal = false;
        Vector<FieldModel> childFields = parentField.getChildFields();
        if (childFields != null) {
            for (FieldModel currentChild : childFields) {
                if (!currentChild.getName().equals(fieldName)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private void removeSubsequentChildren(FieldModel parentField, List<FieldModel> subsequentFields) {
        Vector<FieldModel> childFields = parentField.getChildFields();
        if (childFields != null) {
            for (FieldModel currentChild : childFields) {
                this.removeSubsequentChildren(currentChild, subsequentFields);
                subsequentFields.remove(currentChild);
            }
        }
    }

    private void clearInvalidDatatypeAttrs() {
        DBDConstants physDT = this.fieldModel.getPhysicalDataType();
        DBDConstants appDT = this.fieldModel.getAppDatatype();
        if (physDT != DBDConstants.PACKEDDECIMAL && physDT != DBDConstants.ZONEDDECIMAL && (appDT != DBDConstants.DECIMAL || physDT != DBDConstants.BINARY)) {
            this.clearDecimalAttrs();
        }
        if (!this.fieldModel.isUserSelected()) {
            this.clearUserAttrs();
        }
        if (physDT != DBDConstants.XML_CLOB) {
            this.clearXMLAttrs();
        }
        if (appDT != DBDConstants.DATE && appDT != DBDConstants.TIME && appDT != DBDConstants.TIMESTAMP) {
            this.fieldModel.setPattern(null);
        }
        this.fieldModel.removeMarshallerIfEmpty();
    }

    private void clearDecimalAttrs() {
        this.fieldModel.setIsSigned(null);
        this.fieldModel.setPrecision(null);
        this.fieldModel.setScale(null);
    }

    private void clearUserAttrs() {
        this.fieldModel.removeAllProperties();
        this.fieldModel.setUserTypeConverer(null);
    }

    private void clearXMLAttrs() {
        this.fieldModel.setOverflow("");
        this.fieldModel.setUrl("");
    }

    private void updateModelForAppDataTypeChange() throws InvalidInputException {
        DBDConstants newAppDT = this.fieldModel.getAppDatatype();
        DBDConstants pdt = this.fieldModel.getPhysicalDataType();
        String[] attrs = new String[]{PHY_DATATYPE};
        if (newAppDT == DBDConstants.OTHER) {
            this.setPhysicalDataType(DBDConstants.USER);
            this.notifyListeners(attrs);
        } else if (newAppDT == DBDConstants.XML) {
            this.setPhysicalDataType(DBDConstants.XML_CLOB);
            attrs = new String[]{PHY_DATATYPE};
            this.notifyListeners(attrs);
            if (this.fieldModel.isStartAfterSelected()) {
                this.fieldModel.setStartAfterSelected(false);
                this.fieldModel.setStartPos(0);
                attrs = new String[]{START};
                this.notifyListeners(attrs);
            } else if (this.fieldModel.getStartPos() == 0) {
                this.fieldModel.setBytes(0);
                attrs = new String[]{LENGTH};
                this.notifyListeners(attrs);
            }
        } else if (!newAppDT.equals((Object)pdt)) {
            if (pdt == null) {
                this.fieldModel.setUserSelected(false);
            } else {
                this.fieldModel.setPhysicalDataType(null);
            }
            attrs = new String[]{PHY_DATATYPE, LENGTH};
            this.notifyListeners(attrs);
        }
        this.updateLengthValue();
    }

    private void updateLengthValue() {
        DBDConstants newPhysDT = this.fieldModel.getPhysicalDataType();
        if (newPhysDT != null && !newPhysDT.value().isEmpty() && this.lengthMap.keySet().contains(newPhysDT.value())) {
            this.fieldModel.setBytes(this.lengthMap.get(newPhysDT.value()));
            this.notifyListeners(LENGTH);
        } else {
            DBDConstants newAppDT = this.fieldModel.getAppDatatype();
            if (newAppDT != null && this.lengthMap.keySet().contains(newAppDT.value()) && newPhysDT == null) {
                this.fieldModel.setBytes(this.lengthMap.get(newAppDT.value()));
                this.notifyListeners(LENGTH);
            }
        }
    }

    public void addModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    private void notifyListeners(ModelChangeEvent event) {
        for (IModelChangeListener listener : this.modelChangeListeners) {
            listener.handleModelChange(event);
        }
    }

    public void notifyListeners(String[] attrs) {
        ModelChangeEvent changeEvent = new ModelChangeEvent(attrs);
        this.notifyListeners(changeEvent);
    }

    public void notifyListeners(String attr) {
        String[] attrs = new String[]{attr};
        this.notifyListeners(attrs);
    }

    private void initLengthMap() {
        this.lengthMap.put("BIT", 1);
        this.lengthMap.put("BYTE", 1);
        this.lengthMap.put("DOUBLE", 8);
        this.lengthMap.put("FLOAT", 4);
        this.lengthMap.put("INT", 4);
        this.lengthMap.put("LONG", 8);
        this.lengthMap.put("SHORT", 2);
        this.lengthMap.put("DATE", 8);
        this.lengthMap.put("TIME", 8);
        this.lengthMap.put("TIMESTAMP", 8);
        this.lengthMap.put("UBYTE", 1);
        this.lengthMap.put("USHORT", 2);
        this.lengthMap.put("UINT", 4);
        this.lengthMap.put("ULONG", 8);
    }

    private void setDependsOnIfNeeded() throws InvalidInputException {
        int maxVal;
        int minVal = this.fieldModel.getMinOccurs() == null ? 0 : this.fieldModel.getMinOccurs();
        int n = maxVal = this.fieldModel.getMaxOccurs() == null ? 0 : this.fieldModel.getMaxOccurs();
        if (minVal == maxVal) {
            this.setDependsOn(null);
            this.notifyListeners(DEPENDSON);
        }
    }
}

