/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.editor;

import com.ibm.im.ims.workbench.imsdb.connections.utils.JDBCHelper;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ClearJDBCCacheJob;
import com.ibm.im.ims.workbench.model.utilities.DatabaseViewGeneratorExceptionHelper;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ResourceEditorController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private PsbModel psbModel;
    private DbdModel dbdModel;
    private String projectName;
    private boolean segmentMetadataChanged = false;

    public ResourceEditorController(InputStream inputStream, boolean isPsb, String projectName) throws ModelException {
        if (isPsb) {
            this.psbModel = new PsbModel(inputStream);
        } else {
            this.dbdModel = new DbdModel(inputStream);
        }
        this.projectName = projectName;
    }

    public ResourceEditorController(InputStream inputStream, boolean isPsb) throws ModelException {
        if (isPsb) {
            this.psbModel = new PsbModel(inputStream);
        } else {
            this.dbdModel = new DbdModel(inputStream);
        }
    }

    public PsbModel getPsbModel() {
        return this.psbModel;
    }

    public DbdModel getDbdModel() {
        return this.dbdModel;
    }

    public SegmentModel getSegmentModel(String segmentName) {
        return this.dbdModel.getSegment(segmentName);
    }

    public DatabaseViewGeneratorExceptionHelper doSave(String projectName, IFile file, IProgressMonitor monitor, boolean genDBViews) throws CoreException, ModelException, FileNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DatabaseViewGeneratorExceptionHelper helper = null;
        if (this.psbModel != null) {
            this.savePsbModel(file, monitor);
            this.saveGeneratedPsbSource(projectName, monitor);
            this.saveGeneratedPsbDdl(projectName, monitor);
            this.saveGeneratedPsbSourceExtended(projectName, monitor);
            if (genDBViews) {
                ArrayList<PsbModel> listPsb = new ArrayList<PsbModel>(1);
                listPsb.add(this.psbModel);
                helper = this.marshallGeneratedDbViews(projectName, listPsb);
            }
        } else {
            Vector profiles;
            this.saveDbdModel(file, monitor);
            this.saveGeneratedDbdSource(projectName, monitor);
            this.saveGeneratedDbdSourceExtended(projectName, monitor);
            if (genDBViews) {
                ArrayList<String> tempDBDs = new ArrayList<String>(1);
                tempDBDs.add(this.dbdModel.getDBDName());
                List<PsbModel> listPsb = ProjectTreeFileHelper.findRelatedPSBs(projectName, tempDBDs);
                helper = this.marshallGeneratedDbViews(projectName, listPsb);
            }
            if (this.segmentMetadataChanged && (profiles = JDBCHelper.getIMSConnectionProfilesBasedOnProject((String)projectName)) != null && profiles.size() > 0) {
                ClearJDBCCacheJob clearJob = new ClearJDBCCacheJob("Clearing JDBC metadata cache for connections using metadata from project: " + projectName, profiles);
                logger.finer("Scheduling job to clear the JDBC driver's metadata cache for connections using metadata from project: " + projectName);
                clearJob.schedule();
            }
            this.segmentMetadataChanged = false;
        }
        return helper;
    }

    private void saveDbdModel(IFile file, IProgressMonitor monitor) throws ModelException, CoreException {
        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
        this.dbdModel.marshall(dbdOutputStream);
        file.setContents((InputStream)new ByteArrayInputStream(dbdOutputStream.toByteArray()), true, true, monitor);
    }

    private void saveGeneratedDbdSource(String projectName, IProgressMonitor monitor) throws CoreException, ModelException {
        ProjectTreeFileHelper.marshallGeneratedDbdFile(projectName, this.dbdModel);
        ProjectTreeFileHelper.marshallGeneratedDdlFile(projectName, this.dbdModel);
    }

    private void saveGeneratedDbdSourceExtended(String projectName, IProgressMonitor monitor) throws CoreException, ModelException {
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile(projectName, this.dbdModel);
    }

    private void savePsbModel(IFile file, IProgressMonitor monitor) throws ModelException, CoreException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.psbModel.marshall(outputStream);
        file.setContents((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, true, monitor);
    }

    private void saveGeneratedPsbSource(String projectName, IProgressMonitor monitor) throws CoreException {
        ProjectTreeFileHelper.marshallGeneratedPsbFile(projectName, this.psbModel);
    }

    private void saveGeneratedPsbDdl(String projectName, IProgressMonitor monitor) throws CoreException, ModelException {
        ProjectTreeFileHelper.marshallGeneratedDdlFile(projectName, this.psbModel);
    }

    private void saveGeneratedPsbSourceExtended(String projectName, IProgressMonitor monitor) throws ModelException, CoreException {
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedPsbFile(projectName, this.psbModel);
    }

    private DatabaseViewGeneratorExceptionHelper marshallGeneratedDbViews(String projectName, List<PsbModel> listPsb) throws CoreException {
        DatabaseViewGeneratorExceptionHelper helper = new DatabaseViewGeneratorExceptionHelper();
        int i = 0;
        while (i < listPsb.size()) {
            PsbModel currPsb = listPsb.get(i);
            helper.addExceptions(ProjectTreeFileHelper.marshallGeneratedDbView(projectName, currPsb));
            ++i;
        }
        return helper;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isSegmentMetadataChanged() {
        return this.segmentMetadataChanged;
    }

    public void setSegmentMetadataChanged(boolean segmentMetadataChanged) {
        this.segmentMetadataChanged = segmentMetadataChanged;
    }
}

