/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.editor;

import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class EditSegmentController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SegmentModel origSegmentModel;
    private SegmentModel clonedSegmentModel;
    private DBDConstants dbdAccessType;
    private static final int EXITNAME = 1001;
    private static final int ASTRIXNAME = 1002;
    private static final int INSIDECASCADE = 1003;
    private static final int OUTSIDECASCADE = 1004;
    public static final String MAXBYTES = "MAXBYTES";
    public static final String MINBYTES = "MINBYTES";
    public static final String DEDB_DEPENDENT_SEGMENT_TYPE = "DEDB_DEPENDENT_SEGMENT_TYPE";
    public static final String SSPTR = "SSPTR";
    public static final String ENCODING = "ENCODING";
    public static final String DSGROUP = "DSGROUP";
    public static final String BYTES = "BYTES";
    public static final String RULES = "RULES";
    public static final String SOURCE = "SOURCE";
    public static final String FREQ = "FREQ";
    public static final String LTWIN = "LTWIN";
    public static final String INSERTION_LOCATION = "INSERTION_LOCATION";
    public static final String DATA_CAPTURE = "DATA_CAPTURE";
    public static final String NOCASCADE = "NO_CASCADE";
    public static final String DLET = "DLET";
    public static final String FLD = "FLD";
    public static final String EXIT = "EXIT";
    public static final String SSPCMD = "SSPCMD";
    public static final String NOTWIN = "NOTWIN";
    public static final String PAIREDYES = "PAIREDYES";
    public static final String COUNTER = "COUNTER";
    public static final String DBD_ACCESS_TYPE = "DBD_ACCESS_TYPE";
    public static final String NOBEFORE = "NOBEFORE";
    public static final String COMPRTN = "COMPRTN";
    private String exitString = null;

    public EditSegmentController(SegmentModel segmentModel) throws ModelException {
        this.origSegmentModel = segmentModel;
        this.clonedSegmentModel = new SegmentModel(segmentModel);
        this.dbdAccessType = segmentModel.getDBDAccessType();
        this.exitString = DBDSourceGenerator.getEXITString(this.origSegmentModel);
        if (this.exitString == null || this.exitString.isEmpty()) {
            this.exitString = DBDSourceGenerator.getDBDEXITString(this.origSegmentModel.getDbdModel());
        }
    }

    public void performFinish() throws ModelException {
        this.origSegmentModel.updateJaxbSegment(this.clonedSegmentModel.getSegmentType());
        this.updateDataCaptureExit();
    }

    private void updateDataCaptureExit() {
        List<DataExitRoutine> origExits = this.origSegmentModel.getDataCaptureExitRoutines();
        List<DataExitRoutine> newExits = this.clonedSegmentModel.getDataCaptureExitRoutines();
        if (origExits != null && !origExits.isEmpty()) {
            origExits.clear();
        }
        if (newExits != null) {
            Iterator<DataExitRoutine> iter = newExits.iterator();
            while (iter.hasNext()) {
                origExits.add(iter.next());
            }
        }
    }

    public String getImsName() {
        return this.clonedSegmentModel.getImsName();
    }

    public String getName() {
        return this.clonedSegmentModel.getName();
    }

    public String getParent() {
        return DBDSourceGenerator.getPARENTString(this.origSegmentModel);
    }

    public String getDBDAccessType() {
        return this.clonedSegmentModel.getDBDAccessType().value();
    }

    public String getSegmentSourceSegName() {
        return this.clonedSegmentModel.getSegmentSourceSegName();
    }

    public String getComprtnModify() {
        return this.clonedSegmentModel.getComprtnModify();
    }

    public String getDedbComprtnRoutineName() {
        return this.clonedSegmentModel.getDedbComprtnRoutineName();
    }

    public String getDedbComprtnInit() {
        DBDConstants init = this.clonedSegmentModel.getDedbComprtnInit();
        if (init == null) {
            return null;
        }
        return init.value();
    }

    public String getDedbComprtnData() {
        DBDConstants data = this.clonedSegmentModel.getDedbComprtnData();
        if (data == null) {
            return null;
        }
        return data.value();
    }

    public String getLogicalChildSourceSegName() {
        return this.clonedSegmentModel.getLogicalChildSourceSegName();
    }

    public String getSegmentSourceData() {
        DBDConstants retVal = this.clonedSegmentModel.getSegmentSourceData();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getSegmentSourceDBName() {
        return this.clonedSegmentModel.getSegmentSourceDBName();
    }

    public String getLogicalChildSourceData() {
        DBDConstants retVal = this.clonedSegmentModel.getLogicalChildSourceData();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getLogicalChildSourceDBName() {
        return this.clonedSegmentModel.getLogicalChildSourceDBName();
    }

    public String getTargetParentSourceSegName() {
        return this.clonedSegmentModel.getTargetParentSourceSegName();
    }

    public String getTargetParentSourceData() {
        DBDConstants retVal = this.clonedSegmentModel.getTargetParentSourceData();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getTargetParentSourceDBName() {
        return this.clonedSegmentModel.getTargetParentSourceDBName();
    }

    public String getEXITString() {
        return DBDSourceGenerator.getEXITString(this.clonedSegmentModel);
    }

    public String getMaxBytes() {
        return String.valueOf(this.clonedSegmentModel.getMaxBytes());
    }

    public String getMinBytes() {
        return String.valueOf(this.clonedSegmentModel.getMinBytes());
    }

    public String getDedbDependentSegmentType() {
        return this.clonedSegmentModel.getDedbDependentSegmentType();
    }

    public String getPhysicalPointer() {
        DBDConstants retVal = this.clonedSegmentModel.getPhysicalPointer();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getLogicalPointer() {
        DBDConstants retVal = this.clonedSegmentModel.getLogicalPointer();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getLparnt() {
        DBDConstants retVal = this.clonedSegmentModel.getLparnt();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getPaired() {
        return String.valueOf((Object)this.clonedSegmentModel.getPaired());
    }

    public String getCtr() {
        DBDConstants retVal = this.clonedSegmentModel.getCtr();
        if (retVal != null) {
            return retVal.value();
        }
        return null;
    }

    public String getInsertionRule() {
        return this.clonedSegmentModel.getInsertionRule();
    }

    public String getDeletionRule() {
        return this.clonedSegmentModel.getDeletionRule();
    }

    public String getReplacementRule() {
        return this.clonedSegmentModel.getReplacementRule();
    }

    public String getInsertionLocation() {
        return this.clonedSegmentModel.getInsertionLocation();
    }

    public String getComprtnRoutineName() {
        return this.clonedSegmentModel.getComprtnRoutineName();
    }

    public String getComprtnInit() {
        DBDConstants init = this.clonedSegmentModel.getComprtnInit();
        if (init == null) {
            return null;
        }
        return init.value();
    }

    public String getComprtnMaxBytesNumber() {
        return this.clonedSegmentModel.getComprtnMaxBytesNumber();
    }

    public String getComprtnMaxBytesPad() {
        DBDConstants pad = this.clonedSegmentModel.getComprtnMaxBytesPad();
        if (pad == null) {
            return null;
        }
        return pad.value();
    }

    public String getEncoding() {
        return this.clonedSegmentModel.getEncoding();
    }

    public String getRemarks() {
        return this.clonedSegmentModel.getRemarks();
    }

    public String getSsptr() {
        return String.valueOf(this.clonedSegmentModel.getSsptr());
    }

    public String getFreq() {
        String retVal = null;
        BigDecimal freq = this.clonedSegmentModel.getFreq();
        if (freq != null) {
            retVal = String.valueOf(freq);
        }
        return retVal;
    }

    public String getDsgroup() {
        return this.clonedSegmentModel.getDsgroup();
    }

    public void setMaxBytes(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            if (!value.matches("^[0-9]*$")) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB444"), value};
                String[] attrs = new String[]{MAXBYTES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (Integer.parseInt(value) < 4) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB444"), value};
                String[] attrs = new String[]{MAXBYTES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (Integer.parseInt(value) > 32760) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB444"), value};
                String[] attrs = new String[]{MAXBYTES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            this.clonedSegmentModel.setMaxBytes(Integer.parseInt(value));
        }
    }

    public void setMinBytes(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            if (!value.matches("^[0-9]*$")) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB444"), value};
                String[] attrs = new String[]{MINBYTES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (this.origSegmentModel.getMinBytes() == -1) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB444"), value};
                String[] attrs = new String[]{MINBYTES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (Integer.parseInt(value) > 32760) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB444"), value};
                String[] attrs = new String[]{MAXBYTES};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            this.clonedSegmentModel.setMinBytes(Integer.parseInt(value));
        }
    }

    public void setSourceData(String value, boolean isSource1) {
        if (isSource1) {
            if (this.clonedSegmentModel.getLogicalChildSourceSegName() == null) {
                this.clonedSegmentModel.setSegmentSourceData(DBDConstants.valueOf(value));
            } else {
                this.clonedSegmentModel.setLogicalChildSourceData(DBDConstants.valueOf(value));
            }
        } else {
            this.clonedSegmentModel.setTargetParentSourceData(DBDConstants.valueOf(value));
        }
    }

    public void setAmbiguousInsertRule(String rules2) throws InvalidInputException {
        String rules1 = this.getInsertionRule() + this.getDeletionRule() + this.getReplacementRule();
        if (this.getDBDAccessType().equals(DBDConstants.DEDB.value())) {
            rules1 = null;
        }
        this.clonedSegmentModel.setRules(rules1, rules2);
    }

    public void setInsertionRule(String value) throws InvalidInputException {
        if (value == null || value.isEmpty()) {
            value = "L";
        }
        this.clonedSegmentModel.setInsertionRule(value.charAt(0));
    }

    public void setDeletionRule(String value) throws InvalidInputException {
        if (value == null || value.isEmpty()) {
            value = "L";
        }
        this.clonedSegmentModel.setDeletionRule(value.charAt(0));
    }

    public void setReplacementRule(String value) throws InvalidInputException {
        if (value == null || value.isEmpty()) {
            value = "L";
        }
        this.clonedSegmentModel.setReplacementRule(value.charAt(0));
    }

    public void addDataCaptureExitRoutine(DataExitRoutine exitRoutine) throws ModelException {
        this.clonedSegmentModel.addDataCaptureExitRoutine(exitRoutine);
    }

    public void setDedbComprtn(String[] comprtnKeywords) throws InvalidInputException {
        if (comprtnKeywords[0] != null && !comprtnKeywords[0].isEmpty()) {
            if (comprtnKeywords[0].length() < 1 || comprtnKeywords[0].length() > 8) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB478"), "1", "8"};
                String[] attrs = new String[]{COMPRTN};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", inserts), attrs);
            }
            if (Utility.hasReservedName(comprtnKeywords[0]) || Utility.hasReservedIMSRoutines(comprtnKeywords[0]) || Utility.hasReservedSQLKeywords(comprtnKeywords[0]) || Utility.hasSpecialChar(comprtnKeywords[0], false) || comprtnKeywords[0].indexOf(" ") >= 0) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), 8);
            }
        }
        if (!(comprtnKeywords[1] == null || comprtnKeywords[1].isEmpty() || comprtnKeywords[1].equals("INIT") || comprtnKeywords[1].equals("DATA"))) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{COMPRTN, comprtnKeywords[1]}), 8);
        }
        if ((comprtnKeywords[1] == null || comprtnKeywords[1].isEmpty()) && comprtnKeywords[2] != null && !comprtnKeywords[2].isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{COMPRTN, comprtnKeywords[1] + "," + comprtnKeywords[2]}), 8);
        }
        if (comprtnKeywords[2] != null && !comprtnKeywords[2].isEmpty() && !comprtnKeywords[2].equals("INIT")) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{COMPRTN, comprtnKeywords[2]}), 8);
        }
        if (comprtnKeywords[2] != null && !comprtnKeywords[2].equals("INIT") && comprtnKeywords[1] != null && !comprtnKeywords[1].equals("DATA")) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{COMPRTN, comprtnKeywords[1] + "," + comprtnKeywords[2]}), 8);
        }
        this.clonedSegmentModel.setDedbComprtn(comprtnKeywords);
    }

    public void setComprtn(String[] comprtnKeywords) throws InvalidInputException {
        int maxByte;
        if (comprtnKeywords[0] != null && !comprtnKeywords[0].isEmpty()) {
            if (comprtnKeywords[0].length() < 1 || comprtnKeywords[0].length() > 8) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB478"), "1", "8"};
                String[] attrs = new String[]{COMPRTN};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", inserts), attrs);
            }
            if (Utility.hasReservedName(comprtnKeywords[0]) || Utility.hasReservedIMSRoutines(comprtnKeywords[0]) || Utility.hasReservedSQLKeywords(comprtnKeywords[0]) || Utility.hasSpecialChar(comprtnKeywords[0], false) || comprtnKeywords[0].indexOf(" ") >= 0) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), 8);
            }
        }
        if (comprtnKeywords[2] != null && !comprtnKeywords[2].isEmpty()) {
            if (!comprtnKeywords[2].equals("INIT")) {
                maxByte = Integer.valueOf(comprtnKeywords[2]);
                if (maxByte < 1 || maxByte > Short.MAX_VALUE) {
                    Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB478"), comprtnKeywords[2]};
                    String[] attrs = new String[]{COMPRTN};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
                }
            } else if (comprtnKeywords[3] != null && !comprtnKeywords[3].isEmpty()) {
                if (!Utility.isStringNumeric(comprtnKeywords[3])) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{COMPRTN, "1", "32767"}), 8);
                }
                maxByte = Integer.valueOf(comprtnKeywords[3]);
                if (maxByte < 1 || maxByte > Short.MAX_VALUE) {
                    Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB478"), comprtnKeywords[3]};
                    String[] attrs = new String[]{COMPRTN};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
                }
            }
        }
        if (comprtnKeywords[3] != null && !comprtnKeywords[3].isEmpty()) {
            if (!Utility.isStringNumeric(comprtnKeywords[3])) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{COMPRTN, "1", "32767"}), 8);
            }
            maxByte = Integer.valueOf(comprtnKeywords[3]);
            if (maxByte < 1 || maxByte > Short.MAX_VALUE) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB478"), comprtnKeywords[3]};
                String[] attrs = new String[]{COMPRTN};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
        }
        this.clonedSegmentModel.setComprtn(comprtnKeywords);
    }

    public void setEncoding(String encoding) throws InvalidInputException {
        String dummyStr = "dummy";
        try {
            if (encoding != null && !encoding.isEmpty()) {
                dummyStr.getBytes(encoding);
                this.clonedSegmentModel.setEncoding(encoding);
            } else {
                this.clonedSegmentModel.setEncoding(null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC21"), 8);
        }
    }

    public void setName(String name) {
        this.clonedSegmentModel.setName(name);
    }

    public void setRemarks(String remarks) throws InvalidInputException {
        String invalidCharacter = Utility.getInvalidRemarksCharacter(remarks);
        if (invalidCharacter != null && !invalidCharacter.isEmpty()) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB019A"), invalidCharacter};
            String[] attrs = new String[]{"REMARKS"};
            Object errorMessage = WorkbenchModelBundle.getError().getString("EISRC11", inserts);
            if (invalidCharacter.equals("'")) {
                errorMessage = (String)errorMessage + " " + WorkbenchModelBundle.getError().getString("EISRC11A");
            }
            throw new InvalidInputException((String)errorMessage, attrs);
        }
        this.clonedSegmentModel.setRemarks(remarks);
    }

    public void setSsptr(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            if (!Utility.isStringNumeric(value)) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", (Object[])new String[]{SSPTR, "1", "8"}), 8);
            }
            int ssptr = Integer.parseInt(value);
            if (ssptr < 0 || ssptr > 8) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB481"), value};
                String[] attrs = new String[]{SSPTR};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            this.clonedSegmentModel.setSsptr(ssptr);
        }
    }

    public void setFreq(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            if (!Utility.isStringDecimal(value)) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB474"), value};
                String[] attrs = new String[]{FREQ};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            BigDecimal freq = new BigDecimal(value);
            BigDecimal floor = new BigDecimal(".01");
            BigDecimal ceiling = new BigDecimal("16777215");
            if (freq != null && (freq.compareTo(floor) == -1 || freq.compareTo(ceiling) == 1)) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB474"), freq.toString()};
                String[] attrs = new String[]{FREQ};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            char decimalPoint = symbols.getDecimalSeparator();
            int i = value.lastIndexOf(decimalPoint);
            if (i != -1 && value.substring(i + 1).length() > 2) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB474"), freq.toString()};
                String[] attrs = new String[]{FREQ};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            try {
                this.clonedSegmentModel.setFreq(new BigDecimal(value));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{FREQ, "0.01", "16777215"}), 8);
            }
        }
    }

    public void setDsgroup(String value) {
        if (value != null && !value.isEmpty()) {
            this.clonedSegmentModel.setDsgroup(value);
        }
    }

    public void semanticCheck() throws InvalidInputException, ModelException {
        this.validateBytes();
        this.validateSource();
        this.validateDsgroup();
        this.validateRules();
    }

    private void validateRules() throws InvalidInputException {
        String dRule;
        boolean exitSpecified;
        boolean isLogicalParent = this.isLogicalParent();
        boolean isLogicalChild = this.isLogicalChild();
        boolean bl = exitSpecified = this.exitString != null && !this.exitString.isEmpty();
        if (!exitSpecified) {
            this.exitString = DBDSourceGenerator.getDBDEXITString(this.clonedSegmentModel.getDbdModel());
            boolean bl2 = exitSpecified = this.exitString != null && !this.exitString.isEmpty();
        }
        if (exitSpecified && (dRule = this.clonedSegmentModel.getDeletionRule()) != null && !dRule.isEmpty()) {
            if (isLogicalChild && !dRule.equals("V")) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"Deletion Rule (RULES)", dRule, EXIT, this.exitString}), new String[]{RULES}, 8);
            }
            if (isLogicalParent && !dRule.equals("L") && !dRule.equals("P")) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"Deletion Rule (RULES)", dRule, EXIT, this.exitString}), new String[]{RULES}, 8);
            }
        }
    }

    private void validateBytes() throws InvalidInputException {
        if (this.clonedSegmentModel.getMaxBytes() < this.clonedSegmentModel.getMinBytes()) {
            throw new InvalidInputException("INVALID BYTES: Minbytes cannot be larger than maxbytes.", new String[]{BYTES}, 8);
        }
    }

    private void validateSource() throws InvalidInputException {
        DBDConstants sourceData;
        DBDConstants accessType = this.clonedSegmentModel.getDBDAccessType();
        if (accessType != DBDConstants.HDAM && accessType != DBDConstants.HIDAM && accessType != DBDConstants.HSAM && accessType != DBDConstants.SHISAM && accessType != DBDConstants.LOGICAL) {
            String sourceSeg1 = this.clonedSegmentModel.getSegmentSourceSegName();
            String sourceSeg2 = this.clonedSegmentModel.getTargetParentSourceSegName();
            if (sourceSeg1 != null) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{SOURCE, sourceSeg1, "ACCESS", accessType.value()}), new String[]{SOURCE}, 8);
            }
            if (sourceSeg2 != null) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{SOURCE, sourceSeg2, "ACCESS", accessType.value()}), new String[]{SOURCE}, 8);
            }
        } else if ((accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM || accessType == DBDConstants.HSAM || accessType == DBDConstants.SHISAM) && (sourceData = this.clonedSegmentModel.getSegmentSourceData()) != null && sourceData == DBDConstants.N) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{SOURCE, "KEY", "ACCESS", accessType.value()}), new String[]{SOURCE}, 8);
        }
    }

    private void validateDsgroup() throws InvalidInputException {
        if (this.clonedSegmentModel.getDsgroup() != null && (this.dbdAccessType == DBDConstants.PHDAM || this.dbdAccessType == DBDConstants.PHIDAM)) {
            String[] attrs;
            Object[] inserts;
            Vector<SegmentModel> clonedSegmentList = this.clonedSegmentModel.getDbdModel().getSegments();
            String oldDsGroup = this.origSegmentModel.getDsgroup();
            int origDsgroupVal = 65;
            if (oldDsGroup != null && !oldDsGroup.isEmpty()) {
                origDsgroupVal = oldDsGroup.charAt(0);
            }
            String newDsGroup = this.clonedSegmentModel.getDsgroup();
            char clonedDsgroupVal = 'A';
            boolean gapFound = false;
            if (newDsGroup != null && !newDsGroup.isEmpty()) {
                clonedDsgroupVal = newDsGroup.charAt(0);
                gapFound = true;
            }
            char lastDsgroup = 'A';
            for (SegmentModel currentSegment : clonedSegmentList) {
                String currentDsgroup;
                if (currentSegment.getName().equals(this.origSegmentModel.getName()) || (currentDsgroup = currentSegment.getDsgroup()) == null || currentDsgroup.isEmpty()) continue;
                char currentDsgroupVal = currentSegment.getDsgroup().charAt(0);
                if (currentDsgroupVal == origDsgroupVal) {
                    gapFound = false;
                }
                if (currentDsgroupVal <= lastDsgroup) continue;
                lastDsgroup = currentDsgroupVal;
            }
            if (gapFound && (origDsgroupVal == lastDsgroup + 1 || origDsgroupVal == clonedDsgroupVal)) {
                gapFound = false;
            }
            if (gapFound) {
                inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB495"), Character.toString(clonedDsgroupVal)};
                attrs = new String[]{DSGROUP};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (clonedDsgroupVal > lastDsgroup + 1) {
                inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB495"), Character.toString(clonedDsgroupVal)};
                attrs = new String[]{DSGROUP};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (this.origSegmentModel.isRoot() && !this.clonedSegmentModel.getDsgroup().equals("A")) {
                inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB495"), Character.toString(clonedDsgroupVal)};
                attrs = new String[]{DSGROUP};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
        }
    }

    private void validateDataCaptureExitRoutines() throws InvalidInputException {
        List<DataExitRoutine> exits = this.clonedSegmentModel.getDataCaptureExitRoutines();
        DBDConstants accessType = this.clonedSegmentModel.getDBDAccessType();
        if (accessType != DBDConstants.HISAM && accessType != DBDConstants.SHISAM && accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.HIDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.DEDB && exits != null && exits.size() > 0) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16"), new String[]{EXIT, DBDSourceGenerator.getEXITString(this.clonedSegmentModel), "ACCESS", accessType.value()}, 8);
        }
        for (DataExitRoutine der : exits) {
            if (der.getDoCascade() != null && der.getDoCascade().equals((Object)DBDConstants.N) && (der.getCascadeData().equals((Object)DBDConstants.Y) || der.getCascadeKey().equals((Object)DBDConstants.Y) || der.getCascadePath().equals((Object)DBDConstants.Y))) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB028"), "NOCASCADE"};
                String[] attrs = new String[]{DATA_CAPTURE, NOCASCADE};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (der.getExitName() != null && der.getExitName().length() > 8) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB328"), "1", "8"};
                String[] attrs = new String[]{DATA_CAPTURE, EXIT};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", inserts), attrs);
            }
            if (this.dbdAccessType == DBDConstants.DEDB) continue;
            if (der.getBefore() != null && der.getBefore().equals((Object)DBDConstants.N)) {
                Object[] inserts = new String[]{"DEDB " + WorkbenchModelBundle.getLabel().getString("WB028"), NOBEFORE};
                String[] attrs = new String[]{DATA_CAPTURE, NOBEFORE};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (der.getDlet() != null && der.getDlet().equals((Object)DBDConstants.N)) {
                Object[] inserts = new String[]{"DEDB " + WorkbenchModelBundle.getLabel().getString("WB028"), "NODLET"};
                String[] attrs = new String[]{DATA_CAPTURE, DLET};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (der.getFld() != null && der.getFld().equals((Object)DBDConstants.Y)) {
                Object[] inserts = new String[]{"DEDB " + WorkbenchModelBundle.getLabel().getString("WB028"), FLD};
                String[] attrs = new String[]{DATA_CAPTURE, FLD};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
            }
            if (der.getSspcmd() == null || !der.getSspcmd().equals((Object)DBDConstants.Y)) continue;
            Object[] inserts = new String[]{"DEDB " + WorkbenchModelBundle.getLabel().getString("WB028"), SSPCMD};
            String[] attrs = new String[]{DATA_CAPTURE, SSPCMD};
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", inserts), attrs);
        }
    }

    public boolean isRootSegment() {
        return this.origSegmentModel.isRoot();
    }

    public boolean isVirtualLogicalChild() {
        return this.origSegmentModel.isVirtualLogicalChild();
    }

    public boolean isLogicalParent() {
        return this.origSegmentModel.hasLogicalChild();
    }

    public boolean isLogicalChild() {
        return this.origSegmentModel.hasLogicalParent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setExit(String exit, boolean isFinish) throws InvalidInputException, ModelException {
        this.exitString = exit;
        if (exit == null || exit.isEmpty()) return;
        if (exit.indexOf("NONE") >= 0) {
            if (!exit.equals("NONE") && !exit.equals("(NONE)")) throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{EXIT, exit}), 8);
            if (this.clonedSegmentModel.getDataCaptureExitRoutines() == null) return;
            this.clonedSegmentModel.getDataCaptureExitRoutines().clear();
            return;
        } else {
            Iterator<DataExitRoutine> iter = this.getExits(exit).iterator();
            if (!isFinish) return;
            while (iter.hasNext()) {
                this.clonedSegmentModel.addDataCaptureExitRoutine(iter.next(), isFinish);
                if (!isFinish) continue;
                isFinish = false;
            }
        }
    }

    private List<DataExitRoutine> getExits(String exitStr) throws InvalidInputException {
        ArrayList<DataExitRoutine> newExits;
        block77: {
            DBDConstants accessType = this.clonedSegmentModel.getDBDAccessType();
            newExits = new ArrayList<DataExitRoutine>();
            try {
                if (accessType != DBDConstants.HDAM && accessType != DBDConstants.HISAM && accessType != DBDConstants.SHISAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.HIDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.DEDB) break block77;
                int cascadeState = 1004;
                List<String> exitParms = this.parseExitSubParms(exitStr);
                if (exitParms == null || exitParms.size() <= 0) break block77;
                int exitParmCount = 0;
                int totalParms = exitParms.size();
                DataExitRoutine dataExit = new DataExitRoutine();
                String nextParm = exitParms.get(exitParmCount);
                if (nextParm.equals("*")) {
                    dataExit.setExitName("*");
                } else {
                    assert (!nextParm.equals("("));
                    if (nextParm.length() > 8 || Utility.hasSpecialChar(nextParm, false) || Utility.hasReservedSQLKeywords(nextParm) || Utility.hasReservedIMSRoutines(nextParm) || Utility.hasReservedName(nextParm)) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), 8);
                    }
                    boolean errorFound = true;
                    try {
                        this.validateExitParm(nextParm);
                    }
                    catch (InvalidInputException invalidInputException) {
                        dataExit.setExitName(nextParm);
                        errorFound = false;
                    }
                    if (errorFound) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{EXIT, nextParm}), new String[]{EXIT}, 8);
                    }
                }
                ++exitParmCount;
                while (exitParmCount < totalParms) {
                    nextParm = exitParms.get(exitParmCount);
                    if (nextParm.equals("LOG")) {
                        dataExit.setLog(DBDConstants.Y);
                    } else if (nextParm.equals("NOLOG")) {
                        dataExit.setLog(DBDConstants.N);
                    } else if (nextParm.equals("KEY")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitKey(DBDConstants.Y);
                        } else {
                            dataExit.setCascadeKey(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NOKEY")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitKey(DBDConstants.N);
                        } else {
                            dataExit.setCascadeKey(DBDConstants.N);
                        }
                    } else if (nextParm.equals("PATH")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitPath(DBDConstants.Y);
                        } else {
                            dataExit.setCascadePath(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NOPATH")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitPath(DBDConstants.N);
                        } else {
                            dataExit.setCascadePath(DBDConstants.N);
                        }
                    } else if (nextParm.equals("DATA")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitData(DBDConstants.Y);
                        } else {
                            dataExit.setCascadeData(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NODATA")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitData(DBDConstants.N);
                        } else {
                            dataExit.setCascadeData(DBDConstants.N);
                        }
                    } else if (nextParm.equals("CASCADE")) {
                        dataExit.setDoCascade(DBDConstants.Y);
                    } else if (nextParm.equals("NOCASCADE")) {
                        dataExit.setDoCascade(DBDConstants.N);
                    } else if (nextParm.equals(DLET)) {
                        dataExit.setDlet(DBDConstants.Y);
                    } else if (nextParm.equals("NODLET")) {
                        dataExit.setDlet(DBDConstants.N);
                    } else if (nextParm.equals("BEFORE")) {
                        dataExit.setBefore(DBDConstants.Y);
                    } else if (nextParm.equals(NOBEFORE)) {
                        dataExit.setBefore(DBDConstants.N);
                    } else if (nextParm.equals(SSPCMD)) {
                        dataExit.setSspcmd(DBDConstants.Y);
                    } else if (nextParm.equals("NOSSPCMD")) {
                        dataExit.setSspcmd(DBDConstants.N);
                    } else if (nextParm.equals("INPOS")) {
                        dataExit.setInpos(DBDConstants.Y);
                    } else if (nextParm.equals("NOINPOS")) {
                        dataExit.setInpos(DBDConstants.N);
                    } else if (nextParm.equals(FLD)) {
                        dataExit.setFld(DBDConstants.Y);
                    } else if (nextParm.equals("NOFLD")) {
                        dataExit.setFld(DBDConstants.N);
                    } else if (nextParm.equals("(")) {
                        if (exitParms.get(exitParmCount + 1).equals("CASCADEOPTIONS")) {
                            dataExit.setDoCascade(DBDConstants.Y);
                            cascadeState = 1003;
                            ++exitParmCount;
                        } else if (exitParms.get(exitParmCount + 1).equals("NOCASCADEOPTIONS")) {
                            dataExit.setDoCascade(DBDConstants.N);
                            cascadeState = 1003;
                            ++exitParmCount;
                        }
                    } else if (nextParm.equals(")")) {
                        assert (cascadeState == 1003);
                        cascadeState = 1004;
                    } else if (nextParm.equals("*")) {
                        assert (cascadeState != 1003);
                        newExits.add(dataExit);
                        dataExit = new DataExitRoutine();
                        cascadeState = 1004;
                        dataExit.setExitName("*");
                    } else {
                        assert (cascadeState != 1003);
                        if (dataExit.getExitName().equals("*")) {
                            this.validateExitParm(nextParm);
                        }
                        newExits.add(dataExit);
                        dataExit = new DataExitRoutine();
                        cascadeState = 1004;
                        String exitName = exitParms.get(exitParmCount);
                        if (exitName.length() > 8 || Utility.hasSpecialChar(exitName, false) || Utility.hasReservedSQLKeywords(exitName) || Utility.hasReservedIMSRoutines(exitName) || Utility.hasReservedName(exitName)) {
                            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), 8);
                        }
                        dataExit.setExitName(exitName);
                    }
                    ++exitParmCount;
                }
                assert (cascadeState != 1003);
                newExits.add(dataExit);
            }
            catch (Throwable throwable) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{EXIT, exitStr}), 8);
            }
        }
        return newExits;
    }

    private void validateExitParm(String parm) throws InvalidInputException {
        if (!(parm.equals("LOG") || parm.equals("NOLOG") || parm.equals("KEY") || parm.equals("NOKEY") || parm.equals("PATH") || parm.equals("NOPATH") || parm.equals("DATA") || parm.equals("NODATA") || parm.equals("CASCADE") || parm.equals("NOCASCADE") || parm.equals("BEFORE") || parm.equals(NOBEFORE) || parm.equals(DLET) || parm.equals("NODLET") || parm.equals(SSPCMD) || parm.equals("NOSSPCMD") || parm.equals("INPOS") || parm.equals("NOINPOS") || parm.equals(FLD) || parm.equals("NOFLD"))) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{EXIT, parm}), new String[]{EXIT}, 8);
        }
    }

    private List<String> parseExitSubParms(String aParam) throws NoSuchElementException {
        ArrayList<String> strList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(aParam, "(),", true);
        boolean insideCascade = false;
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("(")) {
                token = st.nextToken();
                if (token.equals("(")) continue;
                if (token.equals("CASCADE")) {
                    strList.add(count, "(");
                    strList.add(count + 1, "CASCADEOPTIONS");
                    count += 2;
                    insideCascade = true;
                    continue;
                }
                if (token.equals("NOCASCADE")) {
                    strList.add(count, "(");
                    strList.add(count + 1, "NOCASCADEOPTIONS");
                    count += 2;
                    insideCascade = true;
                    continue;
                }
                strList.add(count, token);
                ++count;
                continue;
            }
            if (token.equals(")")) {
                if (!insideCascade) continue;
                strList.add(count, ")");
                insideCascade = false;
                ++count;
                continue;
            }
            if (token.equals(",")) continue;
            strList.add(count, token);
            ++count;
        }
        if (strList.size() == 0) {
            return null;
        }
        return strList;
    }

    public List<DataExitRoutine> getDataCaptureExitRoutines() {
        return this.clonedSegmentModel.getDataCaptureExitRoutines();
    }

    public String getExitString() {
        return this.exitString;
    }

    public String getInitialExitString() {
        return DBDSourceGenerator.getEXITString(this.origSegmentModel);
    }
}

