/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.editor;

import com.ibm.im.ims.workbench.controller.editor.DatasetModel;
import com.ibm.im.ims.workbench.model.AreaStmt;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.HidamDataSetModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.util.ArrayList;

public class EditDatasetController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DbdModel dbdModel;
    public static final String DDNAME = "DDNAME";
    public static final String DD2NAME = "DD2NAME";
    public static final String SIZE = "SIZE";
    public static final String BLOCK = "BLOCK";
    public static final String ROOT = "ROOT";
    public static final String RECORD = "RECORD";
    public static final String FORMAT = "FORMAT";
    public static final String OVERFLOW = "OVERFLOW";
    public static final String FRSPC_FB = "FRSPC-fbff";
    public static final String FRSPC_FS = "FRSPC-fspf";
    public static final String SCAN = "SCAN";
    public static final String SEARCHA = "SEARCHA";
    public static final String UOW = "UOW";
    public static final String REMARKS = "REMARKS";
    private static final int VSAM_MAX_SIZE = 30720;
    private static final int OSAM_MAX_SIZE = Short.MAX_VALUE;
    private static final int VSAM_MIN_SIZE = 1;
    private static final int OSAM_MIN_SIZE = 1;
    private static final int DEDB_MIN_SIZE = 512;
    private static final int DEDB_MAX_SIZE = 28672;
    private static final int DEDB_MIN_ROOT = 3;
    private static final int DEDB_MAX_ROOT = 32766;
    private static final int DEDB_MIN_ROOT_OVFL = 1;
    private ArrayList<DatasetModel> datasets;

    public EditDatasetController(DbdModel dbdModel) throws ModelException {
        this.dbdModel = dbdModel;
        this.datasets = Utility.getDatasetModels(dbdModel);
    }

    public String getDBDName() {
        return this.dbdModel.getDBDName();
    }

    public DBDConstants getAccessType() {
        return this.dbdModel.getAccessType();
    }

    public String[] getDsNames() {
        String[] retVal = new String[this.datasets.size()];
        int i = 0;
        while (i < this.datasets.size()) {
            retVal[i] = this.datasets.get(i).getDatasetName();
            ++i;
        }
        return retVal;
    }

    public DatasetModel getDsModel() {
        return this.datasets.get(0);
    }

    public DatasetModel getDsModel(String dsName) {
        DatasetModel retVal = null;
        int i = 0;
        while (i < this.datasets.size()) {
            DatasetModel ds = this.datasets.get(i);
            if (ds.getDatasetName().equals(dsName)) {
                retVal = ds;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private void updateDatasetModel() throws ModelException {
        DBDConstants accessType = this.dbdModel.getAccessType();
        if (accessType == DBDConstants.DEDB) {
            ArrayList<AreaStmt> areas = this.dbdModel.getAreaList();
            int i = 0;
            while (i < areas.size()) {
                DatasetModel ds = this.datasets.get(i);
                AreaStmt area = areas.get(i);
                area.setRootNumber2(ds.getRootOrBlock1());
                area.setRootOverflow2(ds.getRootOrBlock2());
                area.setUowNumber1(ds.getUowOrRecord1());
                area.setUowOverflow1(ds.getUowOrRecord2());
                area.setSize(String.valueOf(ds.getSize1()));
                area.setRemarks(ds.getRemarks());
                ++i;
            }
        } else if (accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM) {
            ArrayList<HidamDataSetModel> hdamDatasets = this.dbdModel.getHidamDataset();
            int i = 0;
            while (i < hdamDatasets.size()) {
                HidamDataSetModel hdamDs = hdamDatasets.get(i);
                DatasetModel ds = this.datasets.get(i);
                hdamDs.setSize0(ds.getRootOrBlock1());
                hdamDs.setSize1(ds.getSize1());
                hdamDs.setCyls(ds.getScan());
                hdamDs.setFbff(ds.getFreeBlock());
                hdamDs.setFspf(ds.getFreeSpace());
                hdamDs.setSearcha(ds.getSearchAlgorithm());
                hdamDs.setRemarks(ds.getRemarks());
                ++i;
            }
            this.dbdModel.setHidamDataset(hdamDatasets);
        } else {
            DatasetModel ds = this.datasets.get(0);
            if (accessType == DBDConstants.HISAM || accessType == DBDConstants.INDEX) {
                this.dbdModel.setOvflw(ds.getOutPutOrOverflow());
            } else {
                this.dbdModel.setDdname2(ds.getOutPutOrOverflow());
            }
            Integer value = ds.getRootOrBlock1();
            if (value != null && value >= 0) {
                this.dbdModel.setBLOCKBlkfact1(value);
            }
            if ((value = Integer.valueOf(ds.getRootOrBlock2())) != null && value >= 0) {
                this.dbdModel.setBLOCKBlkfact2(value);
            }
            if ((value = ds.getSize1()) != null && value > 0) {
                this.dbdModel.setSize1(value);
            }
            if ((value = ds.getSize2()) != null && value > 0) {
                this.dbdModel.setSize2(value);
            }
            if ((value = ds.getUowOrRecord1()) != null && value > 0) {
                this.dbdModel.setRECORDReclen1(value);
            }
            if ((value = ds.getUowOrRecord2()) != null && value > 0) {
                this.dbdModel.setRECORDReclen2(value);
            }
            this.dbdModel.setDatasetRemarks(ds.getRemarks());
            this.dbdModel.setRecfm(ds.getRecordFormat());
        }
    }

    public void setOutputOrOverflow(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            if (newValue == null || newValue.isEmpty() || newValue.length() > 8 || Utility.hasSpecialChar(newValue, false) || Utility.hasReservedSQLKeywords(newValue) || Utility.hasReservedIMSRoutines(newValue) || Utility.hasReservedName(newValue)) {
                String[] attrs = new String[]{DD2NAME};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), attrs);
            }
            ds.setOutPutOrOverflow(newValue);
        }
    }

    public void setSize1(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            DBDConstants accessType = this.dbdModel.getAccessType();
            boolean isDEDB = accessType == DBDConstants.DEDB;
            boolean isOsam = this.dbdModel.getOsAccess() != null && this.dbdModel.getOsAccess().equals(DBDConstants.OSAM.value());
            int start = 512;
            if (!isDEDB) {
                start = isOsam ? 1 : 1;
            }
            int end = 28672;
            if (!isDEDB) {
                end = isOsam ? Short.MAX_VALUE : 30720;
            }
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{SIZE, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{SIZE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{SIZE, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{SIZE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                if (!isOsam && accessType != DBDConstants.GSAM) {
                    int mod = 0;
                    String multiple = "2K";
                    if (!isDEDB) {
                        mod = newIntValue <= 4096 ? newIntValue % 512 : newIntValue % 2048;
                    } else {
                        multiple = "4K";
                        mod = newIntValue <= 4096 ? newIntValue % 512 : newIntValue % 4096;
                    }
                    if (mod != 0) {
                        Object[] inserts = new String[]{SIZE, "512", multiple};
                        String[] attrs = new String[]{SIZE};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_SIZE_MESSAGE", inserts), attrs);
                    }
                }
                ds.setSize1(newIntValue);
            } else {
                if (isDEDB) {
                    Object[] inserts = new String[]{SIZE, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{SIZE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setSize1(null);
            }
        }
    }

    public void setSize2(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            if (newValue != null && !newValue.isEmpty()) {
                boolean isOsam = this.dbdModel.getOsAccess() != null && this.dbdModel.getOsAccess().equals(DBDConstants.OSAM.value());
                int start = 1;
                if (!isOsam) {
                    start = 1;
                }
                int end = Short.MAX_VALUE;
                if (!isOsam) {
                    end = 30720;
                }
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{SIZE, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{SIZE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{SIZE, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{SIZE};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setSize2(newIntValue);
            } else {
                ds.setSize2(null);
            }
        }
    }

    public void setRootOrBlock1(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            DBDConstants accessType = this.dbdModel.getAccessType();
            boolean isDEDB = accessType == DBDConstants.DEDB;
            boolean isOsam = this.dbdModel.getOsAccess() != null && this.dbdModel.getOsAccess().equals(DBDConstants.OSAM.value());
            String attribute = ROOT;
            int start = 3;
            if (!isDEDB) {
                attribute = BLOCK;
                start = accessType == DBDConstants.HSAM || accessType == DBDConstants.SHSAM ? 1 : (isOsam ? 1 : 1);
            }
            int end = 32766;
            if (!isDEDB) {
                end = accessType == DBDConstants.HSAM || accessType == DBDConstants.SHSAM ? 1 : (isOsam ? Short.MAX_VALUE : 30720);
            }
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setRootOrBlock1(newIntValue);
            } else {
                if (isDEDB) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setRootOrBlock1(-1);
            }
        }
    }

    public void setRootOrBlock2(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            boolean isDEDB = this.dbdModel.getAccessType() == DBDConstants.DEDB;
            boolean isOsam = this.dbdModel.getOsAccess() != null && this.dbdModel.getOsAccess().equals(DBDConstants.OSAM.value());
            String attribute = ROOT;
            int start = 1;
            if (!isDEDB) {
                attribute = BLOCK;
                start = isOsam ? 1 : 1;
            }
            int end = ds.getRootOrBlock1() - 1;
            if (!isDEDB) {
                end = isOsam ? Short.MAX_VALUE : 30720;
            }
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setRootOrBlock2(newIntValue);
            } else {
                if (isDEDB) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setRootOrBlock2(-1);
            }
        }
    }

    public void setUowOrRecord1(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            boolean isDEDB = this.dbdModel.getAccessType() == DBDConstants.DEDB;
            boolean isOsam = this.dbdModel.getOsAccess() != null && this.dbdModel.getOsAccess().equals(DBDConstants.OSAM.value());
            String attribute = UOW;
            int start = 3;
            if (!isDEDB) {
                attribute = RECORD;
                start = isOsam ? 1 : 1;
            }
            int end = 32766;
            if (!isDEDB) {
                end = isOsam ? Short.MAX_VALUE : 30720;
            }
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                if (attribute == RECORD && newIntValue % 2 != 0) {
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_RECORD_MESSAGE"), attrs);
                }
                ds.setUowOrRecord1(newIntValue);
            } else {
                if (isDEDB) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setUowOrRecord1(null);
            }
        }
    }

    public void setUowOrRecord2(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            boolean isDEDB = this.dbdModel.getAccessType() == DBDConstants.DEDB;
            boolean isOsam = this.dbdModel.getOsAccess() != null && this.dbdModel.getOsAccess().equals(DBDConstants.OSAM.value());
            String attribute = UOW;
            int start = 1;
            if (!isDEDB) {
                attribute = RECORD;
                start = isOsam ? 1 : 1;
            }
            Integer end = ds.getUowOrRecord1() - 1;
            if (!isDEDB) {
                end = isOsam ? Integer.valueOf(Short.MAX_VALUE) : Integer.valueOf(30720);
            }
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                if (attribute == RECORD && newIntValue % 2 != 0) {
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_RECORD_MESSAGE"), attrs);
                }
                ds.setUowOrRecord2(newIntValue);
            } else {
                if (isDEDB) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setUowOrRecord2(null);
            }
        }
    }

    public void setRecordFormat(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            ds.setRecordFormat(DBDConstants.valueOf(newValue));
        }
    }

    public void setFreeBlock(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            int start = 2;
            int end = 100;
            String attribute = FRSPC_FB;
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, "0," + String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < 0 || newIntValue > 0 && newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, "0," + String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setFreeBlock(newIntValue);
            } else {
                ds.setFreeBlock(0);
            }
        }
    }

    public void setFreeSpace(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            int start = 0;
            int end = 99;
            String attribute = FRSPC_FS;
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setFreeSpace(newIntValue);
            } else {
                ds.setFreeSpace(0);
            }
        }
    }

    public void setScan(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            int start = 0;
            int end = 255;
            String attribute = SCAN;
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setScan(newIntValue);
            } else {
                ds.setScan(-1);
            }
        }
    }

    public void setSearchA(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            int start = 0;
            int end = 2;
            String attribute = SEARCHA;
            if (newValue != null && !newValue.isEmpty()) {
                if (!Utility.isStringNumeric(newValue)) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                int newIntValue = Integer.valueOf(newValue);
                if (newIntValue < start || newIntValue > end) {
                    Object[] inserts = new String[]{attribute, String.valueOf(start), String.valueOf(end)};
                    String[] attrs = new String[]{attribute};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", inserts), attrs);
                }
                ds.setSearchAlgorithm(newIntValue);
            } else {
                ds.setSearchAlgorithm(-1);
            }
        }
    }

    public void setRemarks(String dsName, String newValue) throws InvalidInputException {
        DatasetModel ds = this.getDataset(dsName);
        if (ds != null) {
            String invalidCharacter = Utility.getInvalidRemarksCharacter(newValue);
            if (invalidCharacter != null && !invalidCharacter.isEmpty()) {
                Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB019A"), invalidCharacter};
                String[] attrs = new String[]{REMARKS};
                Object errorMessage = WorkbenchModelBundle.getError().getString("EISRC11", inserts);
                if (invalidCharacter.equals("'")) {
                    errorMessage = (String)errorMessage + " " + WorkbenchModelBundle.getError().getString("EISRC11A");
                }
                throw new InvalidInputException((String)errorMessage, attrs);
            }
            ds.setRemarks(newValue);
        }
    }

    private DatasetModel getDataset(String dsName) throws InvalidInputException {
        for (DatasetModel currentDs : this.datasets) {
            if (!dsName.equals(currentDs.getDatasetName())) continue;
            return currentDs;
        }
        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_INFO_MESSAGE", (Object[])new String[]{dsName, this.dbdModel.getDBDName()}));
    }

    public void performFinish() throws ModelException {
        this.updateDatasetModel();
    }

    public void semanticCheck(String dsName) throws InvalidInputException, ModelException {
        DatasetModel ds = this.getDataset(dsName);
        this.validateSizes(ds);
    }

    private void validateSizes(DatasetModel ds) throws InvalidInputException {
        Integer size2 = ds.getSize2();
        Integer record2 = ds.getUowOrRecord2();
        String ovflow = ds.getOutPutOrOverflow();
        if (ovflow != null && !ovflow.isEmpty() && this.dbdModel.getAccessType() != DBDConstants.GSAM) {
            if (size2 == null && record2 == null) {
                String[] attrs = new String[]{OVERFLOW};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_OVFL_MESSAGE"), attrs);
            }
            if (size2 == null) {
                if (record2 == 0) {
                    String[] attrs = new String[]{OVERFLOW};
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_OVFL_MESSAGE"), attrs);
                }
            } else if (size2 == 0) {
                String[] attrs = new String[]{OVERFLOW};
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DATASET_OVFL_MESSAGE"), attrs);
            }
        }
    }
}

