/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.editor;

import com.ibm.im.ims.metadata.dbd.Dbd;
import com.ibm.im.ims.metadata.dbd.IndexType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DataExitRoutine;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.DBDSourceGenerator;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class EditDatabaseController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int EXITNAME = 1001;
    private static final int ASTRIXNAME = 1002;
    private static final int INSIDECASCADE = 1003;
    private static final int OUTSIDECASCADE = 1004;
    private DbdModel originalDbdModel;
    private DbdModel clonedDbdModel;

    public EditDatabaseController(DbdModel dbdModel) throws ModelException {
        this.originalDbdModel = dbdModel;
        this.cloneOriginalDbd();
    }

    private void cloneOriginalDbd() throws ModelException {
        IndexType indexType;
        String xci;
        Integer rbn;
        Integer bytes;
        Dbd dbd = new Dbd();
        dbd.setDbdName(this.originalDbdModel.getDBDName());
        dbd.setEncoding(this.originalDbdModel.getEncoding());
        dbd.setRemarks(this.originalDbdModel.getRemarks());
        dbd.setUserVersion(this.originalDbdModel.getUserVersion());
        dbd.setVersion(this.originalDbdModel.getVersion());
        this.clonedDbdModel = new DbdModel();
        this.clonedDbdModel.setDbd(dbd);
        this.clonedDbdModel.setAccessType(this.originalDbdModel.getAccessType().value());
        this.clonedDbdModel.setDatxexit(this.originalDbdModel.getDatxexit());
        this.clonedDbdModel.setDoscomp(this.originalDbdModel.getDoscomp());
        this.clonedDbdModel.setPassword(this.originalDbdModel.getPassword());
        this.clonedDbdModel.setProt(this.originalDbdModel.getProt());
        this.clonedDbdModel.setPsname(this.originalDbdModel.getPsname());
        this.clonedDbdModel.setRMName(this.originalDbdModel.getRMName());
        Integer anch = this.originalDbdModel.getRmNameAnchorPoints();
        if (anch != null && anch > 0) {
            this.clonedDbdModel.setRmNameAnchorPoints(anch);
        }
        if ((bytes = this.originalDbdModel.getRmNameBytes()) != null && bytes > 0) {
            this.clonedDbdModel.setRmNameBytes(bytes);
        }
        if ((rbn = this.originalDbdModel.getRmNameMaxRBN()) != null && rbn > 0) {
            this.clonedDbdModel.setRmNameMaxRBN(rbn);
        }
        if ((xci = this.originalDbdModel.getXCI()) != null) {
            this.clonedDbdModel.setXci(xci);
        }
        if ((indexType = dbd.getAccess().getIndex()) != null) {
            indexType.setFpindex(this.originalDbdModel.getFPindex());
        }
        this.cloneOriginalDataExits();
    }

    private void replaceOriginalDataExits() throws ModelException {
        List<DataExitRoutine> exits = this.clonedDbdModel.getDataCaptureExitRoutines();
        boolean replace = true;
        if (exits != null) {
            Iterator<DataExitRoutine> iter = exits.iterator();
            while (iter.hasNext()) {
                this.originalDbdModel.addDataCaptureExitRoutine(iter.next(), replace);
                if (!replace) continue;
                replace = false;
            }
        }
    }

    private void cloneOriginalDataExits() throws ModelException {
        List<DataExitRoutine> exits = this.originalDbdModel.getDataCaptureExitRoutines();
        if (exits != null) {
            Iterator<DataExitRoutine> iter = exits.iterator();
            while (iter.hasNext()) {
                this.clonedDbdModel.addDataCaptureExitRoutine(iter.next(), true);
            }
        }
    }

    public String getDBDName() {
        return this.clonedDbdModel.getDBDName();
    }

    public void performFinish() throws ModelException {
        this.replaceOrigDatabaseWithClone();
    }

    private void replaceOrigDatabaseWithClone() throws ModelException {
        String xci;
        Integer rbn;
        Integer bytes;
        this.originalDbdModel.setEncoding(this.clonedDbdModel.getEncoding());
        this.originalDbdModel.setRemarks(this.clonedDbdModel.getRemarks());
        this.originalDbdModel.setUserVersion(this.clonedDbdModel.getUserVersion());
        this.originalDbdModel.setVersion(this.clonedDbdModel.getVersion());
        this.originalDbdModel.setDatxexit(this.clonedDbdModel.getDatxexit());
        this.originalDbdModel.setDoscomp(this.clonedDbdModel.getDoscomp());
        this.originalDbdModel.setPassword(this.clonedDbdModel.getPassword());
        this.originalDbdModel.setProt(this.clonedDbdModel.getProt());
        this.originalDbdModel.setPsname(this.clonedDbdModel.getPsname());
        this.originalDbdModel.setRMName(this.clonedDbdModel.getRMName());
        Integer anch = this.clonedDbdModel.getRmNameAnchorPoints();
        if (anch != null) {
            this.originalDbdModel.setRmNameAnchorPoints(anch);
        }
        if ((bytes = this.clonedDbdModel.getRmNameBytes()) != null) {
            this.originalDbdModel.setRmNameBytes(bytes);
        }
        if ((rbn = this.clonedDbdModel.getRmNameMaxRBN()) != null) {
            this.originalDbdModel.setRmNameMaxRBN(rbn);
        }
        if ((xci = this.clonedDbdModel.getXCI()) != null) {
            this.originalDbdModel.setXci(xci);
        }
        if (this.originalDbdModel.getDbd().getAccess().getIndex() != null) {
            this.originalDbdModel.getDbd().getAccess().getIndex().setFpindex(this.clonedDbdModel.getFPindex());
        }
        this.replaceOriginalDataExits();
    }

    public void semanticCheck() throws InvalidInputException {
        this.validateRmName();
        this.validateRmAnch();
        this.validateRmMaxRbn();
        this.validateRmBytes();
        this.validateRmXCI();
        this.validateProt();
        this.validateDosComp();
        this.validatePsName();
        this.validateFpIndex();
        this.validateDatXExit();
        this.validateDbVer();
        this.validateExit();
    }

    private void validateRmName() throws InvalidInputException {
        String rmName;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.DEDB && (rmName = this.clonedDbdModel.getRMName()) != null && !rmName.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME", rmName, "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateRmAnch() throws InvalidInputException {
        Integer anch;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.DEDB && (anch = this.clonedDbdModel.getRmNameAnchorPoints()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME/ANCHOR POINTS", String.valueOf(anch), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateRmMaxRbn() throws InvalidInputException {
        Integer rbn;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && (rbn = this.clonedDbdModel.getRmNameMaxRBN()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME/MAXRBN", String.valueOf(rbn), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateRmBytes() throws InvalidInputException {
        Integer bytes;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && (bytes = this.clonedDbdModel.getRmNameBytes()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME/BYTES", String.valueOf(bytes), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateRmXCI() throws InvalidInputException {
        String xci;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.DEDB && (xci = this.clonedDbdModel.getXCI()) != null && !xci.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME/XCI", xci, "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateDbVer() throws InvalidInputException {
        Integer dbVer;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.HIDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.DEDB && (dbVer = this.clonedDbdModel.getUserVersion()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"DBVER", String.valueOf(dbVer), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateExit() throws InvalidInputException {
        List<DataExitRoutine> exits;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.HISAM && accessType != DBDConstants.SHISAM && accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.HIDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.DEDB && (exits = this.clonedDbdModel.getDataCaptureExitRoutines()) != null && exits.size() > 0) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16"), new String[]{"EXIT", DBDSourceGenerator.getDBDEXITString(this.clonedDbdModel), "ACCESS", accessType.value()}, 8);
        }
    }

    private void validateProt() throws InvalidInputException {
        YesnoType prot;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.INDEX && accessType != DBDConstants.PSINDEX && (prot = this.clonedDbdModel.getProt()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"PROT", prot.value(), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateDosComp() throws InvalidInputException {
        YesnoType dosComp;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.INDEX && (dosComp = this.clonedDbdModel.getDoscomp()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"DOSCOMP", dosComp.value(), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateDatXExit() throws InvalidInputException {
        YesnoType datXExit;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType == DBDConstants.LOGICAL && (datXExit = this.clonedDbdModel.getDatxexit()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"DATXEXIT", datXExit.value(), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validateFpIndex() throws InvalidInputException {
        YesnoType fpIndex;
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        if (accessType != DBDConstants.INDEX && (fpIndex = this.clonedDbdModel.getFPindex()) != null) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"FPINDEX", fpIndex.value(), "ACCESS", accessType.value()}), 8);
        }
    }

    private void validatePsName() throws InvalidInputException {
        String psName;
        DBDConstants accessType = this.clonedDbdModel.getAccessType();
        if (accessType != DBDConstants.PHDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.PSINDEX && (psName = this.clonedDbdModel.getPsname()) != null && !psName.isEmpty()) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"PSNAME", psName, "ACCESS", accessType.value()}), 8);
        }
    }

    public void setProt(String pointerProt) {
        if (pointerProt != null) {
            if (pointerProt.equals(YesnoType.N.value())) {
                this.clonedDbdModel.setProt(YesnoType.N);
            } else if (pointerProt.equals(YesnoType.Y.value())) {
                this.clonedDbdModel.setProt(YesnoType.Y);
            } else {
                this.clonedDbdModel.setProt(null);
            }
        } else {
            this.clonedDbdModel.setProt(null);
        }
    }

    public void setDoscomp(String useDos) {
        if (useDos != null) {
            if (useDos.equals(YesnoType.Y.value())) {
                this.clonedDbdModel.setDoscomp(YesnoType.Y);
            } else if (useDos.equals(YesnoType.N.value())) {
                this.clonedDbdModel.setDoscomp(YesnoType.N);
            } else {
                this.clonedDbdModel.setDoscomp(null);
            }
        } else {
            this.clonedDbdModel.setDoscomp(null);
        }
    }

    public void setDatxExit(String datXExit) {
        if (datXExit != null) {
            if (datXExit.equals(YesnoType.N.value())) {
                this.clonedDbdModel.setDatxexit(YesnoType.N);
            } else if (datXExit.equals(YesnoType.Y.value())) {
                this.clonedDbdModel.setDatxexit(YesnoType.Y);
            } else {
                this.clonedDbdModel.setDatxexit(null);
            }
        } else {
            this.clonedDbdModel.setDatxexit(null);
        }
    }

    public void setPassword(String passWord) {
        if (passWord != null) {
            if (passWord.equals(YesnoType.Y.value())) {
                this.clonedDbdModel.setPassword(YesnoType.Y);
            } else if (passWord.equals(YesnoType.N.value())) {
                this.clonedDbdModel.setPassword(YesnoType.N);
            } else {
                this.clonedDbdModel.setPassword(null);
            }
        } else {
            this.clonedDbdModel.setPassword(null);
        }
    }

    public void setFpIndex(String fpIndex) {
        if (fpIndex != null && (fpIndex.equals("YES") || fpIndex.equals(YesnoType.Y.value()))) {
            this.clonedDbdModel.setFPindex("YES");
        } else {
            this.clonedDbdModel.setFPindex(null);
        }
    }

    public void setVersion(String version) throws InvalidInputException {
        if (version != null && !version.isEmpty()) {
            if (version.length() > 255) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"VERSION", version}), 8);
            }
            this.clonedDbdModel.setVersion(version);
        } else {
            this.clonedDbdModel.setVersion(null);
        }
    }

    public void setRMName(String rmName) throws ModelException, InvalidInputException {
        if (rmName == null || rmName.isEmpty()) {
            DBDConstants accessType = this.clonedDbdModel.getAccessType();
            if (accessType == DBDConstants.DEDB || accessType == DBDConstants.HDAM || accessType == DBDConstants.PHDAM) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC15", (Object[])new String[]{"RMNAME"}), 8);
            }
        } else {
            if (rmName.length() > 8 || Utility.hasReservedIMSRoutines(rmName) || Utility.hasReservedName(rmName) || Utility.hasReservedSQLKeywords(rmName) || Utility.hasSpecialChar(rmName, false) || rmName.indexOf(" ") >= 0) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"RMNAME", rmName}), 8);
            }
            this.clonedDbdModel.setRMName(rmName);
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE", (Object[])new String[]{"RMNAME"}), 12);
        }
        this.clonedDbdModel.setRMName(null);
    }

    public void setRmNameAnchorPoints(String anchorPoints) throws ModelException, InvalidInputException {
        try {
            if (anchorPoints != null && !anchorPoints.isEmpty()) {
                int anchor = Integer.parseInt(anchorPoints);
                DBDConstants accessType = this.clonedDbdModel.getAccessType();
                if (anchor < 0 || anchor > 255) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{"RMNAME/ANCHOR POINTS", "1", "255"}), 8);
                }
                if (accessType == DBDConstants.DEDB && (anchor < 1 || anchor > 2)) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{"RMNAME/ANCHOR POINTS", "1", "2"}), 8);
                }
                this.clonedDbdModel.setRmNameAnchorPoints(anchor);
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE", (Object[])new String[]{"RMNAME"}), 12);
            }
            this.clonedDbdModel.setRmNameAnchorPoints(1);
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE", (Object[])new String[]{"RMNAME"}), 12);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", (Object[])new String[]{"RMNAME/ANCHOR POINTS", "1", "255"}), 8);
        }
    }

    public void setXci(String isXCI) throws InvalidInputException, ModelException {
        DBDConstants accessType = this.clonedDbdModel.getAccessType();
        if (accessType == DBDConstants.DEDB) {
            this.clonedDbdModel.setXci(isXCI);
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE", (Object[])new String[]{"RMNAME"}), 12);
        }
    }

    public void setRmNameMaxRBN(String rmRbn) throws InvalidInputException, ModelException {
        try {
            if (rmRbn != null && !rmRbn.isEmpty()) {
                int rbn = Integer.parseInt(rmRbn);
                DBDConstants accessType = this.clonedDbdModel.getAccessType();
                if (rbn < 1 || rbn > 0xFFFFFF) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{"RMNAME/RBN", "1", "16777215"}), 8);
                }
                if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME", rmRbn, "ACCESS", accessType.value()}), 8);
                }
                this.clonedDbdModel.setRmNameMaxRBN(rbn);
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE", (Object[])new String[]{"RMNAME"}), 12);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", (Object[])new String[]{"RMNAME/RBN", "1", "16777215"}), 8);
        }
    }

    public void setRmNameBytes(String rmBytes) throws InvalidInputException, ModelException {
        try {
            if (rmBytes != null && !rmBytes.isEmpty()) {
                int bytes = Integer.parseInt(rmBytes);
                DBDConstants accessType = this.clonedDbdModel.getAccessType();
                if (bytes < 1 || bytes > 0xFFFFFF) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{"RMNAME/BYTES", "1", "16777215"}), 8);
                }
                if (accessType != DBDConstants.HDAM && accessType != DBDConstants.PHDAM) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC16", (Object[])new String[]{"RMNAME", rmBytes, "ACCESS", accessType.value()}), 8);
                }
                this.clonedDbdModel.setRmNameBytes(bytes);
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE", (Object[])new String[]{"RMNAME"}), 12);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC43", (Object[])new String[]{"RMNAME/BYTES", "1", "16777215"}), 8);
        }
    }

    public void setPsName(String psName) throws ModelException, InvalidInputException {
        if (psName != null && !psName.isEmpty()) {
            if (psName.length() > 8 || Utility.hasReservedIMSRoutines(psName) || Utility.hasReservedName(psName) || Utility.hasReservedSQLKeywords(psName) || Utility.hasSpecialChar(psName, false) || psName.indexOf(" ") >= 0) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"PSNAME", psName}), 8);
            }
            this.clonedDbdModel.setPsname(psName);
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EDIT_DBDSEGM_INFO_MESSAGE_1", (Object[])new String[]{"PSNAME"}), 12);
        }
    }

    public void setEncoding(String encoding) throws InvalidInputException {
        String dummyStr = "dummy";
        try {
            if (encoding != null && !encoding.isEmpty()) {
                dummyStr.getBytes(encoding);
                this.clonedDbdModel.setEncoding(encoding);
            } else {
                this.clonedDbdModel.setEncoding(null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC21"), 8);
        }
    }

    public void setRemarks(String remarks) throws InvalidInputException {
        String invalidCharacter = Utility.getInvalidRemarksCharacter(remarks);
        if (invalidCharacter != null && !invalidCharacter.isEmpty()) {
            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB019A"), invalidCharacter};
            String[] attrs = new String[]{"REMARKS"};
            Object errorMessage = WorkbenchModelBundle.getError().getString("EISRC11", inserts);
            if (invalidCharacter.equals("'")) {
                errorMessage = (String)errorMessage + " " + WorkbenchModelBundle.getError().getString("EISRC11A");
            }
            throw new InvalidInputException((String)errorMessage, attrs);
        }
        this.clonedDbdModel.setRemarks(remarks);
    }

    public void setDbVer(String dbVer) throws InvalidInputException {
        try {
            if (dbVer != null && !dbVer.isEmpty()) {
                int version = Integer.parseInt(dbVer);
                if (version < 0 || version > Integer.MAX_VALUE) {
                    throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC17", (Object[])new String[]{"DBVER", "1", "2147483647"}), 8);
                }
                this.clonedDbdModel.setUserVersion(version);
            } else {
                this.clonedDbdModel.setUserVersion(null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC9A"), 8);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setExit(String exit, boolean isFinish) throws InvalidInputException, ModelException {
        if (exit == null || exit.isEmpty()) return;
        if (exit.indexOf("NONE") >= 0) {
            if (!exit.equals("NONE") && !exit.equals("(NONE)")) throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"EXIT", exit}), 8);
            if (this.clonedDbdModel.getDataCaptureExitRoutines() == null) return;
            this.clonedDbdModel.getDataCaptureExitRoutines().clear();
            return;
        } else {
            Iterator<DataExitRoutine> iter = this.getExits(exit).iterator();
            if (!isFinish) return;
            while (iter.hasNext()) {
                this.clonedDbdModel.addDataCaptureExitRoutine(iter.next(), isFinish);
                if (!isFinish) continue;
                isFinish = false;
            }
        }
    }

    private List<DataExitRoutine> getExits(String exitStr) throws InvalidInputException {
        ArrayList<DataExitRoutine> newExits;
        block77: {
            DBDConstants accessType = this.clonedDbdModel.getAccessType();
            newExits = new ArrayList<DataExitRoutine>();
            try {
                if (accessType != DBDConstants.HDAM && accessType != DBDConstants.HISAM && accessType != DBDConstants.SHISAM && accessType != DBDConstants.PHDAM && accessType != DBDConstants.HIDAM && accessType != DBDConstants.PHIDAM && accessType != DBDConstants.DEDB) break block77;
                int cascadeState = 1004;
                List<String> exitParms = this.parseExitSubParms(exitStr);
                if (exitParms == null || exitParms.size() <= 0) break block77;
                int exitParmCount = 0;
                int totalParms = exitParms.size();
                DataExitRoutine dataExit = new DataExitRoutine();
                String nextParm = exitParms.get(exitParmCount);
                if (nextParm.equals("*")) {
                    dataExit.setExitName("*");
                } else {
                    assert (!nextParm.equals("("));
                    if (nextParm.length() > 8 || Utility.hasSpecialChar(nextParm, false) || Utility.hasReservedSQLKeywords(nextParm) || Utility.hasReservedIMSRoutines(nextParm) || Utility.hasReservedName(nextParm)) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), 8);
                    }
                    boolean errorFound = true;
                    try {
                        this.validateExitParm(nextParm);
                    }
                    catch (InvalidInputException invalidInputException) {
                        dataExit.setExitName(nextParm);
                        errorFound = false;
                    }
                    if (errorFound) {
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"EXIT", nextParm}), new String[]{"EXIT"}, 8);
                    }
                }
                ++exitParmCount;
                while (exitParmCount < totalParms) {
                    nextParm = exitParms.get(exitParmCount);
                    if (nextParm.equals("LOG")) {
                        dataExit.setLog(DBDConstants.Y);
                    } else if (nextParm.equals("NOLOG")) {
                        dataExit.setLog(DBDConstants.N);
                    } else if (nextParm.equals("KEY")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitKey(DBDConstants.Y);
                        } else {
                            dataExit.setCascadeKey(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NOKEY")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitKey(DBDConstants.N);
                        } else {
                            dataExit.setCascadeKey(DBDConstants.N);
                        }
                    } else if (nextParm.equals("PATH")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitPath(DBDConstants.Y);
                        } else {
                            dataExit.setCascadePath(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NOPATH")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitPath(DBDConstants.N);
                        } else {
                            dataExit.setCascadePath(DBDConstants.N);
                        }
                    } else if (nextParm.equals("DATA")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitData(DBDConstants.Y);
                        } else {
                            dataExit.setCascadeData(DBDConstants.Y);
                        }
                    } else if (nextParm.equals("NODATA")) {
                        if (cascadeState != 1003) {
                            dataExit.setExitData(DBDConstants.N);
                        } else {
                            dataExit.setCascadeData(DBDConstants.N);
                        }
                    } else if (nextParm.equals("CASCADE")) {
                        dataExit.setDoCascade(DBDConstants.Y);
                    } else if (nextParm.equals("NOCASCADE")) {
                        dataExit.setDoCascade(DBDConstants.N);
                    } else if (nextParm.equals("DLET")) {
                        dataExit.setDlet(DBDConstants.Y);
                    } else if (nextParm.equals("NODLET")) {
                        dataExit.setDlet(DBDConstants.N);
                    } else if (nextParm.equals("BEFORE")) {
                        dataExit.setBefore(DBDConstants.Y);
                    } else if (nextParm.equals("NOBEFORE")) {
                        dataExit.setBefore(DBDConstants.N);
                    } else if (nextParm.equals("SSPCMD")) {
                        dataExit.setSspcmd(DBDConstants.Y);
                    } else if (nextParm.equals("NOSSPCMD")) {
                        dataExit.setSspcmd(DBDConstants.N);
                    } else if (nextParm.equals("INPOS")) {
                        dataExit.setInpos(DBDConstants.Y);
                    } else if (nextParm.equals("NOINPOS")) {
                        dataExit.setInpos(DBDConstants.N);
                    } else if (nextParm.equals("FLD")) {
                        dataExit.setFld(DBDConstants.Y);
                    } else if (nextParm.equals("NOFLD")) {
                        dataExit.setFld(DBDConstants.N);
                    } else if (nextParm.equals("(")) {
                        if (exitParms.get(exitParmCount + 1).equals("CASCADEOPTIONS")) {
                            dataExit.setDoCascade(DBDConstants.Y);
                            cascadeState = 1003;
                            ++exitParmCount;
                        } else if (exitParms.get(exitParmCount + 1).equals("NOCASCADEOPTIONS")) {
                            dataExit.setDoCascade(DBDConstants.N);
                            cascadeState = 1003;
                            ++exitParmCount;
                        }
                    } else if (nextParm.equals(")")) {
                        assert (cascadeState == 1003);
                        cascadeState = 1004;
                    } else if (nextParm.equals("*")) {
                        assert (cascadeState != 1003);
                        newExits.add(dataExit);
                        dataExit = new DataExitRoutine();
                        cascadeState = 1004;
                        dataExit.setExitName("*");
                    } else {
                        assert (cascadeState != 1003);
                        if (dataExit.getExitName().equals("*")) {
                            this.validateExitParm(nextParm);
                        }
                        newExits.add(dataExit);
                        dataExit = new DataExitRoutine();
                        cascadeState = 1004;
                        String exitName = exitParms.get(exitParmCount);
                        if (exitName.length() > 8 || Utility.hasSpecialChar(exitName, false) || Utility.hasReservedSQLKeywords(exitName) || Utility.hasReservedIMSRoutines(exitName) || Utility.hasReservedName(exitName)) {
                            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC10"), 8);
                        }
                        dataExit.setExitName(exitName);
                    }
                    ++exitParmCount;
                }
                assert (cascadeState != 1003);
                newExits.add(dataExit);
            }
            catch (Throwable throwable) {
                throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"EXIT", exitStr}), 8);
            }
        }
        return newExits;
    }

    private void validateExitParm(String parm) throws InvalidInputException {
        if (!(parm.equals("LOG") || parm.equals("NOLOG") || parm.equals("KEY") || parm.equals("NOKEY") || parm.equals("PATH") || parm.equals("NOPATH") || parm.equals("DATA") || parm.equals("NODATA") || parm.equals("CASCADE") || parm.equals("NOCASCADE") || parm.equals("BEFORE") || parm.equals("NOBEFORE") || parm.equals("DLET") || parm.equals("NODLET") || parm.equals("SSPCMD") || parm.equals("NOSSPCMD") || parm.equals("INPOS") || parm.equals("NOINPOS") || parm.equals("FLD") || parm.equals("NOFLD"))) {
            throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC11", (Object[])new String[]{"EXIT", parm}), 8);
        }
    }

    private List<String> parseExitSubParms(String aParam) throws NoSuchElementException {
        ArrayList<String> strList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(aParam, "(),", true);
        boolean insideCascade = false;
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("(")) {
                token = st.nextToken();
                if (token.equals("(")) continue;
                if (token.equals("CASCADE")) {
                    strList.add(count, "(");
                    strList.add(count + 1, "CASCADEOPTIONS");
                    count += 2;
                    insideCascade = true;
                    continue;
                }
                if (token.equals("NOCASCADE")) {
                    strList.add(count, "(");
                    strList.add(count + 1, "NOCASCADEOPTIONS");
                    count += 2;
                    insideCascade = true;
                    continue;
                }
                strList.add(count, token);
                ++count;
                continue;
            }
            if (token.equals(")")) {
                if (!insideCascade) continue;
                strList.add(count, ")");
                insideCascade = false;
                ++count;
                continue;
            }
            if (token.equals(",")) continue;
            strList.add(count, token);
            ++count;
        }
        if (strList.size() == 0) {
            return null;
        }
        return strList;
    }

    public String getACCESSString() {
        DBDConstants accessType = this.originalDbdModel.getAccessType();
        Object retVal = accessType.value();
        if (accessType == DBDConstants.GSAM || accessType == DBDConstants.HISAM || accessType == DBDConstants.SHISAM || accessType == DBDConstants.HDAM || accessType == DBDConstants.PHDAM || accessType == DBDConstants.HIDAM || accessType == DBDConstants.PHIDAM) {
            retVal = "(" + accessType.value() + "," + this.originalDbdModel.getOsAccess() + ")";
        } else if (accessType == DBDConstants.INDEX || accessType == DBDConstants.PSINDEX) {
            IndexType indexType = this.originalDbdModel.getDbd().getAccess().getIndex();
            retVal = indexType != null ? "(" + (String)retVal + "," + String.valueOf((Object)indexType.getOsAccess()) + ")" : "(" + (String)retVal + ",VSAM)";
        }
        return retVal;
    }

    public DBDConstants getAccessType() {
        return this.originalDbdModel.getAccessType();
    }

    public String getEncoding() {
        return this.clonedDbdModel.getEncoding();
    }

    public String getRemarks() {
        return this.clonedDbdModel.getRemarks();
    }

    public String getVersion() {
        return this.clonedDbdModel.getVersion();
    }

    public String getUserVersion() {
        Integer userVersion = this.clonedDbdModel.getUserVersion();
        String retVal = null;
        if (userVersion != null) {
            retVal = String.valueOf(userVersion);
        }
        return retVal;
    }

    public String getProt() {
        YesnoType prot = this.clonedDbdModel.getProt();
        String retVal = null;
        if (prot != null) {
            retVal = prot.value();
        }
        return retVal;
    }

    public String getDoscomp() {
        YesnoType dosComp = this.clonedDbdModel.getDoscomp();
        String retVal = null;
        if (dosComp != null) {
            retVal = dosComp.value();
        }
        return retVal;
    }

    public String getFPindex() {
        YesnoType fpIndex = this.clonedDbdModel.getFPindex();
        String retVal = null;
        if (fpIndex != null) {
            retVal = fpIndex.value();
        }
        return retVal;
    }

    public List<String> getSecondaryIxDBDNames() {
        return this.clonedDbdModel.getSecondaryIxDBDNames();
    }

    public DbdModel getDbdModel() {
        return this.clonedDbdModel;
    }

    public String getDatxexit() {
        YesnoType datXExit = this.clonedDbdModel.getDatxexit();
        String retVal = null;
        if (datXExit != null) {
            retVal = datXExit.value();
        }
        return retVal;
    }

    public String getPassword() {
        YesnoType password = this.clonedDbdModel.getPassword();
        String retVal = null;
        if (password != null) {
            retVal = password.value();
        }
        return retVal;
    }

    public String getEXITString() {
        return DBDSourceGenerator.getDBDEXITString(this.clonedDbdModel);
    }

    public String getRmNameAnchorPoints() {
        Integer anch = this.clonedDbdModel.getRmNameAnchorPoints();
        String retVal = null;
        if (anch != null) {
            retVal = String.valueOf(anch);
        }
        return retVal;
    }

    public String getRMName() {
        return this.clonedDbdModel.getRMName();
    }

    public String getXCI() {
        return this.clonedDbdModel.getXCI();
    }

    public String getRmNameMaxRBN() {
        Integer rbn = this.clonedDbdModel.getRmNameMaxRBN();
        String retVal = null;
        if (rbn != null) {
            retVal = String.valueOf(rbn);
        }
        return retVal;
    }

    public String getRmNameBytes() {
        Integer bytes = this.clonedDbdModel.getRmNameBytes();
        String retVal = null;
        if (bytes != null) {
            retVal = String.valueOf(bytes);
        }
        return retVal;
    }

    public String getPsname() {
        return this.clonedDbdModel.getPsname();
    }
}

