/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.compare;

import com.ibm.im.ims.workbench.controller.compare.DbdCompare;
import com.ibm.im.ims.workbench.controller.compare.ModelCompareException;
import com.ibm.im.ims.workbench.controller.compare.SegmentCompare;
import com.ibm.im.ims.workbench.controller.editor.DatasetModel;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.SegmentDDLGenerator;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SubmitChangesController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015-2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static String CR = System.getProperty("line.separator");
    private static String TAB = "    ";
    public static final String END = ";";
    private DbdModel projectDbd;
    private ArrayList<String> ddlStatements;
    private String connProfName;

    public SubmitChangesController(String projectName, DbdModel projectDbd) {
        this.projectDbd = projectDbd;
    }

    public void doYourThing() {
    }

    public List<String> getIMSConnectionProfiles() {
        return ImsDbUtils.getConnectionProfileNames();
    }

    public String getConnProfName() {
        return this.connProfName;
    }

    public void setConnProfName(String connProfName) {
        this.connProfName = connProfName;
    }

    public ArrayList<String> runObjectCompare() throws ModelCompareException, ModelException, ImsDbConnectionException {
        String alteredRemarks;
        IImsDbConnection imsConn = ImsDbUtils.getConnectionByName((String)this.connProfName, (boolean)true);
        DbdModel currActiveDbdModel = new DbdModel(new ByteArrayInputStream(imsConn.getDbdXml(this.projectDbd.getDBDName())));
        DbdCompare dCompare = new DbdCompare(currActiveDbdModel, this.projectDbd);
        dCompare.doCompare();
        this.ddlStatements = new ArrayList();
        String dbdName = currActiveDbdModel.getDBDName();
        LinkedHashMap<String, String> attributes = dCompare.getAlteredAttributes();
        if (!attributes.isEmpty()) {
            Object alterAttributes = "";
            alterAttributes = (String)alterAttributes + "ALTER DATABASE " + dbdName + CR;
            Set<Map.Entry<String, String>> keys = attributes.entrySet();
            Iterator<Map.Entry<String, String>> iter = keys.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> current = iter.next();
                String key = current.getKey();
                String value = current.getValue();
                alterAttributes = (String)alterAttributes + TAB + key + (value.equals("YES") || value.equals("NO") ? "" : " ") + value + (iter.hasNext() ? CR : END);
            }
            alterAttributes = (String)alterAttributes + CR + CR;
            this.ddlStatements.add((String)alterAttributes);
        }
        if ((alteredRemarks = dCompare.getAlteredRemarks()) != null) {
            this.ddlStatements.add("COMMENT ON DATABASE " + dbdName + " IS" + CR + TAB + "'" + alteredRemarks + "';" + CR + CR);
        }
        List<DatasetModel> datasetAlteredList = dCompare.getAlteredDatasets();
        int i = 0;
        while (i < datasetAlteredList.size()) {
            String dsRemarks;
            DatasetModel ds = datasetAlteredList.get(i);
            String dsName = ds.getDatasetName();
            String alteredAttributes = this.getDatasetAttributes(ds, currActiveDbdModel.getAccessType());
            if (alteredAttributes != null && alteredAttributes.length() > 1) {
                this.ddlStatements.add("ALTER TABLESPACE " + dsName + " IN " + dbdName + CR + TAB + alteredAttributes + CR + CR);
            }
            if ((dsRemarks = ds.getRemarks()) != null) {
                this.ddlStatements.add("COMMENT ON TABLESPACE " + dsName + " IN " + dbdName + " IS" + CR + TAB + "'" + dsRemarks + "';" + CR + CR);
            }
            ++i;
        }
        List<SegmentCompare> segmentCompareList = dCompare.getSegmentCompareList();
        int size = segmentCompareList.size();
        int i2 = 0;
        while (i2 < size) {
            SegmentCompare segmentCompare = segmentCompareList.get(i2);
            SegmentDDLGenerator segmentDDLGenerator = new SegmentDDLGenerator(segmentCompare, this.projectDbd.getDBDName(), segmentCompare.getDBDAccessType());
            this.ddlStatements.add(segmentDDLGenerator.doGen());
            String segmentRemarks = segmentCompare.getSegmentRemarks();
            if (segmentRemarks != null) {
                this.ddlStatements.add("COMMENT ON TABLE " + segmentCompare.getSegmentName() + " IN " + dbdName + " IS" + CR + TAB + "'" + segmentRemarks + "';" + CR + CR);
            }
            ++i2;
        }
        return this.ddlStatements;
    }

    private String getDatasetAttributes(DatasetModel ds, DBDConstants accessType) {
        DBDConstants recFm;
        Integer intValue;
        Object retVal = "";
        String strValue = ds.getOutPutOrOverflow();
        if (strValue != null && !strValue.isEmpty()) {
            retVal = accessType == DBDConstants.HISAM || accessType == DBDConstants.INDEX ? (String)retVal + "OVERFLOW(" + strValue + ") " : (String)retVal + "OUTPUT(" + strValue + ") ";
        }
        if ((intValue = Integer.valueOf(ds.getRootOrBlock1())) != null && intValue > 0) {
            if (accessType == DBDConstants.GSAM || accessType == DBDConstants.HISAM || accessType == DBDConstants.SHISAM || accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM || accessType == DBDConstants.INDEX) {
                retVal = (String)retVal + "BLOCK PRIMARY " + String.valueOf(intValue) + " ";
            } else if (accessType == DBDConstants.DEDB) {
                retVal = (String)retVal + "ROOT(" + String.valueOf(intValue) + "," + ds.getRootOrBlock2() + ") ";
            }
        }
        if ((intValue = Integer.valueOf(ds.getRootOrBlock2())) != null && intValue > 0 && (accessType == DBDConstants.HISAM || accessType == DBDConstants.SHISAM || accessType == DBDConstants.INDEX)) {
            retVal = (String)retVal + "BLOCK SECONDARY " + String.valueOf(intValue) + " ";
        }
        if ((intValue = ds.getSize1()) != null && intValue > 0 && (accessType == DBDConstants.GSAM || accessType == DBDConstants.HISAM || accessType == DBDConstants.SHISAM || accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM || accessType == DBDConstants.DEDB || accessType == DBDConstants.INDEX)) {
            retVal = (String)retVal + "SIZE PRIMARY " + String.valueOf(intValue) + " ";
        }
        if ((intValue = ds.getSize2()) != null && intValue > 0 && (accessType == DBDConstants.HISAM || accessType == DBDConstants.SHISAM || accessType == DBDConstants.INDEX)) {
            retVal = (String)retVal + "SIZE SECONDARY " + String.valueOf(intValue) + " ";
        }
        if ((intValue = ds.getUowOrRecord1()) != null && intValue > 0) {
            retVal = accessType == DBDConstants.DEDB ? (String)retVal + "UOW(" + String.valueOf(intValue) + "," + String.valueOf(ds.getUowOrRecord2()) + ") " : (String)retVal + "RECORD(" + String.valueOf(intValue) + "," + String.valueOf(ds.getUowOrRecord2()) + ") ";
        }
        if (accessType == DBDConstants.HDAM || accessType == DBDConstants.HIDAM) {
            intValue = ds.getScan();
            if (intValue != null && intValue > 0) {
                retVal = (String)retVal + "SCAN " + String.valueOf(intValue) + " ";
            }
            if ((intValue = ds.getFreeBlock()) != null && intValue > 0) {
                retVal = (String)retVal + "FREEBLOCK " + String.valueOf(intValue) + " ";
            }
            if ((intValue = ds.getFreeSpace()) != null && intValue > 0) {
                retVal = (String)retVal + "FREESPACE " + String.valueOf(intValue) + " ";
            }
            if ((intValue = ds.getSearchAlgorithm()) != null && intValue > 0) {
                retVal = (String)retVal + "SEARCHA " + String.valueOf(intValue);
            }
        } else if (accessType == DBDConstants.GSAM && (recFm = ds.getRecordFormat()) != null) {
            retVal = (String)retVal + "FORMAT " + this.getLongName(recFm);
        }
        return this.formatMessage((String)retVal) + END;
    }

    public ArrayList<String> getDdlStatements() {
        return this.ddlStatements;
    }

    public void runDDLStatements(IProgressMonitor monitor) throws ImsDbConnectionException {
        IImsDbConnection imsConn = ImsDbUtils.getConnectionByName((String)this.connProfName, (boolean)true);
        imsConn.executeDdl(this.ddlStatements, monitor);
    }

    private String getLongName(DBDConstants recFm) {
        String retVal = "FIXED";
        if (recFm == DBDConstants.FB) {
            retVal = "FIXEDBLOCK";
        } else if (recFm == DBDConstants.V) {
            retVal = "VARIABLE";
        } else if (recFm == DBDConstants.VB) {
            retVal = "VARIABLEBLOCK";
        } else if (recFm == DBDConstants.U) {
            retVal = "UNDEFINED";
        }
        return retVal;
    }

    private String formatMessage(String inputMessage) {
        Object retVal = "";
        int maxLength = 37;
        int length = inputMessage.length();
        if (length >= maxLength) {
            if (inputMessage.substring(length - 1).equals(" ")) {
                inputMessage = inputMessage.substring(0, length - 1);
            } else if (inputMessage.substring(length - CR.length()).equals(CR)) {
                inputMessage = inputMessage.substring(0, length - CR.length());
            } else if (inputMessage.substring(length - TAB.length()).equals(TAB)) {
                inputMessage = inputMessage.substring(0, length - TAB.length());
            }
        }
        if (inputMessage != null) {
            while (inputMessage.length() > 0) {
                int index = inputMessage.indexOf(" ");
                if (index >= 0) {
                    int currentLineLength = ((String)retVal).length() % maxLength;
                    String tempString = inputMessage.substring(0, index + 1);
                    retVal = (String)retVal + tempString;
                    if (tempString.indexOf(CR) < 0) {
                        if (tempString.length() >= maxLength) {
                            retVal = (String)retVal + CR + TAB;
                        } else if (((String)retVal).length() % maxLength < currentLineLength) {
                            retVal = (String)retVal + CR + TAB;
                        }
                    }
                    inputMessage = inputMessage.substring(index + 1);
                    continue;
                }
                retVal = (String)retVal + inputMessage;
                break;
            }
        }
        return retVal;
    }
}

