/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.compare;

import com.ibm.im.ims.metadata.dbd.AlteredCaseType;
import com.ibm.im.ims.metadata.dbd.AlteredFieldType;
import com.ibm.im.ims.metadata.dbd.AlteredMapType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.MappingType;
import com.ibm.im.ims.metadata.dbd.RemovedCaseType;
import com.ibm.im.ims.metadata.dbd.RemovedFieldType;
import com.ibm.im.ims.metadata.dbd.RemovedMapType;
import com.ibm.im.ims.metadata.dbd.SegmentDifferences;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.controller.compare.FieldCompare;
import com.ibm.im.ims.workbench.controller.compare.MappingCompare;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.DatabaseDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

public class SegmentCompare {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015-2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private SegmentModel oldSegment;
    private SegmentModel newSegment;
    private LinkedHashMap<String, String> alteredAttributes = new LinkedHashMap();
    private List<MappingModel> createdMapsModel = new ArrayList<MappingModel>();
    private List<MappingModel> droppedMapsModel = new ArrayList<MappingModel>();
    private List<MappingModel> alteredMapsModelNew = new ArrayList<MappingModel>();
    private List<MappingModel> alteredMapsModelOld = new ArrayList<MappingModel>();
    private List<FieldModel> createdFieldsModel = new ArrayList<FieldModel>();
    private List<FieldModel> droppedFieldsModel = new ArrayList<FieldModel>();
    private List<FieldModel> alteredFieldsModelNew = new ArrayList<FieldModel>();
    private List<FieldModel> alteredFieldsModelOld = new ArrayList<FieldModel>();
    private SegmentDifferences segmentDifferences = new SegmentDifferences();
    private List<MappingType> createdMapsType = this.segmentDifferences.getCreatedMaps();
    private List<RemovedMapType> removedMapsType = this.segmentDifferences.getRemovedMaps();
    private List<AlteredMapType> alteredMapsType = this.segmentDifferences.getAlteredMaps();
    private List<FieldType> createdFieldsType = this.segmentDifferences.getCreatedFields();
    private List<RemovedFieldType> removedFieldsType = this.segmentDifferences.getRemovedFields();
    private List<AlteredFieldType> alteredFieldsType = this.segmentDifferences.getAlteredFields();
    private List<MappingCompare> mappingCompareList = new ArrayList<MappingCompare>();
    private List<FieldCompare> fieldCompareList = new ArrayList<FieldCompare>();
    private boolean sameFields = false;
    private boolean sameMappings = false;
    private boolean sameSegments = false;
    private ArrayList<MappingType> createdMapswRemarks;
    private ArrayList<AlteredRemarksMappingModel> alteredMapswRemarks;
    private ArrayList<FieldType> unmappedFieldswRemarks;
    private String segmentRemarks;

    public SegmentCompare(SegmentModel oldSegment, SegmentModel newSegment) {
        this.oldSegment = oldSegment;
        this.newSegment = newSegment;
        this.segmentDifferences.setSegmentName(newSegment.getName());
    }

    public boolean doCompare() {
        try {
            this.compareAttributes();
            this.compareFields(this.oldSegment.getFieldList(false, false), this.newSegment.getFieldList(false, false));
            this.compareMapping(this.oldSegment.getMapList(), this.newSegment.getMapList());
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        this.sameSegments = this.sameFields && this.sameMappings;
        return this.sameSegments;
    }

    private void compareAttributes() {
        DBDConstants newConstValue;
        String newStringValue = this.newSegment.getEncoding();
        String oldStringValue = this.oldSegment.getEncoding();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null || newStringValue.isEmpty()) {
                newStringValue = "Cp1047";
            }
            this.alteredAttributes.put("CCSID", "'" + newStringValue + "'");
        }
        newStringValue = this.newSegment.getDsgroup();
        oldStringValue = this.oldSegment.getDsgroup();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null) {
                newStringValue = "";
            }
            this.alteredAttributes.put("DSGROUP", newStringValue);
        }
        newStringValue = this.newSegment.getInsertionRule();
        oldStringValue = this.oldSegment.getInsertionRule();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null || newStringValue.isEmpty()) {
                newStringValue = "L";
            }
            this.alteredAttributes.put("INSERT", this.getLongName(newStringValue));
        }
        newStringValue = this.newSegment.getDeletionRule();
        oldStringValue = this.oldSegment.getDeletionRule();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null || newStringValue.isEmpty()) {
                newStringValue = "L";
            }
            this.alteredAttributes.put("DELETE", this.getLongName(newStringValue));
        }
        newStringValue = this.newSegment.getReplacementRule();
        oldStringValue = this.oldSegment.getReplacementRule();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null || newStringValue.isEmpty()) {
                newStringValue = "L";
            }
            this.alteredAttributes.put("REPLACE", this.getLongName(newStringValue));
        }
        newStringValue = this.newSegment.getInsertionLocation();
        oldStringValue = this.oldSegment.getInsertionLocation();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null || newStringValue.isEmpty()) {
                newStringValue = "LAST";
            }
            this.alteredAttributes.put("AMBIGUOUS INSERT", newStringValue);
        }
        int newIntValue = this.newSegment.getMaxBytes();
        if (this.oldSegment.getMaxBytes() != newIntValue) {
            this.alteredAttributes.put("MAXBYTES", String.valueOf(newIntValue));
        }
        newIntValue = this.newSegment.getMinBytes();
        if (this.oldSegment.getMinBytes() != newIntValue) {
            this.alteredAttributes.put("MINBYTES", String.valueOf(newIntValue));
        }
        if ((newIntValue = this.newSegment.getSsptr()) > -1 && this.oldSegment.getSsptr() != newIntValue) {
            this.alteredAttributes.put("SSPTR", String.valueOf(newIntValue));
        }
        BigDecimal newBigDecimalValue = this.newSegment.getFreq();
        if (this.oldSegment.getFreq() != newBigDecimalValue) {
            this.alteredAttributes.put("FREQ", String.valueOf(newBigDecimalValue));
        }
        Object source2 = "";
        Object source1 = "";
        if (this.oldSegment.getLogicalChildSourceSegName() == null) {
            newConstValue = this.newSegment.getSegmentSourceData();
            if (newConstValue != null && !newConstValue.equals((Object)this.oldSegment.getSegmentSourceData())) {
                source1 = this.oldSegment.getSegmentSourceDBName() + "." + this.oldSegment.getSegmentSourceSegName() + " " + (newConstValue.value() == YesnoType.Y.value() ? "DATA" : "KEY");
            }
        } else {
            newConstValue = this.newSegment.getLogicalChildSourceData();
            DBDConstants newConstValue1 = this.newSegment.getTargetParentSourceData();
            if (newConstValue != null && !newConstValue.equals((Object)this.oldSegment.getLogicalChildSourceData()) || newConstValue1 != null && !newConstValue1.equals((Object)this.oldSegment.getTargetParentSourceData())) {
                source1 = this.oldSegment.getLogicalChildSourceDBName() + "." + this.oldSegment.getLogicalChildSourceSegName() + " " + (newConstValue.value() == YesnoType.Y.value() ? "DATA" : "KEY");
                source2 = "," + this.oldSegment.getTargetParentSourceDBName() + "." + this.oldSegment.getTargetParentSourceSegName() + " " + (newConstValue1.value() == YesnoType.Y.value() ? "DATA" : "KEY");
            }
        }
        if (!((String)source1).isEmpty()) {
            this.alteredAttributes.put("SOURCE", "(" + (String)source1 + (String)source2 + ")");
        }
        Object comprtn = "";
        newStringValue = this.newSegment.getComprtnRoutineName();
        oldStringValue = this.oldSegment.getComprtnRoutineName();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            String quote = "";
            if (Utility.isQuoteNeeded(newStringValue)) {
                quote = "\"";
            }
            comprtn = (String)comprtn + quote + newStringValue + quote;
        }
        if (this.getDBDAccessType() == DBDConstants.DEDB) {
            withNeeded = true;
            newConstValue = this.newSegment.getDedbComprtnData();
            if (newConstValue != this.oldSegment.getDedbComprtnData()) {
                withNeeded = false;
                comprtn = ((String)comprtn).isEmpty() ? this.newSegment.getComprtnRoutineName() + " WITH " : (String)comprtn + " WITH ";
                comprtn = (String)comprtn + (newConstValue != null && newConstValue.value().equals(YesnoType.Y.value()) ? "DATA" : "");
            }
            if ((newConstValue = this.newSegment.getDedbComprtnInit()) != this.oldSegment.getDedbComprtnInit()) {
                comprtn = ((String)comprtn).isEmpty() ? this.newSegment.getComprtnRoutineName() + " WITH " : (withNeeded ? (String)comprtn + " WITH " : (String)comprtn + " ");
                comprtn = (String)comprtn + (newConstValue != null && newConstValue.value().equals(YesnoType.Y.value()) ? "INIT" : "");
            }
        } else {
            newStringValue = this.newSegment.getComprtnModify();
            oldStringValue = this.oldSegment.getComprtnModify();
            withNeeded = true;
            if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
                comprtn = ((String)comprtn).isEmpty() ? this.newSegment.getComprtnRoutineName() + " WITH " : (String)comprtn + " WITH ";
                comprtn = (String)comprtn + newStringValue;
                withNeeded = false;
            }
            if ((newConstValue = this.newSegment.getComprtnInit()) != this.oldSegment.getComprtnInit()) {
                comprtn = ((String)comprtn).isEmpty() ? this.newSegment.getComprtnRoutineName() + " WITH " : (withNeeded ? (String)comprtn + " WITH " : (String)comprtn + " ");
                comprtn = (String)comprtn + (newConstValue != null && newConstValue.value().equals(YesnoType.Y.value()) ? "INIT" : "");
                withNeeded = false;
            }
            newStringValue = this.newSegment.getComprtnMaxBytesNumber();
            oldStringValue = this.oldSegment.getComprtnMaxBytesNumber();
            if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
                comprtn = ((String)comprtn).isEmpty() ? this.newSegment.getComprtnRoutineName() + " WITH " : (withNeeded ? (String)comprtn + " WITH " : (String)comprtn + " ");
                comprtn = (String)comprtn + newStringValue;
                withNeeded = false;
            }
            if ((newConstValue = this.newSegment.getComprtnMaxBytesPad()) != this.oldSegment.getComprtnMaxBytesPad()) {
                comprtn = ((String)comprtn).isEmpty() ? this.newSegment.getComprtnRoutineName() + " WITH " + this.newSegment.getComprtnMaxBytesNumber() : (withNeeded ? (String)comprtn + " WITH " : (String)comprtn + " ");
                comprtn = (String)comprtn + (newConstValue != null && newConstValue.value().equals(YesnoType.Y.value()) ? "PAD" : "");
            }
        }
        if (!((String)comprtn).isEmpty()) {
            this.alteredAttributes.put("EDITPROC", "(" + (String)comprtn + ")");
        }
        String exit = "";
        newStringValue = DatabaseDDLGenerator.getSEGMEXITString(this.newSegment);
        if (!newStringValue.equals(oldStringValue = DatabaseDDLGenerator.getSEGMEXITString(this.oldSegment))) {
            exit = newStringValue;
        }
        if (!exit.isEmpty()) {
            this.alteredAttributes.put("DATA CAPTURE", exit);
        }
        newStringValue = this.newSegment.getRemarks();
        oldStringValue = this.oldSegment.getRemarks();
        if (oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            if (newStringValue == null) {
                newStringValue = "";
            }
            this.segmentRemarks = newStringValue;
        }
    }

    private void compareFields(List<FieldModel> oldFieldList, List<FieldModel> newFieldList) throws ModelException {
        this.droppedFieldsModel.addAll(oldFieldList);
        this.createdFieldsModel.addAll(newFieldList);
        block0: for (FieldModel oldField : oldFieldList) {
            for (FieldModel newField : newFieldList) {
                if (!oldField.getName().equals(newField.getName())) continue;
                this.droppedFieldsModel.remove(oldField);
                this.createdFieldsModel.remove(newField);
                FieldCompare fieldCompare = new FieldCompare(oldField, newField);
                fieldCompare.doCompare();
                if (fieldCompare.isAlteredRemarks()) {
                    if (this.unmappedFieldswRemarks == null) {
                        this.unmappedFieldswRemarks = new ArrayList();
                    }
                    this.unmappedFieldswRemarks.add(newField.getFieldType());
                }
                if (fieldCompare.isSameFields()) continue block0;
                this.alteredFieldsModelNew.add(newField);
                this.alteredFieldsModelOld.add(oldField);
                this.fieldCompareList.add(fieldCompare);
                continue block0;
            }
        }
        this.copyCreatedFieldsXFieldRemarks();
        this.copyDroppedFields();
        this.copyAlteredFields();
        this.sameFields = this.droppedFieldsModel.isEmpty() && this.createdFieldsModel.isEmpty() && this.alteredFieldsModelNew.isEmpty();
    }

    private void compareMapping(List<MappingModel> oldList, List<MappingModel> newList) throws ModelException {
        this.droppedMapsModel.addAll(oldList);
        this.createdMapsModel.addAll(newList);
        block0: for (MappingModel oldMap : oldList) {
            for (MappingModel newMap : newList) {
                if (!oldMap.getName().equals(newMap.getName())) continue;
                this.droppedMapsModel.remove(oldMap);
                this.createdMapsModel.remove(newMap);
                MappingCompare mappingCompare = new MappingCompare(oldMap, newMap);
                mappingCompare.doCompare();
                AlteredRemarksMappingModel alteredRemarksMapping = mappingCompare.getAlteredRemarksMappingModel();
                if (alteredRemarksMapping != null) {
                    if (this.alteredMapswRemarks == null) {
                        this.alteredMapswRemarks = new ArrayList();
                    }
                    this.alteredMapswRemarks.add(alteredRemarksMapping);
                }
                if (mappingCompare.isMapsSame() && mappingCompare.isSameMappingAttributes()) continue block0;
                this.alteredMapsModelNew.add(newMap);
                this.alteredMapsModelOld.add(oldMap);
                this.mappingCompareList.add(mappingCompare);
                continue block0;
            }
        }
        this.copyCreatedMapsXMapRemarks();
        this.copyDroppedMaps();
        this.copyAlteredMaps();
        this.sameMappings = this.droppedMapsModel.isEmpty() && this.createdMapsModel.isEmpty() && this.alteredMapsModelNew.isEmpty();
    }

    private void copyCreatedMapsXMapRemarks() {
        if (this.createdMapsModel.isEmpty()) {
            return;
        }
        for (MappingModel currentMapModel : this.createdMapsModel) {
            this.createdMapsType.add(currentMapModel.getMappingType());
            try {
                Vector<FieldModel> fldMdls = currentMapModel.getMapCaseList().get(0).getFieldList(false);
                fldMdls.size();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            if (currentMapModel.getRemarks() == null || currentMapModel.getRemarks().isEmpty()) continue;
            if (this.createdMapswRemarks == null) {
                this.createdMapswRemarks = new ArrayList();
            }
            this.createdMapswRemarks.add(currentMapModel.getMappingType());
        }
    }

    private void copyDroppedMaps() {
        if (this.droppedMapsModel.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.droppedMapsModel.size()) {
            RemovedMapType newType = new RemovedMapType();
            newType.setMapName(this.droppedMapsModel.get(i).getMappingType().getName());
            this.removedMapsType.add(newType);
            ++i;
        }
    }

    private void copyAlteredMaps() {
        if (this.alteredMapsModelNew.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.alteredMapsModelNew.size()) {
            AlteredMapType alteredMapType = new AlteredMapType();
            alteredMapType.setMapName(this.alteredMapsModelNew.get(i).getName());
            if (!this.alteredMapsModelNew.get(i).getDependingOnField().equals(this.alteredMapsModelOld.get(i).getDependingOnField())) {
                alteredMapType.setControlField(this.alteredMapsModelNew.get(i).getDependingOnField());
            }
            String oldRemarks = this.alteredMapsModelOld.get(i).getRemarks();
            String newRemarks = this.alteredMapsModelNew.get(i).getRemarks();
            if ((oldRemarks == null || oldRemarks.isEmpty()) && newRemarks != null && !newRemarks.isEmpty() || (newRemarks == null || newRemarks.isEmpty()) && oldRemarks != null && !oldRemarks.isEmpty() || newRemarks != null && !newRemarks.isEmpty() && oldRemarks != null && !oldRemarks.isEmpty() && !oldRemarks.equals(newRemarks)) {
                alteredMapType.setRemark(newRemarks);
            }
            List<MappingCaseType> createdCases = alteredMapType.getCreatedCases();
            createdCases.addAll(this.mappingCompareList.get(i).getCreatedCasesTypeList());
            List<RemovedCaseType> removedCases = alteredMapType.getRemovedCases();
            removedCases.addAll(this.mappingCompareList.get(i).getRemovedCasesTypeList());
            List<AlteredCaseType> alteredCases = alteredMapType.getAlteredCases();
            alteredCases.addAll(this.mappingCompareList.get(i).getAlteredCasesTypeList());
            this.alteredMapsType.add(alteredMapType);
            ++i;
        }
    }

    private void copyCreatedFieldsXFieldRemarks() {
        if (this.createdFieldsModel.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.createdFieldsModel.size()) {
            FieldModel currentFieldModel = this.createdFieldsModel.get(i);
            FieldType newFieldType = currentFieldModel.getFieldType();
            if (this.createdFieldsModel.get(i).getParentField() != null) {
                newFieldType.setParentField(currentFieldModel.getParentField().getName());
            }
            this.createdFieldsType.add(newFieldType);
            if (newFieldType.getRemarks() != null && !newFieldType.getRemarks().isEmpty()) {
                if (this.unmappedFieldswRemarks == null) {
                    this.unmappedFieldswRemarks = new ArrayList();
                }
                this.unmappedFieldswRemarks.add(newFieldType);
            }
            ++i;
        }
    }

    private void copyDroppedFields() {
        if (this.droppedFieldsModel.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.droppedFieldsModel.size()) {
            RemovedFieldType removedFieldType = new RemovedFieldType();
            removedFieldType.setExternalName(this.droppedFieldsModel.get(i).getAlias());
            this.removedFieldsType.add(removedFieldType);
            ++i;
        }
    }

    private void copyAlteredFields() {
        if (this.alteredFieldsModelNew.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.alteredFieldsModelNew.size()) {
            AlteredFieldType alteredFieldType = new AlteredFieldType();
            FieldType newFieldType = this.alteredFieldsModelNew.get(i).getFieldType();
            if (this.alteredFieldsModelNew.get(i).getParentField() != null) {
                newFieldType.setParentField(this.alteredFieldsModelNew.get(i).getParentField().getName());
            }
            FieldType oldFieldType = this.alteredFieldsModelOld.get(i).getFieldType();
            if (this.alteredFieldsModelOld.get(i).getParentField() != null) {
                oldFieldType.setParentField(this.alteredFieldsModelOld.get(i).getParentField().getName());
            }
            alteredFieldType.setExternalName(this.alteredFieldsModelNew.get(i).getAlias());
            alteredFieldType.setNewField(newFieldType);
            alteredFieldType.setOldField(oldFieldType);
            this.alteredFieldsType.add(alteredFieldType);
            ++i;
        }
    }

    public SegmentDifferences getSegmentDifferences() {
        return this.segmentDifferences;
    }

    public ArrayList<MappingType> getCreatedMapswRemarks() {
        return this.createdMapswRemarks;
    }

    public ArrayList<AlteredRemarksMappingModel> getAlteredMapswRemarks() {
        return this.alteredMapswRemarks;
    }

    public ArrayList<FieldType> getAlteredRemarksUFields() {
        return this.unmappedFieldswRemarks;
    }

    public List<FieldModel> getDroppedListFields() {
        return this.droppedFieldsModel;
    }

    public List<FieldModel> getCreatedListFields() {
        return this.createdFieldsModel;
    }

    public List<FieldModel> getAlteredListFields() {
        return this.alteredFieldsModelNew;
    }

    public List<MappingModel> getDroppedListMaps() {
        return this.droppedMapsModel;
    }

    public List<MappingModel> getCreatedListMaps() {
        return this.createdMapsModel;
    }

    public List<MappingModel> getAlteredListMaps() {
        return this.alteredMapsModelNew;
    }

    public List<MappingCompare> getMappingCompareList() {
        return this.mappingCompareList;
    }

    public List<FieldCompare> getFieldCompareList() {
        return this.fieldCompareList;
    }

    public boolean isSegmentsSame() {
        return this.sameSegments;
    }

    public DBDConstants getDBDAccessType() {
        return this.newSegment.getDBDAccessType();
    }

    public LinkedHashMap<String, String> getAlteredAttributes() {
        return this.alteredAttributes;
    }

    public String getSegmentRemarks() {
        return this.segmentRemarks;
    }

    public String getSegmentName() {
        return this.newSegment.getName();
    }

    private String getLongName(String shortName) {
        String retVal = "";
        if (shortName != null) {
            if (shortName.equals("L")) {
                retVal = DBDConstants.LOGICAL.value();
            } else if (shortName.equals("P")) {
                retVal = DBDConstants.PHYSICAL.value();
            } else if (shortName.equals("V")) {
                retVal = DBDConstants.VIRTUAL.value();
            } else if (shortName.equals("B")) {
                retVal = "BIDIRECTIONAL";
            }
        }
        return retVal;
    }
}

