/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.compare;

import com.ibm.im.ims.metadata.dbd.AlteredCaseType;
import com.ibm.im.ims.metadata.dbd.AlteredFieldType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.MappingType;
import com.ibm.im.ims.metadata.dbd.RemovedCaseType;
import com.ibm.im.ims.metadata.dbd.RemovedFieldType;
import com.ibm.im.ims.workbench.controller.compare.MappingCaseCompare;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingCaseModel;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MappingCompare {
    private MappingModel oldMapping;
    private MappingModel newMapping;
    private List<MappingCaseModel> createdCasesModel = new ArrayList<MappingCaseModel>();
    private List<MappingCaseModel> droppedCasesModel = new ArrayList<MappingCaseModel>();
    private List<MappingCaseModel> alteredCasesModelNew = new ArrayList<MappingCaseModel>();
    private List<MappingCaseModel> alteredCasesModelOld = new ArrayList<MappingCaseModel>();
    private AlteredRemarksMappingModel alteredRemarksMappingModel;
    private List<MappingCaseType> createdCasesType = new ArrayList<MappingCaseType>();
    private List<RemovedCaseType> removedCasesType = new ArrayList<RemovedCaseType>();
    private List<AlteredCaseType> alteredCasesType = new ArrayList<AlteredCaseType>();
    private List<MappingCaseCompare> mappingCaseCompareList = new ArrayList<MappingCaseCompare>();
    boolean sameMaps = false;
    boolean sameMappingAttributes = false;

    public MappingCompare(MappingModel oldMapping, MappingModel newMapping) {
        this.oldMapping = oldMapping;
        this.newMapping = newMapping;
    }

    public boolean doCompare() throws ModelException {
        this.compareMappingCases(this.oldMapping.getMapCaseList(), this.newMapping.getMapCaseList());
        this.compareMappingAttributes(this.oldMapping, this.newMapping);
        return this.sameMaps;
    }

    private void compareMappingCases(List<MappingCaseModel> oldList, List<MappingCaseModel> newList) throws ModelException {
        this.droppedCasesModel.addAll(oldList);
        this.createdCasesModel.addAll(newList);
        block0: for (MappingCaseModel oldCase : oldList) {
            for (MappingCaseModel newCase : newList) {
                if (!oldCase.getName().equals(newCase.getName())) continue;
                this.droppedCasesModel.remove(oldCase);
                this.createdCasesModel.remove(newCase);
                MappingCaseCompare mappingCaseCompare = new MappingCaseCompare(oldCase, newCase);
                mappingCaseCompare.doCompare();
                AlteredRemarksMappingCaseModel alteredRemarksCaseModel = mappingCaseCompare.getAlteredRemarksCaseModel();
                if (alteredRemarksCaseModel != null) {
                    if (this.alteredRemarksMappingModel == null) {
                        MappingType alteredRemarksMapping = new MappingType();
                        alteredRemarksMapping.setName(this.newMapping.getName());
                        alteredRemarksMapping.setRemarks(this.newMapping.getRemarks());
                        this.alteredRemarksMappingModel = new AlteredRemarksMappingModel(alteredRemarksMapping);
                    }
                    this.alteredRemarksMappingModel.getMappingType().getCase().add(alteredRemarksCaseModel.getMappingCaseType());
                    this.alteredRemarksMappingModel.getCases().add(alteredRemarksCaseModel);
                }
                if (mappingCaseCompare.isSameCases() && mappingCaseCompare.isSameMappingCaseAttributes()) continue block0;
                this.alteredCasesModelNew.add(newCase);
                this.alteredCasesModelOld.add(oldCase);
                this.mappingCaseCompareList.add(mappingCaseCompare);
                continue block0;
            }
        }
        this.copyCreatedCasesXCaseRemarks();
        this.copyDroppedCases();
        this.copyAlteredCases();
        this.sameMaps = this.droppedCasesModel.isEmpty() && this.createdCasesModel.isEmpty() && this.alteredCasesModelNew.isEmpty();
    }

    private void copyCreatedCasesXCaseRemarks() {
        if (this.createdCasesModel.isEmpty()) {
            return;
        }
        for (MappingCaseModel currentMappingCaseModel : this.createdCasesModel) {
            this.createdCasesType.add(currentMappingCaseModel.getMappingCaseType());
            try {
                Vector<FieldModel> fldMdls = currentMappingCaseModel.getFieldList(false);
                fldMdls.size();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            if (currentMappingCaseModel.getRemarks() == null || currentMappingCaseModel.getRemarks().isEmpty()) continue;
            if (this.alteredRemarksMappingModel == null) {
                MappingType alteredRemarksMapping = new MappingType();
                alteredRemarksMapping.setName(this.newMapping.getName());
                alteredRemarksMapping.setRemarks(this.newMapping.getRemarks());
                this.alteredRemarksMappingModel = new AlteredRemarksMappingModel(alteredRemarksMapping);
            }
            MappingCaseType alteredRemarksCase = new MappingCaseType();
            alteredRemarksCase.setName(currentMappingCaseModel.getName());
            alteredRemarksCase.setRemarks(currentMappingCaseModel.getRemarks());
            AlteredRemarksMappingCaseModel alteredRemarksMappingCaseModel = new AlteredRemarksMappingCaseModel(alteredRemarksCase);
            alteredRemarksMappingCaseModel.setAlteredRemarks(true);
            this.alteredRemarksMappingModel.getMappingType().getCase().add(alteredRemarksCase);
            this.alteredRemarksMappingModel.getCases().add(alteredRemarksMappingCaseModel);
        }
    }

    private void copyDroppedCases() {
        if (this.droppedCasesModel.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.droppedCasesModel.size()) {
            RemovedCaseType newType = new RemovedCaseType();
            newType.setCaseName(this.droppedCasesModel.get(i).getMappingCaseType().getName());
            this.removedCasesType.add(newType);
            ++i;
        }
    }

    private void copyAlteredCases() {
        if (this.alteredCasesModelNew.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.alteredCasesModelNew.size()) {
            AlteredCaseType alteredCaseType = new AlteredCaseType();
            alteredCaseType.setCaseName(this.alteredCasesModelNew.get(i).getName());
            if (!this.alteredCasesModelNew.get(i).getDependingOnFieldValue().getValue().equals(this.alteredCasesModelOld.get(i).getDependingOnFieldValue().getValue())) {
                alteredCaseType.setCaseID(this.alteredCasesModelNew.get(i).getDependingOnFieldValue().getValue());
            }
            if (!this.alteredCasesModelNew.get(i).getDependingOnFieldValue().getValueDatatype().value().equals(this.alteredCasesModelOld.get(i).getDependingOnFieldValue().getValueDatatype().value())) {
                alteredCaseType.setCaseIDType(this.alteredCasesModelNew.get(i).getDependingOnFieldValue().getValueDatatype().value());
            }
            String oldRemarks = this.alteredCasesModelOld.get(i).getRemarks();
            String newRemarks = this.alteredCasesModelNew.get(i).getRemarks();
            if ((oldRemarks == null || oldRemarks.isEmpty()) && newRemarks != null && !newRemarks.isEmpty() || (newRemarks == null || newRemarks.isEmpty()) && oldRemarks != null && !oldRemarks.isEmpty() || newRemarks != null && !newRemarks.isEmpty() && oldRemarks != null && !oldRemarks.isEmpty() && !oldRemarks.equals(newRemarks)) {
                alteredCaseType.setRemark(newRemarks);
            }
            List<FieldType> createdFields = alteredCaseType.getCreatedFields();
            createdFields.addAll(this.mappingCaseCompareList.get(i).getCreatedFieldsTypeList());
            List<RemovedFieldType> removedFields = alteredCaseType.getRemovedFields();
            removedFields.addAll(this.mappingCaseCompareList.get(i).getRemovedFieldsTypeList());
            List<AlteredFieldType> alteredFields = alteredCaseType.getAlteredFields();
            alteredFields.addAll(this.mappingCaseCompareList.get(i).getAlteredFieldsTypeList());
            this.alteredCasesType.add(alteredCaseType);
            ++i;
        }
    }

    private void compareMappingAttributes(MappingModel oldMapping, MappingModel newMapping) {
        String oldRemarks = oldMapping.getRemarks();
        String newRemarks = newMapping.getRemarks();
        if ((oldRemarks == null || oldRemarks.isEmpty()) && newRemarks != null && !newRemarks.isEmpty() || (newRemarks == null || newRemarks.isEmpty()) && oldRemarks != null && !oldRemarks.isEmpty() || newRemarks != null && !newRemarks.isEmpty() && oldRemarks != null && !oldRemarks.isEmpty() && !oldRemarks.equals(newRemarks)) {
            if (this.alteredRemarksMappingModel == null) {
                MappingType alteredRemarksMapping = new MappingType();
                alteredRemarksMapping.setName(newMapping.getName());
                alteredRemarksMapping.setRemarks(newMapping.getRemarks());
                this.alteredRemarksMappingModel = new AlteredRemarksMappingModel(alteredRemarksMapping);
            }
            this.alteredRemarksMappingModel.getMappingType().setRemarks(newRemarks);
            this.alteredRemarksMappingModel.setAlteredRemarks(true);
        }
        if (oldMapping.getDependingOnField() != null && newMapping.getDependingOnField() != null ? !oldMapping.getDependingOnField().equals(newMapping.getDependingOnField()) : oldMapping.getDependingOnField() != null ^ newMapping.getDependingOnField() != null) {
            return;
        }
        this.sameMappingAttributes = true;
    }

    public List<MappingCaseModel> getDroppedListCases() {
        return this.droppedCasesModel;
    }

    public List<MappingCaseModel> getCreatedListCases() {
        return this.createdCasesModel;
    }

    public List<MappingCaseModel> getAlteredListCases() {
        return this.alteredCasesModelNew;
    }

    public List<MappingCaseType> getCreatedCasesTypeList() {
        return this.createdCasesType;
    }

    public List<RemovedCaseType> getRemovedCasesTypeList() {
        return this.removedCasesType;
    }

    public List<AlteredCaseType> getAlteredCasesTypeList() {
        return this.alteredCasesType;
    }

    public List<MappingCaseCompare> getMappingCaseCompareList() {
        return this.mappingCaseCompareList;
    }

    public boolean isMapsSame() {
        return this.sameMaps;
    }

    public boolean isSameMappingAttributes() {
        return this.sameMappingAttributes;
    }

    public AlteredRemarksMappingModel getAlteredRemarksMappingModel() {
        return this.alteredRemarksMappingModel;
    }
}

