/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.compare;

import com.ibm.im.ims.metadata.dbd.AlteredFieldType;
import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.MappingCaseType;
import com.ibm.im.ims.metadata.dbd.RemovedFieldType;
import com.ibm.im.ims.workbench.controller.compare.FieldCompare;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingCaseModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import java.util.ArrayList;
import java.util.List;

public class MappingCaseCompare {
    private MappingCaseModel oldMappingCase;
    private MappingCaseModel newMappingCase;
    private List<FieldModel> droppedFieldsModel = new ArrayList<FieldModel>();
    private List<FieldModel> createdFieldsModel = new ArrayList<FieldModel>();
    private List<FieldModel> alteredFieldsModelNew = new ArrayList<FieldModel>();
    private List<FieldModel> alteredFieldsModelOld = new ArrayList<FieldModel>();
    private List<FieldType> createdFieldsType = new ArrayList<FieldType>();
    private List<RemovedFieldType> removedFieldsType = new ArrayList<RemovedFieldType>();
    private List<AlteredFieldType> alteredFieldsType = new ArrayList<AlteredFieldType>();
    private AlteredRemarksMappingCaseModel alteredRemarksCaseModel;
    private List<FieldCompare> fieldCompareList = new ArrayList<FieldCompare>();
    boolean sameCases = false;
    boolean sameMappingCaseAttributes = false;

    public MappingCaseCompare(MappingCaseModel oldMappingCase, MappingCaseModel newMappingCase) {
        this.oldMappingCase = oldMappingCase;
        this.newMappingCase = newMappingCase;
    }

    public boolean doCompare() throws ModelException {
        this.compareFields(this.oldMappingCase.getFieldList(false), this.newMappingCase.getFieldList(false));
        this.compareMappingCaseAttributes(this.oldMappingCase, this.newMappingCase);
        return this.sameCases;
    }

    private void compareFields(List<FieldModel> oldFieldList, List<FieldModel> newFieldList) {
        this.droppedFieldsModel.addAll(oldFieldList);
        this.createdFieldsModel.addAll(newFieldList);
        block0: for (FieldModel oldField : oldFieldList) {
            for (FieldModel newField : newFieldList) {
                if (!oldField.getName().equals(newField.getName())) continue;
                this.droppedFieldsModel.remove(oldField);
                this.createdFieldsModel.remove(newField);
                FieldCompare fieldCompare = new FieldCompare(oldField, newField);
                fieldCompare.doCompare();
                if (fieldCompare.isAlteredRemarks()) {
                    if (this.alteredRemarksCaseModel == null) {
                        MappingCaseType alteredRemarksCase = new MappingCaseType();
                        alteredRemarksCase.setName(this.newMappingCase.getName());
                        alteredRemarksCase.setRemarks(this.newMappingCase.getRemarks());
                        this.alteredRemarksCaseModel = new AlteredRemarksMappingCaseModel(alteredRemarksCase);
                    }
                    this.alteredRemarksCaseModel.getMappingCaseType().getField().add(newField.getFieldType());
                }
                if (fieldCompare.isSameFields()) continue block0;
                this.alteredFieldsModelNew.add(newField);
                this.alteredFieldsModelOld.add(oldField);
                this.fieldCompareList.add(fieldCompare);
                continue block0;
            }
        }
        this.copyCreatedFieldsXFieldRemarks();
        this.copyDroppedFields();
        this.copyAlteredFields();
        this.sameCases = this.droppedFieldsModel.isEmpty() && this.createdFieldsModel.isEmpty() && this.alteredFieldsModelNew.isEmpty();
    }

    private void compareMappingCaseAttributes(MappingCaseModel oldMappingCase, MappingCaseModel newMappingCase) {
        String oldRemarks = oldMappingCase.getRemarks();
        String newRemarks = newMappingCase.getRemarks();
        if ((oldRemarks == null || oldRemarks.isEmpty()) && newRemarks != null && !newRemarks.isEmpty() || (newRemarks == null || newRemarks.isEmpty()) && oldRemarks != null && !oldRemarks.isEmpty() || newRemarks != null && !newRemarks.isEmpty() && oldRemarks != null && !oldRemarks.isEmpty() && !oldRemarks.equals(newRemarks)) {
            if (this.alteredRemarksCaseModel == null) {
                MappingCaseType alteredRemarksCase = new MappingCaseType();
                alteredRemarksCase.setName(newMappingCase.getName());
                alteredRemarksCase.setRemarks(newMappingCase.getRemarks());
                this.alteredRemarksCaseModel = new AlteredRemarksMappingCaseModel(alteredRemarksCase);
            }
            this.alteredRemarksCaseModel.getMappingCaseType().setRemarks(newRemarks);
            this.alteredRemarksCaseModel.setAlteredRemarks(true);
            this.alteredRemarksCaseModel.getMappingCaseType().setName(newMappingCase.getName());
        }
        if (oldMappingCase.getDependingOnFieldValue().getValue() != null && newMappingCase.getDependingOnFieldValue().getValue() != null ? !oldMappingCase.getDependingOnFieldValue().getValue().equals(newMappingCase.getDependingOnFieldValue().getValue()) : oldMappingCase.getDependingOnFieldValue().getValue() != null ^ newMappingCase.getDependingOnFieldValue().getValue() != null) {
            return;
        }
        if (oldMappingCase.getDependingOnFieldValue().getValueDatatype() != null && newMappingCase.getDependingOnFieldValue().getValueDatatype() != null ? !oldMappingCase.getDependingOnFieldValue().getValueDatatype().equals((Object)newMappingCase.getDependingOnFieldValue().getValueDatatype()) : oldMappingCase.getDependingOnFieldValue().getValueDatatype() != null ^ newMappingCase.getDependingOnFieldValue().getValueDatatype() != null) {
            return;
        }
        this.sameMappingCaseAttributes = true;
    }

    private void copyCreatedFieldsXFieldRemarks() {
        if (this.createdFieldsModel.isEmpty()) {
            return;
        }
        for (FieldModel currentFieldModel : this.createdFieldsModel) {
            FieldType newFieldType = currentFieldModel.getFieldType();
            if (currentFieldModel.getParentField() != null) {
                newFieldType.setParentField(currentFieldModel.getParentField().getName());
            }
            this.createdFieldsType.add(newFieldType);
            if (this.alteredRemarksCaseModel == null) {
                MappingCaseType alteredRemarksCase = new MappingCaseType();
                alteredRemarksCase.setName(this.newMappingCase.getName());
                alteredRemarksCase.setRemarks(this.newMappingCase.getRemarks());
                this.alteredRemarksCaseModel = new AlteredRemarksMappingCaseModel(alteredRemarksCase);
            }
            if (currentFieldModel.getRemarks() == null || currentFieldModel.getRemarks().isEmpty()) continue;
            this.alteredRemarksCaseModel.getMappingCaseType().getField().add(currentFieldModel.getFieldType());
        }
    }

    private void copyDroppedFields() {
        if (this.droppedFieldsModel.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.droppedFieldsModel.size()) {
            RemovedFieldType removedFieldType = new RemovedFieldType();
            removedFieldType.setExternalName(this.droppedFieldsModel.get(i).getAlias());
            this.removedFieldsType.add(removedFieldType);
            ++i;
        }
    }

    private void copyAlteredFields() {
        if (this.alteredFieldsModelNew.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.alteredFieldsModelNew.size()) {
            AlteredFieldType alteredFieldType = new AlteredFieldType();
            FieldType newFieldType = this.alteredFieldsModelNew.get(i).getFieldType();
            if (this.alteredFieldsModelNew.get(i).getParentField() != null) {
                newFieldType.setParentField(this.alteredFieldsModelNew.get(i).getParentField().getName());
            }
            FieldType oldFieldType = this.alteredFieldsModelOld.get(i).getFieldType();
            if (this.alteredFieldsModelOld.get(i).getParentField() != null) {
                oldFieldType.setParentField(this.alteredFieldsModelOld.get(i).getParentField().getName());
            }
            alteredFieldType.setExternalName(this.alteredFieldsModelNew.get(i).getAlias());
            alteredFieldType.setNewField(newFieldType);
            alteredFieldType.setOldField(oldFieldType);
            this.alteredFieldsType.add(alteredFieldType);
            ++i;
        }
    }

    public List<FieldModel> getDroppedFieldsList() {
        return this.droppedFieldsModel;
    }

    public List<FieldModel> getCreatedFieldsList() {
        return this.createdFieldsModel;
    }

    public List<FieldModel> getAlteredFieldsList() {
        return this.alteredFieldsModelNew;
    }

    public List<FieldType> getCreatedFieldsTypeList() {
        return this.createdFieldsType;
    }

    public List<RemovedFieldType> getRemovedFieldsTypeList() {
        return this.removedFieldsType;
    }

    public List<AlteredFieldType> getAlteredFieldsTypeList() {
        return this.alteredFieldsType;
    }

    public List<FieldCompare> getFieldCompareList() {
        return this.fieldCompareList;
    }

    public boolean isSameCases() {
        return this.sameCases;
    }

    public boolean isSameMappingCaseAttributes() {
        return this.sameMappingCaseAttributes;
    }

    public AlteredRemarksMappingCaseModel getAlteredRemarksCaseModel() {
        return this.alteredRemarksCaseModel;
    }
}

