/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.controller.compare;

import com.ibm.im.ims.metadata.dbd.FieldType;
import com.ibm.im.ims.metadata.dbd.YesnoType;
import com.ibm.im.ims.workbench.controller.compare.ModelCompareException;
import com.ibm.im.ims.workbench.controller.compare.SegmentCompare;
import com.ibm.im.ims.workbench.controller.editor.DatasetModel;
import com.ibm.im.ims.workbench.model.AlteredRemarksMappingModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.DatabaseDDLGenerator;
import com.ibm.im.ims.workbench.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class DbdCompare {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015-2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private DbdModel oldDbd;
    private DbdModel newDbd;
    private ArrayList<DatasetModel> alteredDatasets = new ArrayList();
    private ArrayList<DatasetModel> droppedDatasets = new ArrayList();
    private ArrayList<DatasetModel> addedDatasets = new ArrayList();
    private LinkedHashMap<String, String> alteredAttributes = new LinkedHashMap();
    private String alteredRemarks = null;
    private List<SegmentCompare> segmentCompareList = new ArrayList<SegmentCompare>();
    boolean sameDBD = false;

    public DbdCompare(DbdModel oldDbd, DbdModel newDbd) {
        this.oldDbd = oldDbd;
        this.newDbd = newDbd;
    }

    public boolean doCompare() {
        try {
            this.compareAttributes();
            this.compareDatasets();
            this.compareSegments(this.oldDbd.getRootSegment(), this.newDbd.getRootSegment());
        }
        catch (ModelCompareException e) {
            e.printStackTrace();
        }
        return this.sameDBD;
    }

    private void compareAttributes() {
        YesnoType newDoscomp;
        YesnoType oldDoscomp;
        YesnoType newProt;
        YesnoType oldProt;
        YesnoType newFpIndex;
        YesnoType oldFpIndex;
        YesnoType newPassword;
        YesnoType oldPassword;
        YesnoType newDatxexit;
        YesnoType oldDatxexit;
        DBDConstants accessType = this.oldDbd.getAccessType();
        if (accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM) || accessType.equals((Object)DBDConstants.DEDB)) {
            Integer newInteger = this.newDbd.getUserVersion();
            Integer oldInteger = this.oldDbd.getUserVersion();
            String newDBVer = null;
            if (newInteger != oldInteger) {
                if (newInteger != null) {
                    newDBVer = oldInteger != null && oldInteger == newInteger - 1 ? newInteger.toString() : "CURRENT";
                } else if (oldInteger != null) {
                    newDBVer = "AUTO";
                }
            }
            if (newDBVer != null) {
                this.alteredAttributes.put("DBVER", newDBVer);
            }
        }
        if ((accessType.equals((Object)DBDConstants.GSAM) || accessType.equals((Object)DBDConstants.HSAM) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHSAM) || accessType.equals((Object)DBDConstants.SHISAM) || accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.PSINDEX) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.PHIDAM)) && (oldDatxexit = this.oldDbd.getDatxexit()) != (newDatxexit = this.newDbd.getDatxexit())) {
            this.alteredAttributes.put("DATXEXIT", this.getLongName(newDatxexit.value()));
        }
        if ((accessType.equals((Object)DBDConstants.PHIDAM) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.GSAM) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHISAM) || accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.PSINDEX)) && (oldPassword = this.oldDbd.getPassword()) != (newPassword = this.newDbd.getPassword())) {
            this.alteredAttributes.put("PASSWD", this.getLongName(newPassword.value()));
        }
        if (accessType.equals((Object)DBDConstants.INDEX) && (oldFpIndex = this.oldDbd.getFPindex()) != (newFpIndex = this.newDbd.getFPindex())) {
            this.alteredAttributes.put("FPINDEX", this.getLongName(newFpIndex.value()));
        }
        if ((accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.PSINDEX)) && (oldProt = this.oldDbd.getProt()) != (newProt = this.newDbd.getProt()) && newProt != null) {
            this.alteredAttributes.put("PROT", this.getLongName(newProt.value()));
        }
        if (accessType.equals((Object)DBDConstants.INDEX) && (oldDoscomp = this.oldDbd.getDoscomp()) != (newDoscomp = this.newDbd.getDoscomp()) && newDoscomp != null) {
            this.alteredAttributes.put("DOSCOMP", this.getLongName(newDoscomp.value()));
        }
        if (accessType.equals((Object)DBDConstants.PHIDAM) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.SHISAM) || accessType.equals((Object)DBDConstants.DEDB)) {
            String oldExitValue;
            String exit = "";
            String newExitValue = DatabaseDDLGenerator.getDBDEXITString(this.newDbd);
            if (!newExitValue.equals(oldExitValue = DatabaseDDLGenerator.getDBDEXITString(this.oldDbd))) {
                exit = newExitValue;
            }
            if (!exit.isEmpty()) {
                this.alteredAttributes.put("DATA CAPTURE", exit);
            }
        }
        if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM) || accessType.equals((Object)DBDConstants.DEDB)) {
            Object newRmName = this.newDbd.getRMName();
            String oldRmName = this.oldDbd.getRMName();
            Object randomizer = "";
            if (!((String)newRmName).equals(oldRmName)) {
                if (Utility.isStringNumeric((String)newRmName)) {
                    newRmName = "\"" + (String)newRmName + "\"";
                }
                randomizer = (String)randomizer + (String)newRmName;
            }
            Integer newInteger = this.newDbd.getRmNameAnchorPoints();
            Integer oldInteger = this.oldDbd.getRmNameAnchorPoints();
            if (newInteger == null && oldInteger != null || newInteger != null && newInteger != -1 && (oldInteger == null || !newInteger.equals(oldInteger))) {
                if (((String)randomizer).isEmpty()) {
                    randomizer = (String)randomizer + (String)newRmName;
                }
                if (newInteger != null) {
                    randomizer = (String)randomizer + " RMANCH " + String.valueOf(newInteger);
                }
            } else if (!((String)randomizer).isEmpty() && oldInteger != null) {
                randomizer = (String)randomizer + " RMANCH " + String.valueOf(oldInteger);
            }
            if (accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.PHDAM)) {
                newInteger = this.newDbd.getRmNameMaxRBN();
                oldInteger = this.oldDbd.getRmNameMaxRBN();
                if (newInteger == null && oldInteger != null || newInteger != null && newInteger != -1 && (oldInteger == null || !newInteger.equals(oldInteger))) {
                    if (((String)randomizer).isEmpty()) {
                        randomizer = (String)randomizer + (String)newRmName;
                        oldInteger = this.oldDbd.getRmNameAnchorPoints();
                        if (oldInteger != null) {
                            randomizer = (String)randomizer + " RMANCH " + String.valueOf(oldInteger);
                        }
                    }
                    if (newInteger != null) {
                        randomizer = (String)randomizer + " RMRBN " + String.valueOf(newInteger);
                    }
                } else if (!((String)randomizer).isEmpty() && oldInteger != null) {
                    randomizer = (String)randomizer + " RMRBN " + String.valueOf(oldInteger);
                }
                newInteger = this.newDbd.getRmNameBytes();
                oldInteger = this.oldDbd.getRmNameBytes();
                if (newInteger == null && oldInteger != null || newInteger != null && (oldInteger == null || !newInteger.equals(oldInteger))) {
                    if (((String)randomizer).isEmpty()) {
                        randomizer = (String)randomizer + (String)newRmName;
                        oldInteger = this.oldDbd.getRmNameAnchorPoints();
                        if (oldInteger != null) {
                            randomizer = (String)randomizer + " RMANCH " + String.valueOf(oldInteger);
                        }
                        if ((oldInteger = this.oldDbd.getRmNameMaxRBN()) != null) {
                            randomizer = (String)randomizer + " RMRBN " + String.valueOf(oldInteger);
                        }
                    }
                    if (newInteger != null) {
                        randomizer = (String)randomizer + " RMBYTES " + String.valueOf(newInteger);
                    }
                } else if (!((String)randomizer).isEmpty() && oldInteger != null) {
                    randomizer = (String)randomizer + " RMBYTES " + String.valueOf(oldInteger);
                }
            } else {
                String oldXci = this.oldDbd.getXCI();
                String newXci = this.newDbd.getXCI();
                if (newXci == null && oldXci != null || newXci != null && oldXci == null || !newXci.equals(oldXci)) {
                    if (((String)randomizer).isEmpty()) {
                        randomizer = (String)randomizer + (String)newRmName;
                    }
                    if (newXci != null) {
                        randomizer = newXci.equals(DBDConstants.Y.value()) ? (String)randomizer + " XCIYES" : (String)randomizer + " XCINO";
                    }
                } else if (!((String)randomizer).isEmpty() && oldXci != null) {
                    randomizer = oldXci.equals("YES") ? (String)randomizer + " XCIYES" : (String)randomizer + " XCINO";
                }
            }
            if (!((String)randomizer).isEmpty()) {
                this.alteredAttributes.put("RMNAME", "(" + (String)randomizer + ")");
            }
        }
        String newStringValue = this.newDbd.getEncoding();
        String oldStringValue = this.oldDbd.getEncoding();
        if ((oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) && newStringValue != null && !newStringValue.trim().isEmpty()) {
            this.alteredAttributes.put("CCSID", "'" + newStringValue + "'");
        }
        newStringValue = this.newDbd.getVersion();
        oldStringValue = this.oldDbd.getVersion();
        if ((oldStringValue == null && newStringValue != null || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) && newStringValue != null && !newStringValue.trim().isEmpty()) {
            this.alteredAttributes.put("VERSION", "'" + newStringValue + "'");
        }
        newStringValue = this.newDbd.getRemarks();
        oldStringValue = this.oldDbd.getRemarks();
        if (oldStringValue == null && newStringValue != null && !newStringValue.isEmpty() || oldStringValue != null && newStringValue == null || oldStringValue != null && newStringValue != null && !oldStringValue.equals(newStringValue)) {
            this.alteredRemarks = newStringValue;
        }
    }

    private void compareDatasets() throws ModelCompareException {
        DBDConstants accessType = this.oldDbd.getAccessType();
        if (accessType.equals((Object)DBDConstants.HSAM) || accessType.equals((Object)DBDConstants.SHSAM) || accessType.equals((Object)DBDConstants.GSAM) || accessType.equals((Object)DBDConstants.HISAM) || accessType.equals((Object)DBDConstants.HDAM) || accessType.equals((Object)DBDConstants.HIDAM) || accessType.equals((Object)DBDConstants.INDEX) || accessType.equals((Object)DBDConstants.DEDB)) {
            ArrayList<DatasetModel> oldDatasets = Utility.getDatasetModels(this.oldDbd);
            ArrayList<DatasetModel> newDatasets = Utility.getDatasetModels(this.newDbd);
            LinkedHashMap<String, DatasetModel> oldDsMap = new LinkedHashMap<String, DatasetModel>();
            for (DatasetModel ds : oldDatasets) {
                oldDsMap.put(ds.getDatasetName(), ds);
            }
            LinkedHashMap<String, DatasetModel> newDsMap = new LinkedHashMap<String, DatasetModel>();
            for (DatasetModel ds : newDatasets) {
                newDsMap.put(ds.getDatasetName(), ds);
            }
            for (DatasetModel ds : oldDatasets) {
                if (newDsMap.get(ds.getDatasetName()) != null) continue;
                this.droppedDatasets.add(ds);
            }
            for (DatasetModel ds : newDatasets) {
                DatasetModel oldDs = (DatasetModel)oldDsMap.get(ds.getDatasetName());
                if (oldDs == null) {
                    this.addedDatasets.add(ds);
                    continue;
                }
                this.compareDataset(oldDs, ds, accessType);
            }
        }
    }

    private void compareDataset(DatasetModel oldDs, DatasetModel newDs, DBDConstants accessType) throws ModelCompareException {
        DatasetModel alteredDs = null;
        String oldStr = oldDs.getRemarks();
        String newStr = newDs.getRemarks();
        if (oldStr == null && newStr != null || oldStr != null && newStr == null || oldStr != null && newStr != null && !oldStr.equals(newStr)) {
            alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), newStr);
        }
        oldStr = oldDs.getOutPutOrOverflow();
        newStr = newDs.getOutPutOrOverflow();
        if (oldStr == null && newStr != null || oldStr != null && newStr == null || oldStr != null && newStr != null && !oldStr.equals(newStr)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setOutPutOrOverflow(newStr);
        }
        Integer oldInt = oldDs.getSize1();
        Integer newInt = newDs.getSize1();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setSize1(newInt);
        }
        oldInt = oldDs.getSize2();
        newInt = newDs.getSize2();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setSize2(newInt);
        }
        oldInt = oldDs.getUowOrRecord1();
        newInt = newDs.getUowOrRecord1();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setUowOrRecord1(newInt);
            if (accessType == DBDConstants.DEDB) {
                alteredDs.setUowOrRecord2(newDs.getUowOrRecord2());
            }
        }
        oldInt = oldDs.getUowOrRecord2();
        newInt = newDs.getUowOrRecord2();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setUowOrRecord2(newInt);
            if (accessType == DBDConstants.DEDB) {
                alteredDs.setUowOrRecord1(newDs.getUowOrRecord1());
            }
        }
        oldInt = oldDs.getScan();
        newInt = newDs.getScan();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setScan(newInt);
        }
        oldInt = oldDs.getFreeBlock();
        newInt = newDs.getFreeBlock();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setFreeBlock(newInt);
        }
        oldInt = oldDs.getFreeSpace();
        newInt = newDs.getFreeSpace();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setFreeSpace(newInt);
        }
        oldInt = oldDs.getSearchAlgorithm();
        newInt = newDs.getSearchAlgorithm();
        if (oldInt == null && newInt != null || oldInt != null && newInt == null || oldInt != null && newInt != null && !oldInt.equals(newInt)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setSearchAlgorithm(newInt);
        }
        if ((oldInt = Integer.valueOf(oldDs.getRootOrBlock1())) != (newInt = Integer.valueOf(newDs.getRootOrBlock1()))) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setRootOrBlock1(newInt);
            if (accessType == DBDConstants.DEDB) {
                alteredDs.setRootOrBlock2(newDs.getRootOrBlock2());
            }
        }
        if ((oldInt = Integer.valueOf(oldDs.getRootOrBlock2())) != (newInt = Integer.valueOf(newDs.getRootOrBlock2()))) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setRootOrBlock2(newInt);
            if (accessType == DBDConstants.DEDB) {
                alteredDs.setRootOrBlock1(newDs.getRootOrBlock1());
            }
        }
        DBDConstants oldConst = oldDs.getRecordFormat();
        DBDConstants newConst = newDs.getRecordFormat();
        if (oldConst == null && newConst != null || oldConst != null && newConst == null || oldConst != null && newConst != null && !oldConst.equals((Object)newConst)) {
            if (alteredDs == null) {
                alteredDs = new DatasetModel(newDs.getDatasetName(), newDs.getDevice(), null);
            }
            alteredDs.setRecordFormat(newConst);
        }
        if (alteredDs != null) {
            this.alteredDatasets.add(alteredDs);
        }
    }

    private void compareSegments(SegmentModel oldSegment, SegmentModel newSegment) throws ModelCompareException {
        SegmentCompare segmentCompare = new SegmentCompare(oldSegment, newSegment);
        segmentCompare.doCompare();
        ArrayList<AlteredRemarksMappingModel> alteredRemarksMappingModels = segmentCompare.getAlteredMapswRemarks();
        ArrayList<FieldType> alteredRemarksUFields = segmentCompare.getAlteredRemarksUFields();
        if (!segmentCompare.isSegmentsSame() || !segmentCompare.getAlteredAttributes().isEmpty() || alteredRemarksMappingModels != null && !alteredRemarksMappingModels.isEmpty() || alteredRemarksUFields != null && !alteredRemarksUFields.isEmpty()) {
            this.segmentCompareList.add(segmentCompare);
        }
        List<SegmentModel> oldChildSegments = oldSegment.getChildSegments();
        List<SegmentModel> newChildSegments = newSegment.getChildSegments();
        if (oldChildSegments.size() != newChildSegments.size()) {
            ModelCompareException mce = new ModelCompareException("Segment trees are not identical. Size mismatch");
            logger.throwing(this.getClass().getName(), "", (Throwable)mce);
            throw mce;
        }
        int i = 0;
        while (i < oldChildSegments.size()) {
            SegmentModel oldChild = oldChildSegments.get(i);
            SegmentModel newChild = newChildSegments.get(i);
            if (!oldChild.getName().equals(newChild.getName())) {
                ModelCompareException mce = new ModelCompareException("Segment trees are not identical. Segment names mismatch");
                logger.throwing(this.getClass().getName(), "", (Throwable)mce);
                throw mce;
            }
            this.compareSegments(oldChild, newChild);
            ++i;
        }
        this.sameDBD = this.segmentCompareList.isEmpty();
    }

    private String getLongName(String name) {
        String retVal = "";
        if (name.equals(YesnoType.Y.value())) {
            retVal = "YES";
        } else if (name.equals(YesnoType.N.value())) {
            retVal = "NO";
        }
        return retVal;
    }

    public List<SegmentCompare> getSegmentCompareList() {
        return this.segmentCompareList;
    }

    public boolean isSameDBD() {
        return this.sameDBD;
    }

    public LinkedHashMap<String, String> getAlteredAttributes() {
        return this.alteredAttributes;
    }

    public String getAlteredRemarks() {
        return this.alteredRemarks;
    }

    public List<DatasetModel> getAlteredDatasets() {
        return this.alteredDatasets;
    }

    public List<DatasetModel> getAddedDatasets() {
        return this.addedDatasets;
    }

    public List<DatasetModel> getDroppedDatasets() {
        return this.droppedDatasets;
    }
}

