/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.cam.walkers.util;

import com.ibm.im.ims.cam.walkers.cobol.ICOBOLModelConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;

public class WrappingOutputStream
extends ByteArrayOutputStream {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Integer leftByteMargin = 1;
    private Integer rightByteMargin = 0;
    private Integer lineBytesRemain = 0;
    private Charset charset = Charset.defaultCharset();
    private String _eol = System.getProperty("line.separator");
    private byte[] _eol_bytes = null;
    private boolean localeIsDBCS = WrappingOutputStream.isJVMLocaleDBCS();
    private boolean inSBCS = false;
    private boolean needSI = false;
    private boolean inDBCS = false;
    private boolean needSO = false;
    private boolean initial = true;
    private WrappingStyle wrappingStyle = WrappingStyle.NORMAL;

    public WrappingOutputStream(Integer rightByteMargin) {
        this(1, rightByteMargin, Charset.defaultCharset());
    }

    public WrappingOutputStream(Integer leftByteMargin, Integer rightByteMargin) {
        this(leftByteMargin, rightByteMargin, Charset.defaultCharset());
    }

    public WrappingOutputStream(Integer leftByteMargin, Integer rightByteMargin, Charset charset) {
        this.leftByteMargin = leftByteMargin;
        this.rightByteMargin = rightByteMargin;
        this.lineBytesRemain = this.rightByteMargin - this.leftByteMargin + 1;
        if (charset != null) {
            this.charset = charset;
        }
        this._eol_bytes = this._eol.getBytes();
    }

    public void write(String prefix, String text, int leadingNewLines, int trailingNewLines) {
        try {
            this.write(prefix, text, leadingNewLines, trailingNewLines, null);
        }
        catch (IOException iOException) {}
    }

    public void write(String text, int leadingNewLines, int trailingNewLines) {
        this.write(null, text, leadingNewLines, trailingNewLines);
    }

    private void write(String prefix, String text, int leadingNewLines, int trailingNewLines, Object dummy) throws IOException {
        int i;
        if (text == null || text.isEmpty()) {
            text = "";
        }
        if (this.initial) {
            i = 1;
            while (i < this.leftByteMargin) {
                super.write(this.toBytes(' '));
                ++i;
            }
        }
        i = 0;
        while (i < leadingNewLines) {
            this.startNewLine(prefix, false, null, null, null);
            ++i;
        }
        if (this.lineBytesRemain == 0) {
            this.startNewLine(prefix, true, null, null, null);
        }
        String _text = text.replaceAll(this._eol, "");
        if (this.initial && prefix != null) {
            _text = prefix.concat(_text);
        }
        char[] _textChars = _text.toCharArray();
        Character nextChr = Character.valueOf(' ');
        Character prevChr = Character.valueOf(' ');
        Character dlimChr = Character.valueOf(' ');
        int dlimCnt = 0;
        int i2 = 0;
        while (i2 < _textChars.length) {
            nextChr = Character.valueOf(_textChars[i2]);
            byte[] nextCharBytes = this.toBytes(nextChr.charValue());
            int nextCharByteCnt = this.getLocaleCharByteCnt(nextChr.charValue());
            if (nextChr.charValue() == '\'' && prevChr.charValue() != '\'' && dlimChr.charValue() != '\"') {
                dlimChr = Character.valueOf('\'');
                ++dlimCnt;
            } else if (nextChr.charValue() == '\"' && dlimChr.charValue() != '\'') {
                dlimChr = Character.valueOf('\"');
                ++dlimCnt;
            }
            if (this.lineBytesRemain < nextCharByteCnt) {
                if (!this.isUnbalanced(dlimCnt) || this.isUnbalanced(dlimCnt) && nextChr.equals(dlimChr)) {
                    this.startNewLine(prefix, true, prevChr, nextChr, null);
                } else {
                    this.startNewLine(prefix, true, prevChr, nextChr, dlimChr);
                }
            } else if (this.localeIsDBCS) {
                if (this.needSI) {
                    super.write(31);
                    this.needSI = false;
                } else if (this.needSO) {
                    super.write(30);
                    this.needSO = false;
                }
            }
            super.write(nextCharBytes);
            this.lineBytesRemain = this.lineBytesRemain - nextCharByteCnt;
            prevChr = nextChr;
            ++i2;
        }
        i2 = 0;
        while (i2 < trailingNewLines) {
            this.startNewLine(prefix, false, null, null, null);
            ++i2;
        }
        this.initial = false;
    }

    private int getLocaleCharByteCnt(char localeChar) {
        byte[] localeCharBytes = this.toBytes(localeChar);
        int localeCharByteCnt = localeCharBytes.length;
        if (this.localeIsDBCS) {
            switch (localeCharByteCnt % 2) {
                case 0: {
                    this.inDBCS = true;
                    if (!this.inSBCS) break;
                    this.inSBCS = false;
                    this.needSO = true;
                    localeCharByteCnt += 2;
                    break;
                }
                default: {
                    this.inSBCS = true;
                    if (!this.inDBCS) break;
                    this.inDBCS = false;
                    this.needSI = true;
                    ++localeCharByteCnt;
                }
            }
        }
        return localeCharByteCnt;
    }

    private void startNewLine(String prefix, boolean isWrap, Character prevChar, Character nextChar, Character dlimChar) throws IOException {
        if (this.localeIsDBCS && this.inDBCS) {
            super.write(31);
            this.needSO = false;
            this.needSI = false;
            this.inDBCS = false;
            this.inSBCS = true;
        }
        super.write(this._eol_bytes);
        this.lineBytesRemain = this.rightByteMargin - this.leftByteMargin + 1;
        int i = 1;
        while (i < this.leftByteMargin) {
            if (isWrap && this.wrappingStyle == WrappingStyle.COBOL && i == ICOBOLModelConstants.INDICATOR_COL && prevChar != null && nextChar != null && prevChar.charValue() != ' ' && nextChar.charValue() != ' ') {
                super.write(this.toBytes('-'));
            } else {
                super.write(this.toBytes(' '));
            }
            ++i;
        }
        if (isWrap && this.wrappingStyle == WrappingStyle.COBOL && this.leftByteMargin < ICOBOLModelConstants.AREA_B_BGN_COL) {
            int padToAreaB = ICOBOLModelConstants.AREA_B_BGN_COL - this.leftByteMargin;
            int i2 = 0;
            while (i2 < padToAreaB) {
                super.write(this.toBytes(' '));
                ++i2;
            }
            this.lineBytesRemain = this.lineBytesRemain - padToAreaB;
            if (dlimChar != null && dlimChar.charValue() != ' ') {
                super.write(this.toBytes(dlimChar.charValue()));
                this.lineBytesRemain = this.lineBytesRemain - 1;
            }
        }
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        String _prefix = prefix.replaceAll(this._eol, "");
        if (WrappingOutputStream.getStringByteCnt(_prefix, this.charset) > this.lineBytesRemain) {
            throw new IllegalArgumentException("|prefix| > lineBytesRemain");
        }
        char[] cArray = _prefix.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char pfxChar = cArray[n2];
            byte[] pfxCharBytes = this.toBytes(pfxChar);
            int pfxCharByteCnt = this.getLocaleCharByteCnt(pfxChar);
            if (this.localeIsDBCS) {
                if (this.needSI) {
                    super.write(31);
                    this.needSI = false;
                } else if (this.needSO) {
                    super.write(30);
                    this.needSO = false;
                }
            }
            super.write(pfxCharBytes);
            this.lineBytesRemain = this.lineBytesRemain - pfxCharByteCnt;
            ++n2;
        }
    }

    private byte[] toBytes(char chr) {
        return String.valueOf(chr).getBytes(this.charset);
    }

    public static byte[] toBytes(char chr, Charset _charset) {
        Charset charset = _charset != null ? _charset : Charset.defaultCharset();
        return String.valueOf(chr).getBytes(charset);
    }

    public static boolean isJVMLocaleDBCS() {
        String language = Locale.getDefault().getLanguage();
        return language.equals(Locale.JAPANESE.getLanguage()) || language.equals(Locale.KOREAN.getLanguage()) || language.equals(Locale.CHINESE.getLanguage()) || language.equals(Locale.SIMPLIFIED_CHINESE.getLanguage()) || language.equals(Locale.TRADITIONAL_CHINESE.getLanguage());
    }

    public static int getStringByteCnt(String text, Charset _charset) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int strByteCnt = 0;
        Charset charset = _charset == null ? Charset.defaultCharset() : _charset;
        boolean strLocaleIsDBCS = WrappingOutputStream.isJVMLocaleDBCS();
        boolean strInSBCS = false;
        boolean strInDBCS = false;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char strChar = cArray[n2];
            byte[] strCharBytes = WrappingOutputStream.toBytes(strChar, charset);
            int strCharByteCnt = strCharBytes.length;
            if (strLocaleIsDBCS) {
                switch (strCharByteCnt % 2) {
                    case 0: {
                        strInDBCS = true;
                        if (!strInSBCS) break;
                        strInSBCS = false;
                        strCharByteCnt += 2;
                        break;
                    }
                    default: {
                        strInSBCS = true;
                        if (!strInDBCS) break;
                        strInDBCS = false;
                        ++strCharByteCnt;
                    }
                }
            }
            strByteCnt += strCharByteCnt;
            ++n2;
        }
        return strByteCnt;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.initial = true;
        this.needSI = false;
        this.inSBCS = false;
        this.needSO = false;
        this.inDBCS = false;
        this.lineBytesRemain = this.rightByteMargin - this.leftByteMargin + 1;
    }

    public synchronized void clear() {
        super.reset();
        this.lineBytesRemain = this.rightByteMargin - this.leftByteMargin + 1;
    }

    public void updateMargins(Integer leftByteMargin, Integer rightByteMargin) {
        this.leftByteMargin = leftByteMargin;
        this.rightByteMargin = rightByteMargin;
        this.lineBytesRemain = Math.min(this.lineBytesRemain, rightByteMargin - leftByteMargin + 1);
    }

    public void updateWrappingStyle(WrappingStyle wrappingStyle) {
        this.wrappingStyle = wrappingStyle;
    }

    public static String hexEncode(String input, Charset charset) {
        byte[] inputBytes = input.getBytes(charset);
        return WrappingOutputStream.hexEncode(inputBytes);
    }

    public static String hexEncode(byte[] input) {
        StringBuffer output = new StringBuffer(input.length * 2);
        byte[] byArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            byte nextByte = byArray[n2];
            output.append(String.format("%02X", nextByte));
            ++n2;
        }
        return output.toString();
    }

    public static byte[] hexDecode(String input) throws Exception {
        if (input.length() % 2 != 0) {
            throw new IllegalArgumentException("WrappingOuputStream#hexDecode: input.length() % 2 != 0.");
        }
        byte[] inputBytes = input.getBytes();
        byte[] output = new byte[input.length() / 2];
        byte[] hexVal = new byte[2];
        int i = 0;
        int o = 0;
        while (i < inputBytes.length) {
            hexVal[0] = inputBytes[i];
            hexVal[1] = inputBytes[i + 1];
            output[o] = (byte)Integer.parseInt(new String(hexVal), 16);
            i += 2;
            ++o;
        }
        return output;
    }

    private boolean isUnbalanced(int count) {
        boolean retVal = false;
        if (count > 0 && count % 2 != 0) {
            retVal = true;
        }
        return retVal;
    }

    public static enum WrappingStyle {
        NORMAL,
        COBOL;

    }
}

