/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.cam.walkers.pli;

import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLIFixedBoundArray;
import com.ibm.ccl.pli.PLIFixedLboundArray;
import com.ibm.ccl.pli.PLIHboundArray;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.PLIVariableBoundArray;
import com.ibm.im.ims.cam.walkers.pli.IPLIModelConstants;
import com.ibm.im.ims.cam.walkers.pli.IPLIModelVisitor;
import com.ibm.im.ims.cam.walkers.pli.PLIModelWalkerException;
import com.ibm.im.ims.cam.walkers.util.FieldPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class PLIModelWalker
implements IPLIModelConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object accept(IPLIModelVisitor visitor, Resource importResource) throws PLIModelWalkerException {
        Object state = visitor.startOfImportResource(importResource, null);
        for (EObject node : importResource.getContents()) {
            if (!(node instanceof PLIElement)) continue;
            this.accept(visitor, (PLIElement)node, state);
        }
        state = visitor.endOfImportResource(importResource, state);
        return state;
    }

    public Object accept(IPLIModelVisitor visitor, Resource importResource, Object state) throws PLIModelWalkerException {
        state = visitor.startOfImportResource(importResource, state);
        for (EObject node : importResource.getContents()) {
            if (!(node instanceof PLIElement)) continue;
            this.accept(visitor, (PLIElement)node, state);
        }
        state = visitor.endOfImportResource(importResource, state);
        return state;
    }

    public void accept(IPLIModelVisitor visitor, PLIElement field) throws PLIModelWalkerException {
        this.accept(visitor, field, null);
    }

    public Object accept(IPLIModelVisitor visitor, PLIElement field, Object state) throws PLIModelWalkerException {
        Stack<PLIElement> fieldParents = new Stack<PLIElement>();
        FieldPath fieldPath = new FieldPath();
        state = this.walkField(field, visitor, fieldPath, fieldParents, state);
        state = this.emptyFieldParentStack(visitor, fieldPath, fieldParents, state);
        return state;
    }

    private Object walkField(PLIElement field, IPLIModelVisitor visitor, FieldPath fieldPath, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        while (!fieldParents.isEmpty() && !PLIModelWalker.getImmediateChildren(fieldParents.peek()).contains(field)) {
            PLIElement parent = fieldParents.pop();
            state = PLIModelWalker.isArray(parent) ? visitor.endOfCompositeArrayField(parent, (PLIComposedType)parent.getSharedType(), fieldPath, PLIModelWalker.getImmediateChildren(parent), fieldParents, state) : visitor.endOfCompositeField(parent, (PLIComposedType)parent.getSharedType(), fieldPath, PLIModelWalker.getImmediateChildren(parent), fieldParents, state);
            fieldPath.pop();
        }
        if (PLIModelWalker.isCompositeField(field)) {
            if (PLIModelWalker.isArray(field)) {
                fieldPath.push(field.getName());
                state = visitor.startOfCompositeArrayField(field, (PLIComposedType)field.getSharedType(), fieldPath, PLIModelWalker.getImmediateChildren(field), fieldParents, state);
                fieldParents.push(field);
                for (PLIElement cField : PLIModelWalker.getImmediateChildren(field)) {
                    state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                }
            } else {
                fieldPath.push(field.getName());
                state = visitor.startOfCompositeField(field, (PLIComposedType)field.getSharedType(), fieldPath, PLIModelWalker.getImmediateChildren(field), fieldParents, state);
                fieldParents.push(field);
                for (PLIElement cField : PLIModelWalker.getImmediateChildren(field)) {
                    state = this.walkField(cField, visitor, fieldPath, fieldParents, state);
                }
            }
        } else {
            fieldPath.push(field.getName());
            state = PLIModelWalker.isArray(field) ? visitor.leafArrayField(field, (PLISimpleType)field.getSharedType(), fieldPath, fieldParents, state) : visitor.leafField(field, (PLISimpleType)field.getSharedType(), fieldPath, fieldParents, state);
            fieldPath.pop();
        }
        return state;
    }

    private Object emptyFieldParentStack(IPLIModelVisitor visitor, FieldPath fieldPath, Stack<PLIElement> fieldParents, Object state) throws PLIModelWalkerException {
        while (!fieldParents.isEmpty()) {
            PLIElement parent = fieldParents.pop();
            state = PLIModelWalker.isArray(parent) ? visitor.endOfCompositeArrayField(parent, (PLIComposedType)parent.getSharedType(), fieldPath, PLIModelWalker.getImmediateChildren(parent), fieldParents, state) : visitor.endOfCompositeField(parent, (PLIComposedType)parent.getSharedType(), fieldPath, PLIModelWalker.getImmediateChildren(parent), fieldParents, state);
            fieldPath.pop();
        }
        return state;
    }

    public static boolean isArray(PLIElement field) {
        if (PLIModelWalker.isFixedLengthArrayField(field)) {
            return true;
        }
        return PLIModelWalker.isVariableLengthArray(field);
    }

    public static boolean isCompositeField(PLIElement field) {
        return field.getSharedType() instanceof PLIComposedType;
    }

    public static int getMinOccursAsInt(PLIElement field) {
        int minOccurs = 0;
        Object minOccursObj = PLIModelWalker.getMinOccursObject(field);
        if (minOccursObj instanceof Integer) {
            minOccurs = (Integer)minOccursObj;
        } else if (minOccursObj instanceof String) {
            try {
                minOccurs = Integer.parseInt((String)minOccursObj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return minOccurs;
    }

    public static int getMaxOccursAsInt(PLIElement field) {
        int maxOccurs = 1;
        Object maxOccursObj = PLIModelWalker.getMaxOccursObject(field);
        if (maxOccursObj instanceof Integer) {
            maxOccurs = (Integer)maxOccursObj;
        } else if (maxOccursObj instanceof String) {
            try {
                maxOccurs = Integer.parseInt((String)maxOccursObj);
            }
            catch (NumberFormatException numberFormatException) {
                maxOccurs = -1;
            }
        }
        return maxOccurs;
    }

    public static boolean isFixedLengthArrayField(PLIElement field) {
        int maxOccurs;
        int minOccurs = PLIModelWalker.getMinOccursAsInt(field);
        return minOccurs == (maxOccurs = PLIModelWalker.getMaxOccursAsInt(field)) && maxOccurs > 1;
    }

    public static boolean isVariableLengthArray(PLIElement field) {
        int maxOccurs;
        int minOccurs = PLIModelWalker.getMinOccursAsInt(field);
        return minOccurs != (maxOccurs = PLIModelWalker.getMaxOccursAsInt(field)) && (maxOccurs > 1 || maxOccurs == -1);
    }

    public static Object getMinOccursObject(PLIElement field) {
        Object minOccurs = 0;
        EList array = field.getArray();
        if (array == null || array.isEmpty()) {
            return minOccurs;
        }
        Object arrayType = array.get(0);
        if (arrayType instanceof PLIFixedBoundArray) {
            minOccurs = ((PLIFixedBoundArray)arrayType).getLBound();
        } else if (arrayType instanceof PLIVariableBoundArray) {
            minOccurs = ((PLIVariableBoundArray)arrayType).getLboundToAllocate();
        } else if (!(arrayType instanceof PLIHboundArray) && arrayType instanceof PLIFixedLboundArray) {
            minOccurs = ((PLIFixedLboundArray)arrayType).getLBound();
        }
        return minOccurs;
    }

    public static Object getMaxOccursObject(PLIElement field) {
        Object maxOccurs = 1;
        EList array = field.getArray();
        if (array == null || array.isEmpty()) {
            return maxOccurs;
        }
        Object arrayType = array.get(0);
        if (arrayType instanceof PLIFixedBoundArray) {
            maxOccurs = ((PLIFixedBoundArray)arrayType).getUBound().toString();
        } else if (arrayType instanceof PLIVariableBoundArray) {
            PLIElement referredTo = ((PLIVariableBoundArray)arrayType).getReferredTo();
            maxOccurs = referredTo != null ? referredTo.getName() : ((PLIVariableBoundArray)arrayType).getHboundToAllocate();
        } else if (!(arrayType instanceof PLIHboundArray) && arrayType instanceof PLIFixedLboundArray) {
            PLIElement referredTo = ((PLIFixedLboundArray)arrayType).getReferredTo();
            maxOccurs = referredTo != null ? referredTo.getName() : ((PLIFixedLboundArray)arrayType).getUBoundtoAllocate();
        }
        return maxOccurs;
    }

    public static List<PLIElement> getImmediateChildren(PLIElement element) {
        ArrayList<PLIElement> children = new ArrayList<PLIElement>();
        PLIClassifier type = element.getSharedType();
        if (type instanceof PLIComposedType) {
            PLIComposedType composedType = (PLIComposedType)element.getSharedType();
            for (Object content : composedType.eContents()) {
                if (!(content instanceof PLIElement)) continue;
                children.add((PLIElement)content);
            }
        }
        return children;
    }

    public static boolean isFillerField(PLIElement field) {
        return field.getName().startsWith("FILL_");
    }

    public static String getFieldName(PLIElement field) {
        if (PLIModelWalker.isFillerField(field)) {
            return "*";
        }
        return field.getName();
    }

    public static String generateFieldQualification(PLIElement field) {
        PLIElement childElement = field;
        PLIElement parentElement = null;
        StringBuilder retVal = new StringBuilder(PLIModelWalker.getFieldName(field));
        while (childElement.getGroup() != null) {
            parentElement = (PLIElement)childElement.getGroup().getTypedElement().get(0);
            if (!PLIModelWalker.isFillerField(field)) {
                retVal.insert(0, PLIModelWalker.getFieldName(parentElement) + ".");
            }
            childElement = parentElement;
        }
        return retVal.toString();
    }
}

