/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.cam.walkers.cobol.util;

import com.ibm.im.ims.cam.walkers.cobol.ICOBOLModelConstants;
import com.ibm.im.ims.cam.walkers.util.IValueClauseBuilder;
import com.ibm.im.ims.cam.walkers.util.PictureSize;

public class COBOLStringDeclaration
implements ICOBOLModelConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String Z1 = "0";
    public static final String Z2 = "00";
    public static final String Z3 = "000";
    public static final String Z4 = "0000";

    public static String create(String text, int level, int charCnt, boolean unicode, boolean dbcs, boolean hex) throws Exception {
        return COBOLStringDeclaration.create(text, level, charCnt, unicode, dbcs, hex, null, null);
    }

    public static String create(String text, int level, int charCnt, boolean unicode, boolean dbcs, boolean hex, PictureSize picSize) throws Exception {
        return COBOLStringDeclaration.create(text, level, charCnt, unicode, dbcs, hex, null, picSize);
    }

    public static String create(String text, int level, int charCnt, boolean unicode, boolean dbcs, boolean hex, IValueClauseBuilder vb, PictureSize picSize) throws Exception {
        int padding;
        String str = hex ? COBOLStringDeclaration.convertToHex(text, unicode) : new String(COBOLStringDeclaration.escapeDelimiter(text));
        StringBuffer dcl = new StringBuffer();
        while (str.length() >= 48) {
            int shiftRt = hex ? 0 : (str.charAt(47) == '\'' && str.charAt(46) != '\'' ? 1 : 0);
            String subStr = str.substring(0, 48 + shiftRt);
            int sizeAdj = COBOLStringDeclaration.countDelimiterSizeAdjust(subStr);
            int size = 48 + shiftRt - sizeAdj;
            if (vb != null) {
                dcl.append(vb.createValueDecl(level, size, subStr, unicode, dbcs, hex));
            } else {
                dcl.append(COBOLStringDeclaration.createValueDecl(level, size, subStr, unicode, dbcs, hex));
            }
            str = str.substring(48 + shiftRt);
            if (picSize == null) continue;
            picSize.addTo(COBOLStringDeclaration.getCntOut(size, unicode, dbcs, hex));
        }
        if (str.length() > 0) {
            int sizeAdj = COBOLStringDeclaration.countDelimiterSizeAdjust(str);
            if (vb != null) {
                dcl.append(vb.createValueDecl(level, str.length() - sizeAdj, str, unicode, dbcs, hex));
            } else {
                dcl.append(COBOLStringDeclaration.createValueDecl(level, str.length() - sizeAdj, str, unicode, dbcs, hex));
            }
            if (picSize != null) {
                picSize.addTo(COBOLStringDeclaration.getCntOut(str.length() - sizeAdj, unicode, dbcs, hex));
            }
        }
        if ((padding = charCnt - text.length()) > 0) {
            if (vb != null) {
                dcl.append(vb.createValueDecl(level, padding, null, unicode, dbcs, false));
            } else {
                dcl.append(COBOLStringDeclaration.createValueDecl(level, padding, null, unicode, dbcs, false));
            }
            if (picSize != null) {
                picSize.addTo(COBOLStringDeclaration.getCntOut(padding, unicode, dbcs, false));
            }
        }
        return dcl.toString();
    }

    private static int getCntOut(int size, boolean unicode, boolean dbcs, boolean hex) {
        return unicode ? (hex ? size / 4 : size) : (hex ? size / 2 : (dbcs ? size * 2 + 2 : size));
    }

    private static String createValueDecl(int level, int size, String value, boolean unicode, boolean dbcs, boolean hex) {
        int charCnt = COBOLStringDeclaration.getCntOut(size, unicode, dbcs, hex);
        StringBuffer dcl = new StringBuffer();
        dcl.append("       " + level + " PIC " + (unicode ? "N" : "X") + "(" + charCnt + ") USAGE " + (unicode ? "NATIONAL" : "DISPLAY") + EOL);
        if (value != null) {
            String litType = unicode ? (hex ? "NX" : "N") : (hex ? "X" : "");
            dcl.append("           VALUE " + litType + "'" + value + "'." + EOL);
        } else {
            dcl.append("           VALUE SPACES." + EOL);
        }
        return dcl.toString();
    }

    public static String convertToHex(String text, boolean unicode) {
        int hxChLen = unicode ? 4 : 2;
        StringBuffer hexText = new StringBuffer();
        char[] textCh = text.toCharArray();
        int nx = 0;
        while (nx < textCh.length) {
            Object hexChar = Integer.toHexString(textCh[nx]).toUpperCase();
            switch (hxChLen - ((String)hexChar).length()) {
                case 1: {
                    hexChar = Z1 + (String)hexChar;
                    break;
                }
                case 2: {
                    hexChar = Z2 + (String)hexChar;
                    break;
                }
                case 3: {
                    hexChar = Z3 + (String)hexChar;
                    break;
                }
                case 4: {
                    hexChar = Z4 + (String)hexChar;
                }
            }
            hexText.append((String)hexChar);
            ++nx;
        }
        return hexText.toString();
    }

    private static int countDelimiterSizeAdjust(String str) {
        int result = 0;
        if (str.indexOf(39) != -1) {
            int nxtDelim = str.indexOf(39);
            while (nxtDelim != -1) {
                ++result;
                str = str.substring(nxtDelim + 1);
                nxtDelim = str.indexOf(39);
            }
        }
        return result / 2;
    }

    private static String escapeDelimiter(String str) {
        String result = str;
        if (str.indexOf(39) != -1) {
            StringBuffer sb = new StringBuffer();
            char[] strch = str.toCharArray();
            int ndx = 0;
            while (ndx < strch.length) {
                switch (strch[ndx]) {
                    case '\'': {
                        sb.append('\'');
                        sb.append('\'');
                        break;
                    }
                    default: {
                        sb.append(strch[ndx]);
                    }
                }
                ++ndx;
            }
            result = sb.toString();
        }
        return result;
    }
}

