/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sql.util;

import com.ibm.ims.datatools.modelbase.sql.query.helper.DataTypeHelper;
import com.ibm.ims.datatools.sqltools.sql.reference.IDatatype;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLUtil {
    public static final int NO_QUOTES = 0;
    public static final int MATCHING_SINGLE_QUOTES = 1;
    public static final int MATCHING_DOUBLE_QUOTES = 2;
    public static final int NO_MATCHING_QUOTES = 3;
    public static final Pattern ID_PATTERN = Pattern.compile("((\\Q[\\E([^\"]|(\"\"))+\\Q]\\E|[^\\s\"\\Q.\\E]+|\"([^\"]|(\"\"))+\")\\Q.\\E?)");
    public static final Pattern STRING_PATTERN = Pattern.compile("(([^\\s'\"]+)|('([^']|(''))+')|(\"([^\"]|(\"\"))+\"))");
    public static int MAX_NAME_LENGTH_FOR_MESSAGE_DIALOGS = 30;
    private static final char[] HexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String[] _allCurrencySymbols;

    public static String[] parseDatabaseObject(String objstr) {
        ArrayList<String> ids = new ArrayList<String>();
        Matcher m = ID_PATTERN.matcher(objstr);
        while (m.find()) {
            ids.add(0, SQLUtil.unquote(m.group(2)));
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static int findQuotes(String content) {
        if (content == null) {
            return 0;
        }
        if (content.indexOf(39) < 0 && content.indexOf(34) < 0) {
            return 0;
        }
        if (content.indexOf("'") == 0 && content.lastIndexOf("'") == content.length() - 1) {
            return 1;
        }
        if (content.indexOf("\"") == 0 && content.lastIndexOf("\"") == content.length() - 1) {
            return 2;
        }
        return 3;
    }

    public static String quote(String in, char quoteChar) {
        StringBuffer buffer = new StringBuffer(in.length() + 8);
        buffer.append(quoteChar);
        int len = in.length();
        int i = 0;
        while (i < len) {
            char c = in.charAt(i);
            if (c == quoteChar) {
                buffer.append(c);
            }
            buffer.append(c);
            ++i;
        }
        buffer.append(quoteChar);
        return buffer.toString();
    }

    public static String quote(String content, String quoteMark) {
        return quoteMark + content.replaceAll(quoteMark, quoteMark + quoteMark) + quoteMark;
    }

    public static String unquote(String quoted) {
        String content = quoted;
        if (quoted.indexOf("'") == 0 && quoted.lastIndexOf("'") == quoted.length() - 1) {
            content = quoted.substring(1, quoted.length() - 1).replaceAll("''", "'");
        } else if (quoted.indexOf("\"") == 0 && quoted.lastIndexOf("\"") == quoted.length() - 1) {
            content = quoted.substring(1, quoted.length() - 1).replaceAll("\"\"", "\"");
        }
        return content;
    }

    public static String describeSQL(String sql, int length) {
        sql = sql.trim().replaceAll(System.getProperty("line.separator"), " ");
        if ((sql = sql.replaceAll("\t", " ")).length() <= length) {
            return sql;
        }
        return sql.substring(0, length - 3).concat("...");
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        sb.append("0x");
        int i = 0;
        while (i < bytes.length) {
            sb.append(HexChars[bytes[i] >> 4 & 0xF]);
            sb.append(HexChars[bytes[i] & 0xF]);
            ++i;
        }
        return new String(sb);
    }

    public static String[] splitDotStr(String input) {
        int i = 0;
        int count = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '.') {
                ++count;
            }
            ++i;
        }
        String[] tokens = new String[count + 1];
        i = 0;
        int start = 0;
        int j = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '.') {
                tokens[j] = start < i ? input.substring(start, i) : null;
                start = i + 1;
                ++j;
            }
            ++i;
        }
        tokens[j] = start <= i - 1 ? input.substring(start, i) : null;
        return tokens;
    }

    public static synchronized String[] getAvaiableCurrencySymbols() {
        if (_allCurrencySymbols == null) {
            Locale[] locals = Locale.getAvailableLocales();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < locals.length) {
                list.add(NumberFormat.getInstance(locals[i]).getCurrency().getSymbol(locals[i]));
                ++i;
            }
            _allCurrencySymbols = list.toArray(new String[list.size()]);
            return _allCurrencySymbols;
        }
        return _allCurrencySymbols;
    }

    public static boolean equalsIgnoreQuote(String s1, String s2, boolean caseSensitive) {
        if (caseSensitive) {
            boolean e = s1.equals(s2);
            if (!e) {
                s1 = SQLUtil.unquote(s1);
                s2 = SQLUtil.unquote(s2);
                e = s1.equals(s2);
            }
            return e;
        }
        boolean e = s1.equalsIgnoreCase(s2);
        if (!e) {
            if (s1.equals(SQLUtil.unquote(s2)) || s2.equals(SQLUtil.unquote(s1))) {
                return true;
            }
            s1 = SQLUtil.unquote(s1);
            s2 = SQLUtil.unquote(s2);
            e = s1.equalsIgnoreCase(s2);
        }
        return e;
    }

    public static boolean isBinaryType(IDatatype datatype) {
        if (datatype.isUDT()) {
            return SQLUtil.isBinaryType(datatype.getBaseType().toString());
        }
        return SQLUtil.isBinaryType(datatype.toString());
    }

    public static boolean isBinaryType(String datatype) {
        int _sqlDataType;
        String strType = datatype;
        int position = strType.indexOf(40);
        if (position > 0) {
            strType = strType.substring(0, position);
        }
        return (_sqlDataType = SQLUtil.convert2SQLType(strType)) == -2 || _sqlDataType == -4 || _sqlDataType == -3;
    }

    public static boolean isNumericType(String datatype) {
        int _sqlDataType;
        int position = datatype.indexOf(40);
        if (position > 0) {
            datatype = datatype.substring(0, position);
        }
        return (_sqlDataType = SQLUtil.convert2SQLType(datatype)) == -5 || _sqlDataType == 3 || _sqlDataType == 8 || _sqlDataType == 6 || _sqlDataType == 4 || _sqlDataType == 2 || _sqlDataType == 7 || _sqlDataType == 5 || _sqlDataType == -6;
    }

    public static int convert2SQLType(String datatype) {
        return DataTypeHelper.getJDBCTypeForNamedType((String)datatype);
    }

    public static boolean isNumericType(int datatype) {
        return datatype == -5 || datatype == 3 || datatype == 8 || datatype == 6 || datatype == 4 || datatype == 2 || datatype == 7 || datatype == 5 || datatype == -6;
    }

    public static boolean isNumericType(IDatatype datatype) {
        if (datatype.isUDT()) {
            return SQLUtil.isNumericType(datatype.getBaseType().toString());
        }
        return SQLUtil.isNumericType(datatype.toString());
    }

    public static boolean isStringType(String datatype) {
        String strType = datatype;
        int position = strType.indexOf(40);
        if (position > 0) {
            strType = strType.substring(0, position);
        }
        int _sqlDataType = SQLUtil.convert2SQLType(strType);
        return SQLUtil.isStringType(_sqlDataType);
    }

    public static boolean isStringType(IDatatype datatype) {
        if (datatype.isUDT()) {
            return SQLUtil.isStringType(datatype.getBaseType().toString());
        }
        return SQLUtil.isStringType(datatype.toString());
    }

    public static boolean isStringType(int sqlType) {
        return sqlType == 1 || sqlType == 12 || sqlType == -1 || sqlType == 91 || sqlType == 92 || sqlType == 93;
    }
}

