/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.common.writer;

import com.ibm.lang.common.writer.NamingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public class XSD2EMFConverter {
    public XSDEcoreBuilder convertXSDToEMF(IFile schemaFile) {
        XSDEcoreBuilder builder = new XSDEcoreBuilder();
        if (!schemaFile.getFileExtension().equals("xsd") && !schemaFile.getFileExtension().equals("wsdl")) {
            return builder;
        }
        URI xsdURI = URI.createFileURI((String)schemaFile.getFullPath().toOSString());
        builder.generate(xsdURI);
        this.nameMangleEMFModel(builder);
        return builder;
    }

    public XSDEcoreBuilder convertXSDToEMF(XSDSchema schema) {
        XSDEcoreBuilder builder = new XSDEcoreBuilder();
        builder.generate(schema);
        this.nameMangleEMFModel(builder);
        return builder;
    }

    public Collection<EPackage> nameMangleEMFModel(XSDEcoreBuilder builder) {
        Map nsToPkgMap = builder.getTargetNamespaceToEPackageMap();
        ArrayList<EPackage> results = new ArrayList<EPackage>();
        Set nsPkgSet = nsToPkgMap.entrySet();
        for (Map.Entry element : nsPkgSet) {
            String ns = (String)element.getKey();
            EPackage pkg = (EPackage)element.getValue();
            String renamedPkg = NamingUtils.getPackageNameFromNamespaceURI(ns);
            pkg.setName(renamedPkg);
            results.add(pkg);
        }
        for (EPackage pkg : results) {
            for (EClassifier classifier : pkg.getEClassifiers()) {
                EClass aClass;
                ExtendedMetaData emd;
                String classXMLName;
                if (!(classifier instanceof EClass) || (classXMLName = (emd = ExtendedMetaData.INSTANCE).getName((EClassifier)(aClass = (EClass)classifier))) == null || "".equals(classXMLName)) continue;
                String renamedClassName = NamingUtils.getJavaClassNameFromXMLName(classXMLName);
                aClass.setName(renamedClassName);
                for (EStructuralFeature sf : aClass.getEAllStructuralFeatures()) {
                    String sfXMLName = ExtendedMetaData.INSTANCE.getName(sf);
                    String renamedFeatureName = NamingUtils.getJavaNameFromXMLName(sfXMLName);
                    sf.setName(renamedFeatureName);
                }
            }
        }
        return results;
    }

    public void printEMFModel(XSDEcoreBuilder builder) {
        Map nsToPkgMap = builder.getTargetNamespaceToEPackageMap();
        ArrayList<EPackage> results = new ArrayList<EPackage>();
        for (Map.Entry element : nsToPkgMap.entrySet()) {
            String ns = (String)element.getKey();
            EPackage pkg = (EPackage)element.getValue();
            System.out.println("Schema Namespace: " + ns);
            System.out.println("PackageName: " + pkg.getName());
            System.out.println();
            results.add(pkg);
        }
        for (EPackage pkg : results) {
            for (EClassifier classifier : pkg.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                EClass aClass = (EClass)classifier;
                String className = aClass.getName();
                System.out.println("Class Name: " + className);
                System.out.println();
                for (EStructuralFeature sf : aClass.getEAllStructuralFeatures()) {
                    String name = sf.getName();
                    System.out.println("Feature Name: " + name);
                    EClassifier cf = sf.getEType();
                    if (cf instanceof EDataType) {
                        EDataType dt = (EDataType)cf;
                        System.out.println("Data Type Name: " + dt.getName());
                        System.out.println("Instance Class Name: " + dt.getInstanceClassName());
                        continue;
                    }
                    if (!(cf instanceof EClass)) continue;
                    System.out.println("Data Type Name: " + cf.getName());
                    System.out.println("Instance Class Name: " + cf.getInstanceClassName());
                }
                System.out.println();
            }
        }
        System.out.println();
    }
}

