/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.common.writer;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.j2ca.spi.util.ProjectUtils;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.lang.common.writer.Level88;
import com.ibm.lang.common.writer.LogFacility;
import com.ibm.lang.common.writer.MessageResource;
import com.ibm.lang.common.writer.WriterPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CodegenUtil
extends ProjectUtils {
    public static String getElementText(Element element) {
        String result = null;
        if (!element.hasChildNodes()) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        Node currNode = element.getFirstChild();
        while (currNode != null) {
            Text text;
            if (currNode.getNodeType() == 3) {
                text = (Text)currNode;
                sb.append(text.getNodeValue());
            } else if (currNode.getNodeType() == 4) {
                text = (CDATASection)currNode;
                sb.append(text.getNodeValue());
            }
            currNode = currNode.getNextSibling();
        }
        result = sb.toString().trim();
        return result;
    }

    public static String getUppercaseName(String name) {
        if (name == null) {
            return "";
        }
        if (name.length() == 0) {
            return name;
        }
        int char32 = UTF16.charAt((String)name, (int)0);
        if (UCharacter.isUpperCase((int)char32)) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        char32 = UCharacter.toUpperCase((int)char32);
        UTF16.append((StringBuffer)sb, (int)char32);
        sb.append(name.substring(UTF16.getCharCount((int)char32)));
        return sb.toString();
    }

    public static String getLowercaseName(String name) {
        if (name == null) {
            return "";
        }
        if (name.length() == 0) {
            return name;
        }
        int char32 = UTF16.charAt((String)name, (int)0);
        if (UCharacter.isLowerCase((int)char32)) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        char32 = UCharacter.toLowerCase((int)char32);
        UTF16.append((StringBuffer)sb, (int)char32);
        sb.append(name.substring(UTF16.getCharCount((int)char32)));
        return sb.toString();
    }

    public static String getParameterName(String name) {
        IStatus status;
        if (name == null) {
            return "";
        }
        if (name.length() == 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        int char32 = UTF16.charAt((String)name, (int)0);
        if (!UCharacter.isLowerCase((int)char32)) {
            char32 = UCharacter.toLowerCase((int)char32);
            int i = 0;
            while (i < UTF16.getCharCount((int)char32)) {
                sb.deleteCharAt(0);
                ++i;
            }
            UTF16.insert((StringBuffer)sb, (int)0, (int)char32);
        }
        if (!UCharacter.isJavaIdentifierStart((int)char32)) {
            sb.insert(0, '_');
        }
        if (sb.length() > 1) {
            StringBuffer sb2 = new StringBuffer();
            int offset16 = 0;
            while (offset16 < sb.length()) {
                int charValue = UTF16.charAt((StringBuffer)sb, (int)offset16);
                if (UCharacter.isJavaIdentifierPart((int)charValue)) {
                    UTF16.append((StringBuffer)sb2, (int)charValue);
                }
                offset16 += UTF16.getCharCount((int)charValue);
            }
            sb = sb2;
        }
        if (sb.length() == 0) {
            sb.append("_");
        }
        if (!(status = JavaConventions.validateTypeVariableName((String)sb.toString(), (String)"1.3", (String)"1.3")).isOK()) {
            sb.insert(0, '_');
        }
        return sb.toString();
    }

    public static String getClassName(ICompilationUnit compilationUnit) {
        String className = compilationUnit.getElementName();
        int index = className.lastIndexOf(".java");
        if (index != -1) {
            className = className.substring(0, index);
        }
        return className;
    }

    public static String getPackageName(ICompilationUnit compilationUnit) {
        String packageName = "";
        IJavaElement parent = compilationUnit.getParent();
        if (parent instanceof IPackageFragment) {
            packageName = ((IPackageFragment)parent).getElementName();
        }
        return packageName;
    }

    public static Level88 getLevel88Text(Element element) {
        Level88 level88 = new Level88();
        String level88Text = CodegenUtil.getElementText(element);
        if (level88Text == null || level88Text.equals("")) {
            return level88;
        }
        int valueIndex = level88Text.indexOf("value");
        if (valueIndex == -1) {
            return level88;
        }
        boolean found = false;
        while (!found && valueIndex != -1) {
            BreakIterator iter = BreakIterator.getCharacterInstance();
            iter.setText(level88Text);
            iter.preceding(valueIndex);
            int char32 = UTF16.charAt((String)level88Text, (int)iter.current());
            if (UCharacter.isWhitespace((int)char32)) {
                found = true;
                continue;
            }
            valueIndex = level88Text.indexOf("value", valueIndex + 1);
        }
        if (!found) {
            return level88;
        }
        String name = level88Text.substring(0, valueIndex - 1);
        level88.level88Name = name = name.trim();
        try {
            int nextIndex = valueIndex + "value".length() + 1;
            if (level88Text.charAt(nextIndex - 1) == '\n') {
                --nextIndex;
            }
            level88Text = level88Text.substring(nextIndex);
        }
        catch (Exception exception) {
            level88Text = " ";
        }
        int newLineIndex = level88Text.indexOf(10);
        while (newLineIndex != -1) {
            char[] level88Chars = level88Text.toCharArray();
            level88Chars[newLineIndex] = 32;
            int j = newLineIndex;
            int char32 = UTF16.charAt((String)level88Text, (int)j);
            while (j < level88Chars.length && UCharacter.isWhitespace((int)char32)) {
                if ((j += UTF16.getCharCount((int)char32)) >= level88Text.length()) continue;
                char32 = UTF16.charAt((String)level88Text, (int)j);
            }
            if (j != level88Chars.length && level88Chars[j] == ',') {
                --j;
            }
            String head = level88Text.substring(0, newLineIndex);
            String tail = level88Text.substring(j);
            level88Text = "".equals(tail) ? head : ("".equals(head) ? tail : String.valueOf(head) + " " + tail);
            newLineIndex = level88Text.indexOf(10);
        }
        level88.level88Value = level88Text;
        return level88;
    }

    public static void modifyJavaSource(ICompilationUnit cu, ASTVisitor visitor) throws JavaModelException, BadLocationException {
        boolean workingCopyPassed = cu.isWorkingCopy();
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!workingCopyPassed) {
            cu = cu.getWorkingCopy((IProgressMonitor)monitor);
        }
        Document doc = new Document(cu.getSource());
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(doc.get().toCharArray());
        CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
        astCU.recordModifications();
        astCU.accept(visitor);
        TextEdit te = astCU.rewrite((IDocument)doc, null);
        te.apply((IDocument)doc);
        Map options = cu.getJavaProject().getOptions(true);
        options.put("org.eclipse.jdt.core.formatter.comment.format_javadoc_comments", "true");
        options.put("org.eclipse.jdt.core.formatter.comment.format_header", "false");
        CodeFormatter cf = ToolFactory.createCodeFormatter((Map)options);
        TextEdit cfte = cf.format(8, doc.get(), 0, doc.get().length(), 0, null);
        if (cfte != null) {
            cfte.apply((IDocument)doc);
        }
        if (!cu.getSource().equals(doc.get())) {
            cu.getBuffer().setContents(doc.get());
        }
        if (!workingCopyPassed) {
            cu.reconcile(0, false, null, (IProgressMonitor)monitor);
            cu.commitWorkingCopy(true, (IProgressMonitor)monitor);
            cu.save((IProgressMonitor)monitor, true);
            cu.discardWorkingCopy();
        }
    }

    public static ICompilationUnit createCompilationUnit(IJavaProject project, String packageName, String className, IEnvironment environment) throws BaseException {
        if (project == null || packageName == null || className == null) {
            return null;
        }
        ICompilationUnit unit = null;
        try {
            IPackageFragmentRoot root = ProjectUtils.getSourcePackage((IJavaProject)project, (IEnvironment)environment);
            IPackageFragment pkgFragment = root.createPackageFragment(packageName, false, null);
            unit = pkgFragment.createCompilationUnit(String.valueOf(className) + ".java", new String(), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException exc) {
            String qualifiedName = String.valueOf(packageName) + "." + className;
            String message = NLS.bind((String)MessageResource.ERR_CREATING_COMP_UNIT, (Object)qualifiedName, (Object)project.getProject().getName());
            Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
        return unit;
    }

    public static String generate(ICompilationUnit compilationUnit, Object emitterInstance, Object templateArgument, IEnvironment environment) throws BaseException {
        if (compilationUnit == null) {
            return CodegenUtil.generate(null, emitterInstance, templateArgument, environment);
        }
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(compilationUnit.getPath());
        return CodegenUtil.generate(targetFile, emitterInstance, templateArgument, environment);
    }

    public static String generate(IFile targetFile, Object emitterInstance, Object templateArgument, IEnvironment environment) throws BaseException {
        try {
            JETEmitter emitter = null;
            IProgressMonitor progressMonitor = environment.getProgressMonitor();
            progressMonitor.subTask(NLS.bind((String)MessageResource.DISP_PROG_MSG_GENERATING_FILE, (Object)(targetFile == null ? "" : targetFile.getLocation().toOSString())));
            if (emitter == null) {
                emitter = new JETEmitter(null);
                if (emitterInstance != null) {
                    try {
                        emitter.setMethod(emitterInstance.getClass().getDeclaredMethod("generate", Object.class));
                    }
                    catch (NoSuchMethodException exc) {
                        String message = NLS.bind((String)MessageResource.ERR_CANNOT_FIND_GENERATE_METHOD, (Object)emitterInstance.getClass().getName());
                        Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, (Throwable)exc);
                        LogFacility.logErrorMessage((IStatus)status);
                        throw new BaseException((IStatus)status);
                    }
                }
            }
            String emitterResult = emitter.generate(progressMonitor, new Object[]{templateArgument});
            if (targetFile == null) {
                return emitterResult;
            }
            String charset = targetFile.getProject().getDefaultCharset();
            byte[] bytes = null;
            try {
                bytes = emitterResult.getBytes(charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = emitterResult.getBytes();
            }
            ByteArrayInputStream contents = new ByteArrayInputStream(bytes);
            if (targetFile.exists()) {
                targetFile.setContents((InputStream)contents, true, true, progressMonitor);
            } else {
                IPath path = targetFile.getProjectRelativePath();
                IProject project = targetFile.getProject();
                int i = 1;
                int n = path.segmentCount();
                while (i < n) {
                    IFolder folder = project.getFolder(path.uptoSegment(i));
                    if (!folder.exists()) {
                        folder.create(true, true, progressMonitor);
                    }
                    ++i;
                }
                targetFile.create((InputStream)contents, true, progressMonitor);
            }
            return emitterResult;
        }
        catch (Exception exc) {
            Throwable targetException = exc;
            if (targetException instanceof InvocationTargetException) {
                targetException = ((InvocationTargetException)targetException).getTargetException();
            }
            String message = NLS.bind((String)MessageResource.ERR_ERROR_GENERATING_FILE, (Object)targetFile.getLocation().toOSString());
            Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static NodeList parseXMLFragment(String appInfoString, IEnvironment environment) throws BaseException {
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentRoot>\n";
        String xmlFooter = "</DocumentRoot>";
        appInfoString = appInfoString.replaceAll("&#xD;", "");
        appInfoString = appInfoString.replaceAll("&#xA;", "\n");
        String xmlDoc = String.valueOf(xmlHeader) + appInfoString + xmlFooter;
        NodeList nodes = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlDoc.getBytes("UTF-8"));
            org.w3c.dom.Document doc = docBuilder.parse(is);
            Element rootElement = doc.getDocumentElement();
            nodes = rootElement.getChildNodes();
        }
        catch (Exception exc) {
            String message = NLS.bind((String)MessageResource.ERR_PARSING_XML_FRAGMENT, (Object)xmlDoc);
            Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
        return nodes;
    }
}

