/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.codegen;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.util.bidi.BidiFlag;
import com.ibm.etools.marshall.util.bidi.BidiFlagSet;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;
import java.util.Vector;

public class CodeGenStringUtils {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    private static String getStringJustification(int justification) {
        StringBuffer sb = new StringBuffer("MarshallStringUtils.STRING_JUSTIFICATION_");
        switch (justification) {
            case 0: {
                sb.append("LEFT");
                break;
            }
            case 1: {
                sb.append("RIGHT");
                break;
            }
            case 2: {
                sb.append("CENTER");
            }
        }
        return sb.toString();
    }

    private static String generateBidiTransformMethodParms(String valueName, BidiFlagSet bidiFS) {
        StringBuffer sb = new StringBuffer("(" + valueName);
        sb.append(", ");
        BidiFlag bf = bidiFS.getType();
        sb.append("com.ibm.etools.marshall.util.bidi.BidiFlag.TYPE_");
        if (bf.equals(BidiFlag.TYPE_IMPLICIT)) {
            sb.append("IMPLICIT");
        } else {
            sb.append("VISUAL");
        }
        sb.append(", ");
        bf = bidiFS.getOrientation();
        sb.append("com.ibm.etools.marshall.util.bidi.BidiFlag.ORIENTATION_");
        if (bf.equals(BidiFlag.ORIENTATION_RTL)) {
            sb.append("RTL");
        } else if (bf.equals(BidiFlag.ORIENTATION_CONTEXT_LTR)) {
            sb.append("CONTEXT_LTR");
        } else if (bf.equals(BidiFlag.ORIENTATION_CONTEXT_RTL)) {
            sb.append("CONTEXT_RTL");
        } else {
            sb.append("LTR");
        }
        sb.append(", ");
        bf = bidiFS.getSwap();
        sb.append("com.ibm.etools.marshall.util.bidi.BidiFlag.SWAP_");
        if (bf.equals(BidiFlag.SWAP_NO)) {
            sb.append("NO");
        } else {
            sb.append("YES");
        }
        sb.append(", ");
        bf = bidiFS.getNumerals();
        sb.append("com.ibm.etools.marshall.util.bidi.BidiFlag.NUMERALS_");
        if (bf.equals(BidiFlag.NUMERALS_CONTEXTUAL)) {
            sb.append("CONTEXTUAL");
        } else if (bf.equals(BidiFlag.NUMERALS_NATIONAL)) {
            sb.append("NATIONAL");
        } else {
            sb.append("NOMINAL");
        }
        sb.append(", ");
        bf = bidiFS.getText();
        sb.append("com.ibm.etools.marshall.util.bidi.BidiFlag.TEXT_");
        if (bf.equals(BidiFlag.TEXT_SHAPED)) {
            sb.append("SHAPED");
        } else if (bf.equals(BidiFlag.TEXT_INITIAL)) {
            sb.append("INITIAL");
        } else if (bf.equals(BidiFlag.TEXT_MIDDLE)) {
            sb.append("MIDDLE");
        } else if (bf.equals(BidiFlag.TEXT_FINAL)) {
            sb.append("FINAL");
        } else if (bf.equals(BidiFlag.TEXT_ISOLATED)) {
            sb.append("ISOLATED");
        } else {
            sb.append("NOMINAL");
        }
        sb.append(");");
        return sb.toString();
    }

    public static String[] generateStringMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, StringTD typeDescriptor) throws IllegalArgumentException {
        Bi_DirectionStringTD bidiTD;
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer("MarshallStringUtils.");
        int maxSize = 0;
        maxSize = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        String codePage = MarshallParms.getCodePage(typeDescriptor, instanceTD);
        int encodingStyle = MarshallParms.getEncodingStyle(typeDescriptor);
        int charSize = MarshallParms.getCharacterSize(typeDescriptor);
        String padCharStr = MarshallParms.getPaddingCharacter(typeDescriptor);
        if (padCharStr != null && padCharStr.equals("")) {
            padCharStr = " ";
        }
        String format = MarshallParms.getFormatString(instanceTD);
        int justification = MarshallParms.getStringJustification(typeDescriptor);
        boolean DBCSOnly = MarshallParms.getDBCSOnly(typeDescriptor);
        boolean isDBUnicode = false;
        if (charSize > 1) {
            isDBUnicode = CodeGenStringUtils.isCodepageDBUnicode(codePage);
        }
        if ((bidiTD = MarshallParms.getBidiStringTD(typeDescriptor, instanceTD)) != null) {
            BidiFlagSet bidiFS = MarshallParms.createBidiFlagSet(bidiTD);
            StringBuffer bidiSB = new StringBuffer(String.valueOf(valueName) + " = ConversionUtils.transformBidiTextMarshall ");
            bidiSB.append(CodeGenStringUtils.generateBidiTransformMethodParms(valueName, bidiFS));
            genMethods.add(bidiSB.toString());
        }
        if (format != null) {
            StringBuffer fmtSB = new StringBuffer(String.valueOf(valueName) + " = FormatTransform.transformFormatMarshall (");
            fmtSB.append(String.valueOf(valueName) + ", " + "\"" + format + "\");");
            genMethods.add(fmtSB.toString());
        }
        switch (encodingStyle) {
            case 0: {
                if (charSize == 1) {
                    sb.append("marshallFixedLengthStringIntoBuffer (");
                    sb.append(valueName);
                    sb.append(", ");
                    sb.append(byteArrayName);
                    sb.append(", ");
                    sb.append(offsetString);
                    sb.append(", ");
                    sb.append("\"" + codePage + "\"");
                    sb.append(", ");
                    sb.append(Integer.toString(maxSize));
                    sb.append(", ");
                    String strJustification = CodeGenStringUtils.getStringJustification(justification);
                    sb.append(strJustification);
                    sb.append(", ");
                    if (padCharStr == null) {
                        sb.append("null");
                    } else {
                        sb.append("\"" + padCharStr + "\"");
                    }
                    sb.append(");");
                    break;
                }
                if (isDBUnicode) {
                    sb.append("marshallFixedLengthUnicodeDBCSStringIntoBuffer (");
                } else {
                    sb.append("marshallFixedLengthDBCSStringIntoBuffer (");
                }
                sb.append(valueName);
                sb.append(", ");
                sb.append(byteArrayName);
                sb.append(", ");
                sb.append(offsetString);
                sb.append(", ");
                sb.append("\"" + codePage + "\"");
                sb.append(", ");
                sb.append(Integer.toString(charSize));
                sb.append(", ");
                sb.append(Integer.toString(maxSize));
                sb.append(", ");
                switch (justification) {
                    case 0: {
                        sb.append("MarshallStringUtils.STRING_JUSTIFICATION_LEFT");
                        break;
                    }
                    case 1: {
                        sb.append("MarshallStringUtils.STRING_JUSTIFICATION_RIGHT");
                        break;
                    }
                    case 2: {
                        sb.append("MarshallStringUtils.STRING_JUSTIFICATION_CENTER");
                    }
                }
                sb.append(", ");
                if (padCharStr == null) {
                    sb.append("null");
                } else {
                    sb.append("\"" + padCharStr + "\"");
                }
                sb.append(", ");
                sb.append(new Boolean(DBCSOnly).toString());
                sb.append(");");
                break;
            }
            case 1: {
                boolean bigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
                int prefixLength = MarshallParms.getPrefixLength(typeDescriptor);
                if (charSize == 1) {
                    sb.append("marshallLengthPrefixedStringIntoBuffer (");
                    sb.append(valueName);
                    sb.append(", ");
                    sb.append(byteArrayName);
                    sb.append(", ");
                    sb.append(offsetString);
                    sb.append(", ");
                    sb.append("\"" + codePage + "\"");
                    sb.append(", ");
                    sb.append(Integer.toString(maxSize));
                    sb.append(", ");
                    String strJustification = CodeGenStringUtils.getStringJustification(justification);
                    sb.append(strJustification);
                    sb.append(", ");
                    if (padCharStr == null) {
                        sb.append("null");
                    } else {
                        sb.append("\"" + padCharStr + "\"");
                    }
                    sb.append(", ");
                    sb.append(new Boolean(bigEndian).toString());
                    sb.append(", ");
                    sb.append(Integer.toString(prefixLength));
                    sb.append(");");
                    break;
                }
                if (isDBUnicode) {
                    sb.append("marshallLengthPrefixedUnicodeDBCSStringIntoBuffer (");
                } else {
                    sb.append("marshallLengthPrefixedDBCSStringIntoBuffer (");
                }
                sb.append(valueName);
                sb.append(", ");
                sb.append(byteArrayName);
                sb.append(", ");
                sb.append(offsetString);
                sb.append(", ");
                sb.append("\"" + codePage + "\"");
                sb.append(", ");
                sb.append(Integer.toString(charSize));
                sb.append(", ");
                sb.append(Integer.toString(maxSize));
                sb.append(", ");
                String strJustification = CodeGenStringUtils.getStringJustification(justification);
                sb.append(strJustification);
                sb.append(", ");
                if (padCharStr == null) {
                    sb.append("null");
                } else {
                    sb.append("\"" + padCharStr + "\"");
                }
                sb.append(", ");
                sb.append(new Boolean(bigEndian).toString());
                sb.append(", ");
                sb.append(Integer.toString(prefixLength));
                sb.append(", ");
                sb.append(new Boolean(DBCSOnly).toString());
                sb.append(");");
                break;
            }
            case 2: {
                if (charSize == 1) {
                    sb.append("marshallNullTerminatedStringIntoBuffer (");
                    sb.append(valueName);
                    sb.append(", ");
                    sb.append(byteArrayName);
                    sb.append(", ");
                    sb.append(offsetString);
                    sb.append(", ");
                    sb.append("\"" + codePage + "\"");
                    sb.append(", ");
                    sb.append(Integer.toString(maxSize));
                    sb.append(");");
                    break;
                }
                if (isDBUnicode) {
                    sb.append("marshallNullTerminatedUnicodeDBCSStringIntoBuffer (");
                } else {
                    sb.append("marshallNullTerminatedDBCSStringIntoBuffer (");
                }
                sb.append(valueName);
                sb.append(", ");
                sb.append(byteArrayName);
                sb.append(", ");
                sb.append(offsetString);
                sb.append(", ");
                sb.append("\"" + codePage + "\"");
                sb.append(", ");
                sb.append(Integer.toString(charSize));
                sb.append(", ");
                sb.append(Integer.toString(maxSize));
                sb.append(", ");
                sb.append(new Boolean(DBCSOnly).toString());
                sb.append(");");
            }
        }
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String[] generateStringUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, StringTD typeDescriptor) throws IllegalArgumentException {
        Bi_DirectionStringTD bidiTD;
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer(String.valueOf(valueName) + " = MarshallStringUtils.");
        int maxSize = 0;
        maxSize = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        String codePage = MarshallParms.getCodePage(typeDescriptor, instanceTD);
        int encodingStyle = MarshallParms.getEncodingStyle(typeDescriptor);
        int charSize = MarshallParms.getCharacterSize(typeDescriptor);
        boolean DBCSOnly = MarshallParms.getDBCSOnly(typeDescriptor);
        boolean isDBUnicode = false;
        if (charSize > 1) {
            isDBUnicode = CodeGenStringUtils.isCodepageDBUnicode(codePage);
        }
        switch (encodingStyle) {
            case 0: {
                if (charSize == 1) {
                    sb.append("unmarshallFixedLengthStringFromBuffer (");
                    sb.append(byteArrayName);
                    sb.append(", ");
                    sb.append(offsetString);
                    sb.append(", ");
                    sb.append("\"" + codePage + "\"");
                    sb.append(", ");
                    sb.append(Integer.toString(maxSize));
                    sb.append(");");
                    break;
                }
                if (isDBUnicode) {
                    sb.append("unmarshallFixedLengthUnicodeDBCSStringFromBuffer (");
                } else {
                    sb.append("unmarshallFixedLengthDBCSStringFromBuffer (");
                }
                sb.append(byteArrayName);
                sb.append(", ");
                sb.append(offsetString);
                sb.append(", ");
                sb.append("\"" + codePage + "\"");
                sb.append(", ");
                sb.append(Integer.toString(maxSize));
                sb.append(", ");
                sb.append(new Boolean(DBCSOnly).toString());
                sb.append(");");
                break;
            }
            case 1: {
                boolean bigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
                int prefixLength = MarshallParms.getPrefixLength(typeDescriptor);
                if (charSize == 1) {
                    sb.append("unmarshallLengthPrefixedStringFromBuffer (");
                    sb.append(byteArrayName);
                    sb.append(", ");
                    sb.append(offsetString);
                    sb.append(", ");
                    sb.append("\"" + codePage + "\"");
                    sb.append(", ");
                    sb.append(Integer.toString(maxSize));
                    sb.append(", ");
                    sb.append(new Boolean(bigEndian).toString());
                    sb.append(", ");
                    sb.append(Integer.toString(prefixLength));
                    sb.append(");");
                    break;
                }
                if (isDBUnicode) {
                    sb.append("unmarshallLengthPrefixedUnicodeDBCSStringFromBuffer (");
                } else {
                    sb.append("unmarshallLengthPrefixedDBCSStringFromBuffer (");
                }
                sb.append(byteArrayName);
                sb.append(", ");
                sb.append(offsetString);
                sb.append(", ");
                sb.append("\"" + codePage + "\"");
                sb.append(", ");
                sb.append(Integer.toString(maxSize));
                sb.append(", ");
                sb.append(new Boolean(bigEndian).toString());
                sb.append(", ");
                sb.append(Integer.toString(prefixLength));
                sb.append(", ");
                sb.append(new Boolean(DBCSOnly).toString());
                sb.append(");");
                break;
            }
            case 2: {
                if (charSize == 1) {
                    sb.append("unmarshallNullTerminatedStringFromBuffer (");
                    sb.append(byteArrayName);
                    sb.append(", ");
                    sb.append(offsetString);
                    sb.append(", ");
                    sb.append("\"" + codePage + "\"");
                    sb.append(", ");
                    sb.append(Integer.toString(maxSize));
                    sb.append(");");
                    break;
                }
                if (isDBUnicode) {
                    sb.append("unmarshallNullTerminatedUnicodeDBCSStringFromBuffer (");
                } else {
                    sb.append("unmarshallNullTerminatedDBCSStringFromBuffer (");
                }
                sb.append(byteArrayName);
                sb.append(", ");
                sb.append(offsetString);
                sb.append(", ");
                sb.append("\"" + codePage + "\"");
                sb.append(", ");
                sb.append(Integer.toString(maxSize));
                sb.append(", ");
                sb.append(new Boolean(DBCSOnly).toString());
                sb.append(", ");
                sb.append(Integer.toString(charSize));
                sb.append(");");
            }
        }
        genMethods.add(sb.toString());
        String format = MarshallParms.getFormatString(instanceTD);
        if (format != null) {
            StringBuffer fmtSB = new StringBuffer(String.valueOf(valueName) + " = FormatTransform.transformFormatUnmarshall (");
            fmtSB.append(String.valueOf(valueName) + ", " + "\"" + format + "\");");
            genMethods.add(fmtSB.toString());
        }
        if ((bidiTD = MarshallParms.getBidiStringTD(typeDescriptor, instanceTD)) != null) {
            BidiFlagSet bidiFS = MarshallParms.createBidiFlagSet(bidiTD);
            StringBuffer bidiSB = new StringBuffer(String.valueOf(valueName) + " = ConversionUtils.transformBidiTextUnmarshall ");
            bidiSB.append(CodeGenStringUtils.generateBidiTransformMethodParms(valueName, bidiFS));
            genMethods.add(bidiSB.toString());
        }
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static boolean isCodepageDBUnicode(String codePage) {
        return codePage.startsWith("UTF") || codePage.startsWith("utf") || codePage.startsWith("Unicode");
    }
}

