/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.codegen;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.util.Vector;

public class CodeGenIntegerUtils {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    private static String getStringSize(int size) throws IllegalArgumentException {
        String strSize = null;
        switch (size) {
            case 1: {
                strSize = "One";
                break;
            }
            case 2: {
                strSize = "Two";
                break;
            }
            case 4: {
                strSize = "Four";
                break;
            }
            case 8: {
                strSize = "Eight";
                break;
            }
            case 16: {
                strSize = "Sixteen";
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
        return strSize;
    }

    private static boolean useUnsignedMethod(int size, String javaType) throws IllegalArgumentException {
        boolean useUnsigned = false;
        switch (size) {
            case 1: {
                if (javaType.equals("byte")) break;
                useUnsigned = true;
                break;
            }
            case 2: {
                if (javaType.equals("short")) break;
                useUnsigned = true;
                break;
            }
            case 4: {
                if (javaType.equals("int")) break;
                useUnsigned = true;
                break;
            }
            case 8: {
                if (javaType.equals("long")) break;
                useUnsigned = true;
                break;
            }
            case 16: {
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
        return useUnsigned;
    }

    private static String getStringSignCoding(int signCoding) {
        StringBuffer sb = new StringBuffer("MarshallIntegerUtils.SIGN_CODING_");
        switch (signCoding) {
            case 0: {
                sb.append("TWOS_COMPLEMENT");
                break;
            }
            case 1: {
                sb.append("ONES_COMPLEMENT");
                break;
            }
            case 2: {
                sb.append("SIGN_MAGNITUDE");
                break;
            }
            case 3: {
                sb.append("UNSIGNED_BINARY");
                break;
            }
            case 4: {
                sb.append("UNSIGNED_DECIMAL");
            }
        }
        return sb.toString();
    }

    public static String[] generateIntegerMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, IntegerTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        boolean isBigDecimal = CodeGenUtils.addVirtualDecimalPoint(javaType);
        StringBuffer sb = new StringBuffer("MarshallIntegerUtils.marshall");
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        String strSize = CodeGenIntegerUtils.getStringSize(size);
        sb.append(String.valueOf(strSize) + "Byte");
        if (!isBigDecimal && CodeGenIntegerUtils.useUnsignedMethod(size, javaType)) {
            sb.append("Unsigned");
        }
        sb.append("IntegerIntoBuffer (");
        sb.append(valueName);
        sb.append(", ");
        sb.append(byteArrayName);
        sb.append(", ");
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int signCoding = MarshallParms.getSignCoding(typeDescriptor);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        sb.append(offsetString);
        sb.append(", ");
        if (size == 16 || isBigDecimal) {
            sb.append(new Boolean(signed).toString());
            sb.append(", ");
        }
        if (size != 1 || isBigDecimal) {
            sb.append(new Boolean(isBigEndian).toString());
            sb.append(", ");
        }
        String strSignCoding = CodeGenIntegerUtils.getStringSignCoding(signCoding);
        sb.append(strSignCoding);
        if (isBigDecimal) {
            int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
            sb.append(", ");
            sb.append(Integer.toString(virtualDecimalPoint));
        }
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String[] generateIntegerUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, IntegerTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer(String.valueOf(valueName) + " = MarshallIntegerUtils.unmarshall");
        boolean isBigDecimal = CodeGenUtils.addVirtualDecimalPoint(javaType);
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        if (isBigDecimal) {
            sb.append("BigDecimalFromBuffer (");
        } else {
            String strSize = CodeGenIntegerUtils.getStringSize(size);
            sb.append(String.valueOf(strSize) + "Byte");
            if (CodeGenIntegerUtils.useUnsignedMethod(size, javaType)) {
                sb.append("Unsigned");
            }
            sb.append("IntegerFromBuffer (");
        }
        sb.append(byteArrayName);
        sb.append(", ");
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int signCoding = MarshallParms.getSignCoding(typeDescriptor);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        sb.append(offsetString);
        sb.append(", ");
        if (isBigDecimal) {
            sb.append(Integer.toString(size));
            sb.append(", ");
            sb.append(new Boolean(signed).toString());
            sb.append(", ");
        }
        if (size != 1 || isBigDecimal) {
            sb.append(new Boolean(isBigEndian).toString());
            sb.append(", ");
        }
        String strSignCoding = CodeGenIntegerUtils.getStringSignCoding(signCoding);
        sb.append(strSignCoding);
        if (isBigDecimal) {
            sb.append(", ");
            int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
            sb.append(Integer.toString(virtualDecimalPoint));
        }
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }
}

