/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.codegen;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.util.Vector;

public class CodeGenFloatUtils {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    private static String getStringFloatType(int floatType) throws IllegalArgumentException {
        StringBuffer sb = new StringBuffer("MarshallFloatUtils.FLOAT_FORMAT_");
        switch (floatType) {
            case 0: {
                sb.append("UNSPECIFIED");
                break;
            }
            case 1: {
                sb.append("IEEE_EXTENTED_INTEL");
                break;
            }
            case 2: {
                sb.append("IEEE_EXTENTED_AIX");
                break;
            }
            case 3: {
                sb.append("IEEE_EXTENTED_OS390");
                break;
            }
            case 4: {
                sb.append("IEEE_EXTENTED_AS400");
                break;
            }
            case 5: {
                sb.append("IEEE_NON_EXTENTED");
                break;
            }
            case 6: {
                sb.append("IBM_390_HEX");
                break;
            }
            case 7: {
                sb.append("IBM_400_HEX");
                break;
            }
            case 8: {
                sb.append("IEEE_DFP_IBM");
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FLOAT_TYPE_NOT_VALID", Integer.toString(floatType)));
            }
        }
        return sb.toString();
    }

    public static String[] generateFloatMarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, FloatTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer("MarshallFloatUtils.marshallFloatIntoBuffer (");
        sb.append(valueName);
        sb.append(", ");
        sb.append(byteArrayName);
        sb.append(", ");
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        sb.append(offsetString);
        sb.append(", ");
        sb.append(new Boolean(isBigEndian).toString());
        sb.append(", ");
        String strFloatType = CodeGenFloatUtils.getStringFloatType(floatType);
        sb.append(strFloatType);
        sb.append(", ");
        sb.append(Integer.toString(size));
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }

    public static String[] generateFloatUnmarshallMethod(String valueName, String byteArrayName, String offsetString, SimpleInstanceTD instanceTD, String javaType, FloatTD typeDescriptor) throws IllegalArgumentException {
        Object[] result = null;
        Vector<String> genMethods = new Vector<String>();
        StringBuffer sb = new StringBuffer(String.valueOf(valueName) + " = MarshallFloatUtils.unmarshall");
        String typeName = CodeGenUtils.uppercaseFirstLetterInSring(javaType);
        sb.append(String.valueOf(typeName) + "FromBuffer (");
        sb.append(byteArrayName);
        sb.append(", ");
        boolean isBigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
        int floatType = MarshallParms.getFloatType(typeDescriptor, instanceTD);
        int size = 0;
        size = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize(instanceTD);
        if (offsetString == null) {
            int offset = MarshallParms.getOffset(instanceTD);
            offsetString = Integer.toString(offset);
        }
        sb.append(offsetString);
        sb.append(", ");
        sb.append(new Boolean(isBigEndian).toString());
        sb.append(", ");
        String strFloatType = CodeGenFloatUtils.getStringFloatType(floatType);
        sb.append(strFloatType);
        sb.append(", ");
        sb.append(Integer.toString(size));
        sb.append(");");
        genMethods.add(sb.toString());
        result = new String[genMethods.size()];
        genMethods.copyInto(result);
        return result;
    }
}

