/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.FormatTransform;
import com.ibm.etools.marshall.util.MarshallStringUtils;
import com.ibm.etools.marshall.util.bidi.BidiFlag;
import com.ibm.etools.marshall.util.bidi.BidiFlagSet;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;

public class MarshallString {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static void marshallStringIntoBuffer(String value, byte[] buffer, int startingOffset, StringTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int maxSize = MarshallParms.getSize(instanceTD);
        String codePage = MarshallParms.getCodePage(typeDescriptor, instanceTD);
        int encodingStyle = MarshallParms.getEncodingStyle(typeDescriptor);
        int charSize = MarshallParms.getCharacterSize(typeDescriptor);
        String padCharStr = MarshallParms.getPaddingCharacter(typeDescriptor);
        String format = MarshallParms.getFormatString(instanceTD);
        int justification = MarshallParms.getStringJustification(typeDescriptor);
        boolean DBCSOnly = MarshallParms.getDBCSOnly(typeDescriptor);
        Bi_DirectionStringTD bidiTD = MarshallParms.getBidiStringTD(typeDescriptor, instanceTD);
        if (bidiTD != null) {
            BidiFlagSet bidiFS = MarshallParms.createBidiFlagSet(bidiTD);
            value = ConversionUtils.transformBidiTextMarshall((String)value, (BidiFlag)bidiFS.getType(), (BidiFlag)bidiFS.getOrientation(), (BidiFlag)bidiFS.getSwap(), (BidiFlag)bidiFS.getNumerals(), (BidiFlag)bidiFS.getText());
        }
        if (format != null) {
            value = FormatTransform.transformFormatMarshall((String)value, (String)format);
        }
        switch (encodingStyle) {
            case 0: {
                if (charSize == 1) {
                    MarshallStringUtils.marshallFixedLengthStringIntoBuffer((String)value, (byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize, (int)justification, (String)padCharStr);
                    break;
                }
                MarshallStringUtils.marshallFixedLengthDBCSStringIntoBuffer((String)value, (byte[])buffer, (int)startingOffset, (String)codePage, (int)charSize, (int)maxSize, (int)justification, (String)padCharStr, (boolean)DBCSOnly);
                break;
            }
            case 1: {
                boolean bigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
                int prefixLength = MarshallParms.getPrefixLength(typeDescriptor);
                if (charSize == 1) {
                    MarshallStringUtils.marshallLengthPrefixedStringIntoBuffer((String)value, (byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize, (int)justification, (String)padCharStr, (boolean)bigEndian, (int)prefixLength);
                    break;
                }
                MarshallStringUtils.marshallLengthPrefixedDBCSStringIntoBuffer((String)value, (byte[])buffer, (int)startingOffset, (String)codePage, (int)charSize, (int)maxSize, (int)justification, (String)padCharStr, (boolean)bigEndian, (int)prefixLength, (boolean)DBCSOnly);
                break;
            }
            case 2: {
                if (charSize == 1) {
                    MarshallStringUtils.marshallNullTerminatedStringIntoBuffer((String)value, (byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize);
                    break;
                }
                MarshallStringUtils.marshallNullTerminatedDBCSStringIntoBuffer((String)value, (byte[])buffer, (int)startingOffset, (String)codePage, (int)charSize, (int)maxSize, (boolean)DBCSOnly);
            }
        }
    }

    public static String unmarshallStringFromBuffer(byte[] buffer, int startingOffset, StringTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        Bi_DirectionStringTD bidiTD;
        int maxSize = MarshallParms.getSize(instanceTD);
        String codePage = MarshallParms.getCodePage(typeDescriptor, instanceTD);
        int encodingStyle = MarshallParms.getEncodingStyle(typeDescriptor);
        int charSize = MarshallParms.getCharacterSize(typeDescriptor);
        boolean DBCSOnly = MarshallParms.getDBCSOnly(typeDescriptor);
        String result = null;
        switch (encodingStyle) {
            case 0: {
                if (charSize == 1) {
                    result = MarshallStringUtils.unmarshallFixedLengthStringFromBuffer((byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize);
                    break;
                }
                result = MarshallStringUtils.unmarshallFixedLengthDBCSStringFromBuffer((byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize, (boolean)DBCSOnly);
                break;
            }
            case 1: {
                boolean bigEndian = MarshallParms.isBigEndian((BaseTDType)typeDescriptor, instanceTD);
                int prefixLength = MarshallParms.getPrefixLength(typeDescriptor);
                if (charSize == 1) {
                    result = MarshallStringUtils.unmarshallLengthPrefixedStringFromBuffer((byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize, (boolean)bigEndian, (int)prefixLength);
                    break;
                }
                result = MarshallStringUtils.unmarshallLengthPrefixedDBCSStringFromBuffer((byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize, (boolean)bigEndian, (int)prefixLength, (boolean)DBCSOnly);
                break;
            }
            case 2: {
                result = charSize == 1 ? MarshallStringUtils.unmarshallNullTerminatedStringFromBuffer((byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize) : MarshallStringUtils.unmarshallNullTerminatedDBCSStringFromBuffer((byte[])buffer, (int)startingOffset, (String)codePage, (int)maxSize, (boolean)DBCSOnly);
            }
        }
        String format = MarshallParms.getFormatString(instanceTD);
        if (format != null) {
            result = FormatTransform.transformFormatUnmarshall(result, (String)format);
        }
        if ((bidiTD = MarshallParms.getBidiStringTD(typeDescriptor, instanceTD)) != null) {
            BidiFlagSet bidiFS = MarshallParms.createBidiFlagSet(bidiTD);
            result = ConversionUtils.transformBidiTextUnmarshall((String)result, (BidiFlag)bidiFS.getType(), (BidiFlag)bidiFS.getOrientation(), (BidiFlag)bidiFS.getSwap(), (BidiFlag)bidiFS.getNumerals(), (BidiFlag)bidiFS.getText());
        }
        return result;
    }
}

