/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.util.MarshallExternalDecimalUtils;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallExternalDecimal {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static void marshallExternalDecimalIntoBuffer(BigInteger value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(value);
        MarshallExternalDecimal.marshallExternalDecimalIntoBuffer(bd, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallExternalDecimalIntoBuffer(double value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        MarshallExternalDecimal.marshallExternalDecimalIntoBuffer(bd, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallExternalDecimalIntoBuffer(float value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigDecimal bd = new BigDecimal(Float.toString(value));
        MarshallExternalDecimal.marshallExternalDecimalIntoBuffer(bd, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallExternalDecimalIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = MarshallParms.getSize(instanceTD);
        int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = MarshallParms.getExternalDecimalSign(typeDescriptor, instanceTD);
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer((BigDecimal)value, (byte[])buffer, (int)startingOffset, (int)size, (boolean)signed, (int)virtualDecimalPoint, (int)signFormat, (int)externalDecimalSign);
    }

    public static void marshallExternalDecimalIntoBuffer(byte value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallExternalDecimal.marshallExternalDecimalIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallExternalDecimalIntoBuffer(short value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallExternalDecimal.marshallExternalDecimalIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallExternalDecimalIntoBuffer(int value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        MarshallExternalDecimal.marshallExternalDecimalIntoBuffer((long)value, buffer, startingOffset, typeDescriptor, instanceTD);
    }

    public static void marshallExternalDecimalIntoBuffer(long value, byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = MarshallParms.getSize(instanceTD);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = MarshallParms.getExternalDecimalSign(typeDescriptor, instanceTD);
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer((long)value, (byte[])buffer, (int)startingOffset, (int)size, (boolean)signed, (int)signFormat, (int)externalDecimalSign);
    }

    public static byte unmarshalByteFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        byte result = (byte)MarshallExternalDecimal.unmarshalLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static short unmarshalShortFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        short result = (short)MarshallExternalDecimal.unmarshalLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static int unmarshalIntFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int result = (int)MarshallExternalDecimal.unmarshalLongFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD);
        return result;
    }

    public static long unmarshalLongFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        long result = 0L;
        int size = MarshallParms.getSize(instanceTD);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = MarshallParms.getExternalDecimalSign(typeDescriptor, instanceTD);
        result = MarshallExternalDecimalUtils.unmarshallLongFromBuffer((byte[])buffer, (int)startingOffset, (int)size, (boolean)signed, (int)signFormat, (int)externalDecimalSign);
        return result;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        int size = MarshallParms.getSize(instanceTD);
        int virtualDecimalPoint = MarshallParms.getVirtualDecimalPoint((NumberTD)typeDescriptor);
        boolean signed = MarshallParms.isSigned((NumberTD)typeDescriptor);
        int signFormat = -1;
        if (signed) {
            signFormat = MarshallParms.getSignFormat(typeDescriptor);
        }
        int externalDecimalSign = MarshallParms.getExternalDecimalSign(typeDescriptor, instanceTD);
        BigDecimal result = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer((byte[])buffer, (int)startingOffset, (int)size, (boolean)signed, (int)virtualDecimalPoint, (int)signFormat, (int)externalDecimalSign);
        return result;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        BigInteger result = MarshallExternalDecimal.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD).toBigInteger();
        return result;
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        double result = MarshallExternalDecimal.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD).doubleValue();
        return result;
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, ExternalDecimalTD typeDescriptor, SimpleInstanceTD instanceTD) throws IllegalArgumentException {
        float result = MarshallExternalDecimal.unmarshallBigDecimalFromBuffer(buffer, startingOffset, typeDescriptor, instanceTD).floatValue();
        return result;
    }
}

