/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.util;

import com.ibm.zcc.ws.rd.annotations.util.IResourceErrorAccumulator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public abstract class ResourceErrorAccumulator
implements IResourceErrorAccumulator {
    public static final String TAG_NAME = "annotationTagName";
    private List errorMsgs = null;

    @Override
    public abstract IFile getErringResource();

    @Override
    public boolean isValid() {
        this.clearErrors();
        return true;
    }

    @Override
    public List errorMsgs() {
        return this.errorMsgs;
    }

    private void ensureError() {
        if (this.errorMsgs == null) {
            this.errorMsgs = new ArrayList();
        }
    }

    public abstract String getTagName();

    @Override
    public void addErr(String msg, int start, int end, boolean persistent) {
        this.ensureError();
        Error err = new Error(this.getErringResource(), this.getTagName(), msg, start, end);
        err.persistent = persistent;
        this.errorMsgs.add(err);
    }

    @Override
    public void addWarning(String msg, int start, int end, boolean persistent) {
        this.ensureError();
        Warning warn = new Warning(this.getErringResource(), this.getTagName(), msg, start, end);
        warn.persistent = persistent;
        this.errorMsgs.add(warn);
    }

    public void addMarker(String markerId, String msg, int start, int end) {
        this.ensureError();
        Error err = new Error(this.getErringResource(), this.getTagName(), msg, start, end);
        err.markerIdOverride = markerId;
        this.errorMsgs.add(err);
    }

    public void addWarningMarker(String markerId, String msg, int start, int end) {
        this.ensureError();
        Warning warn = new Warning(this.getErringResource(), this.getTagName(), msg, start, end);
        warn.markerIdOverride = markerId;
        this.errorMsgs.add(warn);
    }

    @Override
    public void addErr(String msg, int start, int end) {
        this.addErr(msg, start, end, false);
    }

    @Override
    public void addWarning(String msg, int start, int end) {
        this.addWarning(msg, start, end, false);
    }

    @Override
    public void clearErrors() {
        if (this.errorMsgs != null && !this.errorMsgs.isEmpty()) {
            Iterator i = this.errorMsgs.iterator();
            while (i.hasNext()) {
                Error err = (Error)i.next();
                if (err.persistent) continue;
                i.remove();
            }
        }
    }

    @Override
    public void takeErrorsFrom(IResourceErrorAccumulator a) {
        List al = a.errorMsgs();
        if (al != null) {
            this.ensureError();
            this.errorMsgs.addAll(al);
            a.clearErrors();
        }
    }

    @Override
    public boolean areValid(List aas) {
        if (aas == null) {
            return true;
        }
        boolean retval = true;
        for (IResourceErrorAccumulator aa : aas) {
            if (aa.isValid()) continue;
            retval = false;
            this.takeErrorsFrom(aa);
        }
        return retval;
    }

    public static void createProblemMarkersFor(String markerId, List errors) {
        if (errors != null) {
            for (Error e : errors) {
                e.createProblemMarker(markerId);
            }
        }
    }

    @Override
    public void createProblemMarkers(String markerId) {
        ResourceErrorAccumulator.createProblemMarkersFor(markerId, this.errorMsgs());
        this.clearErrors();
    }

    public static void removeAllAccumulatedProblemMarkers(IFile f, String markerId) {
        try {
            f.deleteMarkers(markerId, true, 0);
        }
        catch (CoreException coreException) {}
    }

    public void shareErrorListWith(ResourceErrorAccumulator rea) {
        if (this.errorMsgs == null) {
            if (rea.errorMsgs == null) {
                this.errorMsgs = new ArrayList();
                rea.errorMsgs = this.errorMsgs;
            } else {
                this.errorMsgs = rea.errorMsgs;
            }
        } else if (rea.errorMsgs == null) {
            rea.errorMsgs = this.errorMsgs;
        } else {
            this.errorMsgs.addAll(rea.errorMsgs);
            rea.errorMsgs = this.errorMsgs;
        }
    }

    @Override
    public boolean hasErrors() {
        if (this.errorMsgs != null) {
            for (Error e : this.errorMsgs) {
                if (!e.isError()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasMessages() {
        return this.errorMsgs != null && !this.errorMsgs.isEmpty();
    }

    @Override
    public boolean hasWarnings() {
        if (this.errorMsgs != null) {
            for (Error e : this.errorMsgs) {
                if (!e.isWarning()) continue;
                return true;
            }
        }
        return false;
    }

    protected static class Error {
        public int start;
        public int end;
        public String msg;
        public IFile file;
        public String tag;
        public boolean persistent;
        public String markerIdOverride;

        public Error(IFile f, String tagName, String message, int s, int e) {
            this.msg = message;
            this.start = s;
            this.end = e;
            this.file = f;
            this.tag = tagName;
        }

        public void createProblemMarker(String markerId) {
            if (this.file != null && this.msg != null) {
                try {
                    IMarker m = this.file.createMarker(this.markerIdOverride == null ? markerId : this.markerIdOverride);
                    int sev = this.isError() ? 2 : 1;
                    m.setAttribute("charStart", this.start);
                    m.setAttribute("charEnd", this.end);
                    m.setAttribute("message", (Object)this.msg);
                    m.setAttribute("severity", sev);
                    m.setAttribute(ResourceErrorAccumulator.TAG_NAME, (Object)this.tag);
                }
                catch (CoreException coreException) {}
            }
        }

        public boolean isWarning() {
            return false;
        }

        public boolean isError() {
            return true;
        }
    }

    protected static class Warning
    extends Error {
        public Warning(IFile f, String tagName, String message, int s, int e) {
            super(f, tagName, message, s, e);
        }

        @Override
        public boolean isWarning() {
            return true;
        }

        @Override
        public boolean isError() {
            return false;
        }
    }
}

