/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.AnnotationHandlerRegistry;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.TagDataList;
import com.ibm.zcc.ws.rd.annotations.core.TagProcessingException;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import com.ibm.zcc.ws.rd.annotations.util.ResourceErrorAccumulator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TagData
extends ResourceErrorAccumulator {
    private String name;
    private Map data;
    protected BodyDeclaration declaration;
    private int tagStart;
    private int tagEnd;
    private IFile javaSourceFile;
    private String javaDoc;
    boolean beenValidatedOnce = false;
    private static final String[] YN_CHOICES = new String[]{"yes", "no"};

    public TagData(String name, Map data, BodyDeclaration declaration) {
        this.name = name;
        this.data = data;
        this.declaration = declaration;
    }

    public TagData(TagData td) {
        this.name = td.name;
        this.data = td.data;
        this.declaration = td.declaration;
        this.tagStart = td.tagStart;
        this.tagEnd = td.tagEnd;
        this.javaSourceFile = td.javaSourceFile;
        this.javaDoc = td.javaDoc;
    }

    void freeDeclaration() {
        this.declaration = null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTagName() {
        return this.name;
    }

    protected Map getData() {
        return this.data;
    }

    public boolean containsKey(String key) {
        if (this.data == null) {
            return false;
        }
        return this.data.containsKey(key);
    }

    public String get(String key) {
        if (this.data == null) {
            return null;
        }
        return (String)this.data.get(key);
    }

    public boolean getBool(String key, boolean def) {
        String val = this.get(key);
        if (val == null) {
            return def;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }

    public void putObject(String key, Object val) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, val);
    }

    public Object getObject(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public String get(String key, String defVal) {
        String val = this.get(key);
        if (val == null) {
            return defVal;
        }
        return val;
    }

    public boolean isEmpty() {
        if (this.data == null) {
            return true;
        }
        return this.data.isEmpty();
    }

    public int size() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public Iterator iterator() {
        if (this.data == null) {
            return new EmptyIterator();
        }
        return this.data.keySet().iterator();
    }

    public BodyDeclaration getDeclaration() {
        if (this.declaration == null) {
            return null;
        }
        return this.declaration;
    }

    public String toString() {
        return "[" + this.name + ": " + this.data + " " + this.declaration + "]";
    }

    public int getTagEnd() {
        return this.tagEnd;
    }

    public int getTagStart() {
        return this.tagStart;
    }

    public void setTagEnd(int i) {
        this.tagEnd = i;
    }

    public void setTagStart(int i) {
        this.tagStart = i;
    }

    public IFile getSourceFile() {
        return this.javaSourceFile;
    }

    public void setSourceFile(IFile f) {
        this.javaSourceFile = f;
    }

    @Override
    public IFile getErringResource() {
        return this.javaSourceFile;
    }

    public IFile getResource() {
        return this.javaSourceFile;
    }

    public void addErr(String msg) {
        this.addErr(msg, this.tagStart, this.tagEnd);
    }

    public void addWarning(String msg) {
        this.addWarning(msg, this.tagStart, this.tagEnd);
    }

    public void addPersistentErr(String msg) {
        this.addErr(msg, this.tagStart, this.tagEnd, true);
    }

    public void addPersistentWarning(String msg) {
        this.addWarning(msg, this.tagStart, this.tagEnd, true);
    }

    public void addMarker(String markerId, String msg) {
        this.addMarker(markerId, msg, this.tagStart, this.tagEnd);
    }

    public void addWarningMarker(String markerId, String msg) {
        this.addWarningMarker(markerId, msg, this.tagStart, this.tagEnd);
    }

    @Override
    public boolean isValid() {
        this.beenValidatedOnce = true;
        return true;
    }

    public boolean beenValidatedOnce() {
        return this.beenValidatedOnce;
    }

    protected void setValidated() {
        this.beenValidatedOnce = true;
    }

    protected void walkUpTree(ASTNode node, Stack accumulator) {
        while (node != null) {
            switch (node.getNodeType()) {
                case 55: {
                    TypeDeclaration td = (TypeDeclaration)node;
                    accumulator.push(td.getName().getIdentifier());
                    break;
                }
                case 15: {
                    CompilationUnit cu = (CompilationUnit)node;
                    String pck = this.extractPackageName(cu);
                    if (pck.length() == 0) break;
                    accumulator.push(pck);
                }
            }
            node = node.getParent();
        }
    }

    protected String extractPackageName(CompilationUnit cu) {
        PackageDeclaration pack = cu.getPackage();
        if (pack != null) {
            Name n = pack.getName();
            if (n.isQualifiedName()) {
                QualifiedName qn = (QualifiedName)n;
                return qn.getQualifier() + "." + qn.getName().getIdentifier();
            }
            SimpleName sn = (SimpleName)n;
            return sn.getIdentifier();
        }
        return "";
    }

    protected String getTypeNameFor(ASTNode n) {
        Stack accum = new Stack();
        this.walkUpTree(n, accum);
        StringBuffer aName = new StringBuffer(64);
        while (!accum.isEmpty()) {
            String val = (String)accum.pop();
            aName.append(val);
            if (accum.isEmpty()) continue;
            aName.append('.');
        }
        return aName.toString();
    }

    public String getTypePackage() {
        BodyDeclaration an = this.getDeclaration();
        while (an != null) {
            if (15 == an.getNodeType()) {
                return this.extractPackageName((CompilationUnit)an);
            }
            an = an.getParent();
        }
        return "";
    }

    public TypeDeclaration getContainingType() {
        BodyDeclaration n = this.getDeclaration();
        while (n != null) {
            if (n.getNodeType() == 55) {
                return (TypeDeclaration)n;
            }
            n = n.getParent();
        }
        WRDAnnotationCore.log(4, IWRDResources.getString("TagData.No_Enclosing_Type_Found"), null);
        return null;
    }

    public String getContainingTypeName() {
        return this.getTypeNameFor((ASTNode)this.getContainingType());
    }

    public static String nameToString(Name n) {
        if (n != null) {
            if (n.isSimpleName()) {
                return ((SimpleName)n).getIdentifier();
            }
            if (n.isQualifiedName()) {
                QualifiedName qn = (QualifiedName)n;
                return qn.getQualifier() + "." + qn.getName().getIdentifier();
            }
        }
        return null;
    }

    public static String getQualifiedTypeName(Type t) {
        if ((t.getFlags() & 1) == 0) {
            ITypeBinding tb = t.resolveBinding();
            if (tb != null) {
                return tb.getQualifiedName();
            }
            return TagData.getNameFromType(t);
        }
        return "MALFORMED";
    }

    private static String getNameFromType(Type t) {
        Type workingType;
        int ndims = 0;
        StringBuffer rv = new StringBuffer(40);
        if (t.isArrayType()) {
            ArrayType at = (ArrayType)t;
            ndims = at.getDimensions();
            workingType = at.getElementType();
        } else {
            workingType = t;
        }
        if (workingType.isPrimitiveType()) {
            PrimitiveType pt = (PrimitiveType)workingType;
            rv.append(pt.getPrimitiveTypeCode().toString());
        } else if (workingType.isQualifiedType()) {
            QualifiedType qt = (QualifiedType)workingType;
            rv.append(TagData.getNameFromType(qt.getQualifier()));
            rv.append('.');
            rv.append(qt.getName().getIdentifier());
        } else if (workingType.isSimpleType()) {
            SimpleType st = (SimpleType)workingType;
            rv.append(TagData.resolveQN((ASTNode)st, TagData.nameToString(st.getName())));
        } else {
            WRDAnnotationCore.log(4, "Could not resolve type name: " + t, new Exception());
            rv.append("<UNKNOWN_TYPE>");
        }
        if (ndims > 0) {
            int i = 0;
            while (i < ndims) {
                rv.append("[]");
                ++i;
            }
        }
        return rv.toString();
    }

    protected static String resolveQN(ASTNode st, String simpleName) {
        if (simpleName.indexOf(46) != -1) {
            return simpleName;
        }
        ASTNode gr = st.getRoot();
        if (gr.getNodeType() != 15) {
            WRDAnnotationCore.log(4, "Compilation unit not found at root of AST tree.", new Exception());
            return simpleName;
        }
        CompilationUnit cu = (CompilationUnit)gr;
        List imports = cu.imports();
        for (ImportDeclaration id : imports) {
            String qn;
            int ld;
            String sn;
            Name n;
            if (id.isOnDemand() || !(n = id.getName()).isQualifiedName() || !simpleName.equals(sn = (ld = (qn = n.getFullyQualifiedName()).lastIndexOf(46)) != -1 ? qn.substring(ld + 1) : qn)) continue;
            return qn;
        }
        return simpleName;
    }

    public String getTagSet() {
        return AnnotationHandlerRegistry.tagSetFromTagName(this.name);
    }

    public boolean isTypeTag() {
        return false;
    }

    public boolean isMethodTag() {
        return false;
    }

    public boolean isFieldTag() {
        return false;
    }

    public String scopeString() {
        return "<UNKNOWN>";
    }

    public String memberName() {
        return "<UNKNOWN>";
    }

    public TagDataList createList() {
        return new TagDataList(this);
    }

    protected boolean yesNo(String val, boolean defaultVal) {
        if (val == null) {
            return defaultVal;
        }
        return val.equalsIgnoreCase("yes");
    }

    protected boolean validateYesNo(String val, String attrName) {
        return this.validEnum(val, attrName, YN_CHOICES);
    }

    protected boolean validEnum(String val, String valName, String[] choices) {
        if (val == null) {
            val = "<NULL>";
        }
        if (this.pickFromChoices(val, choices) == null) {
            StringBuffer cbuf = new StringBuffer(128);
            int i = 0;
            while (i < choices.length) {
                cbuf.append(choices[i]);
                if (i != choices.length - 1) {
                    cbuf.append(", ");
                }
                ++i;
            }
            this.addErr("'" + val + IWRDResources.getString("AnnotationArtifact.Invalid_Enum.1") + valName + IWRDResources.getString("AnnotationArtifact.Invalid_Enum.2") + cbuf.toString());
            return false;
        }
        return true;
    }

    protected String pickFromChoices(String val, String[] choices) {
        int i = 0;
        while (i < choices.length) {
            String choice = choices[i];
            if (val.equalsIgnoreCase(choice)) {
                return choice;
            }
            ++i;
        }
        return null;
    }

    protected boolean required(String val, String valName) {
        if (val == null || val.length() == 0) {
            this.addErr(String.valueOf(IWRDResources.getString("AnnotationArtifact.RequiredAttribute.1")) + valName + IWRDResources.getString("AnnotationArtifact.RequiredAttribute.2"));
            return false;
        }
        return true;
    }

    public void doubleDispatch(AnnotationTagHandler ath, IResource res) throws TagProcessingException {
    }

    public void setJavaDoc(String jd) {
        this.javaDoc = jd;
    }

    public String getJavaDoc() {
        if (this.javaDoc == null) {
            return "/** ";
        }
        return this.javaDoc;
    }

    public String mkJavadoc() {
        return String.valueOf(this.getJavaDoc()) + "\n*/";
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

