/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.IAnnotatedFileRegistry;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import com.ibm.zcc.ws.rd.resource.javautil.DisabledTagSets;
import com.ibm.zcc.ws.rd.save.ISaveComponent;
import com.ibm.zcc.ws.rd.save.WRDSaveParticipant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagsetRegistry;

public class AnnotatedFileRegistry
implements ISaveComponent,
IAnnotatedFileRegistry {
    private static AnnotatedFileRegistry INSTANCE;
    private static final IPath STATE_FILE_LOOKUP;
    private static final String id = "annotatedfileregistry";
    Map tagsetToFile = new HashMap();
    Map fileToTagset = new HashMap();
    private boolean initialized;
    private IPath fileToLoadFrom;
    Map uniqueTSSets = new HashMap();
    Set tmpSet = new HashSet();
    static final Set EMPTY;

    static {
        STATE_FILE_LOOKUP = new Path("com.ibm.ws.rapiddeploy.annotatedFileRegistry");
        EMPTY = new HashSet();
    }

    public String getID() {
        return id;
    }

    public AnnotatedFileRegistry() {
        if (INSTANCE != null) {
            throw new IllegalStateException(IWRDResources.getString("AnnotatedFileRegistry.Singleton_Err"));
        }
        INSTANCE = this;
    }

    public static AnnotatedFileRegistry getInstance() {
        if (INSTANCE == null) {
            WRDSaveParticipant participant = WRDAnnotationCore.getDefault().getSaveParticipant();
            participant.registerSaveComponent("AnnotatedFileRegistry");
            participant.loadSaveComponentState("AnnotatedFileRegistry");
            if (INSTANCE == null) {
                INSTANCE = new AnnotatedFileRegistry();
            }
        }
        return INSTANCE;
    }

    private Set uniqueTSSet(Set tss) {
        HashSet rv = (HashSet)this.uniqueTSSets.get(tss);
        if (rv == null) {
            rv = new HashSet(tss);
            this.uniqueTSSets.put(rv, rv);
        }
        return rv;
    }

    private void filterSetIntoTmp(Set s, DisabledTagSets dts) {
        Iterator i = s.iterator();
        this.tmpSet.clear();
        while (i.hasNext()) {
            String tsn = (String)i.next();
            if (!AnnotatedFileRegistry.isRegisteredTagset(tsn) || dts.isDisabled(tsn)) continue;
            this.tmpSet.add(tsn);
        }
    }

    private void filterInPlace(Set s) {
        for (String tsn : s) {
            if (AnnotatedFileRegistry.isRegisteredTagset(tsn)) continue;
            s.remove(tsn);
        }
    }

    public synchronized void annotatedFileEncountered(IFile javaSource, Set tagsetNames, DisabledTagSets dts) {
        this.ensureInit();
        this.removeFile(javaSource);
        this.filterSetIntoTmp(tagsetNames, dts);
        if (!this.tmpSet.isEmpty()) {
            this.pvtAnnotatedFileEncountered(javaSource, this.tmpSet, false);
        }
    }

    private void pvtAnnotatedFileEncountered(IFile javaSource, Set tagsetNames, boolean useSuppliedSet) {
        if (useSuppliedSet) {
            this.filterInPlace(tagsetNames);
        }
        Iterator i = tagsetNames.iterator();
        while (i.hasNext()) {
            this.addFile(javaSource, (String)i.next());
        }
        if (useSuppliedSet) {
            this.fileToTagset.put(javaSource, tagsetNames);
        } else {
            this.fileToTagset.put(javaSource, this.uniqueTSSet(tagsetNames));
        }
    }

    public synchronized void unannotatedFileEncountered(IFile javaSource) {
        this.ensureInit();
        this.removeFile(javaSource);
    }

    public synchronized void javaFileDeleted(IFile javaSource) {
        this.ensureInit();
        this.removeFile(javaSource);
    }

    public synchronized void javaFileRenamed(IFile original, IFile newLoc) {
        Set tagSetNames = (Set)this.fileToTagset.get(original);
        if (tagSetNames != null) {
            this.removeFile(original);
            this.pvtAnnotatedFileEncountered(newLoc, tagSetNames, false);
        }
    }

    private void removeFile(IFile f) {
        Set tagsets = (Set)this.fileToTagset.get(f);
        if (tagsets != null) {
            Iterator i = tagsets.iterator();
            while (i.hasNext()) {
                Set files = (Set)this.tagsetToFile.get((String)i.next());
                if (files == null) continue;
                files.remove(f);
            }
            this.fileToTagset.remove(f);
        }
    }

    private void addFile(IFile f, String tagSetName) {
        HashSet<IFile> files = (HashSet<IFile>)this.tagsetToFile.get(tagSetName);
        if (files == null) {
            files = new HashSet<IFile>();
            this.tagsetToFile.put(tagSetName, files);
        }
        files.add(f);
    }

    private static boolean isRegisteredTagset(String tagSetName) {
        return AnnotationTagsetRegistry.INSTANCE.getDescriptor(tagSetName) != null;
    }

    @Override
    public synchronized boolean fileIsAnnotated(IFile f) {
        this.ensureInit();
        Set tagsets = (Set)this.fileToTagset.get(f);
        return tagsets != null && !tagsets.isEmpty();
    }

    public synchronized Collection getTagsets(IFile file) {
        this.ensureInit();
        Collection result = (Collection)this.fileToTagset.get(file);
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public synchronized Set filesAnnotatedWithTagSet(String tagSetName) {
        this.ensureInit();
        Set rv = (Set)this.tagsetToFile.get(tagSetName);
        if (rv == null) {
            rv = EMPTY;
        }
        return rv;
    }

    @Override
    public synchronized Set allAnnotatedFiles() {
        this.ensureInit();
        return this.fileToTagset.keySet();
    }

    private void ensureInit() {
        if (!this.initialized) {
            try {
                if (this.fileToLoadFrom != null) {
                    this.loadState(this.fileToLoadFrom);
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    public void load(ISavedState state) {
        if (state != null) {
            int saveNum = state.getSaveNumber();
            if (saveNum == 0) {
                return;
            }
            this.fileToLoadFrom = state.lookup(STATE_FILE_LOOKUP);
        }
    }

    public void doneSaving(ISaveContext ctx) {
        this.cleanupOldSaveFile(ctx);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    private void cleanupOldSaveFile(ISaveContext ctx) {
        int lastSave;
        if (ctx.getKind() == 1 && this.initialized && (lastSave = ctx.getPreviousSaveNumber()) != 0) {
            File oldFile = this.mkStatePath(this.stateFileName(lastSave)).toFile();
            try {
                oldFile.delete();
            }
            catch (SecurityException securityException) {}
        }
    }

    public void rollback(ISaveContext ctx) {
        this.cleanupOldSaveFile(ctx);
    }

    private String stateFileName(int savenum) {
        return "annotated-file-registry-" + savenum;
    }

    private IPath mkStatePath(String baseName) {
        return WRDAnnotationCore.getDefault().getStateLocation().append(baseName);
    }

    private void loadState(IPath saveFile) {
        block17: {
            ObjectInputStream ois = null;
            try {
                try {
                    int fileIndex = -1;
                    fileIndex = saveFile.toOSString().lastIndexOf("/");
                    if (fileIndex > 0 || (fileIndex = saveFile.toOSString().lastIndexOf("\\")) > 0) {
                        String fileName = saveFile.toOSString().substring(fileIndex + 1);
                        saveFile = WRDAnnotationCore.getDefault().getStateLocation().append(fileName);
                    }
                    ois = new ObjectInputStream(new FileInputStream(saveFile.toFile()));
                    int numFiles = ois.readInt();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    int i = 0;
                    while (i < numFiles) {
                        IFile f;
                        String path = (String)ois.readObject();
                        HashSet tss = (HashSet)ois.readObject();
                        if (path != null && (f = root.getFileForLocation((IPath)new Path(path))) != null) {
                            this.pvtAnnotatedFileEncountered(f, tss, true);
                        }
                        ++i;
                    }
                    this.uniqueTSSets = (HashMap)ois.readObject();
                }
                catch (Exception ex) {
                    WRDAnnotationCore.log(2, IWRDResources.getString("AnnotatedFileRegistry.Reg_Restore_Prob"), ex);
                    this.fileToTagset.clear();
                    this.tagsetToFile.clear();
                    this.uniqueTSSets.clear();
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean saveState(IPath saveFile) {
        boolean err;
        block25: {
            ObjectOutputStream oos = null;
            File sf = saveFile.toFile();
            err = false;
            try {
                try {
                    oos = new ObjectOutputStream(new FileOutputStream(sf));
                    int numFiles = this.fileToTagset.size();
                    oos.writeInt(numFiles);
                    for (IFile f : this.fileToTagset.keySet()) {
                        IPath floc = f.getLocation();
                        if (floc == null) {
                            oos.writeObject(null);
                            oos.writeObject(null);
                            continue;
                        }
                        oos.writeObject(floc.toString());
                        oos.writeObject(this.fileToTagset.get(f));
                    }
                    oos.writeObject(this.uniqueTSSets);
                }
                catch (Exception ex) {
                    WRDAnnotationCore.log(4, IWRDResources.getString("AnnotatedFileRegistry.Reg_Save_Prob"), ex);
                    err = true;
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (err) {
                        try {
                            sf.delete();
                        }
                        catch (Exception exception) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (err) {
                    try {
                        sf.delete();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (err) {
                try {
                    sf.delete();
                }
                catch (Exception exception) {}
            }
        }
        return !err;
    }

    public void saving(ISaveContext ctx) throws CoreException {
        if (ctx.getKind() != 1) {
            return;
        }
        if (!this.initialized) {
            return;
        }
        int saveNum = ctx.getSaveNumber();
        IPath sfPath = this.mkStatePath(this.stateFileName(saveNum));
        if (this.saveState(sfPath)) {
            ctx.map(STATE_FILE_LOOKUP, sfPath);
            ctx.needSaveNumber();
        } else {
            ctx.map(STATE_FILE_LOOKUP, null);
        }
    }
}

