/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.validation.framework;

import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.migration.validation.framework.IMigrationValidator;
import com.ibm.etools.common.migration.validation.framework.IMigrationValidatorListener;
import com.ibm.etools.common.migration.validation.framework.MigrationValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractMigrationValidator
implements IMigrationValidator {
    protected IStatus currentErrorStatus = null;
    protected List migrationValidatorListeners = null;
    private String id = null;
    private Set successfulMigratorIDs = null;
    private Set failedMigratorIDs = null;
    private Set requiresMigratorIDs = null;
    protected Boolean requiredValidatorsTested = null;

    @Override
    public IStatus validate(IProject project, IProgressMonitor monitor) {
        block6: {
            try {
                try {
                    this.didRequiresValidatorsSucceed();
                    this.doValidate(project, monitor);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    MigrationPlugin.logError(e);
                    this.reportError(e);
                    monitor.done();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        return this.getStatus();
    }

    protected abstract void doValidate(IProject var1, IProgressMonitor var2);

    protected IStatus getStatus() {
        if (this.currentErrorStatus != null) {
            return this.currentErrorStatus;
        }
        return Status.OK_STATUS;
    }

    protected void reportWarning(String message) {
        IStatus status = MigrationPlugin.createStatus(2, message);
        this.reportWarning(status);
    }

    protected void reportWarning(IStatus status) {
        this.reportProblem(status);
    }

    protected void reportError(String message) {
        IStatus anErrorStatus = MigrationPlugin.createStatus(4, message);
        this.reportError(anErrorStatus);
    }

    protected void reportError(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        IStatus anErrorStatus = MigrationPlugin.createStatus(4, message, e);
        this.reportError(anErrorStatus);
    }

    protected void reportError(IStatus status) {
        this.reportProblem(status);
    }

    private void reportProblem(IStatus status) {
        if (this.currentErrorStatus == null) {
            this.currentErrorStatus = status;
        } else {
            if (!this.currentErrorStatus.isMultiStatus()) {
                MultiStatus multiStatus = MigrationValidationUtils.createMutliStatus(this.currentErrorStatus);
                this.currentErrorStatus = multiStatus;
            }
            ((MultiStatus)this.currentErrorStatus).add(status);
        }
        this.notifyListeners(status);
    }

    protected void reportSuccess(String message) {
        IStatus anOKStatus = MigrationPlugin.createStatus(0, message);
        this.reportSuccess(anOKStatus);
    }

    protected void reportSuccess(IStatus status) {
        this.notifyListeners(status);
    }

    protected void reportInformation(String message) {
        IStatus anInfoStatus = MigrationPlugin.createStatus(1, message);
        this.reportInformation(anInfoStatus);
    }

    protected void reportInformation(IStatus status) {
        this.notifyListeners(status);
    }

    protected void notifyListeners(IStatus aStatus) {
        if (this.migrationValidatorListeners != null) {
            int i = 0;
            while (i < this.migrationValidatorListeners.size()) {
                IMigrationValidatorListener aListener = (IMigrationValidatorListener)this.migrationValidatorListeners.get(i);
                aListener.reportStatus(aStatus);
                ++i;
            }
        }
    }

    public void addMigrationValidatorListener(IMigrationValidatorListener listener) {
        if (this.migrationValidatorListeners == null) {
            this.migrationValidatorListeners = new ArrayList();
        }
        this.migrationValidatorListeners.add(listener);
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public Set getRequiresMigratorIDs() {
        return this.requiresMigratorIDs;
    }

    public void setRequiresMigratorIDs(Set requiresMigratorIDs) {
        this.requiresMigratorIDs = requiresMigratorIDs;
    }

    public Set getFailedMigratorIDs() {
        return this.failedMigratorIDs;
    }

    public void setFailedMigratorIDs(Set failedMigratorIDs) {
        this.failedMigratorIDs = failedMigratorIDs;
    }

    public Set getSuccessfulMigratorIDs() {
        return this.successfulMigratorIDs;
    }

    public void setSuccessfulMigratorIDs(Set successfulMigratorIDs) {
        this.successfulMigratorIDs = successfulMigratorIDs;
    }

    public boolean didRequiresValidatorsSucceed() {
        if (this.requiredValidatorsTested == null) {
            boolean b = this.didRequiresValidatorsSucceed(this.getRequiresMigratorIDs());
            this.requiredValidatorsTested = new Boolean(b);
        }
        return this.requiredValidatorsTested;
    }

    public boolean didRequiresValidatorsSucceed(Set requiredMigrationValidatorIDs) {
        boolean allOK = true;
        for (String prereqID : requiredMigrationValidatorIDs) {
            if (this.getFailedMigratorIDs().contains(prereqID)) {
                this.reportError(NLS.bind((String)MigrationMessages.MigrationValidatorFramework_validator_failed, (Object)prereqID));
                allOK = false;
                continue;
            }
            if (this.getSuccessfulMigratorIDs().contains(prereqID)) continue;
            this.reportError(NLS.bind((String)MigrationMessages.MigrationValidatorFramework_not_exeuted, (Object)prereqID));
            allOK = false;
        }
        return allOK;
    }

    public void reportIncompatibleNatures(IProject project, Set natureSet) {
        this.reportInformation(MigrationMessages.MigrationValidatorFramework_check_natures);
        for (String natureID : natureSet) {
            if (this.hasNature(project, natureID)) {
                this.reportError(NLS.bind((String)MigrationMessages.MigrationValidatorFramework_incompat_nature, (Object)natureID));
                continue;
            }
            this.reportSuccess(NLS.bind((String)MigrationMessages.MigrationValidatorFramework_nature_notfound, (Object)natureID));
        }
        this.reportInformation(MigrationMessages.MigrationValidatorFramework_finished_nature_check);
    }

    public Set hasNatures(IProject project, Set natureSet) {
        HashSet<String> foundNatureSet = null;
        for (String natureID : natureSet) {
            if (!this.hasNature(project, natureID)) continue;
            if (foundNatureSet == null) {
                foundNatureSet = new HashSet<String>();
            }
            foundNatureSet.add(natureID);
        }
        return foundNatureSet == null ? Collections.EMPTY_SET : foundNatureSet;
    }

    public boolean hasNature(IProject project, String natureID) {
        try {
            return project.getDescription().hasNature(natureID);
        }
        catch (CoreException e) {
            MigrationPlugin.logError(e);
            this.reportError((Exception)((Object)e));
            return false;
        }
    }

    public boolean isLegacyValidator() {
        return false;
    }
}

