/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class WorkspaceMigrationListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private Set emptyProjects = new HashSet();

    public WorkspaceMigrationListener() {
        this.init();
    }

    public void init() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                WorkspaceMigrationEngine engine = WorkspaceMigrationEngine.instance();
                delta.accept((IResourceDeltaVisitor)this);
                if (MigrationPlugin.isFinishedStartup() && engine.hasProjects()) {
                    engine.begin();
                }
            }
            catch (CoreException e) {
                MigrationPlugin.logError(e);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null && resource.getType() == 4) {
            IProject project = (IProject)resource;
            try {
                switch (delta.getKind()) {
                    case 1: {
                        if (this.checkAndRememberEmptyProject(project)) break;
                        WorkspaceMigrationEngine.instance().addProject(project);
                        break;
                    }
                    case 4: {
                        if (this.recallAndClearEmptyProject(project)) {
                            WorkspaceMigrationEngine.instance().addProject(project);
                            break;
                        }
                        if ((delta.getFlags() & 0x40000) != 0) {
                            WorkspaceMigrationEngine.instance().addProject(project);
                            break;
                        }
                        if ((delta.getFlags() & 0x4000) == 0 || !project.isOpen()) break;
                        WorkspaceMigrationEngine.instance().addProject(project);
                        break;
                    }
                }
                return false;
            }
            catch (Exception e) {
                MigrationPlugin.logError(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndRememberEmptyProject(IProject emptyProject) {
        block5: {
            try {
                if (emptyProject.isAccessible() && emptyProject.members().length != 1) break block5;
                Set set = this.emptyProjects;
                synchronized (set) {
                    this.emptyProjects.add(emptyProject);
                }
                return true;
            }
            catch (CoreException e) {
                MigrationPlugin.logError(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recallAndClearEmptyProject(IProject emptyProject) {
        Set set = this.emptyProjects;
        synchronized (set) {
            block4: {
                if (!this.emptyProjects.contains(emptyProject)) break block4;
                this.emptyProjects.remove(emptyProject);
                return true;
            }
            return false;
        }
    }
}

