/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.AbstractMigrationHandler;
import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MigrationHandlerRegistry {
    static final String EXTENSION_POINT = "MigrationHandlerExtention";
    static final String ELEMENT_MIGRATION_HANDLER = "MigrationHandler";
    static final String ATTRIBUTE_CLASS = "class";
    public static MigrationHandlerRegistry INSTANCE = new MigrationHandlerRegistry();
    private IConfigurationElement migrationHandlerElement = null;
    private boolean registryIsRead = false;

    public AbstractMigrationHandler getMigrationHandler() {
        if (!this.registryIsRead) {
            this.readRegistry();
        }
        if (this.migrationHandlerElement != null) {
            try {
                return (AbstractMigrationHandler)this.migrationHandlerElement.createExecutableExtension(ATTRIBUTE_CLASS);
            }
            catch (CoreException e) {
                String className = this.migrationHandlerElement.getAttribute(ATTRIBUTE_CLASS);
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_failedToLoad, (Object)className));
                MigrationPlugin.logError(e);
            }
        }
        return null;
    }

    private void readRegistry() {
        this.registryIsRead = true;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.etools.common.migration", EXTENSION_POINT);
        if (point == null) {
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationHandlerRegistry_noExtenders, (Object)EXTENSION_POINT));
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        if (elements.length > 1) {
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationHandlerRegistry_onlyOneExtender, (Object)EXTENSION_POINT));
        }
        IConfigurationElement element = null;
        if (elements.length != 0) {
            element = elements[0];
        }
        if (element != null && ELEMENT_MIGRATION_HANDLER.equals(element.getName())) {
            String className = element.getAttribute(ATTRIBUTE_CLASS);
            if (className == null || className.trim().length() == 0) {
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_missingAttribute, (Object[])new Object[]{EXTENSION_POINT, ELEMENT_MIGRATION_HANDLER, ATTRIBUTE_CLASS}));
            }
            this.migrationHandlerElement = element;
        } else {
            MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_elementName, (Object[])new Object[]{ELEMENT_MIGRATION_HANDLER, EXTENSION_POINT}));
            if (element != null) {
                MigrationPlugin.logError(MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkRegistry_invalidElement, (Object[])new Object[]{element.getName(), EXTENSION_POINT}));
            }
        }
    }
}

