/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkOperation;
import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class MigrationFrameworkDataModelProvider
extends AbstractDataModelProvider
implements IMigrationFrameworkDataModelProperties {
    public static final String DEFAULT_MIGRATION_LOG_FILENAME = "migration.log";

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IMigrationFrameworkDataModelProperties.NEEDS_METADATA_MIGRATION");
        propertyNames.add("IMigrationFrameworkDataModelProperties.POTENTIAL_MIGRATION_PROJECTS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.PROJECT_MIGRATORS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES");
        propertyNames.add("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.MIGRATION_LOG_DESTINATION");
        propertyNames.add("IMigrationFrameworkDataModelProperties.MIGRATION_RESULTS_VIEW_LISTENER");
        propertyNames.add("IMigrationFrameworkDataModelProperties.MIGRATION_VALIDATION_STATUS");
        propertyNames.add("IMigrationFrameworkDataModelProperties.LEGACY_PROJECTS");
        return propertyNames;
    }

    public IDataModelOperation getDefaultOperation() {
        return new MigrationFrameworkOperation(this.model);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IMigrationFrameworkDataModelProperties.NEEDS_METADATA_MIGRATION".equals(propertyName)) {
            return Boolean.FALSE;
        }
        if ("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS".equals(propertyName)) {
            return Collections.EMPTY_LIST;
        }
        if ("IMigrationFrameworkDataModelProperties.POTENTIAL_MIGRATION_PROJECTS".equals(propertyName)) {
            return Collections.EMPTY_LIST;
        }
        if ("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS".equals(propertyName)) {
            return Collections.EMPTY_LIST;
        }
        if ("IMigrationFrameworkDataModelProperties.PROJECT_MIGRATORS".equals(propertyName)) {
            return new HashMap();
        }
        if ("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES".equals(propertyName)) {
            return Collections.EMPTY_SET;
        }
        if ("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS".equals(propertyName)) {
            return Status.OK_STATUS;
        }
        if ("IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS".equals(propertyName)) {
            return Status.OK_STATUS;
        }
        if ("IMigrationFrameworkDataModelProperties.MIGRATION_LOG_DESTINATION".equals(propertyName)) {
            IPath metadataLocation = Platform.getLogFileLocation().removeLastSegments(1);
            return metadataLocation.append(DEFAULT_MIGRATION_LOG_FILENAME);
        }
        if ("IMigrationFrameworkDataModelProperties.MIGRATION_VALIDATION_STATUS".equals(propertyName)) {
            return Status.OK_STATUS;
        }
        if ("IMigrationFrameworkDataModelProperties.LEGACY_PROJECTS".equals(propertyName)) {
            return Collections.EMPTY_SET;
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if ("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS".equals(propertyName)) {
            int selectedProjectsSize = ((List)this.getProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS")).size();
            int migrationProjectsSize = ((List)this.getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS")).size();
            if (selectedProjectsSize == 0 && migrationProjectsSize != 0) {
                return new Status(4, "com.ibm.etools.common.migration", 0, MigrationMessages.MigrationFrameworkDataModelProvider_selectProject, null);
            }
        } else if ("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS".equals(propertyName)) {
            IStatus status = (IStatus)this.getProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS");
            if (!status.isOK()) {
                if (status.isMultiStatus()) {
                    MultiStatus mStatus = (MultiStatus)status;
                    return mStatus.getChildren()[0];
                }
                return status;
            }
        } else if ("IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS".equals(propertyName)) {
            IStatus status = (IStatus)this.getProperty("IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS");
            if (!status.isOK()) {
                return new Status(4, "com.ibm.etools.common.migration", 0, MigrationMessages.MigrationFrameworkDataModelProvider_resourceCheckoutError, null);
            }
        } else if ("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS".equals(propertyName)) {
            int migrationProjectsSize = ((List)this.getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS")).size();
            boolean needsMetadataMigration = this.getBooleanProperty("IMigrationFrameworkDataModelProperties.NEEDS_METADATA_MIGRATION");
            if (migrationProjectsSize == 0 && !needsMetadataMigration) {
                return new Status(4, "com.ibm.etools.common.migration", 0, "", null);
            }
        }
        return super.validate(propertyName);
    }
}

