/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.query.util;

import com.ibm.ims.datatools.modelbase.sql.query.helper.StatementHelper;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLQuerySourceWriterProvider {
    private Map registeredSourceWriterPackageMap = new HashMap();
    private static SQLQuerySourceWriterProvider instance = null;

    private SQLQuerySourceWriterProvider() {
    }

    public static SQLQuerySourceWriterProvider getInstance() {
        if (instance == null) {
            instance = new SQLQuerySourceWriterProvider();
        }
        return instance;
    }

    public void registerSourceWriter(Class sourceWriterClass, String sqlModelObjectsPackageName) {
        if (sourceWriterClass != null && sqlModelObjectsPackageName != null) {
            if (this.registeredSourceWriterPackageMap.containsKey(sqlModelObjectsPackageName)) {
                Class previousSW = (Class)this.registeredSourceWriterPackageMap.get(sqlModelObjectsPackageName);
                if (sourceWriterClass == previousSW || sourceWriterClass.isAssignableFrom(previousSW)) {
                    return;
                }
                if (!previousSW.isAssignableFrom(sourceWriterClass)) {
                    StatementHelper.logError("\n" + sourceWriterClass.getName() + " can not displace " + previousSW.getName() + " for package " + sqlModelObjectsPackageName + " because it is not an extending " + previousSW.getName());
                    return;
                }
            }
            this.registeredSourceWriterPackageMap.put(sqlModelObjectsPackageName, sourceWriterClass);
            String packageName = sqlModelObjectsPackageName;
            if (packageName.endsWith(".impl")) {
                int interfaceLevelPackageNameLength = packageName.lastIndexOf(".impl");
                String interfaceLevelPackageName = packageName.substring(0, interfaceLevelPackageNameLength);
                if (interfaceLevelPackageName != null) {
                    this.registeredSourceWriterPackageMap.put(interfaceLevelPackageName, sourceWriterClass);
                }
            } else {
                String implPackageName = packageName + ".impl";
                if (implPackageName != null) {
                    this.registeredSourceWriterPackageMap.put(implPackageName, sourceWriterClass);
                }
            }
        }
    }

    Class getQuerySourceWriterClass(Class queryObjectClass) {
        Class sourceWriterClass = null;
        Map registeredSourceWriters = this.registeredSourceWriterPackageMap;
        String queryObjectsPackageName = queryObjectClass.getPackage().getName();
        if (registeredSourceWriters.containsKey(queryObjectsPackageName)) {
            sourceWriterClass = (Class)registeredSourceWriters.get(queryObjectsPackageName);
        } else {
            List potentialSourceWriterNames = this.getPotentialQuerySourceWriterNames(queryObjectClass);
            List sourceWriterClasses = this.getClassesForNames(potentialSourceWriterNames);
            try {
                queryObjectClass = Class.forName(SQLQuerySourceWriter.getInterfaceName(queryObjectClass));
            }
            catch (Exception exception) {}
            for (Class swClass : sourceWriterClasses) {
                try {
                    SQLQuerySourceWriter.getSpecificAppendSQLMethod(swClass, queryObjectClass);
                    sourceWriterClass = swClass;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        return sourceWriterClass;
    }

    private List getClassesForNames(List classNames) {
        ArrayList classes = new ArrayList();
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Class<?> swClass = Class.forName(className);
                    classes.add(swClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Exception exception) {}
            }
        }
        return classes;
    }

    List getPotentialQuerySourceWriterNames(Class queryObjectClass) {
        ArrayList<CallSite> potentialSourceWriterNames = new ArrayList<CallSite>();
        if (queryObjectClass == null) {
            return null;
        }
        String packageName = queryObjectClass.getPackage().getName();
        int sqlQueryPackageBeginIndex = packageName.indexOf(".sql.") + 1;
        int sqlQueryPackageEndIndex = packageName.length();
        if (packageName.endsWith(".impl")) {
            sqlQueryPackageEndIndex -= 5;
        }
        String basePackage = packageName.substring(0, sqlQueryPackageBeginIndex - 1);
        String stripToSQLQueryPackage = packageName.substring(sqlQueryPackageBeginIndex, sqlQueryPackageEndIndex);
        String[] subpackages = stripToSQLQueryPackage.split("\\.");
        ArrayList potentialSourceWriterPackageAndPrefixes = new ArrayList();
        String currentPackage = basePackage + ".";
        int i = 0;
        while (i < subpackages.length) {
            String subpackage = subpackages[i];
            String firstUpperCase = subpackage.substring(0, 1).toUpperCase();
            String restLowerCase = subpackage.substring(1);
            String partName = firstUpperCase + restLowerCase;
            String partNameUC = subpackage.toUpperCase();
            currentPackage = currentPackage + subpackage + ".";
            ArrayList<CallSite> additionalSourceWriterPackageAndPrefixes = new ArrayList<CallSite>();
            for (String potential : potentialSourceWriterPackageAndPrefixes) {
                int potentialSubpackageEndIndex = potential.lastIndexOf(".") + 1;
                String newPotentialSubpackage = currentPackage;
                String partPrefix = potential.substring(potentialSubpackageEndIndex);
                String newPart = newPotentialSubpackage + partPrefix + partName;
                String newPartUC = newPotentialSubpackage + partPrefix + partName.toUpperCase();
                additionalSourceWriterPackageAndPrefixes.add((CallSite)((Object)newPart));
                if (partName.length() > 3) continue;
                additionalSourceWriterPackageAndPrefixes.add((CallSite)((Object)newPartUC));
            }
            potentialSourceWriterPackageAndPrefixes.addAll(additionalSourceWriterPackageAndPrefixes);
            potentialSourceWriterPackageAndPrefixes.add(currentPackage + partName);
            if (partName.length() <= 3) {
                potentialSourceWriterPackageAndPrefixes.add(currentPackage + partNameUC);
            }
            ++i;
        }
        for (String potPrefix : potentialSourceWriterPackageAndPrefixes) {
            int lastDot = potPrefix.lastIndexOf(46);
            String sourceWriterPackage = potPrefix.substring(0, lastDot);
            String sourceWriterName = potPrefix.substring(lastDot + 1);
            potentialSourceWriterNames.add(0, (CallSite)((Object)(sourceWriterPackage + ".util." + sourceWriterName + "SourceWriter")));
        }
        return potentialSourceWriterNames;
    }
}

