/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.query.util;

import com.ibm.ims.datatools.modelbase.sql.datatypes.ApproximateNumericDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.ArrayDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.DataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.DateDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.ElementType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.IntegerDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.MultisetDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.PrimitiveType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.TimeDataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.XMLDataType;
import com.ibm.ims.datatools.modelbase.sql.query.CallStatement;
import com.ibm.ims.datatools.modelbase.sql.query.ColumnName;
import com.ibm.ims.datatools.modelbase.sql.query.CursorReference;
import com.ibm.ims.datatools.modelbase.sql.query.Grouping;
import com.ibm.ims.datatools.modelbase.sql.query.GroupingExpression;
import com.ibm.ims.datatools.modelbase.sql.query.GroupingSets;
import com.ibm.ims.datatools.modelbase.sql.query.GroupingSetsElementExpression;
import com.ibm.ims.datatools.modelbase.sql.query.GroupingSetsElementSublist;
import com.ibm.ims.datatools.modelbase.sql.query.MergeInsertSpecification;
import com.ibm.ims.datatools.modelbase.sql.query.MergeOnCondition;
import com.ibm.ims.datatools.modelbase.sql.query.MergeOperationSpecification;
import com.ibm.ims.datatools.modelbase.sql.query.MergeSourceTable;
import com.ibm.ims.datatools.modelbase.sql.query.MergeTargetTable;
import com.ibm.ims.datatools.modelbase.sql.query.MergeUpdateSpecification;
import com.ibm.ims.datatools.modelbase.sql.query.NullOrderingType;
import com.ibm.ims.datatools.modelbase.sql.query.OrderByOrdinal;
import com.ibm.ims.datatools.modelbase.sql.query.OrderByResultColumn;
import com.ibm.ims.datatools.modelbase.sql.query.OrderBySpecification;
import com.ibm.ims.datatools.modelbase.sql.query.OrderByValueExpression;
import com.ibm.ims.datatools.modelbase.sql.query.OrderingSpecType;
import com.ibm.ims.datatools.modelbase.sql.query.Predicate;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateBasic;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateBetween;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateComparisonOperator;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateExists;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateInValueList;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateInValueRowSelect;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateInValueSelect;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateIsNull;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateLike;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateQuantifiedType;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect;
import com.ibm.ims.datatools.modelbase.sql.query.ProcedureReference;
import com.ibm.ims.datatools.modelbase.sql.query.QueryCombined;
import com.ibm.ims.datatools.modelbase.sql.query.QueryCombinedOperator;
import com.ibm.ims.datatools.modelbase.sql.query.QueryDeleteStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryExpressionBody;
import com.ibm.ims.datatools.modelbase.sql.query.QueryExpressionRoot;
import com.ibm.ims.datatools.modelbase.sql.query.QueryInsertStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryMergeStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryNested;
import com.ibm.ims.datatools.modelbase.sql.query.QuerySearchCondition;
import com.ibm.ims.datatools.modelbase.sql.query.QuerySelect;
import com.ibm.ims.datatools.modelbase.sql.query.QuerySelectStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryUpdateStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryValueExpression;
import com.ibm.ims.datatools.modelbase.sql.query.QueryValues;
import com.ibm.ims.datatools.modelbase.sql.query.ResultColumn;
import com.ibm.ims.datatools.modelbase.sql.query.ResultTableAllColumns;
import com.ibm.ims.datatools.modelbase.sql.query.SQLQueryObject;
import com.ibm.ims.datatools.modelbase.sql.query.SearchConditionCombined;
import com.ibm.ims.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import com.ibm.ims.datatools.modelbase.sql.query.SearchConditionNested;
import com.ibm.ims.datatools.modelbase.sql.query.SuperGroup;
import com.ibm.ims.datatools.modelbase.sql.query.SuperGroupElementExpression;
import com.ibm.ims.datatools.modelbase.sql.query.SuperGroupElementSublist;
import com.ibm.ims.datatools.modelbase.sql.query.SuperGroupType;
import com.ibm.ims.datatools.modelbase.sql.query.TableCorrelation;
import com.ibm.ims.datatools.modelbase.sql.query.TableExpression;
import com.ibm.ims.datatools.modelbase.sql.query.TableFunction;
import com.ibm.ims.datatools.modelbase.sql.query.TableInDatabase;
import com.ibm.ims.datatools.modelbase.sql.query.TableJoined;
import com.ibm.ims.datatools.modelbase.sql.query.TableJoinedOperator;
import com.ibm.ims.datatools.modelbase.sql.query.TableNested;
import com.ibm.ims.datatools.modelbase.sql.query.TableReference;
import com.ibm.ims.datatools.modelbase.sql.query.UpdatabilityExpression;
import com.ibm.ims.datatools.modelbase.sql.query.UpdatabilityType;
import com.ibm.ims.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import com.ibm.ims.datatools.modelbase.sql.query.UpdateOfColumn;
import com.ibm.ims.datatools.modelbase.sql.query.UpdateSource;
import com.ibm.ims.datatools.modelbase.sql.query.UpdateSourceExprList;
import com.ibm.ims.datatools.modelbase.sql.query.UpdateSourceQuery;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionAtomic;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCast;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionColumn;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCombined;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionFunction;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionLabeledDuration;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionLabeledDurationType;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionNested;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionNullValue;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionRow;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionSimple;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionUnaryOperator;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionVariable;
import com.ibm.ims.datatools.modelbase.sql.query.ValuesRow;
import com.ibm.ims.datatools.modelbase.sql.query.WithTableReference;
import com.ibm.ims.datatools.modelbase.sql.query.WithTableSpecification;
import com.ibm.ims.datatools.modelbase.sql.query.helper.DataTypeHelper;
import com.ibm.ims.datatools.modelbase.sql.query.helper.StatementHelper;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLComment;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQueryArrayDataType;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQueryMultisetDataType;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceWriterProvider;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLSourceWriter;
import com.ibm.ims.datatools.modelbase.sql.routines.Procedure;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.schema.helper.ISQLObjectNameHelper;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class SQLQuerySourceWriter
implements SQLSourceWriter {
    protected static final int STANDARD_INDENT = 2;
    protected int displayWidth = 80;
    protected boolean alwaysQualifyColumnNamesForMultipleTables = true;
    protected boolean alwaysQualifyColumnNamesForSubqueries = false;
    protected boolean qualifyColumnNamesInSubqueriesWhenQualifiedInSuperQuery = false;
    protected boolean alwaysQualifyColumnNamesReferencedInSubqueries = true;
    protected static final String SQL_OBJECT_NAME_HELPER = "com.ibm.ims.datatools.modelbase.sql.sqlObjectNameHelper";
    protected static final String SQL_OBJECT_NAME_HELPER_DBTYPE = "databaseType";
    protected static final String SQL_OBJECT_NAME_HELPER_CLASS = "class";
    private Map lastSLCommentIndentMap = null;
    private char delimitedIdentifierQuote = (char)34;
    private int indentUnitSize = 2;
    private boolean preserveComments = true;
    public static final String DEFAULT_STMT_SELECT = "SELECT *\n  FROM";
    protected static String COMMENT_PREFIX_SINGLE_LINE = "--";
    protected static String COMMENT_PREFIX_MULTI_LINE = "/*";
    protected static String COMMENT_SUFFIX_MULTI_LINE = "*/";
    private static final String FUNCTION_COUNT = "COUNT";
    protected static final String ORDERING_SPEC_TYPE_ASC = "ASC";
    protected static final String ORDERING_SPEC_TYPE_DESC = "DESC";
    protected static final String NULL_ORDERING_TYPE_NULLS_FIRST = "NULLS FIRST";
    protected static final String NULL_ORDERING_TYPE_NULLS_LAST = "NULLS LAST";
    protected static final char DOT = '.';
    protected static final char NEW_LINE = '\n';
    protected static final String NEW_LINE_STRING = String.valueOf('\n');
    protected static final char PAREN_LEFT = '(';
    protected static final char PAREN_RIGHT = ')';
    protected static final char BRACKET_LEFT = '[';
    protected static final char BRACKET_RIGHT = ']';
    protected static final char SPACE = ' ';
    protected static final char COMMA = ',';
    protected static final String EQUAL = "=";
    protected static final String NOT_EQUAL = "<>";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String LESS_THAN_OR_EQUAL = "<=";
    protected static final String GREATER_THAN_OR_EQUAL = ">=";
    protected static final String AND = "AND";
    protected static final String OR = "OR";
    protected static final String PLUS = "+";
    protected static final String MINUS = "-";
    protected static final String ADD = "+";
    protected static final String SUBTRACT = "-";
    protected static final String MULTIPLY = "*";
    protected static final String DIVIDE = "/";
    protected static final String CONCATENATE = "||";
    protected static final String UNION = "UNION";
    protected static final String UNION_ALL = "UNION ALL";
    protected static final String INTERSECT = "INTERSECT";
    protected static final String INTERSECT_ALL = "INTERSECT ALL";
    protected static final String EXCEPT = "EXCEPT";
    protected static final String EXCEPT_ALL = "EXCEPT ALL";
    protected static final String COLON = ":";
    protected static final String QUESTIONMARK = "?";
    protected static final String ARRAY = "ARRAY";
    protected static final String AS = "AS";
    protected static final String ALL = "ALL";
    protected static final String ANY = "ANY";
    protected static final String ASC = "ASC";
    protected static final String ASTERISK = "*";
    protected static final String BETWEEN = "BETWEEN";
    protected static final String CALL = "CALL";
    protected static final String CASE = "CASE";
    protected static final String CAST = "CAST";
    protected static final String CUBE = "CUBE";
    protected static final String DAYS = "DAYS";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String DELETE = "DELETE";
    protected static final String DESC = "DESC";
    protected static final String DISTINCT = "DISTINCT";
    protected static final String ELSE = "ELSE";
    protected static final String END = "END";
    protected static final String ESCAPE = "ESCAPE";
    protected static final String EXISTS = "EXISTS";
    protected static final String FETCH = "FETCH";
    protected static final String FIRST = "FIRST";
    protected static final String FOR = "FOR";
    protected static final String FROM = "FROM";
    protected static final String FULL = "FULL";
    protected static final String GRANDTOTAL = "GRANDTOTAL";
    protected static final String GROUP_BY = "GROUP BY";
    protected static final String GROUPING_SETS = "GROUPING SETS";
    protected static final String HAVING = "HAVING";
    protected static final String HOURS = "HOURS";
    protected static final String IN = "IN";
    protected static final String INSERT = "INSERT";
    protected static final String INNER = "INNER";
    protected static final String INTO = "INTO";
    protected static final String IS = "IS";
    protected static final String JOIN = "JOIN";
    protected static final String LIKE = "LIKE";
    protected static final String LEFT = "LEFT";
    protected static final String MATCHED = "MATCHED";
    protected static final String MERGE = "MERGE";
    protected static final String MICROSECONDS = "MICROSECONDS";
    protected static final String MINUTES = "MINUTES";
    protected static final String MONTHS = "MONTHS";
    protected static final String MULTISET = "MULTISET";
    protected static final String NOT = "NOT";
    protected static final String NULL = "NULL";
    protected static final String OF = "OF";
    protected static final String ON = "ON";
    protected static final String ONLY = "ONLY";
    protected static final String ORDER_BY = "ORDER BY";
    protected static final String OUTER = "OUTER";
    protected static final String READ = "READ";
    protected static final String RIGHT = "RIGHT";
    protected static final String ROLLUP = "ROLLUP";
    protected static final String ROW = "ROW";
    protected static final String ROWS = "ROWS";
    protected static final String SECONDS = "SECONDS";
    protected static final String SELECT = "SELECT";
    protected static final String SELECTIVITY = "SELECTIVITY";
    protected static final String SET = "SET";
    protected static final String STAR = "*";
    protected static final String SOME = "SOME";
    protected static final String TABLE = "TABLE";
    protected static final String THEN = "THEN";
    protected static final String UPDATE = "UPDATE";
    protected static final String USING = "USING";
    protected static final String VALUES = "VALUES";
    protected static final String WITH = "WITH";
    protected static final String WHEN = "WHEN";
    protected static final String WHERE = "WHERE";
    protected static final String YEARS = "YEARS";
    protected static Object lastExternalyProcessed = null;

    static String getInterfaceName(Class sqlObjectClass) {
        if (sqlObjectClass == null) {
            return null;
        }
        StringBuffer className = null;
        String interfaceName = null;
        className = new StringBuffer(sqlObjectClass.getName());
        if (sqlObjectClass.getPackage().getName().endsWith("impl")) {
            int implStart = className.lastIndexOf(".impl.") + 1;
            int implEnd = implStart + 5;
            className.delete(implStart, implEnd);
        }
        if (sqlObjectClass.getName().endsWith("Impl")) {
            className.delete(className.length() - 4, className.length());
        }
        interfaceName = className.toString();
        return interfaceName;
    }

    static Method getSpecificAppendSQLMethod(Class sourceWriterClass, Class queryObjectInterfaceClass) throws NoSuchMethodException {
        if (queryObjectInterfaceClass == null || sourceWriterClass == null) {
            return null;
        }
        Method appendSQL = null;
        try {
            Class<StringBuffer> stringBufferClass = StringBuffer.class;
            Class[] methodArgTypes = new Class[]{queryObjectInterfaceClass, stringBufferClass};
            appendSQL = sourceWriterClass.getDeclaredMethod("appendSpecificSQL", methodArgTypes);
        }
        catch (NoSuchMethodException nsme) {
            Class superClass = sourceWriterClass.getSuperclass();
            if (superClass != null && SQLQuerySourceWriter.class.isAssignableFrom(superClass)) {
                appendSQL = SQLQuerySourceWriter.getSpecificAppendSQLMethod(superClass, queryObjectInterfaceClass);
            }
            throw nsme;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return appendSQL;
    }

    @Override
    public String getSQL(SQLQueryObject queryObject) {
        String sql = null;
        if (queryObject != null) {
            SQLQuerySourceFormat sourceFormat;
            try {
                if (this.getSpecificAppendSQLMethod(queryObject) != null) {
                    SQLQuerySourceWriterProvider.getInstance().registerSourceWriter(this.getClass(), queryObject.getClass().getPackage().getName());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            this.preserveComments = (sourceFormat = queryObject.getSourceInfo().getSqlFormat()).isPreserveComments() && (queryObject instanceof QueryStatement || !sourceFormat.isGenerateCommentsForStatementOnly());
            this.delimitedIdentifierQuote = sourceFormat.getDelimitedIdentifierQuote();
            StringBuffer sb = new StringBuffer();
            this.appendSQL(queryObject, sb);
            sql = sb.toString();
            sql = this.filterOutEmptyLines(sql);
            this.lastSLCommentIndentMap = null;
        }
        return sql;
    }

    protected void appendComment(SQLComment comment, StringBuffer sb) {
        if (comment == null) {
            return;
        }
        if (!(comment.getRelativePosition() != 2 && comment.getRelativePosition() != 1 || this.isLastLineEmpty(sb))) {
            int lastLineIndent = this.getLastLineIndent(sb);
            this.appendNewLine(sb);
            this.appendSpace(sb, lastLineIndent);
        }
        if (comment.isMultiLineComment()) {
            String text = comment.getText();
            String trimText = text.trim();
            StringBuffer sbComment = new StringBuffer();
            if (!trimText.startsWith(COMMENT_PREFIX_MULTI_LINE)) {
                this.appendString(sbComment, COMMENT_PREFIX_MULTI_LINE);
            }
            this.appendString(sbComment, text);
            if (!trimText.endsWith(COMMENT_SUFFIX_MULTI_LINE)) {
                this.appendString(sbComment, COMMENT_SUFFIX_MULTI_LINE);
            }
            this.appendStringBuffer(sb, sbComment);
            if (this.getLastLineLength(sbComment) > 40 && !text.endsWith(NEW_LINE_STRING)) {
                this.appendNewLine(sb);
            }
        } else {
            String text = comment.getText();
            if (!this.isLastLineEmpty(sb)) {
                this.appendSpace(sb);
            }
            if (comment.getRelativePosition() == 0) {
                int currentIndent = this.getLastLineLength(sb);
                if (this.lastSLCommentIndentMap == null) {
                    this.lastSLCommentIndentMap = new HashMap();
                }
                if (this.lastSLCommentIndentMap.containsKey(sb)) {
                    int lastSingleLineCommentStart = (Integer)this.lastSLCommentIndentMap.get(sb);
                    if (lastSingleLineCommentStart > currentIndent) {
                        this.appendSpace(sb, lastSingleLineCommentStart - currentIndent);
                    } else {
                        this.lastSLCommentIndentMap.put(sb, currentIndent);
                    }
                } else {
                    this.lastSLCommentIndentMap.put(sb, currentIndent);
                }
            }
            if (!text.startsWith(COMMENT_PREFIX_SINGLE_LINE)) {
                this.appendString(sb, COMMENT_PREFIX_SINGLE_LINE);
            }
            this.appendString(sb, text);
            if (!text.endsWith(NEW_LINE_STRING)) {
                this.appendNewLine(sb);
            }
        }
    }

    protected void appendCommentsPreceeding(SQLQueryObject queryObject, StringBuffer sb) {
        List comments = queryObject.getSourceInfo().getComments();
        if (comments != null) {
            for (SQLComment comment : comments) {
                if (comment.getRelativePosition() != 1) continue;
                this.appendComment(comment, sb);
            }
        }
    }

    protected void appendCommentsSucceeding(SQLQueryObject queryObject, StringBuffer sb) {
        List comments = queryObject.getSourceInfo().getComments();
        if (comments != null) {
            for (SQLComment comment : comments) {
                if (comment.getRelativePosition() == 1) continue;
                this.appendComment(comment, sb);
            }
        }
    }

    protected void appendDataTypeName(StringBuffer sb, String dataTypeName) {
        sb.append(dataTypeName);
    }

    protected boolean appendExternalSQL(SQLQueryObject queryObject, StringBuffer sb) {
        boolean foundExternalSourceWriter = false;
        if (lastExternalyProcessed != queryObject) {
            lastExternalyProcessed = queryObject;
            String externalSQL = null;
            Class swClass = SQLQuerySourceWriterProvider.getInstance().getQuerySourceWriterClass(queryObject.getClass());
            SQLQuerySourceWriter sw = null;
            if (swClass != null) {
                try {
                    sw = (SQLQuerySourceWriter)swClass.newInstance();
                    externalSQL = sw.getSQL(queryObject);
                    if (externalSQL != null && externalSQL.length() > 0) {
                        SQLQuerySourceWriterProvider.getInstance().registerSourceWriter(swClass, queryObject.getClass().getPackage().getName());
                        StringBuffer externalSQLSB = new StringBuffer(externalSQL);
                        int lastLineIndent = this.getLastLineIndent(sb);
                        int externalSQLIndent = lastLineIndent + 2;
                        this.indentSQL(externalSQLSB, externalSQLIndent);
                        sb.append(externalSQLSB);
                        foundExternalSourceWriter = true;
                        lastExternalyProcessed = null;
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return foundExternalSourceWriter;
    }

    protected void appendKeyword(StringBuffer sb, String keyword) {
        sb.append(keyword);
    }

    protected void appendFunctionName(StringBuffer sb, String funcName) {
        sb.append(funcName);
    }

    protected void appendIdentifier(StringBuffer sb, String ident) {
        sb.append(ident);
    }

    protected void appendIndent(StringBuffer sb) {
        int indentSpace = this.getIndentUnitSize();
        this.appendSpace(sb, indentSpace);
    }

    protected void appendIndent(StringBuffer sb, int indentUnitCount) {
        int indentSpace = this.getIndentUnitSize() * indentUnitCount;
        this.appendSpace(sb, indentSpace);
    }

    protected void appendInt(StringBuffer sb, int intVal) {
        sb.append(intVal);
    }

    protected void appendNewLine(StringBuffer sb) {
        if (!this.isLastLineEmpty(sb)) {
            sb.append('\n');
        }
    }

    protected void appendOperator(StringBuffer sb, String oper) {
        sb.append(oper);
    }

    protected void appendSpace(StringBuffer sb) {
        sb.append(' ');
    }

    protected void appendSpace(StringBuffer sb, int number) {
        int i = 0;
        while (i < number) {
            sb.append(' ');
            ++i;
        }
    }

    protected void appendSpecialRegisterName(StringBuffer sb, String regName) {
        sb.append(regName);
    }

    protected void appendSymbol(StringBuffer sb, char symbol) {
        sb.append(symbol);
    }

    protected void appendString(StringBuffer sb, String str) {
        sb.append(str);
    }

    protected void appendStringBuffer(StringBuffer sb, StringBuffer bufToAppend) {
        sb.append(bufToAppend);
    }

    protected void appendSQL(SQLObject sqlObject, StringBuffer sb) {
        if (sqlObject == null) {
            return;
        }
        if (sqlObject instanceof SQLQueryObject) {
            this.appendSQL((SQLQueryObject)sqlObject, sb);
            return;
        }
        try {
            Method specificAppendSQLMethod = this.getSpecificAppendSQLMethod(sqlObject);
            Object[] invokationArgs = new Object[]{sqlObject, sb};
            specificAppendSQLMethod.setAccessible(true);
            specificAppendSQLMethod.invoke((Object)this, invokationArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            ite.getTargetException().printStackTrace();
        }
    }

    protected void appendSQL(SQLQueryObject queryObject, StringBuffer sb) {
        block9: {
            if (queryObject == null) {
                return;
            }
            try {
                Method specificAppendSQLMethod = this.getSpecificAppendSQLMethod(queryObject);
                if (specificAppendSQLMethod != null) {
                    Object[] invokationArgs = new Object[]{queryObject, sb};
                    specificAppendSQLMethod.setAccessible(true);
                    if (this.preserveComments) {
                        this.appendCommentsPreceeding(queryObject, sb);
                    }
                    specificAppendSQLMethod.invoke((Object)this, invokationArgs);
                    if (this.preserveComments) {
                        this.appendCommentsSucceeding(queryObject, sb);
                    }
                    break block9;
                }
                throw new NoSuchMethodException("appendSQL(\"" + queryObject.getClass().getName() + "\") not found in " + this.getClass().getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                boolean specificAppendSQLMethod = this.appendExternalSQL(queryObject, sb);
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
                ite.getTargetException().printStackTrace();
            }
        }
    }

    protected void appendSQLForFetchFirstClause(int aRowFetchLimit, StringBuffer sb) {
        if (aRowFetchLimit > 0) {
            this.appendKeyword(sb, FETCH);
            this.appendSpace(sb);
            this.appendKeyword(sb, FIRST);
            this.appendSpace(sb);
            if (aRowFetchLimit == 1) {
                this.appendKeyword(sb, ROW);
            } else {
                this.appendInt(sb, aRowFetchLimit);
                this.appendSpace(sb);
                this.appendKeyword(sb, ROWS);
            }
            this.appendSpace(sb);
            this.appendKeyword(sb, ONLY);
        }
    }

    protected void appendSQLForLargeObjectSize(int size, StringBuffer sb) {
        int kilo = 1024;
        int mega = 0x100000;
        int giga = 0x40000000;
        if (size > kilo && size % kilo == 0) {
            if (size > mega && size % mega == 0) {
                if (size > giga && size % giga == 0) {
                    this.appendInt(sb, size / giga);
                    this.appendSymbol(sb, 'G');
                } else {
                    this.appendInt(sb, size / mega);
                    this.appendSymbol(sb, 'M');
                }
            } else {
                this.appendInt(sb, size / kilo);
                this.appendSymbol(sb, 'K');
            }
        } else if (size == Integer.MAX_VALUE) {
            this.appendInt(sb, 2);
            this.appendSymbol(sb, 'G');
        } else {
            this.appendInt(sb, size);
        }
    }

    protected void appendSQLForOrderByClause(List orderByClauseList, StringBuffer sb) {
        this.appendKeyword(sb, ORDER_BY);
        this.appendSpace(sb);
        Iterator it = orderByClauseList.iterator();
        while (it.hasNext()) {
            OrderBySpecification orderBySpec = (OrderBySpecification)it.next();
            if (!StatementHelper.isOrderBySpecificationValid(orderBySpec)) continue;
            this.appendSQL(orderBySpec, sb);
            if (!it.hasNext()) continue;
            this.appendSymbol(sb, ',');
            this.appendSpace(sb);
        }
    }

    protected void appendSQLForSQLObjectList(List sqlObjectList, StringBuffer sb) {
        if (sqlObjectList != null) {
            int indent = this.getLastLineIndent(sb) + 2;
            Iterator it = sqlObjectList.iterator();
            while (it.hasNext()) {
                SQLObject sqlObject = (SQLObject)it.next();
                if (sqlObject == null) continue;
                this.appendSQL(sqlObject, sb);
                if (!it.hasNext()) continue;
                this.appendSymbol(sb, ',');
                if (this.getLastLineLength(sb) > this.displayWidth - 20) {
                    this.appendNewLine(sb);
                    this.appendSpace(sb, indent);
                    continue;
                }
                this.appendSpace(sb);
            }
        }
    }

    protected void appendSQLForTableExpression(TableReference tableRef, StringBuffer sb) {
        if (tableRef instanceof QueryExpressionBody) {
            QueryExpressionBody nestedQuery = (QueryExpressionBody)tableRef;
            this.appendSymbol(sb, '(');
            this.appendSQL(nestedQuery, sb);
            this.appendSymbol(sb, ')');
            TableCorrelation tableCorr = nestedQuery.getTableCorrelation();
            if (tableCorr != null) {
                SQLQuerySourceInfo sourceInfo = nestedQuery.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                if (sourceFormat.getGenerateAsKeywordForTableCorrID()) {
                    this.appendSpace(sb);
                    this.appendKeyword(sb, AS);
                }
                this.appendSpace(sb);
                this.appendSQL(tableCorr, sb);
            }
        } else if (tableRef instanceof TableFunction) {
            TableFunction tableFunction = (TableFunction)tableRef;
            this.appendSQL(tableFunction, sb);
        } else {
            this.appendSQL(tableRef, sb);
        }
    }

    protected void appendSQLForTableInDatabase(TableInDatabase tableInDB, StringBuffer sb) {
        if (tableInDB != null) {
            String tableName = tableInDB.getName();
            Schema schema = null;
            char delimQuoteChar = this.getDelimitedIdentifierQuote();
            ISQLObjectNameHelper nameHelper = null;
            Table dbTable = tableInDB.getDatabaseTable();
            if (dbTable != null) {
                schema = tableInDB.getDatabaseTable().getSchema();
                Database db = this.getDatabase(dbTable);
                if (db != null && (nameHelper = this.getSQLObjectNameHelper(db)) != null) {
                    String delimQuoteStr = Character.toString(delimQuoteChar);
                    nameHelper.setIdentifierQuoteString(delimQuoteStr);
                }
            }
            boolean qualify = false;
            if (schema != null && schema.getName() != null && schema.getName().length() > 0) {
                qualify = true;
                SQLQuerySourceInfo sourceInfo = tableInDB.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                int qualifySpec = sourceFormat.getQualifyIdentifiers();
                if (qualifySpec == 3 || qualifySpec == 2) {
                    qualify = false;
                } else if (qualifySpec == 1) {
                    qualify = true;
                } else if (qualifySpec == 0) {
                    qualify = !StatementHelper.omitSchema(tableInDB);
                }
            }
            String sqlFormatName = "";
            if (nameHelper != null) {
                sqlFormatName = qualify ? nameHelper.getQualifiedNameInSQLFormat(dbTable) : nameHelper.getNameInSQLFormat(dbTable);
                this.appendIdentifier(sb, sqlFormatName);
            } else {
                if (qualify) {
                    String schemaName = schema.getName();
                    sqlFormatName = this.convertCatalogIdentifierToSQLFormat(schemaName, delimQuoteChar);
                    this.appendIdentifier(sb, sqlFormatName);
                    this.appendSymbol(sb, '.');
                }
                String sqlFormatTableName = this.convertCatalogIdentifierToSQLFormat(tableName, this.getDelimitedIdentifierQuote());
                this.appendIdentifier(sb, sqlFormatTableName);
            }
        }
    }

    protected void appendWithConditionalLineBreaks(SQLObject sqlObject, StringBuffer sb, int indent, int displayWidth) {
        StringBuffer localSB = new StringBuffer();
        this.appendSQL(sqlObject, localSB);
        int lineLength = this.getLastLineLength(sb);
        int nameSpaceLength = localSB.length();
        if (lineLength + nameSpaceLength > displayWidth) {
            sb.append('\n');
            this.indentSQL(localSB, indent + 2);
        } else {
            sb.append(' ');
        }
        sb.append(localSB);
    }

    protected String convertCatalogIdentifierToSQLFormat(String catalogIdentifier, char idDelimiterQuote) {
        return StatementHelper.convertCatalogIdentifierToSQLFormat(catalogIdentifier, idDelimiterQuote);
    }

    protected String filterOutEmptyLines(String sql) {
        String previousSql = sql;
        sql = sql.replaceAll("\n(\\s*\\n)+", NEW_LINE_STRING);
        previousSql.length();
        sql.length();
        if (sql.startsWith(NEW_LINE_STRING)) {
            sql = sql.substring(1);
        }
        return sql;
    }

    protected char getDelimitedIdentifierQuote() {
        return this.delimitedIdentifierQuote;
    }

    protected int getIndentUnitSize() {
        return this.indentUnitSize;
    }

    protected int getLastLineIndent(StringBuffer sb) {
        int lastIndexOfLineBreak = sb.lastIndexOf(NEW_LINE_STRING);
        int i = 0;
        i = 0;
        while (i < sb.length() - lastIndexOfLineBreak - 1) {
            if (sb.charAt(lastIndexOfLineBreak + i + 1) != ' ') break;
            ++i;
        }
        return i;
    }

    private Database getDatabase(Table table) {
        Schema schema;
        Database db = null;
        if (table != null && (schema = table.getSchema()) != null) {
            db = schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
        }
        return db;
    }

    private ISQLObjectNameHelper getSQLObjectNameHelper(Database database) {
        ISQLObjectNameHelper nameHelper = null;
        if (database != null) {
            String currentDBVendor = database.getVendor();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint nameHandlerExtensionPoint = extensionRegistry.getExtensionPoint(SQL_OBJECT_NAME_HELPER);
            if (nameHandlerExtensionPoint != null) {
                IExtension[] nameHandlerExtensions = nameHandlerExtensionPoint.getExtensions();
                int i = 0;
                while (i < nameHandlerExtensions.length && nameHelper == null) {
                    IExtension ext = nameHandlerExtensions[i];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length && nameHelper == null) {
                        String extVendor = configElements[j].getAttribute(SQL_OBJECT_NAME_HELPER_DBTYPE);
                        if (currentDBVendor.equalsIgnoreCase(extVendor)) {
                            try {
                                Object executableExtension = configElements[j].createExecutableExtension(SQL_OBJECT_NAME_HELPER_CLASS);
                                if (executableExtension instanceof ISQLObjectNameHelper) {
                                    nameHelper = (ISQLObjectNameHelper)executableExtension;
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return nameHelper;
    }

    protected int getLastLineLength(StringBuffer sb) {
        int lastIndexOfLineBreak = sb.lastIndexOf(NEW_LINE_STRING);
        int lastLineLength = 0;
        lastLineLength = lastIndexOfLineBreak == -1 ? sb.length() : sb.length() - lastIndexOfLineBreak - 1;
        return lastLineLength;
    }

    protected Method getSpecificAppendSQLMethod(Class sourceWriterClass, SQLObject sqlObject) throws NoSuchMethodException {
        Class<?> sqlObjectClass;
        if (sqlObject == null) {
            return null;
        }
        String interfaceName = null;
        Method appendSQL = null;
        Class<?> sqlObjectInterfaceClass = sqlObjectClass = sqlObject.getClass();
        if (sqlObjectClass.getName().endsWith("Impl")) {
            interfaceName = SQLQuerySourceWriter.getInterfaceName(sqlObject.getClass());
            Class<?>[] sqlObjectInterfaces = sqlObjectClass.getInterfaces();
            int i = 0;
            while (i < sqlObjectInterfaces.length) {
                Class<?> interfaceClass = sqlObjectClass.getInterfaces()[i];
                if (interfaceClass.getName().equals(interfaceName)) {
                    sqlObjectInterfaceClass = interfaceClass;
                    break;
                }
                ++i;
            }
        }
        appendSQL = SQLQuerySourceWriter.getSpecificAppendSQLMethod(sourceWriterClass, sqlObjectInterfaceClass);
        return appendSQL;
    }

    protected Method getSpecificAppendSQLMethod(SQLObject sqlObject) throws NoSuchMethodException {
        return this.getSpecificAppendSQLMethod(this.getClass(), sqlObject);
    }

    protected void indentOnNewLine(StringBuffer sb, int indent) {
        int lastLineLength = this.getLastLineLength(sb);
        if (this.isLastLineEmpty(sb)) {
            if (lastLineLength > indent) {
                int hangOver = lastLineLength - indent;
                sb.delete(sb.length() - hangOver, sb.length());
            } else {
                this.appendSpace(sb, indent - lastLineLength);
            }
        } else {
            this.appendNewLine(sb);
            this.appendSpace(sb, indent);
        }
    }

    protected void indentSQL(StringBuffer sql, int indent) {
        String newLine = NEW_LINE_STRING;
        StringBuffer indentWhiteSpace = new StringBuffer(indent);
        this.appendSpace(indentWhiteSpace, indent);
        int i = sql.indexOf(newLine, 0);
        while (i > 0) {
            sql.insert(i + 1, indentWhiteSpace);
            i = sql.indexOf(newLine, i + 1);
        }
    }

    protected void indentSQLToLastLineLengthOfContainer(StringBuffer subcomponentToIndent, StringBuffer container) {
        String newLine = NEW_LINE_STRING;
        int indentLength = this.getLastLineLength(container);
        StringBuffer indent = new StringBuffer(indentLength);
        this.appendSpace(indent, indentLength);
        int i = subcomponentToIndent.indexOf(newLine, 0);
        while (i > 0) {
            subcomponentToIndent.insert(i + 1, indent);
            i = subcomponentToIndent.indexOf(newLine, i + 1);
        }
    }

    protected boolean isLastLineEmpty(StringBuffer sb) {
        boolean isLastLineEmpty = true;
        int lastIndexOfLineBreak = sb.lastIndexOf(NEW_LINE_STRING);
        int i = lastIndexOfLineBreak + 1;
        while (i < sb.length()) {
            if (sb.charAt(i) != ' ') {
                isLastLineEmpty = false;
                break;
            }
            ++i;
        }
        return isLastLineEmpty;
    }

    protected boolean isQualifiedColumnNameRequired(ValueExpressionColumn column) {
        boolean shouldQualify = false;
        QuerySelect colRefSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)column, QuerySelect.class);
        if (colRefSelect != null) {
            TableExpression colTableExpr;
            QuerySelect superSelect;
            if (!shouldQualify && this.alwaysQualifyColumnNamesForMultipleTables) {
                List fromTables = StatementHelper.getTableExpressionsInQuerySelect(colRefSelect);
                if (fromTables != null && fromTables.size() > 1) {
                    shouldQualify = true;
                }
                if (!shouldQualify && this.qualifyColumnNamesInSubqueriesWhenQualifiedInSuperQuery) {
                    QuerySelect subSelect = colRefSelect;
                    QuerySelect superSelect2 = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)subSelect, QuerySelect.class);
                    while (!shouldQualify && superSelect2 != null) {
                        fromTables = StatementHelper.getTableExpressionsInQuerySelect(superSelect2);
                        if (fromTables != null && fromTables.size() > 1) {
                            shouldQualify = true;
                        }
                        subSelect = superSelect2;
                        superSelect2 = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)subSelect, QuerySelect.class);
                    }
                }
            }
            if (!shouldQualify && this.alwaysQualifyColumnNamesForSubqueries && (superSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)colRefSelect, QuerySelect.class)) != null) {
                shouldQualify = true;
            }
            if (!shouldQualify && this.alwaysQualifyColumnNamesReferencedInSubqueries && (colTableExpr = column.getTableExpr()) != colRefSelect) {
                QuerySelect tableSelect = StatementHelper.getQuerySelectForTableReference(colTableExpr);
                if (colRefSelect != null && tableSelect != colRefSelect) {
                    shouldQualify = true;
                }
            }
        }
        if (!shouldQualify) {
            shouldQualify = StatementHelper.isColumnNameAmbiguous(column);
        }
        return shouldQualify;
    }

    protected void setIndentUnitSize(int size) {
        this.indentUnitSize = size;
    }

    protected void trimWhiteSpace(StringBuffer toBeTrimmed) {
        StringBuffer trimmed = new StringBuffer();
        int lastChar = 32;
        int i = 0;
        while (i < toBeTrimmed.length()) {
            char currentChar = toBeTrimmed.charAt(i);
            if (currentChar == '\n') {
                if (lastChar != 32) {
                    trimmed.append(' ');
                    lastChar = 32;
                }
            } else if (currentChar != ' ' || lastChar != 32) {
                trimmed.append(currentChar);
                lastChar = currentChar;
            }
            ++i;
        }
        toBeTrimmed.replace(0, toBeTrimmed.length(), trimmed.toString());
    }

    protected void wrapSQL(OrderBySpecification orderBySpec, StringBuffer toWrapUp) {
        if (orderBySpec != null) {
            NullOrderingType nullOrderingType;
            OrderingSpecType orderingSpecType = orderBySpec.getOrderingSpecOption();
            if (orderingSpecType != OrderingSpecType.NONE_LITERAL) {
                this.appendSpace(toWrapUp);
                this.appendSpecificSQL(orderingSpecType, toWrapUp);
            }
            if ((nullOrderingType = orderBySpec.getNullOrderingOption()) != NullOrderingType.NONE_LITERAL) {
                this.appendSpace(toWrapUp);
                this.appendSpecificSQL(nullOrderingType, toWrapUp);
            }
        }
    }

    protected void wrapSQL(Predicate pred, StringBuffer toWrapUp) {
        if (pred != null) {
            if (pred.isNegatedPredicate()) {
                StringBuffer prefix = new StringBuffer(4);
                this.appendOperator(prefix, NOT);
                this.appendSpace(prefix);
                this.indentSQLToLastLineLengthOfContainer(toWrapUp, prefix);
                toWrapUp.insert(0, prefix);
            }
            this.wrapSQL((QuerySearchCondition)pred, toWrapUp);
        }
    }

    protected void wrapSQL(QuerySearchCondition cond, StringBuffer toWrapUp) {
        if (cond != null && cond.isNegatedCondition()) {
            StringBuffer prefix = new StringBuffer(4);
            this.appendOperator(prefix, NOT);
            this.appendSpace(prefix);
            this.appendSymbol(prefix, '(');
            this.indentSQLToLastLineLengthOfContainer(toWrapUp, prefix);
            toWrapUp.insert(0, prefix);
            this.appendSymbol(toWrapUp, ')');
        }
    }

    protected void wrapSQL(QueryValueExpression expr, StringBuffer toWrapUp) {
        ValueExpressionUnaryOperator unaryOp;
        if (expr != null && (unaryOp = expr.getUnaryOperator()) != null) {
            StringBuffer prefix = new StringBuffer();
            this.appendSpecificSQL(unaryOp, prefix);
            this.indentSQLToLastLineLengthOfContainer(toWrapUp, prefix);
            toWrapUp.insert(0, prefix);
        }
    }

    protected void appendSpecificSQL(ApproximateNumericDataType approxNumericDataType, StringBuffer sb) {
        if (approxNumericDataType != null) {
            String typeName = approxNumericDataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendKeyword(sb, typeName);
            } else {
                PrimitiveType primitiveType = approxNumericDataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
            if (approxNumericDataType.getPrecision() != 0) {
                this.appendSpace(sb);
                this.appendSymbol(sb, '(');
                this.appendInt(sb, approxNumericDataType.getPrecision());
                this.appendSymbol(sb, ')');
            }
        }
    }

    protected void appendSpecificSQL(ArrayDataType arrayDataType, StringBuffer sb) {
        if (arrayDataType != null) {
            DataType dataType;
            ElementType elementType = arrayDataType.getElementType();
            if (elementType != null && (dataType = elementType.getDataType()) != null) {
                this.appendSQL((SQLObject)dataType, sb);
            }
            this.appendSpace(sb);
            this.appendKeyword(sb, ARRAY);
            if (arrayDataType.getMaxCardinality() != 0) {
                this.appendSymbol(sb, '[');
                this.appendInt(sb, arrayDataType.getMaxCardinality());
                this.appendSymbol(sb, ']');
            }
        }
    }

    protected void appendSpecificSQL(BinaryStringDataType binaryDataType, StringBuffer sb) {
        if (binaryDataType != null) {
            Object typeName = binaryDataType.getName();
            int parenLoc = ((String)typeName).indexOf(40);
            if (parenLoc > 0) {
                StringBuffer lengthSB = new StringBuffer();
                if (binaryDataType.getLength() > 0) {
                    if (binaryDataType.getPrimitiveType() == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL) {
                        this.appendSQLForLargeObjectSize(binaryDataType.getLength(), lengthSB);
                    } else {
                        this.appendInt(lengthSB, binaryDataType.getLength());
                    }
                }
                String dataTypeLen = lengthSB.toString();
                typeName = ((String)typeName).substring(0, parenLoc + 1) + dataTypeLen + ((String)typeName).substring(parenLoc + 1);
                this.appendKeyword(sb, (String)typeName);
            } else {
                if (typeName != null && ((String)typeName).length() > 0) {
                    this.appendKeyword(sb, (String)typeName);
                } else {
                    PrimitiveType primitiveType = binaryDataType.getPrimitiveType();
                    this.appendSpecificSQL(primitiveType, sb);
                }
                int dataTypeLen = binaryDataType.getLength();
                if (dataTypeLen > 0) {
                    this.appendSymbol(sb, '(');
                    if (binaryDataType.getPrimitiveType() == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL) {
                        this.appendSQLForLargeObjectSize(dataTypeLen, sb);
                    } else {
                        this.appendInt(sb, dataTypeLen);
                    }
                    this.appendSymbol(sb, ')');
                }
            }
        }
    }

    protected void appendSpecificSQL(CallStatement callStmt, StringBuffer sb) {
        if (callStmt != null) {
            this.appendKeyword(sb, CALL);
            this.appendSpace(sb);
            ProcedureReference ref = callStmt.getProcedureRef();
            this.appendSpecificSQL(ref, sb);
            this.appendSpace(sb);
            this.appendSymbol(sb, '(');
            EList argList = callStmt.getArgumentList();
            this.appendSQLForSQLObjectList((List)argList, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(CharacterStringDataType charDataType, StringBuffer sb) {
        if (charDataType != null) {
            String typeName = charDataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendKeyword(sb, typeName);
            } else {
                PrimitiveType primitiveType = charDataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
            if (charDataType.getLength() > 0) {
                this.appendSpace(sb);
                this.appendSymbol(sb, '(');
                if (charDataType.getPrimitiveType() == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL || charDataType.getPrimitiveType() == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL) {
                    this.appendSQLForLargeObjectSize(charDataType.getLength(), sb);
                } else {
                    this.appendInt(sb, charDataType.getLength());
                }
                this.appendSymbol(sb, ')');
            }
        }
    }

    protected void appendSpecificSQL(ColumnName colName, StringBuffer sb) {
        if (colName != null) {
            String colNameStr = colName.getName();
            String sqlFormatName = this.convertCatalogIdentifierToSQLFormat(colNameStr, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sb, sqlFormatName);
        }
    }

    protected void appendSpecificSQL(DateDataType dateDataType, StringBuffer sb) {
        if (dateDataType != null) {
            String typeName = dateDataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendDataTypeName(sb, typeName);
            } else {
                PrimitiveType primitiveType = dateDataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
        }
    }

    protected void appendSpecificSQL(DistinctUserDefinedType distinctType, StringBuffer sb) {
        if (distinctType != null) {
            char delimChar = this.getDelimitedIdentifierQuote();
            Schema schema = distinctType.getSchema();
            if (schema != null && schema.getName() != null && schema.getName().length() > 0) {
                String schemaName = schema.getName();
                String sqlFormatSchemaName = this.convertCatalogIdentifierToSQLFormat(schemaName, delimChar);
                this.appendIdentifier(sb, sqlFormatSchemaName);
                this.appendSymbol(sb, '.');
            }
            String typeName = distinctType.getName();
            String sqlFormatTypeName = this.convertCatalogIdentifierToSQLFormat(typeName, delimChar);
            this.appendDataTypeName(sb, sqlFormatTypeName);
        }
    }

    protected void appendSpecificSQL(FixedPrecisionDataType fixedPrecDataType, StringBuffer sb) {
        if (fixedPrecDataType != null) {
            String typeName = fixedPrecDataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendKeyword(sb, typeName);
            } else {
                PrimitiveType primitiveType = fixedPrecDataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
            if (fixedPrecDataType.getPrecision() != 0) {
                this.appendSpace(sb);
                this.appendSymbol(sb, '(');
                this.appendInt(sb, fixedPrecDataType.getPrecision());
                if (fixedPrecDataType.getScale() != 0) {
                    this.appendSymbol(sb, ',');
                    this.appendInt(sb, fixedPrecDataType.getScale());
                }
                this.appendSymbol(sb, ')');
            }
        }
    }

    protected void appendSpecificSQL(GroupingExpression groupingExpr, StringBuffer sb) {
        if (groupingExpr != null) {
            QueryValueExpression valExpr = groupingExpr.getValueExpr();
            this.appendSQL(valExpr, sb);
        }
    }

    protected void appendSpecificSQL(GroupingSets groupingSets, StringBuffer sb) {
        if (groupingSets != null) {
            this.appendKeyword(sb, GROUPING_SETS);
            this.appendSpace(sb);
            this.appendSymbol(sb, '(');
            EList groupingSetsElementList = groupingSets.getGroupingSetsElementList();
            this.appendSQLForSQLObjectList((List)groupingSetsElementList, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(GroupingSetsElementExpression groupingSetsElementExpr, StringBuffer sb) {
        if (groupingSetsElementExpr != null) {
            Grouping grouping = groupingSetsElementExpr.getGrouping();
            this.appendSQL(grouping, sb);
        }
    }

    protected void appendSpecificSQL(GroupingSetsElementSublist groupingSetsSublist, StringBuffer sb) {
        if (groupingSetsSublist != null) {
            this.appendSymbol(sb, '(');
            EList groupingSetsElementExprList = groupingSetsSublist.getGroupingSetsElementExprList();
            this.appendSQLForSQLObjectList((List)groupingSetsElementExprList, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(IntegerDataType intDataType, StringBuffer sb) {
        if (intDataType != null) {
            String typeName = intDataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendKeyword(sb, typeName);
            } else {
                PrimitiveType primitiveType = intDataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
        }
    }

    protected void appendSpecificSQL(MergeInsertSpecification mergeInsertSpec, StringBuffer sb) {
        if (mergeInsertSpec != null) {
            this.appendKeyword(sb, WHEN);
            this.appendSpace(sb);
            this.appendKeyword(sb, NOT);
            this.appendSpace(sb);
            this.appendKeyword(sb, MATCHED);
            this.appendSpace(sb);
            this.appendKeyword(sb, THEN);
            this.appendNewLine(sb);
            this.appendIndent(sb);
            this.appendKeyword(sb, INSERT);
            this.appendSpace(sb);
            this.appendSymbol(sb, '(');
            EList targetColList = mergeInsertSpec.getTargetColumnList();
            this.appendSQLForSQLObjectList((List)targetColList, sb);
            this.appendSymbol(sb, ')');
            this.appendNewLine(sb);
            this.appendIndent(sb);
            this.appendKeyword(sb, VALUES);
            this.appendSpace(sb);
            ValuesRow sourceValuesRow = mergeInsertSpec.getSourceValuesRow();
            this.appendSQL(sourceValuesRow, sb);
        }
    }

    protected void appendSpecificSQL(MergeOnCondition mergeOnCondition, StringBuffer sb) {
        if (mergeOnCondition != null) {
            QuerySearchCondition searchCond = mergeOnCondition.getSearchCondition();
            this.appendSQL(searchCond, sb);
        }
    }

    protected void appendSpecificSQL(MergeSourceTable mergeSourceTable, StringBuffer sb) {
        if (mergeSourceTable != null) {
            TableReference tableRef = mergeSourceTable.getTableRef();
            if (tableRef instanceof QueryExpressionBody) {
                this.appendNewLine(sb);
                this.appendIndent(sb);
            }
            this.appendSQLForTableExpression(tableRef, sb);
        }
    }

    protected void appendSpecificSQL(MergeTargetTable mergeTargetTable, StringBuffer sb) {
        if (mergeTargetTable != null) {
            TableExpression tableExpr = mergeTargetTable.getTableExpr();
            this.appendSQL(tableExpr, sb);
        }
    }

    protected void appendSpecificSQL(MergeUpdateSpecification mergeUpdateSpec, StringBuffer sb) {
        if (mergeUpdateSpec != null) {
            this.appendKeyword(sb, WHEN);
            this.appendSpace(sb);
            this.appendKeyword(sb, MATCHED);
            this.appendSpace(sb);
            this.appendKeyword(sb, THEN);
            this.appendNewLine(sb);
            this.appendIndent(sb);
            this.appendKeyword(sb, UPDATE);
            this.appendSpace(sb);
            this.appendKeyword(sb, SET);
            EList assignExprList = mergeUpdateSpec.getAssignementExprList();
            Iterator assignExprListIter = assignExprList.iterator();
            while (assignExprListIter.hasNext()) {
                UpdateAssignmentExpression assignExpr = (UpdateAssignmentExpression)assignExprListIter.next();
                this.appendNewLine(sb);
                this.appendIndent(sb, 2);
                this.appendSQL(assignExpr, sb);
                if (!assignExprListIter.hasNext()) continue;
                this.appendSymbol(sb, ',');
            }
        }
    }

    protected void appendSpecificSQL(MultisetDataType multisetDataType, StringBuffer sb) {
        if (multisetDataType != null) {
            DataType dataType;
            ElementType elementType = multisetDataType.getElementType();
            if (elementType != null && (dataType = elementType.getDataType()) != null) {
                this.appendSQL((SQLObject)dataType, sb);
            }
            this.appendSpace(sb);
            this.appendKeyword(sb, MULTISET);
        }
    }

    protected void appendSpecificSQL(NullOrderingType nullOrderingType, StringBuffer sb) {
        if (nullOrderingType != null) {
            int typeVal = nullOrderingType.getValue();
            switch (typeVal) {
                case 1: {
                    this.appendKeyword(sb, NULL_ORDERING_TYPE_NULLS_FIRST);
                    break;
                }
                case 2: {
                    this.appendKeyword(sb, NULL_ORDERING_TYPE_NULLS_LAST);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(OrderByOrdinal orderByOrd, StringBuffer sb) {
        if (orderByOrd != null) {
            StringBuffer localSb = new StringBuffer();
            int ordVal = orderByOrd.getOrdinalValue();
            this.appendInt(localSb, ordVal);
            this.wrapSQL(orderByOrd, localSb);
            this.appendStringBuffer(sb, localSb);
        }
    }

    protected void appendSpecificSQL(OrderByResultColumn orderByExpr, StringBuffer sb) {
        if (orderByExpr != null && orderByExpr.getResultCol() != null) {
            StringBuffer localSB = new StringBuffer();
            ResultColumn resultColumn = orderByExpr.getResultCol();
            String resultColName = resultColumn.getName();
            if (resultColName != null) {
                String sqlFormatResultColName = this.convertCatalogIdentifierToSQLFormat(resultColName, this.getDelimitedIdentifierQuote());
                this.appendIdentifier(localSB, sqlFormatResultColName);
            } else {
                QueryValueExpression resultColValExpr = resultColumn.getValueExpr();
                String sqlFormatResultColExpr = this.getSQL(resultColValExpr);
                this.appendString(localSB, sqlFormatResultColExpr);
            }
            this.wrapSQL(orderByExpr, localSB);
            this.appendStringBuffer(sb, localSB);
        }
    }

    protected void appendSpecificSQL(OrderByValueExpression orderByExpr, StringBuffer sb) {
        if (orderByExpr != null) {
            StringBuffer localSb = new StringBuffer();
            QueryValueExpression valExpr = orderByExpr.getValueExpr();
            this.appendSQL(valExpr, localSb);
            this.wrapSQL(orderByExpr, localSb);
            this.appendStringBuffer(sb, localSb);
        }
    }

    protected void appendSpecificSQL(OrderingSpecType orderingType, StringBuffer sb) {
        if (orderingType != null) {
            int typeVal = orderingType.getValue();
            switch (typeVal) {
                case 1: {
                    this.appendKeyword(sb, "ASC");
                    break;
                }
                case 2: {
                    this.appendKeyword(sb, "DESC");
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(PredicateBasic predBasic, StringBuffer sb) {
        if (predBasic != null) {
            StringBuffer sbPred = new StringBuffer();
            QueryValueExpression leftValExpr = predBasic.getLeftValueExpr();
            if (leftValExpr != null) {
                this.appendSQL(leftValExpr, sbPred);
            }
            this.appendSpace(sbPred);
            PredicateComparisonOperator predCompOp = predBasic.getComparisonOperator();
            if (predCompOp != null) {
                this.appendSpecificSQL(predCompOp, sbPred);
            }
            this.appendSpace(sbPred);
            QueryValueExpression rightValExpr = predBasic.getRightValueExpr();
            if (rightValExpr != null) {
                this.appendSQL(rightValExpr, sbPred);
            }
            if (predBasic.isHasSelectivity()) {
                this.appendSpace(sbPred);
                this.appendKeyword(sbPred, SELECTIVITY);
                this.appendSpace(sbPred);
                Integer predSelVal = predBasic.getSelectivityValue();
                int predSelValInt = predSelVal;
                this.appendInt(sbPred, predSelValInt);
            }
            this.wrapSQL(predBasic, sbPred);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateBetween predBetween, StringBuffer sb) {
        if (predBetween != null) {
            StringBuffer sbPred = new StringBuffer();
            if (predBetween.isNotBetween()) {
                this.appendOperator(sbPred, NOT);
                this.appendSpace(sbPred);
            }
            QueryValueExpression leftValExpr = predBetween.getLeftValueExpr();
            this.appendSQL(leftValExpr, sbPred);
            this.appendSpace(sbPred);
            this.appendKeyword(sbPred, BETWEEN);
            this.appendSpace(sbPred);
            QueryValueExpression rightValExpr1 = predBetween.getRightValueExpr1();
            this.appendSQL(rightValExpr1, sbPred);
            this.appendSpace(sbPred);
            this.appendOperator(sbPred, AND);
            this.appendSpace(sbPred);
            QueryValueExpression rightValExpr2 = predBetween.getRightValueExpr2();
            this.appendSQL(rightValExpr2, sbPred);
            this.wrapSQL(predBetween, sbPred);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateComparisonOperator compOp, StringBuffer sb) {
        if (compOp != null) {
            int compOpVal = compOp.getValue();
            switch (compOpVal) {
                case 0: {
                    this.appendOperator(sb, EQUAL);
                    break;
                }
                case 1: {
                    this.appendOperator(sb, NOT_EQUAL);
                    break;
                }
                case 2: {
                    this.appendOperator(sb, LESS_THAN);
                    break;
                }
                case 3: {
                    this.appendOperator(sb, GREATER_THAN);
                    break;
                }
                case 4: {
                    this.appendOperator(sb, LESS_THAN_OR_EQUAL);
                    break;
                }
                case 5: {
                    this.appendOperator(sb, GREATER_THAN_OR_EQUAL);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(PredicateExists predExists, StringBuffer sb) {
        if (predExists != null) {
            StringBuffer sbPred = new StringBuffer();
            this.appendKeyword(sbPred, EXISTS);
            this.appendSpace(sbPred);
            this.appendSymbol(sbPred, '(');
            QueryExpressionBody queryExpr = predExists.getQueryExpr();
            this.appendSQL(queryExpr, sbPred);
            this.appendSymbol(sbPred, ')');
            this.wrapSQL(predExists, sbPred);
            this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateInValueList predInValueList, StringBuffer sb) {
        if (predInValueList != null) {
            StringBuffer sbPred = new StringBuffer();
            QueryValueExpression valExpr = predInValueList.getValueExpr();
            this.appendSQL(valExpr, sbPred);
            this.appendSpace(sbPred);
            if (predInValueList.isNotIn()) {
                this.appendKeyword(sbPred, NOT);
                this.appendSpace(sbPred);
            }
            this.appendKeyword(sbPred, IN);
            this.appendSpace(sbPred);
            EList valExprList = predInValueList.getValueExprList();
            if (valExprList != null) {
                this.appendSymbol(sbPred, '(');
                this.appendSQLForSQLObjectList((List)valExprList, sbPred);
                this.appendSymbol(sbPred, ')');
            }
            this.wrapSQL(predInValueList, sbPred);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateInValueRowSelect predInValRowSelect, StringBuffer sb) {
        if (predInValRowSelect != null) {
            StringBuffer sbPred = new StringBuffer();
            EList valExprList = predInValRowSelect.getValueExprList();
            if (valExprList != null) {
                this.appendSymbol(sbPred, '(');
                this.appendSQLForSQLObjectList((List)valExprList, sbPred);
                this.appendSymbol(sbPred, ')');
            }
            this.appendSpace(sbPred);
            if (predInValRowSelect.isNotIn()) {
                this.appendKeyword(sbPred, NOT);
                this.appendSpace(sbPred);
            }
            this.appendKeyword(sbPred, IN);
            this.appendSpace(sbPred);
            QueryExpressionRoot queryExpr = predInValRowSelect.getQueryExpr();
            if (queryExpr != null) {
                this.appendSymbol(sbPred, '(');
                this.appendSQL(queryExpr, sbPred);
                this.appendSymbol(sbPred, ')');
            }
            this.wrapSQL(predInValRowSelect, sbPred);
            this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateInValueSelect predInValSelect, StringBuffer sb) {
        if (predInValSelect != null) {
            StringBuffer sbPred = new StringBuffer();
            QueryValueExpression valExpr = predInValSelect.getValueExpr();
            this.appendSQL(valExpr, sbPred);
            this.appendSpace(sbPred);
            if (predInValSelect.isNotIn()) {
                this.appendKeyword(sbPred, NOT);
                this.appendSpace(sbPred);
            }
            this.appendKeyword(sbPred, IN);
            this.appendSpace(sbPred);
            QueryExpressionRoot queryExpr = predInValSelect.getQueryExpr();
            if (queryExpr != null) {
                this.appendSymbol(sbPred, '(');
                this.appendSQL(queryExpr, sbPred);
                this.appendSymbol(sbPred, ')');
            }
            this.wrapSQL(predInValSelect, sbPred);
            this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateIsNull predNull, StringBuffer sb) {
        if (predNull != null) {
            StringBuffer sbPred = new StringBuffer();
            QueryValueExpression valExpr = predNull.getValueExpr();
            this.appendSQL(valExpr, sbPred);
            this.appendSpace(sbPred);
            this.appendKeyword(sbPred, IS);
            this.appendSpace(sbPred);
            if (predNull.isNotNull()) {
                this.appendKeyword(sbPred, NOT);
                this.appendSpace(sbPred);
            }
            this.appendKeyword(sbPred, NULL);
            this.wrapSQL(predNull, sbPred);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateLike predLike, StringBuffer sb) {
        if (predLike != null) {
            StringBuffer sbPred = new StringBuffer();
            QueryValueExpression matchingValExpr = predLike.getMatchingValueExpr();
            this.appendSQL(matchingValExpr, sbPred);
            this.appendSpace(sbPred);
            if (predLike.isNotLike()) {
                this.appendKeyword(sbPred, NOT);
                this.appendSpace(sbPred);
            }
            this.appendKeyword(sbPred, LIKE);
            this.appendSpace(sbPred);
            QueryValueExpression patternValExpr = predLike.getPatternValueExpr();
            this.appendSQL(patternValExpr, sbPred);
            QueryValueExpression escapeValExpr = predLike.getEscapeValueExpr();
            if (escapeValExpr != null) {
                this.appendSpace(sbPred);
                this.appendKeyword(sbPred, ESCAPE);
                this.appendSpace(sbPred);
                this.appendSQL(escapeValExpr, sbPred);
            }
            this.wrapSQL(predLike, sbPred);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateQuantifiedRowSelect predQuantifiedRowSelect, StringBuffer sb) {
        if (predQuantifiedRowSelect != null) {
            StringBuffer sbPred = new StringBuffer();
            this.appendSymbol(sbPred, '(');
            EList valExprList = predQuantifiedRowSelect.getValueExprList();
            this.appendSQLForSQLObjectList((List)valExprList, sbPred);
            this.appendSymbol(sbPred, ')');
            this.appendSpace(sbPred);
            this.appendOperator(sbPred, EQUAL);
            this.appendSpace(sbPred);
            PredicateQuantifiedType predQuantType = predQuantifiedRowSelect.getQuantifiedType();
            this.appendSpecificSQL(predQuantType, sbPred);
            this.appendSpace(sbPred);
            QueryExpressionRoot queryExpr = predQuantifiedRowSelect.getQueryExpr();
            if (queryExpr != null) {
                this.appendSymbol(sbPred, '(');
                this.appendSQL(queryExpr, sbPred);
                this.appendSymbol(sbPred, ')');
            }
            this.wrapSQL(predQuantifiedRowSelect, sbPred);
            this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PredicateQuantifiedType predQuantifiedType, StringBuffer sb) {
        if (predQuantifiedType != null) {
            int quantifiedTypeVal = predQuantifiedType.getValue();
            switch (quantifiedTypeVal) {
                case 2: {
                    this.appendKeyword(sb, ALL);
                    break;
                }
                case 1: {
                    this.appendKeyword(sb, ANY);
                    break;
                }
                case 0: {
                    this.appendKeyword(sb, SOME);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(PredicateQuantifiedValueSelect predQuantifiedValSelect, StringBuffer sb) {
        if (predQuantifiedValSelect != null) {
            StringBuffer sbPred = new StringBuffer();
            QueryValueExpression valExpr = predQuantifiedValSelect.getValueExpr();
            this.appendSQL(valExpr, sbPred);
            this.appendSpace(sbPred);
            PredicateComparisonOperator compOp = predQuantifiedValSelect.getComparisonOperator();
            this.appendSpecificSQL(compOp, sbPred);
            this.appendSpace(sbPred);
            PredicateQuantifiedType quantType = predQuantifiedValSelect.getQuantifiedType();
            this.appendSpecificSQL(quantType, sbPred);
            this.appendSpace(sbPred);
            QueryExpressionRoot queryExpr = predQuantifiedValSelect.getQueryExpr();
            if (queryExpr != null) {
                this.appendSymbol(sbPred, '(');
                this.appendSQL(queryExpr, sbPred);
                this.appendSymbol(sbPred, ')');
            }
            this.wrapSQL(predQuantifiedValSelect, sbPred);
            this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
            this.appendStringBuffer(sb, sbPred);
        }
    }

    protected void appendSpecificSQL(PrimitiveType primitiveType, StringBuffer sb) {
        if (primitiveType != null) {
            String typeName = DataTypeHelper.getPrimitiveTypeName(primitiveType);
            this.appendDataTypeName(sb, typeName);
        }
    }

    protected void appendSpecificSQL(ProcedureReference procRef, StringBuffer sb) {
        Procedure proc;
        if (procRef != null && (proc = procRef.getProcedure()) != null) {
            String procName;
            String schemaName = null;
            Schema schema = proc.getSchema();
            if (schema != null) {
                schemaName = schema.getName();
            }
            char quoteChar = this.getDelimitedIdentifierQuote();
            if (schemaName != null) {
                String convertedSchemaName = this.convertCatalogIdentifierToSQLFormat(schemaName, quoteChar);
                this.appendIdentifier(sb, convertedSchemaName);
                this.appendSymbol(sb, '.');
            }
            if ((procName = proc.getName()) != null) {
                String convertedProcName = this.convertCatalogIdentifierToSQLFormat(procName, quoteChar);
                this.appendIdentifier(sb, convertedProcName);
            }
        }
    }

    protected void appendSpecificSQL(QueryCombined qryComb, StringBuffer sb) {
        if (qryComb != null) {
            int rowFetchLimit;
            EList sortSpecList;
            int combinedIndent = this.getLastLineLength(sb);
            QueryExpressionBody leftQuery = qryComb.getLeftQuery();
            this.appendSQL(leftQuery, sb);
            this.appendNewLine(sb);
            this.appendSpace(sb, combinedIndent);
            QueryCombinedOperator queryCombinedOp = qryComb.getCombinedOperator();
            this.appendSpecificSQL(queryCombinedOp, sb);
            this.appendNewLine(sb);
            boolean isRightQueryNested = qryComb.getRightQuery() instanceof QueryCombined;
            if (isRightQueryNested) {
                this.appendSymbol(sb, '(');
                this.appendNewLine(sb);
                this.appendSpace(sb, 4);
            }
            this.appendSpace(sb, combinedIndent);
            QueryExpressionBody rightQuery = qryComb.getRightQuery();
            this.appendSQL(rightQuery, sb);
            if (isRightQueryNested) {
                this.appendNewLine(sb);
                this.appendSpace(sb, combinedIndent);
                this.appendSymbol(sb, ')');
            }
            if (StatementHelper.isOrderByClauseContainsValidOrderBySpecification((List)(sortSpecList = qryComb.getSortSpecList()))) {
                this.appendNewLine(sb);
                this.appendSpace(sb, combinedIndent);
                this.appendSpace(sb, 2);
                this.appendSQLForOrderByClause((List)sortSpecList, sb);
            }
            if ((rowFetchLimit = qryComb.getRowFetchLimit()) > 0) {
                this.appendSpace(sb);
                this.appendSQLForFetchFirstClause(rowFetchLimit, sb);
            }
        }
    }

    protected void appendSpecificSQL(QueryCombinedOperator op, StringBuffer sb) {
        if (op != null) {
            int opVal = op.getValue();
            switch (opVal) {
                case 0: {
                    this.appendOperator(sb, UNION);
                    break;
                }
                case 1: {
                    this.appendOperator(sb, UNION_ALL);
                    break;
                }
                case 2: {
                    this.appendOperator(sb, INTERSECT);
                    break;
                }
                case 3: {
                    this.appendOperator(sb, INTERSECT_ALL);
                    break;
                }
                case 4: {
                    this.appendOperator(sb, EXCEPT);
                    break;
                }
                case 5: {
                    this.appendOperator(sb, EXCEPT_ALL);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(QueryDeleteStatement deleteStmt, StringBuffer sb) {
        if (deleteStmt != null) {
            this.appendKeyword(sb, DELETE);
            this.appendSpace(sb);
            this.appendKeyword(sb, FROM);
            this.appendSpace(sb);
            TableInDatabase targetTable = deleteStmt.getTargetTable();
            this.appendSQL(targetTable, sb);
            this.appendNewLine(sb);
            QuerySearchCondition whereClause = deleteStmt.getWhereClause();
            if (whereClause != null) {
                this.appendSpace(sb);
                this.appendKeyword(sb, WHERE);
                this.appendSpace(sb);
                this.appendSQL(whereClause, sb);
            }
            CursorReference cursorReference = deleteStmt.getWhereCurrentOfClause();
        }
    }

    protected void appendSpecificSQL(QueryExpressionRoot qryExprRoot, StringBuffer sb) {
        if (qryExprRoot != null) {
            int withTableIndent = 2;
            EList withTableSpecList = qryExprRoot.getWithClause();
            if (withTableSpecList != null && withTableSpecList.size() > 0) {
                this.appendKeyword(sb, WITH);
                this.appendNewLine(sb);
                this.appendSpace(sb, withTableIndent);
                Iterator withIt = withTableSpecList.iterator();
                while (withIt.hasNext()) {
                    WithTableSpecification tableWith = (WithTableSpecification)withIt.next();
                    this.appendSQL(tableWith, sb);
                    if (!withIt.hasNext()) continue;
                    this.appendSymbol(sb, ',');
                    this.appendNewLine(sb);
                    this.appendSpace(sb, withTableIndent);
                }
                this.appendNewLine(sb);
            }
            QueryExpressionBody queryExpr = qryExprRoot.getQuery();
            this.appendSQL(queryExpr, sb);
        }
    }

    protected void appendSpecificSQL(QueryInsertStatement insertStmt, StringBuffer sb) {
        if (insertStmt != null) {
            QueryExpressionRoot sourceQuery;
            EList targetColList;
            this.appendKeyword(sb, INSERT);
            this.appendSpace(sb);
            this.appendKeyword(sb, INTO);
            this.appendSpace(sb);
            TableInDatabase targetTable = insertStmt.getTargetTable();
            if (targetTable != null) {
                this.appendSQL(targetTable, sb);
            }
            if ((targetColList = insertStmt.getTargetColumnList()) != null && targetColList.size() > 0) {
                this.appendSpace(sb);
                this.appendSymbol(sb, '(');
                this.appendSQLForSQLObjectList((List)targetColList, sb);
                this.appendSymbol(sb, ')');
            }
            if ((sourceQuery = insertStmt.getSourceQuery()) != null) {
                this.appendNewLine(sb);
                this.appendSpace(sb, 2);
                this.appendSQL(sourceQuery, sb);
            } else {
                this.appendNewLine(sb);
                this.appendSpace(sb, 2);
                this.appendKeyword(sb, VALUES);
                this.appendSpace(sb);
                EList sourceValRowList = insertStmt.getSourceValuesRowList();
                if (sourceValRowList != null && sourceValRowList.size() > 0) {
                    Iterator it = sourceValRowList.iterator();
                    while (it.hasNext()) {
                        ValuesRow row = (ValuesRow)it.next();
                        this.appendSQL(row, sb);
                        if (!it.hasNext()) continue;
                        this.appendSymbol(sb, ',');
                        this.appendNewLine(sb);
                        this.appendSpace(sb, 9);
                    }
                }
            }
        }
    }

    protected void appendSpecificSQL(QueryMergeStatement mergeStmt, StringBuffer sb) {
        if (mergeStmt != null) {
            this.appendKeyword(sb, MERGE);
            this.appendSpace(sb);
            this.appendKeyword(sb, INTO);
            this.appendSpace(sb);
            MergeTargetTable targetTable = mergeStmt.getTargetTable();
            this.appendSQL(targetTable, sb);
            this.appendNewLine(sb);
            this.appendKeyword(sb, USING);
            this.appendSpace(sb);
            MergeSourceTable sourceTable = mergeStmt.getSourceTable();
            this.appendNewLine(sb);
            this.appendIndent(sb);
            this.appendSQL(sourceTable, sb);
            this.appendNewLine(sb);
            this.appendKeyword(sb, ON);
            this.appendSpace(sb);
            MergeOnCondition onCondition = mergeStmt.getOnCondition();
            this.appendSQL(onCondition, sb);
            EList specOperList = mergeStmt.getOperationSpecList();
            for (MergeOperationSpecification operSpec : specOperList) {
                if (operSpec instanceof MergeUpdateSpecification) {
                    this.appendNewLine(sb);
                    MergeUpdateSpecification updateSpec = (MergeUpdateSpecification)operSpec;
                    this.appendSQL(updateSpec, sb);
                    continue;
                }
                if (!(operSpec instanceof MergeInsertSpecification)) continue;
                this.appendNewLine(sb);
                MergeInsertSpecification insertSpec = (MergeInsertSpecification)operSpec;
                this.appendSQL(insertSpec, sb);
            }
        }
    }

    protected void appendSpecificSQL(QueryNested qryNest, StringBuffer sb) {
        if (qryNest != null) {
            int rowFetchLimit;
            this.appendSymbol(sb, '(');
            QueryExpressionBody nestedQuery = qryNest.getNestedQuery();
            this.appendSQL(nestedQuery, sb);
            this.appendSymbol(sb, ')');
            EList sortSpecList = qryNest.getSortSpecList();
            if (StatementHelper.isOrderByClauseContainsValidOrderBySpecification((List)sortSpecList)) {
                this.appendNewLine(sb);
                this.appendSpace(sb, 2);
                this.appendSQLForOrderByClause((List)sortSpecList, sb);
            }
            if ((rowFetchLimit = qryNest.getRowFetchLimit()) > 0) {
                this.appendSpace(sb);
                this.appendSQLForFetchFirstClause(rowFetchLimit, sb);
            }
        }
    }

    protected void appendSpecificSQL(QuerySelect select, StringBuffer sb) {
        if (select != null) {
            EList intoClauseList;
            int rowFetchLimit;
            EList sortSpecList;
            QuerySearchCondition havingClause;
            EList groupByClauseList;
            QuerySearchCondition whereClause;
            EList selectClauseList;
            StringBuffer sbSelect = new StringBuffer();
            StringBuffer sbClauseIndent = new StringBuffer();
            int selectStartOffset = this.getLastLineLength(sb);
            String spacer4 = "    ";
            if (selectStartOffset > 20) {
                selectStartOffset = this.getLastLineIndent(sb) + 4;
                this.appendNewLine(sbSelect);
                this.appendSpace(sbSelect, selectStartOffset);
            }
            this.appendSpace(sbClauseIndent, selectStartOffset + 2);
            this.appendKeyword(sbSelect, SELECT);
            this.appendSpace(sbSelect);
            if (select.isDistinct()) {
                this.appendKeyword(sbSelect, DISTINCT);
                this.appendSpace(sbSelect);
            }
            if ((selectClauseList = select.getSelectClause()) != null && selectClauseList.size() > 0) {
                this.appendSQLForSQLObjectList((List)selectClauseList, sbSelect);
            } else {
                this.appendString(sbSelect, "*");
            }
            this.appendNewLine(sbSelect);
            this.appendStringBuffer(sbSelect, sbClauseIndent);
            this.appendKeyword(sbSelect, FROM);
            this.appendSpace(sbSelect);
            EList fromClauseList = select.getFromClause();
            if (fromClauseList != null && fromClauseList.size() > 0) {
                int lastTableStartIndex = sbSelect.length();
                Iterator fromIt = select.getFromClause().iterator();
                while (fromIt.hasNext()) {
                    TableReference tableRef = (TableReference)fromIt.next();
                    this.appendSQLForTableExpression(tableRef, sbSelect);
                    if (fromIt.hasNext()) {
                        this.appendSymbol(sbSelect, ',');
                        this.appendSpace(sbSelect);
                    }
                    if (this.getLastLineLength(sbSelect) > this.displayWidth) {
                        sbSelect.insert(lastTableStartIndex - 1, spacer4);
                        sbSelect.insert(lastTableStartIndex - 1, sbClauseIndent.toString());
                        sbSelect.insert(lastTableStartIndex - 1, '\n');
                    }
                    lastTableStartIndex = sbSelect.length();
                }
            }
            if ((whereClause = select.getWhereClause()) != null) {
                this.appendNewLine(sbSelect);
                this.appendStringBuffer(sbSelect, sbClauseIndent);
                this.appendKeyword(sbSelect, WHERE);
                this.appendSpace(sbSelect);
                this.appendSQL(whereClause, sbSelect);
            }
            if ((groupByClauseList = select.getGroupByClause()) != null && groupByClauseList.size() > 0) {
                this.appendNewLine(sbSelect);
                this.appendStringBuffer(sbSelect, sbClauseIndent);
                this.appendKeyword(sbSelect, GROUP_BY);
                this.appendSpace(sbSelect);
                this.appendSQLForSQLObjectList((List)groupByClauseList, sbSelect);
            }
            if ((havingClause = select.getHavingClause()) != null) {
                this.appendNewLine(sbSelect);
                this.appendStringBuffer(sbSelect, sbClauseIndent);
                this.appendKeyword(sbSelect, HAVING);
                this.appendSpace(sbSelect);
                this.appendSQL(havingClause, sbSelect);
            }
            if (StatementHelper.isOrderByClauseContainsValidOrderBySpecification((List)(sortSpecList = select.getSortSpecList()))) {
                this.appendNewLine(sbSelect);
                this.appendStringBuffer(sbSelect, sbClauseIndent);
                this.appendSQLForOrderByClause((List)sortSpecList, sbSelect);
            }
            if ((rowFetchLimit = select.getRowFetchLimit()) > 0) {
                this.appendNewLine(sbSelect);
                this.appendStringBuffer(sbSelect, sbClauseIndent);
                this.appendSQLForFetchFirstClause(rowFetchLimit, sbSelect);
            }
            if ((intoClauseList = select.getIntoClause()) != null) {
                intoClauseList.size();
            }
            if (!(select.eContainer() instanceof QueryExpressionRoot && select.eContainer().eContainer() instanceof QuerySelectStatement || sbSelect.length() >= 0)) {
                this.trimWhiteSpace(sbSelect);
            }
            this.appendStringBuffer(sb, sbSelect);
        }
    }

    protected void appendSpecificSQL(QuerySelectStatement selectStmt, StringBuffer sb) {
        if (selectStmt != null) {
            QueryExpressionRoot queryExpr = selectStmt.getQueryExpr();
            if (queryExpr != null) {
                UpdatabilityExpression updatabilityExpr;
                this.appendSQL(queryExpr, sb);
                EList orderByClause = selectStmt.getOrderByClause();
                if (StatementHelper.isOrderByClauseContainsValidOrderBySpecification((List)orderByClause)) {
                    this.appendNewLine(sb);
                    this.appendSpace(sb, 2);
                    this.appendSQLForOrderByClause((List)orderByClause, sb);
                }
                if ((updatabilityExpr = selectStmt.getUpdatabilityExpr()) != null) {
                    this.appendNewLine(sb);
                    this.appendSpace(sb, 2);
                    this.appendSQL(updatabilityExpr, sb);
                }
            } else {
                this.appendString(sb, DEFAULT_STMT_SELECT);
            }
            this.appendNewLine(sb);
        }
    }

    protected void appendSpecificSQL(QueryUpdateStatement updateStmt, StringBuffer sb) {
        if (updateStmt != null) {
            int clauseIndent = 2;
            this.appendKeyword(sb, UPDATE);
            this.appendSpace(sb);
            TableInDatabase targTable = updateStmt.getTargetTable();
            this.appendSQL(targTable, sb);
            this.appendNewLine(sb);
            this.appendSpace(sb, clauseIndent);
            if (!updateStmt.getAssignmentClause().isEmpty()) {
                this.appendKeyword(sb, SET);
                this.appendSpace(sb);
                Iterator it = updateStmt.getAssignmentClause().iterator();
                while (it.hasNext()) {
                    UpdateAssignmentExpression assignExpr = (UpdateAssignmentExpression)it.next();
                    this.appendSQL(assignExpr, sb);
                    if (!it.hasNext()) continue;
                    this.appendSymbol(sb, ',');
                    if (this.getLastLineLength(sb) > 60) {
                        this.appendNewLine(sb);
                        this.appendSpace(sb, clauseIndent + 4);
                        continue;
                    }
                    this.appendSpace(sb);
                }
            }
            if (updateStmt.getWhereClause() != null) {
                this.appendNewLine(sb);
                this.appendSpace(sb, clauseIndent);
                this.appendKeyword(sb, WHERE);
                this.appendSpace(sb);
                QuerySearchCondition whereClause = updateStmt.getWhereClause();
                this.appendSQL(whereClause, sb);
            }
            updateStmt.getWhereCurrentOfClause();
        }
    }

    protected void appendSpecificSQL(QueryValues queryValues, StringBuffer sb) {
        if (queryValues != null) {
            int rowFetchLimit;
            StringBuffer sbValues = new StringBuffer();
            int valuesStartOffset = this.getLastLineLength(sb);
            if (valuesStartOffset > 20) {
                valuesStartOffset = this.getLastLineIndent(sb) + 4;
                this.appendNewLine(sbValues);
                this.appendSpace(sbValues, valuesStartOffset);
            }
            this.appendKeyword(sbValues, VALUES);
            this.appendSpace(sbValues);
            EList valuesRowList = queryValues.getValuesRowList();
            this.appendSQLForSQLObjectList((List)valuesRowList, sbValues);
            EList sortSpecList = queryValues.getSortSpecList();
            if (StatementHelper.isOrderByClauseContainsValidOrderBySpecification((List)sortSpecList)) {
                this.appendSpace(sbValues);
                this.appendSQLForOrderByClause((List)sortSpecList, sbValues);
            }
            if ((rowFetchLimit = queryValues.getRowFetchLimit()) > 0) {
                this.appendSpace(sbValues);
                this.appendSQLForFetchFirstClause(rowFetchLimit, sbValues);
            }
            if (sb.length() > 0 && sbValues.length() < this.displayWidth) {
                this.trimWhiteSpace(sbValues);
            }
            this.appendStringBuffer(sb, sbValues);
        }
    }

    protected void appendSpecificSQL(ResultColumn resultCol, StringBuffer sb) {
        if (resultCol != null) {
            QueryValueExpression resultColValExpr = resultCol.getValueExpr();
            this.appendSQL(resultColValExpr, sb);
            String resultColName = resultCol.getName();
            if (resultColName != null && resultColName.trim().length() > 0) {
                this.appendSpace(sb);
                this.appendKeyword(sb, AS);
                this.appendSpace(sb);
                String sqlFormatResultColName = this.convertCatalogIdentifierToSQLFormat(resultColName, this.getDelimitedIdentifierQuote());
                this.appendIdentifier(sb, sqlFormatResultColName);
            }
        }
    }

    protected void appendSpecificSQL(ResultTableAllColumns resultAllCols, StringBuffer sb) {
        if (resultAllCols != null) {
            boolean haveName = false;
            TableExpression tableExpr = resultAllCols.getTableExpr();
            if (tableExpr != null) {
                TableCorrelation tableCor = tableExpr.getTableCorrelation();
                if (tableCor != null && tableCor.getName() != null && tableCor.getName().trim().length() > 0) {
                    String tableCorrName = tableCor.getName();
                    tableCorrName = this.convertCatalogIdentifierToSQLFormat(tableCorrName, this.getDelimitedIdentifierQuote());
                    this.appendIdentifier(sb, tableCorrName);
                    haveName = true;
                } else if (tableExpr instanceof TableInDatabase) {
                    TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                    this.appendSQLForTableExpression(tableInDB, sb);
                    haveName = true;
                } else {
                    String tableExprName = tableExpr.getName();
                    if (tableExprName != null && tableExprName.trim().length() > 0) {
                        this.appendIdentifier(sb, tableExprName);
                        haveName = true;
                    }
                }
            } else {
                String allColsName = resultAllCols.getName();
                if (allColsName != null && allColsName.length() > 0) {
                    this.appendIdentifier(sb, allColsName);
                    haveName = true;
                }
            }
            if (haveName) {
                this.appendSymbol(sb, '.');
                this.appendString(sb, "*");
            }
        }
    }

    protected void appendSpecificSQL(SearchConditionCombined condCombined, StringBuffer sb) {
        if (condCombined != null) {
            QuerySearchCondition rightCond;
            StringBuffer sbCond = new StringBuffer();
            StringBuffer sbRightCond = new StringBuffer();
            QuerySearchCondition leftCond = condCombined.getLeftCondition();
            if (leftCond != null) {
                this.appendSQL(leftCond, sbCond);
            }
            if ((rightCond = condCombined.getRightCondition()) != null) {
                this.appendSQL(rightCond, sbRightCond);
            }
            int currentLineLength = sbCond.length() - sbCond.lastIndexOf(NEW_LINE_STRING);
            int prospectiveNewLineLength = currentLineLength + sbRightCond.length();
            if (currentLineLength > this.displayWidth || prospectiveNewLineLength > this.displayWidth) {
                this.appendNewLine(sbCond);
                this.appendSpace(sbCond, 4);
            } else {
                this.appendSpace(sbCond);
            }
            SearchConditionCombinedOperator combinedOp = condCombined.getCombinedOperator();
            this.appendSpecificSQL(combinedOp, sbCond);
            this.appendSpace(sbCond);
            this.appendStringBuffer(sbCond, sbRightCond);
            this.wrapSQL(condCombined, sbCond);
            this.appendStringBuffer(sb, sbCond);
        }
    }

    protected void appendSpecificSQL(SearchConditionCombinedOperator op, StringBuffer sb) {
        if (op != null) {
            int opVal = op.getValue();
            switch (opVal) {
                case 0: {
                    this.appendOperator(sb, AND);
                    break;
                }
                case 1: {
                    this.appendOperator(sb, OR);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(SearchConditionNested condNest, StringBuffer sb) {
        if (condNest != null) {
            if (condNest.isNegatedCondition()) {
                this.appendOperator(sb, NOT);
                this.appendSpace(sb);
            }
            this.appendSymbol(sb, '(');
            if (condNest.getNestedCondition() != null) {
                this.appendSQL(condNest.getNestedCondition(), sb);
            }
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(SQLQueryArrayDataType type, StringBuffer sb) {
        if (type != null) {
            this.appendSpecificSQL((ArrayDataType)type, sb);
        }
    }

    protected void appendSpecificSQL(SQLQueryMultisetDataType type, StringBuffer sb) {
        this.appendSpecificSQL((MultisetDataType)type, sb);
    }

    protected void appendSpecificSQL(StructuredUserDefinedType type, StringBuffer sb) {
        if (type != null) {
            String typeName = type.getName();
            typeName = this.convertCatalogIdentifierToSQLFormat(typeName, this.getDelimitedIdentifierQuote());
            this.appendDataTypeName(sb, typeName);
        }
    }

    protected void appendSpecificSQL(SuperGroup superGroup, StringBuffer sb) {
        if (superGroup != null) {
            SuperGroupType superGroupType = superGroup.getSuperGroupType();
            this.appendSpecificSQL(superGroupType, sb);
            this.appendSymbol(sb, '(');
            EList superGroupElementList = superGroup.getSuperGroupElementList();
            this.appendSQLForSQLObjectList((List)superGroupElementList, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(SuperGroupElementExpression superGroupElementExpr, StringBuffer sb) {
        if (superGroupElementExpr != null) {
            GroupingExpression groupingExpr = superGroupElementExpr.getGroupingExpr();
            this.appendSQL(groupingExpr, sb);
        }
    }

    protected void appendSpecificSQL(SuperGroupElementSublist superGroupSublist, StringBuffer sb) {
        if (superGroupSublist != null) {
            this.appendSymbol(sb, '(');
            EList superGroupElementExprList = superGroupSublist.getSuperGroupElementExprList();
            this.appendSQLForSQLObjectList((List)superGroupElementExprList, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(SuperGroupType groupType, StringBuffer sb) {
        if (groupType != null) {
            int groupTypeVal = groupType.getValue();
            switch (groupTypeVal) {
                case 0: {
                    this.appendKeyword(sb, CUBE);
                    break;
                }
                case 2: {
                    this.appendKeyword(sb, ROLLUP);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(TableCorrelation tableCorrelation, StringBuffer sb) {
        if (tableCorrelation != null) {
            String tableCorrName = tableCorrelation.getName();
            String sqlFormatTableCorrName = this.convertCatalogIdentifierToSQLFormat(tableCorrName, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sb, sqlFormatTableCorrName);
            EList colNameList = tableCorrelation.getColumnNameList();
            if (colNameList.size() > 0) {
                this.appendSpace(sb);
                this.appendSymbol(sb, '(');
                this.appendSQLForSQLObjectList((List)colNameList, sb);
                this.appendSymbol(sb, ')');
            }
        }
    }

    protected void appendSpecificSQL(TableFunction tableFunc, StringBuffer sb) {
        if (tableFunc != null) {
            String schemaName;
            this.appendKeyword(sb, TABLE);
            this.appendSpace(sb);
            this.appendSymbol(sb, '(');
            if (tableFunc.getFunction() != null && tableFunc.getFunction().getSchema() != null && (schemaName = tableFunc.getFunction().getSchema().getName()) != null) {
                String sqlFormatSchemaName = this.convertCatalogIdentifierToSQLFormat(schemaName, this.getDelimitedIdentifierQuote());
                this.appendIdentifier(sb, sqlFormatSchemaName);
                this.appendSymbol(sb, '.');
            }
            String tableFuncName = tableFunc.getName();
            String sqlFormatTableFuncName = this.convertCatalogIdentifierToSQLFormat(tableFuncName, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sb, sqlFormatTableFuncName);
            this.appendSymbol(sb, '(');
            EList paramList = tableFunc.getParameterList();
            if (paramList != null) {
                this.appendSQLForSQLObjectList((List)paramList, sb);
            }
            this.appendSymbol(sb, ')');
            this.appendSymbol(sb, ')');
            TableCorrelation tableCorr = tableFunc.getTableCorrelation();
            if (tableCorr != null) {
                SQLQuerySourceInfo sourceInfo = tableFunc.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                if (sourceFormat.getGenerateAsKeywordForTableCorrID()) {
                    sb.append(' ');
                    sb.append(AS);
                }
                this.appendSpace(sb);
                this.appendSQL(tableCorr, sb);
            }
        }
    }

    protected void appendSpecificSQL(TableInDatabase tableInDB, StringBuffer sb) {
        if (tableInDB != null) {
            this.appendSQLForTableInDatabase(tableInDB, sb);
            TableCorrelation tableCorr = tableInDB.getTableCorrelation();
            if (tableCorr != null) {
                SQLQuerySourceInfo sourceInfo = tableInDB.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                if (sourceFormat.getGenerateAsKeywordForTableCorrID()) {
                    this.appendSpace(sb);
                    this.appendKeyword(sb, AS);
                }
                this.appendSpace(sb);
                this.appendSQL(tableCorr, sb);
            }
        }
    }

    protected void appendSpecificSQL(TableJoined tableJoined, StringBuffer sb) {
        if (tableJoined != null) {
            TableReference leftTableRef = tableJoined.getTableRefLeft();
            this.appendSQLForTableExpression(leftTableRef, sb);
            if (tableJoined.getJoinOperator() != TableJoinedOperator.DEFAULT_INNER_LITERAL) {
                this.appendSpace(sb);
                TableJoinedOperator joinOp = tableJoined.getJoinOperator();
                this.appendSpecificSQL(joinOp, sb);
            }
            this.appendSpace(sb);
            this.appendKeyword(sb, JOIN);
            this.appendSpace(sb);
            TableReference rightTableRef = tableJoined.getTableRefRight();
            this.appendSQLForTableExpression(rightTableRef, sb);
            this.appendSpace(sb);
            this.appendKeyword(sb, ON);
            this.appendSpace(sb);
            QuerySearchCondition joinCond = tableJoined.getJoinCondition();
            this.appendSQL(joinCond, sb);
        }
    }

    protected void appendSpecificSQL(TableJoinedOperator op, StringBuffer sb) {
        if (op != null) {
            int opVal = op.getValue();
            switch (opVal) {
                case 0: {
                    break;
                }
                case 1: {
                    this.appendKeyword(sb, INNER);
                    break;
                }
                case 4: {
                    this.appendKeyword(sb, FULL);
                    this.appendSpace(sb);
                    this.appendKeyword(sb, OUTER);
                    break;
                }
                case 2: {
                    this.appendKeyword(sb, LEFT);
                    this.appendSpace(sb);
                    this.appendKeyword(sb, OUTER);
                    break;
                }
                case 3: {
                    this.appendKeyword(sb, RIGHT);
                    this.appendSpace(sb);
                    this.appendKeyword(sb, OUTER);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(TableNested tableNested, StringBuffer sb) {
        if (tableNested != null) {
            TableReference tableRef = tableNested.getNestedTableRef();
            this.appendSymbol(sb, '(');
            this.appendSQLForTableExpression(tableRef, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(TimeDataType dataType, StringBuffer sb) {
        if (dataType != null) {
            String typeName = dataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendKeyword(sb, typeName);
            } else {
                PrimitiveType primitiveType = dataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
        }
    }

    protected void appendSpecificSQL(UpdatabilityExpression updatabilityExpr, StringBuffer sb) {
        if (updatabilityExpr != null) {
            UpdatabilityType updateType = updatabilityExpr.getUpdatabilityType();
            this.appendSpecificSQL(updateType, sb);
            EList updateOfColList = updatabilityExpr.getUpdateOfColumnList();
            if (updateOfColList != null && updateOfColList.size() > 0) {
                this.appendSpace(sb);
                this.appendKeyword(sb, OF);
                this.appendSpace(sb);
                this.appendSQLForSQLObjectList((List)updateOfColList, sb);
            }
        }
    }

    protected void appendSpecificSQL(UpdatabilityType updatabilityType, StringBuffer sb) {
        if (updatabilityType != null) {
            int typeVal = updatabilityType.getValue();
            switch (typeVal) {
                case 0: {
                    this.appendKeyword(sb, FOR);
                    this.appendSpace(sb);
                    this.appendKeyword(sb, READ);
                    this.appendSpace(sb);
                    this.appendKeyword(sb, ONLY);
                    break;
                }
                case 1: {
                    this.appendKeyword(sb, FOR);
                    this.appendSpace(sb);
                    this.appendKeyword(sb, UPDATE);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(UpdateAssignmentExpression impl, StringBuffer sb) {
        if (impl != null) {
            EList targetColList = impl.getTargetColumnList();
            if (targetColList != null && targetColList.size() > 0) {
                if (targetColList.size() == 1) {
                    Object listObj = targetColList.get(0);
                    if (listObj instanceof SQLQueryObject) {
                        this.appendSQL((SQLQueryObject)listObj, sb);
                    }
                } else {
                    this.appendSymbol(sb, '(');
                    this.appendSQLForSQLObjectList((List)targetColList, sb);
                    this.appendSymbol(sb, ')');
                }
            }
            this.appendSpace(sb);
            this.appendOperator(sb, EQUAL);
            this.appendSpace(sb);
            UpdateSource updateSrc = impl.getUpdateSource();
            this.appendSQL(updateSrc, sb);
        }
    }

    protected void appendSpecificSQL(UpdateOfColumn updateOfCol, StringBuffer sb) {
        if (updateOfCol != null) {
            String colName = updateOfCol.getName();
            String sqlFormatColName = this.convertCatalogIdentifierToSQLFormat(colName, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sb, sqlFormatColName);
        }
    }

    protected void appendSpecificSQL(UpdateSourceExprList sourceExprList, StringBuffer sb) {
        EList valExprList;
        if (sourceExprList != null && (valExprList = sourceExprList.getValueExprList()) != null) {
            if (valExprList.size() == 1) {
                QueryValueExpression valExpr = (QueryValueExpression)valExprList.get(0);
                this.appendSQL(valExpr, sb);
            } else {
                this.appendSymbol(sb, '(');
                this.appendSQLForSQLObjectList((List)valExprList, sb);
                this.appendSymbol(sb, ')');
            }
        }
    }

    protected void appendSpecificSQL(UpdateSourceQuery sourceQuery, StringBuffer sb) {
        if (sourceQuery != null) {
            this.appendSymbol(sb, '(');
            QueryExpressionBody queryExpr = sourceQuery.getQueryExpr();
            this.appendSQL(queryExpr, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(ValueExpressionAtomic atomicExpr, StringBuffer sb) {
    }

    protected void appendSpecificSQL(ValueExpressionCaseElse caseElse, StringBuffer sb) {
        if (caseElse != null) {
            this.appendKeyword(sb, ELSE);
            this.appendSpace(sb);
            QueryValueExpression valExpr = caseElse.getValueExpr();
            this.appendSQL(valExpr, sb);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCaseSearch caseExpr, StringBuffer sb) {
        if (caseExpr != null) {
            ValueExpressionCaseElse caseElse;
            StringBuffer sbCase = new StringBuffer();
            boolean multipleCases = caseExpr.getSearchContentList() != null && caseExpr.getSearchContentList().size() > 1;
            int startOffset = this.getLastLineLength(sb);
            if (startOffset > 30) {
                startOffset = this.getLastLineIndent(sb) + 4;
                if (multipleCases) {
                    this.appendNewLine(sbCase);
                    this.appendSpace(sbCase, startOffset);
                }
            }
            this.appendKeyword(sbCase, CASE);
            EList contentList = caseExpr.getSearchContentList();
            if (contentList != null) {
                for (ValueExpressionCaseSearchContent oneCase : contentList) {
                    if (multipleCases) {
                        this.appendNewLine(sbCase);
                        this.appendSpace(sbCase, startOffset + 2);
                    } else {
                        this.appendSpace(sbCase);
                    }
                    this.appendSQL(oneCase, sbCase);
                }
            }
            if ((caseElse = caseExpr.getCaseElse()) != null) {
                if (multipleCases) {
                    this.appendNewLine(sbCase);
                    this.appendSpace(sbCase, startOffset + 2);
                } else {
                    this.appendSpace(sbCase);
                }
                this.appendSQL(caseElse, sbCase);
            }
            if (multipleCases) {
                this.appendNewLine(sbCase);
                this.appendSpace(sbCase, startOffset);
            } else {
                this.appendSpace(sbCase);
            }
            this.appendKeyword(sbCase, END);
            this.wrapSQL(caseExpr, sbCase);
            this.appendStringBuffer(sb, sbCase);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCaseSearchContent caseSearchContent, StringBuffer sb) {
        if (caseSearchContent != null) {
            this.appendKeyword(sb, WHEN);
            this.appendSpace(sb);
            QuerySearchCondition searchCond = caseSearchContent.getSearchCondition();
            this.appendSQL(searchCond, sb);
            this.appendSpace(sb);
            this.appendKeyword(sb, THEN);
            this.appendSpace(sb);
            QueryValueExpression valExpr = caseSearchContent.getValueExpr();
            this.appendSQL(valExpr, sb);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCaseSimple caseExpr, StringBuffer sb) {
        if (caseExpr != null) {
            ValueExpressionCaseElse caseElse;
            StringBuffer sbCase = new StringBuffer();
            boolean multipleCases = caseExpr.getContentList() != null && caseExpr.getContentList().size() > 1;
            int startOffset = this.getLastLineLength(sb);
            if (startOffset > 30) {
                startOffset = this.getLastLineIndent(sb) + 4;
                if (multipleCases) {
                    this.appendNewLine(sbCase);
                    this.appendSpace(sbCase, startOffset);
                }
            }
            this.appendKeyword(sbCase, CASE);
            this.appendSpace(sbCase);
            QueryValueExpression caseValExpr = caseExpr.getValueExpr();
            this.appendSQL(caseValExpr, sbCase);
            EList contentList = caseExpr.getContentList();
            if (contentList != null) {
                for (ValueExpressionCaseSimpleContent oneCase : contentList) {
                    if (multipleCases) {
                        this.appendNewLine(sbCase);
                        this.appendSpace(sbCase, startOffset + 2);
                    } else {
                        this.appendSpace(sbCase);
                    }
                    this.appendSQL(oneCase, sbCase);
                }
            }
            if ((caseElse = caseExpr.getCaseElse()) != null) {
                if (multipleCases) {
                    this.appendNewLine(sbCase);
                    this.appendSpace(sbCase, startOffset + 2);
                } else {
                    this.appendSpace(sbCase);
                }
                this.appendSQL(caseElse, sbCase);
            }
            if (multipleCases) {
                this.appendNewLine(sbCase);
                this.appendSpace(sbCase, startOffset);
            } else {
                this.appendSpace(sbCase);
            }
            this.appendKeyword(sbCase, END);
            this.wrapSQL(caseExpr, sbCase);
            this.appendStringBuffer(sb, sbCase);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCaseSimpleContent caseSimpleContent, StringBuffer sb) {
        if (caseSimpleContent != null) {
            this.appendKeyword(sb, WHEN);
            this.appendSpace(sb);
            QueryValueExpression whenValExpr = caseSimpleContent.getWhenValueExpr();
            this.appendSQL(whenValExpr, sb);
            this.appendSpace(sb);
            this.appendKeyword(sb, THEN);
            this.appendSpace(sb);
            QueryValueExpression resultValExpr = caseSimpleContent.getResultValueExpr();
            this.appendSQL(resultValExpr, sb);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCast castExpr, StringBuffer sb) {
        if (castExpr != null) {
            StringBuffer sbCast = new StringBuffer();
            this.appendKeyword(sbCast, CAST);
            this.appendSpace(sbCast);
            this.appendSymbol(sbCast, '(');
            QueryValueExpression valExpr = castExpr.getValueExpr();
            this.appendSQL(valExpr, sbCast);
            this.appendSpace(sbCast);
            this.appendKeyword(sbCast, AS);
            this.appendSpace(sbCast);
            DataType datatype = castExpr.getDataType();
            this.appendSQL((SQLObject)datatype, sbCast);
            this.appendSymbol(sbCast, ')');
            this.wrapSQL(castExpr, sbCast);
            this.appendStringBuffer(sb, sbCast);
        }
    }

    protected void appendSpecificSQL(ValueExpressionColumn valExprCol, StringBuffer sb) {
        if (valExprCol != null) {
            StringBuffer sbExpr = new StringBuffer();
            TableExpression tableExpr = valExprCol.getTableExpr();
            if (tableExpr != null) {
                boolean qualify;
                SQLQuerySourceInfo sourceInfo = valExprCol.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                int qualifySpec = sourceFormat.getQualifyIdentifiers();
                boolean qualifyWithSchema = qualifySpec == 1;
                boolean qualifyWithTable = qualifySpec == 2;
                boolean qualifyInContext = qualifySpec == 0;
                boolean bl = qualify = qualifyWithSchema || qualifyWithTable || qualifyInContext && this.isQualifiedColumnNameRequired(valExprCol);
                if (qualify) {
                    if (tableExpr.getTableCorrelation() != null && tableExpr.getTableCorrelation().getName() != null) {
                        String tableCorrName = tableExpr.getTableCorrelation().getName();
                        String sqlFormatTableCorrName = this.convertCatalogIdentifierToSQLFormat(tableCorrName, this.getDelimitedIdentifierQuote());
                        this.appendIdentifier(sbExpr, sqlFormatTableCorrName);
                    } else if (tableExpr instanceof TableInDatabase) {
                        TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                        this.appendSQLForTableInDatabase(tableInDB, sbExpr);
                    } else {
                        String tableExprName = tableExpr.getName();
                        String sqlFormatTableExprName = this.convertCatalogIdentifierToSQLFormat(tableExprName, this.getDelimitedIdentifierQuote());
                        this.appendIdentifier(sbExpr, sqlFormatTableExprName);
                    }
                    this.appendSymbol(sbExpr, '.');
                }
            }
            String valExprColName = valExprCol.getName();
            String sqlFormatValExprColName = this.convertCatalogIdentifierToSQLFormat(valExprColName, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sbExpr, sqlFormatValExprColName);
            this.wrapSQL(valExprCol, sbExpr);
            this.appendStringBuffer(sb, sbExpr);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCombined exprCombined, StringBuffer sb) {
        if (exprCombined != null) {
            if (exprCombined.getLeftValueExpr() != null) {
                QueryValueExpression leftValExpr = exprCombined.getLeftValueExpr();
                this.appendSQL(leftValExpr, sb);
            }
            this.appendSpace(sb);
            ValueExpressionCombinedOperator op = exprCombined.getCombinedOperator();
            this.appendSpecificSQL(op, sb);
            this.appendSpace(sb);
            if (exprCombined.getRightValueExpr() != null) {
                QueryValueExpression rightValExpr = exprCombined.getRightValueExpr();
                this.appendSQL(rightValExpr, sb);
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionCombinedOperator op, StringBuffer sb) {
        if (op != null) {
            int operator = op.getValue();
            switch (operator) {
                case 0: {
                    this.appendOperator(sb, "+");
                    break;
                }
                case 1: {
                    this.appendOperator(sb, "-");
                    break;
                }
                case 2: {
                    this.appendOperator(sb, "*");
                    break;
                }
                case 3: {
                    this.appendOperator(sb, DIVIDE);
                    break;
                }
                case 4: {
                    this.appendOperator(sb, CONCATENATE);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionDefaultValue exprDefault, StringBuffer sb) {
        this.appendKeyword(sb, DEFAULT);
    }

    protected void appendSpecificSQL(ValueExpressionFunction valExprFunc, StringBuffer sb) {
        if (valExprFunc != null) {
            String schemaName;
            StringBuffer sbExpr = new StringBuffer();
            if (valExprFunc.getFunction() != null && valExprFunc.getFunction().getSchema() != null && (schemaName = valExprFunc.getFunction().getSchema().getName()) != null) {
                String sqlFormatSchemaName = this.convertCatalogIdentifierToSQLFormat(schemaName, this.getDelimitedIdentifierQuote());
                this.appendIdentifier(sbExpr, sqlFormatSchemaName);
                this.appendSymbol(sbExpr, '.');
            }
            if (valExprFunc.isSpecialRegister()) {
                ValueExpressionSimple valExprSimple;
                String value;
                Object listObj;
                String regName = valExprFunc.getName();
                this.appendSpecialRegisterName(sbExpr, regName);
                EList paramList = valExprFunc.getParameterList();
                if (paramList != null && paramList.size() > 0 && (listObj = paramList.get(0)) instanceof ValueExpressionSimple && (value = (valExprSimple = (ValueExpressionSimple)listObj).getValue()) != null) {
                    this.appendSpace(sbExpr);
                    this.appendString(sbExpr, value);
                }
                if (valExprFunc.getName().equalsIgnoreCase("CURRENT_TRANSFORM_GROUP_FOR_TYPE")) {
                    DataType datatype = valExprFunc.getDataType();
                    this.appendSpace(sbExpr);
                    this.appendSQL((SQLObject)datatype, sbExpr);
                }
            } else {
                boolean isCountAll;
                String funcName = valExprFunc.getName();
                String sqlFormatFuncName = this.convertCatalogIdentifierToSQLFormat(funcName, this.getDelimitedIdentifierQuote());
                this.appendFunctionName(sbExpr, sqlFormatFuncName);
                this.appendSymbol(sbExpr, '(');
                if (valExprFunc.isDistinct()) {
                    this.appendKeyword(sbExpr, DISTINCT);
                    this.appendSpace(sbExpr);
                }
                EList paramList = valExprFunc.getParameterList();
                boolean bl = isCountAll = valExprFunc.getName().equalsIgnoreCase(FUNCTION_COUNT) && (paramList == null || paramList.isEmpty());
                if (isCountAll) {
                    this.appendString(sbExpr, "*");
                } else if (paramList != null) {
                    this.appendSQLForSQLObjectList((List)paramList, sbExpr);
                }
                this.appendSymbol(sbExpr, ')');
            }
            this.wrapSQL(valExprFunc, sbExpr);
            this.appendStringBuffer(sb, sbExpr);
        }
    }

    protected void appendSpecificSQL(ValueExpressionLabeledDuration duration, StringBuffer sb) {
        if (duration != null) {
            StringBuffer sbDuration = new StringBuffer();
            QueryValueExpression valExpr = duration.getValueExpr();
            this.appendSQL(valExpr, sbDuration);
            this.appendSpace(sbDuration);
            ValueExpressionLabeledDurationType labeledDurType = duration.getLabeledDurationType();
            this.appendSpecificSQL(labeledDurType, sbDuration);
            this.wrapSQL(duration, sbDuration);
            this.appendStringBuffer(sb, sbDuration);
        }
    }

    protected void appendSpecificSQL(ValueExpressionLabeledDurationType durationType, StringBuffer sb) {
        if (durationType != null) {
            int typeVal = durationType.getValue();
            switch (typeVal) {
                case 0: {
                    this.appendKeyword(sb, YEARS);
                    break;
                }
                case 1: {
                    this.appendKeyword(sb, MONTHS);
                    break;
                }
                case 2: {
                    this.appendKeyword(sb, DAYS);
                    break;
                }
                case 3: {
                    this.appendKeyword(sb, HOURS);
                    break;
                }
                case 4: {
                    this.appendKeyword(sb, MINUTES);
                    break;
                }
                case 5: {
                    this.appendKeyword(sb, SECONDS);
                    break;
                }
                case 6: {
                    this.appendKeyword(sb, MICROSECONDS);
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionNested exprNest, StringBuffer sb) {
        if (exprNest != null) {
            StringBuffer sbExprNest = new StringBuffer();
            this.appendSymbol(sbExprNest, '(');
            QueryValueExpression nestedValExpr = exprNest.getNestedValueExpr();
            this.appendSQL(nestedValExpr, sbExprNest);
            this.appendSymbol(sbExprNest, ')');
            this.wrapSQL(exprNest, sbExprNest);
            this.appendStringBuffer(sb, sbExprNest);
        }
    }

    protected void appendSpecificSQL(ValueExpressionNullValue exprNull, StringBuffer sb) {
        this.appendKeyword(sb, NULL);
    }

    protected void appendSpecificSQL(ValueExpressionRow valExprRow, StringBuffer sb) {
        if (valExprRow != null) {
            this.appendSymbol(sb, '(');
            EList valExprList = valExprRow.getValueExprList();
            this.appendSQLForSQLObjectList((List)valExprList, sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(ValueExpressionScalarSelect exprSelect, StringBuffer sb) {
        if (exprSelect != null) {
            StringBuffer sbExpr = new StringBuffer();
            this.appendSymbol(sbExpr, '(');
            QueryExpressionRoot queryExprRoot = exprSelect.getQueryExpr();
            this.appendSQL(queryExprRoot, sbExpr);
            this.appendSymbol(sbExpr, ')');
            this.wrapSQL(exprSelect, sbExpr);
            this.indentSQLToLastLineLengthOfContainer(sbExpr, sb);
            this.appendStringBuffer(sb, sbExpr);
        }
    }

    protected void appendSpecificSQL(ValueExpressionSimple exprSimple, StringBuffer sb) {
        if (exprSimple != null) {
            StringBuffer sbExpr = new StringBuffer();
            String exprValStr = exprSimple.getValue();
            this.appendString(sbExpr, exprValStr);
            this.wrapSQL(exprSimple, sbExpr);
            this.appendStringBuffer(sb, sbExpr);
        }
    }

    protected void appendSpecificSQL(ValueExpressionUnaryOperator op, StringBuffer sb) {
        if (op != null) {
            int operator = op.getValue();
            switch (operator) {
                case 0: {
                    break;
                }
                case 1: {
                    this.appendOperator(sb, "+");
                    break;
                }
                case 2: {
                    this.appendOperator(sb, "-");
                    break;
                }
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionVariable var, StringBuffer sb) {
        if (var != null) {
            String varName;
            StringBuffer sbExpr = new StringBuffer();
            String hostVarPrefix = COLON;
            String paramMarker = QUESTIONMARK;
            if (var.getSourceInfo() != null && var.getSourceInfo().getSqlFormat() != null) {
                SQLQuerySourceFormat sf = var.getSourceInfo().getSqlFormat();
                hostVarPrefix = String.valueOf(sf.getHostVariablePrefix());
                paramMarker = String.valueOf(sf.getParameterMarker());
            }
            if ((varName = var.getName()) != null) {
                this.appendString(sbExpr, hostVarPrefix);
                this.appendString(sbExpr, varName);
            } else {
                this.appendString(sbExpr, paramMarker);
            }
            this.wrapSQL(var, sbExpr);
            this.appendStringBuffer(sb, sbExpr);
        }
    }

    protected void appendSpecificSQL(ValuesRow valuesRow, StringBuffer sb) {
        if (valuesRow != null) {
            EList rowExprList = valuesRow.getExprList();
            if (rowExprList.size() == 1) {
                this.appendSQLForSQLObjectList((List)rowExprList, sb);
            } else if (rowExprList.size() > 1) {
                this.appendSymbol(sb, '(');
                this.appendSQLForSQLObjectList((List)rowExprList, sb);
                this.appendSymbol(sb, ')');
            }
        }
    }

    protected void appendSpecificSQL(WithTableReference withTableRef, StringBuffer sb) {
        if (withTableRef != null) {
            String withTableRefName = withTableRef.getName();
            String sqlFormatWithTableRefName = this.convertCatalogIdentifierToSQLFormat(withTableRefName, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sb, sqlFormatWithTableRefName);
            TableCorrelation tableCorr = withTableRef.getTableCorrelation();
            if (tableCorr != null) {
                SQLQuerySourceInfo sourceInfo = withTableRef.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                if (sourceFormat.getGenerateAsKeywordForTableCorrID()) {
                    this.appendSpace(sb);
                    this.appendKeyword(sb, AS);
                }
                this.appendSpace(sb);
                this.appendSQL(tableCorr, sb);
            }
        }
    }

    protected void appendSpecificSQL(WithTableSpecification withTable, StringBuffer sb) {
        if (withTable != null) {
            int tableWithIndent = this.getLastLineIndent(sb);
            int tableWithQueryIndent = tableWithIndent + 3;
            String withTableName = withTable.getName();
            String sqlFormatWithTableName = this.convertCatalogIdentifierToSQLFormat(withTableName, this.getDelimitedIdentifierQuote());
            this.appendIdentifier(sb, sqlFormatWithTableName);
            if (!withTable.getColumnNameList().isEmpty()) {
                EList columnNameList = withTable.getColumnNameList();
                this.appendSpace(sb);
                this.appendSymbol(sb, '(');
                this.appendSQLForSQLObjectList((List)columnNameList, sb);
                this.appendSymbol(sb, ')');
            }
            this.appendSpace(sb);
            this.appendKeyword(sb, AS);
            this.appendNewLine(sb);
            this.appendSpace(sb, tableWithQueryIndent);
            this.appendSymbol(sb, '(');
            this.appendSQL(withTable.getWithTableQueryExpr(), sb);
            this.appendSymbol(sb, ')');
        }
    }

    protected void appendSpecificSQL(XMLDataType dataType, StringBuffer sb) {
        if (dataType != null) {
            String typeName = dataType.getName();
            if (typeName != null && typeName.length() > 0) {
                this.appendKeyword(sb, typeName);
            } else {
                PrimitiveType primitiveType = dataType.getPrimitiveType();
                this.appendSpecificSQL(primitiveType, sb);
            }
        }
    }
}

