/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.query.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class SQLQuerySourceFormat {
    public static final boolean PRESERVE_SOURCE_FORMAT_DEFAULT = false;
    public static final char STATEMENT_TERMINATOR_DEFAULT = ';';
    public static final char HOSTVARIABLE_PREFIX_DEFAULT = ':';
    public static final char PARAMETER_MARKER_DEFAULT = '?';
    public static final char DELIMITED_IDENTIFIER_QUOTE_DEFAULT = '\"';
    public static final String OMIT_SCHEMA_DEFAULT = null;
    public static final int QUALIFY_IDENTIFIERS_IN_CONTEXT = 0;
    public static final int QUALIFY_IDENTIFIERS_WITH_SCHEMA_NAMES = 1;
    public static final int QUALIFY_IDENTIFIERS_WITH_TABLE_NAMES = 2;
    public static final int QUALIFY_IDENTIFIERS_NEVER = 3;
    public static final int QUALIFY_IDENTIFIERS_DEFAULT = 0;
    public static final boolean PRESERVE_COMMENTS_DEFAULT = true;
    public static final boolean GENERATE_COMMENTS_FOR_STATEMENT_DEFAULT = true;
    public static final boolean INSTANCE_IS_FINAL_DEFAULT = false;
    public static final boolean GENERATE_AS_KEYWORD_FOR_TABLE_CORR_ID_DEFAULT = true;
    public static final SQLQuerySourceFormat SQL_SOURCE_FORMAT_DEFAULT = new SQLQuerySourceFormat(false, ';', ':', '?', '\"', OMIT_SCHEMA_DEFAULT, 0, true, true, true, true);
    private boolean preserveSourceFormat = false;
    private char statementTerminator = (char)59;
    private char hostVariablePrefix = (char)58;
    private char parameterMarker = (char)63;
    private char delimitedIdentifierQuote = (char)34;
    private String omitSchema = OMIT_SCHEMA_DEFAULT;
    private int qualifyIdentifiers = 0;
    private boolean preserveComments = true;
    private boolean generateCommentsForStatementOnly = true;
    private boolean instanceIsFinal = false;
    private boolean generateAsKeywordForTableCorrID = true;

    protected SQLQuerySourceFormat(boolean preserveSourceFormat, char statementTerminator, char hostVariablePrefix, char parameterMarker, char delimitedIdentifierQuote, String omitSchema, int qualifyIdentifiers, boolean preserveComments, boolean generateCommentsForStatementOnly) {
        this(preserveSourceFormat, statementTerminator, hostVariablePrefix, parameterMarker, delimitedIdentifierQuote, omitSchema, qualifyIdentifiers, preserveComments, generateCommentsForStatementOnly, false, true);
    }

    private SQLQuerySourceFormat(boolean preserveSourceFormat, char statementTerminator, char hostVariablePrefix, char parameterMarker, char delimitedIdentifierQuote, String omitSchema, int qualifyIdentifiers, boolean preserveComments, boolean generateCommentsForStatementOnly, boolean finalInstance, boolean generateAsKeywordForTableCorrID) {
        this.preserveSourceFormat = preserveSourceFormat;
        this.statementTerminator = statementTerminator;
        this.hostVariablePrefix = hostVariablePrefix;
        this.parameterMarker = parameterMarker;
        this.delimitedIdentifierQuote = delimitedIdentifierQuote;
        this.omitSchema = omitSchema;
        this.qualifyIdentifiers = qualifyIdentifiers;
        this.preserveComments = preserveComments;
        this.generateCommentsForStatementOnly = generateCommentsForStatementOnly;
        this.instanceIsFinal = finalInstance;
        this.generateAsKeywordForTableCorrID = generateAsKeywordForTableCorrID;
    }

    private SQLQuerySourceFormat() {
    }

    public static SQLQuerySourceFormat copyDefaultFormat() {
        return SQLQuerySourceFormat.copySourceFormat(SQL_SOURCE_FORMAT_DEFAULT);
    }

    public static SQLQuerySourceFormat copySourceFormat(SQLQuerySourceFormat sourceFormat) {
        SQLQuerySourceFormat copy = new SQLQuerySourceFormat();
        SQLQuerySourceFormat.copyFields(sourceFormat, copy);
        return copy;
    }

    public static void copyFields(SQLQuerySourceFormat source, SQLQuerySourceFormat target) {
        Field[] fields = SQLQuerySourceFormat.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!Modifier.isFinal(field.getModifiers()) && !field.getName().equals("instanceIsFinal")) {
                try {
                    field.set(target, field.get(source));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        target.instanceIsFinal = false;
    }

    public void copyFields(SQLQuerySourceFormat sourceFormat) {
        SQLQuerySourceFormat.copyFields(sourceFormat, this);
    }

    private void checkThisForFinalInstance() throws UnsupportedOperationException {
        if (this.instanceIsFinal) {
            throw new UnsupportedOperationException("This " + this.getClass().getName() + " is final! Property modifications illegal. Use " + this.getClass().getName() + "#copyDefaultFormat() to get a copy of this instance.");
        }
    }

    public char getDelimitedIdentifierQuote() {
        return this.delimitedIdentifierQuote;
    }

    public void setDelimitedIdentifierQuote(char delimitedIdentifierQuote) {
        this.checkThisForFinalInstance();
        this.delimitedIdentifierQuote = delimitedIdentifierQuote;
    }

    public char getHostVariablePrefix() {
        return this.hostVariablePrefix;
    }

    public void setHostVariablePrefix(char hostVariablePrefix) {
        this.checkThisForFinalInstance();
        this.hostVariablePrefix = hostVariablePrefix;
    }

    public char getParameterMarker() {
        return this.parameterMarker;
    }

    public void setParameterMarker(char parameterMarker) {
        this.checkThisForFinalInstance();
        this.parameterMarker = parameterMarker;
    }

    public String getOmitSchema() {
        return this.omitSchema;
    }

    public void setOmitSchema(String omitSchema) {
        this.checkThisForFinalInstance();
        this.omitSchema = omitSchema;
    }

    public boolean isPreserveSourceFormat() {
        return this.preserveSourceFormat;
    }

    public void setPreserveSourceFormat(boolean preserveSourceFormat) {
        this.checkThisForFinalInstance();
        this.preserveSourceFormat = preserveSourceFormat;
    }

    public char getStatementTerminator() {
        return this.statementTerminator;
    }

    public void setStatementTerminator(char statementTerminator) {
        this.checkThisForFinalInstance();
        this.statementTerminator = statementTerminator;
    }

    public int getQualifyIdentifiers() {
        return this.qualifyIdentifiers;
    }

    public void setQualifyIdentifiers(int qualifyIdentifiers) {
        this.checkThisForFinalInstance();
        this.qualifyIdentifiers = qualifyIdentifiers;
    }

    public boolean getPreserveComments() {
        return this.preserveComments;
    }

    public boolean isPreserveComments() {
        return this.preserveComments;
    }

    public void setPreserveComments(boolean preserveComments) {
        this.checkThisForFinalInstance();
        this.preserveComments = preserveComments;
    }

    public boolean isGenerateCommentsForStatementOnly() {
        return this.generateCommentsForStatementOnly;
    }

    public void setGenerateCommentsForStatementOnly(boolean generateCommentsForStatementOnly) {
        this.checkThisForFinalInstance();
        this.generateCommentsForStatementOnly = generateCommentsForStatementOnly;
    }

    public boolean getGenerateAsKeywordForTableCorrID() {
        return this.generateAsKeywordForTableCorrID;
    }

    public void setGenerateAsKeywordForTableCorrID(boolean genAsKeywordForTableCorrID) {
        this.checkThisForFinalInstance();
        this.generateAsKeywordForTableCorrID = genAsKeywordForTableCorrID;
    }
}

