/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.query.util;

import com.ibm.icu.text.StringCharacterIterator;
import com.ibm.ims.datatools.modelbase.sql.query.SQLQueryObject;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import java.util.ArrayList;

public class SQLQuerySourceBuffer {
    private static final char TAB = '\t';
    private boolean preserveFormatting = false;
    private String originalSource = null;
    private String originalSourceUC = null;
    private StringBuffer generatedSource = null;
    private int[] originalSourceCharStatus = null;
    private String delimitedIdentQt = "\"";
    StringBuffer[] bucketArray = null;
    int indexOffset = 0;
    int scopeStartIndex = 0;
    int scopeEndIndex = 0;
    private static final int SOURCE_CHAR_STATUS_WRITTEN = 1;
    private static final int SOURCE_CHAR_STATUS_UNWRITTEN = 0;
    private static final int SOURCE_CHAR_STATUS_WHITESPACE = 2;
    private int currentIndex = 0;
    private static final char CARRIAGE_RETURN = '\r';
    protected static final char NEW_LINE = '\n';
    protected static final char SPACE = ' ';
    protected static final char COMMA = ',';
    private static final char PAREN_RIGHT = ')';
    private static final char PAREN_LEFT = '(';
    private static final char EQUAL = '=';
    private static final char LESS_THAN = '<';
    private static final char GREATER_THAN = '>';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char MULTIPLY = '*';
    private static final char DIVIDE = '/';
    private static final char CONCATENATE = '|';
    private static final char COLON = ':';
    private static final char SEMICOLON = ';';
    char[] sqlSeparators = new char[]{'\n', ' ', ',', ')', '(', '=', '<', '>', '+', '-', '*', '/', '|', ';'};

    protected SQLQuerySourceBuffer(String originalSource) {
        this.originalSource = originalSource;
        this.originalSourceUC = originalSource.toUpperCase();
        this.bucketArray = new StringBuffer[originalSource.length()];
        if (originalSource != null && originalSource.length() > 0) {
            this.preserveFormatting = true;
        }
        this.scopeEndIndex = originalSource.length() - 1;
    }

    protected SQLQuerySourceBuffer(SQLQuerySourceInfo originalSourceInfo) {
        this(originalSourceInfo.getSourceSnippet());
        this.indexOffset = originalSourceInfo.getSpanStartOffset();
        char delimIdQtChar = originalSourceInfo.getSqlFormat().getDelimitedIdentifierQuote();
        this.delimitedIdentQt = String.valueOf(delimIdQtChar);
    }

    protected SQLQuerySourceBuffer() {
        this.originalSource = null;
        this.preserveFormatting = false;
        this.generatedSource = new StringBuffer();
    }

    protected void setScope(int start, int end) {
        this.scopeStartIndex = start - this.indexOffset;
        this.scopeEndIndex = end - this.indexOffset;
        if (this.currentIndex < this.scopeStartIndex) {
            this.currentIndex = this.scopeStartIndex;
        }
    }

    protected void setScope(SQLQuerySourceInfo sourceInfo) {
        this.scopeStartIndex = sourceInfo.getSpanStartOffset() - this.indexOffset;
        this.scopeEndIndex = sourceInfo.getSpanEndOffset() - this.indexOffset;
        this.currentIndex = this.scopeStartIndex;
    }

    public SQLQuerySourceBuffer append(String sql) {
        if (!this.preserveFormatting) {
            this.generatedSource.append(sql);
            return this;
        }
        if (sql != null && sql.length() > 0 && sql.length() == 1) {
            return this.append(sql.charAt(0), false);
        }
        return this;
    }

    public SQLQuerySourceBuffer appendKeyword(String keyword, boolean optional) {
        return this.appendWord(keyword, optional, true);
    }

    public SQLQuerySourceBuffer appendIdentifier(String ident) {
        boolean caseSensitive = ident.startsWith(this.delimitedIdentQt);
        return this.appendWord(ident, false, !caseSensitive);
    }

    public SQLQuerySourceBuffer appendWord(String word, boolean optional, boolean ignoreCase) {
        if (!this.preserveFormatting) {
            this.generatedSource.append(word);
            return this;
        }
        if (word != null && word.length() > 0) {
            char c = Character.toUpperCase(word.charAt(0));
            int startedFromIndex = this.currentIndex;
            int wordLength = word.length();
            if (this.currentIndex > this.scopeEndIndex) {
                this.addToBucket(word);
                return this;
            }
            if (this.isWhiteSpace(this.originalSource.charAt(this.currentIndex)) && (this.isWhiteSpace(this.originalSource.charAt(this.currentIndex - 1)) || this.isSeparator(this.originalSource.charAt(this.currentIndex - 1)))) {
                this.skipWhiteSpace();
            }
            if (c == this.originalSourceUC.charAt(this.currentIndex)) {
                if (this.originalSourceUC.regionMatches(ignoreCase, this.currentIndex, word, 0, wordLength)) {
                    this.currentIndex += wordLength;
                    this.updateOriginalSourceCharStatus(startedFromIndex, this.currentIndex, 1);
                }
            } else if (!optional) {
                this.addToBucket(word);
            }
        }
        return this;
    }

    private void updateOriginalSourceCharStatus(int startIndex, int endIndex, int sourceCharStatus) {
        if (startIndex > -1 && endIndex < this.originalSource.length()) {
            int i = startIndex;
            while (i < endIndex + 1) {
                this.originalSourceCharStatus[i] = sourceCharStatus;
                ++i;
            }
        }
    }

    public SQLQuerySourceBuffer append(char c) {
        return this.append(c, false);
    }

    public SQLQuerySourceBuffer appendOptional(char c) {
        return this.append(c, true);
    }

    private SQLQuerySourceBuffer append(char c, boolean optional) {
        if (!this.preserveFormatting) {
            this.generatedSource.append(c);
            return this;
        }
        if (this.currentIndex > this.scopeEndIndex) {
            this.addToBucket(c);
        } else if (c == this.originalSource.charAt(this.currentIndex)) {
            this.originalSourceCharStatus[this.currentIndex] = 1;
            ++this.currentIndex;
        } else if (this.isWhiteSpace(c)) {
            if (!optional) {
                this.addToBucket(c);
            }
            if (this.isWhiteSpace(this.originalSource.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
        } else if (this.isWhiteSpace(this.originalSource.charAt(this.currentIndex)) && (this.isWhiteSpace(this.originalSource.charAt(this.currentIndex - 1)) || this.isSeparator(this.originalSource.charAt(this.currentIndex - 1)))) {
            this.skipWhiteSpace();
            if (c == this.originalSource.charAt(this.currentIndex)) {
                this.originalSourceCharStatus[this.currentIndex] = 1;
                ++this.currentIndex;
            } else if (!optional) {
                this.addToBucket(c);
            }
        } else if (!optional) {
            this.addToBucket(c);
        }
        return this;
    }

    private void skipWhiteSpace() {
        while (this.isWhiteSpace(this.originalSource.charAt(this.currentIndex))) {
            this.originalSourceCharStatus[this.currentIndex] = 2;
            ++this.currentIndex;
        }
    }

    private void addToBucket(char c) {
        StringBuffer bucket = this.getBucket(this.currentIndex);
        bucket.append(c);
    }

    private void addToBucket(String string) {
        StringBuffer bucket = this.getBucket(this.currentIndex);
        bucket.append(string);
    }

    private StringBuffer getBucket(int position) {
        if (this.bucketArray[position] == null) {
            this.bucketArray[position] = new StringBuffer();
        }
        StringBuffer bucket = this.bucketArray[position];
        return bucket;
    }

    private boolean isSeparator(char c) {
        return this.isWhiteSpace(c) || this.isOperator(c) || c == ',' || c == '(' || c == ')';
    }

    private boolean isOperator(char c) {
        if (c == '+' || c == '-' || c == '*' || c == '/') {
            return true;
        }
        return c == '<' || c == '>' || c == '=';
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    private ArrayList splitSQL(String sql, char[] sqlSeparators) {
        ArrayList<String> splitSQL = new ArrayList<String>();
        int lastSplitIndex = 0;
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            int si = 0;
            while (si < sqlSeparators.length) {
                char s = sqlSeparators[si];
                if (c == s) {
                    String split = sql.substring(lastSplitIndex, i);
                    String separator = String.valueOf(c);
                    splitSQL.add(split);
                    splitSQL.add(separator);
                    lastSplitIndex = i + 1;
                }
                ++si;
            }
            ++i;
        }
        if (lastSplitIndex < sql.length()) {
            String lastSplitSegment = sql.substring(lastSplitIndex);
            splitSQL.add(lastSplitSegment);
        }
        return splitSQL;
    }

    public int length() {
        if (!this.preserveFormatting) {
            return this.generatedSource.length();
        }
        return this.toString().length();
    }

    public SQLQuerySourceBuffer replace(int start, int end, String str) {
        if (this.preserveFormatting) {
            throw new UnsupportedOperationException(" replace(int, int, String) not implemented in " + this.getClass().getName());
        }
        this.generatedSource.replace(start, end, str);
        return this;
    }

    public String toString() {
        if (!this.preserveFormatting) {
            return this.generatedSource.toString();
        }
        StringBuffer updatedSource = new StringBuffer(this.currentIndex + 1);
        int i = 0;
        while (i < updatedSource.length()) {
            if (this.bucketArray[i] != null && !this.isWhiteSpaceOnly(this.bucketArray[i])) {
                updatedSource.append(this.bucketArray[i]);
            }
            if (this.originalSourceCharStatus[i] != 0) {
                updatedSource.append(this.originalSource.charAt(i));
            }
            ++i;
        }
        return updatedSource.toString();
    }

    private boolean isWhiteSpaceOnly(StringBuffer buffer) {
        boolean foundNonWhiteSpace = false;
        if (buffer != null) {
            int i = 0;
            while (i < buffer.length()) {
                if (!this.isWhiteSpace(buffer.charAt(i))) {
                    foundNonWhiteSpace = true;
                    break;
                }
                ++i;
            }
        }
        return !foundNonWhiteSpace;
    }

    private void updateIntArray(int[] toBeUpdated, int begin, int end, int value) {
        if (end > begin && toBeUpdated.length >= end && begin >= 0) {
            int i = begin;
            while (i < end) {
                toBeUpdated[i] = value;
                ++i;
            }
        }
    }

    public void stripOriginalSourceCommentsAndBlanks_makeUpperCase_createIndexMapping() {
        int lastChar = 32;
        int delimiterState = 0;
        StringBuffer nonCommentStmt = new StringBuffer();
        int[] trimmedIndexToOriginalIndex = new int[this.originalSource.length()];
        StringCharacterIterator iter = new StringCharacterIterator(this.originalSource);
        int i = 0;
        char c = iter.first();
        while (c != '\uffff') {
            switch (delimiterState) {
                case 3: {
                    if (c != '\r' && c != '\n') break;
                    delimiterState = 0;
                    break;
                }
                case 0: {
                    if (c == '\'') {
                        delimiterState = 1;
                        break;
                    }
                    if (c == '\"') {
                        delimiterState = 2;
                        break;
                    }
                    if (c != '-') break;
                    char lookAheadChar = iter.next();
                    if (lookAheadChar == '-') {
                        delimiterState = 3;
                        break;
                    }
                    nonCommentStmt.append(c);
                    trimmedIndexToOriginalIndex[nonCommentStmt.length() - 1] = i++;
                    lastChar = c;
                    c = lookAheadChar;
                    break;
                }
                case 1: {
                    char lookAheadChar;
                    if (c != '\'' || (lookAheadChar = iter.next()) == '\'') break;
                    delimiterState = 0;
                    nonCommentStmt.append(c);
                    trimmedIndexToOriginalIndex[nonCommentStmt.length() - 1] = i++;
                    lastChar = c;
                    c = lookAheadChar;
                    break;
                }
                case 2: {
                    char lookAheadChar;
                    if (c != '\"' || (lookAheadChar = iter.next()) == '\"') break;
                    delimiterState = 0;
                    nonCommentStmt.append(c);
                    trimmedIndexToOriginalIndex[nonCommentStmt.length() - 1] = i++;
                    lastChar = c;
                    c = lookAheadChar;
                }
            }
            if (delimiterState != 3) {
                if ((c == '\r' || c == '\n' || c == ' ') && delimiterState == 0) {
                    if (lastChar != 32) {
                        nonCommentStmt.append(' ');
                        trimmedIndexToOriginalIndex[nonCommentStmt.length() - 1] = i;
                        lastChar = 32;
                    }
                } else if (c != '\uffff' && (delimiterState != 0 || lastChar != 32 || c != ' ')) {
                    if (delimiterState == 0) {
                        c = Character.toUpperCase(c);
                    }
                    nonCommentStmt.append(c);
                    trimmedIndexToOriginalIndex[nonCommentStmt.length() - 1] = i;
                    lastChar = c;
                }
            }
            ++i;
            c = iter.next();
        }
    }

    public int lastIndexOf(String string) {
        return this.toString().lastIndexOf(string);
    }

    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    public SQLQuerySourceBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public void insertConditionalLineBreak(SQLQueryObject context) {
    }

    public void setIndent(SQLQueryObject context) {
    }
}

