/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.query.helper;

import com.ibm.ims.datatools.modelbase.sql.datatypes.DataType;
import com.ibm.ims.datatools.modelbase.sql.query.Predicate;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateBasic;
import com.ibm.ims.datatools.modelbase.sql.query.PredicateComparisonOperator;
import com.ibm.ims.datatools.modelbase.sql.query.QuerySearchCondition;
import com.ibm.ims.datatools.modelbase.sql.query.QueryValueExpression;
import com.ibm.ims.datatools.modelbase.sql.query.SQLQueryModelFactory;
import com.ibm.ims.datatools.modelbase.sql.query.SearchConditionCombined;
import com.ibm.ims.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import com.ibm.ims.datatools.modelbase.sql.query.TableExpression;
import com.ibm.ims.datatools.modelbase.sql.query.TableJoined;
import com.ibm.ims.datatools.modelbase.sql.query.TableJoinedOperator;
import com.ibm.ims.datatools.modelbase.sql.query.TableNested;
import com.ibm.ims.datatools.modelbase.sql.query.TableReference;
import com.ibm.ims.datatools.modelbase.sql.query.ValueExpressionColumn;
import com.ibm.ims.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JoinHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2004.";
    public static final String GENERIC_CHARACTER = "Character";
    public static final String GENERIC_INTEGER = "Integer";
    public static final String GENERIC_DECIMAL = "Decimal";
    public static final String GENERIC_BINARY = "Binary";
    public static final String GENERIC_DATE = "Date";
    public static final String GENERIC_TIME = "Time";
    public static final String GENERIC_TIMESTAMP = "Timestamp";
    public static final String GENERIC_BLOB = "BLOB";
    public static final String GENERIC_OTHER = "Other";
    public static final int JOIN_COL_TYPE_MISMATCH = -1;
    public static final int JOIN_COL_USED = -2;
    public static final int JOIN_SAME_TABLE = -3;
    public static final int JOIN_VALID = 0;
    public static final String LEFT = "left_col_used";
    public static final String RIGHT = "right_col_used";
    public static final String BOTH = "both_col_used";
    public static final String NONE = "neither_col_used";

    public static TableJoined addJoin(List fromClause, TableExpression sourceTable, TableExpression targetTable, ValueExpressionColumn sourceColumn, ValueExpressionColumn targetColumn, int joinType) {
        TableReference targetContainer;
        TableJoined joinedTable = null;
        TableReference sourceContainer = JoinHelper.findOutermostContainingJoin(fromClause, sourceTable);
        joinedTable = sourceContainer != (targetContainer = JoinHelper.findOutermostContainingJoin(fromClause, targetTable)) ? JoinHelper.addJoinedTable(fromClause, sourceContainer, targetContainer, joinType) : JoinHelper.findClosestContainingJoin(sourceTable, targetTable);
        if (joinedTable != null) {
            QuerySearchCondition searchCon = joinedTable.getJoinCondition();
            searchCon = JoinHelper.buildSearchCondition(searchCon, sourceColumn, targetColumn, "=");
            joinedTable.setJoinCondition(searchCon);
        }
        return joinedTable;
    }

    public static TableJoined addJoinedTable(List fromClause, TableReference joinSource, TableReference joinTarget, int joinType) {
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        TableJoined joinedTable = factory.createTableJoined();
        joinedTable.setTableRefLeft(joinSource);
        joinedTable.setTableRefRight(joinTarget);
        joinedTable.setJoinOperator(TableJoinedOperator.get(joinType));
        fromClause.remove(joinSource);
        fromClause.remove(joinTarget);
        fromClause.add(joinedTable);
        return joinedTable;
    }

    public static PredicateBasic buildPredicateBasic(QueryValueExpression leftExpr, QueryValueExpression rightExpr, String oper) {
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        PredicateBasic pred = factory.createPredicateBasic();
        pred.setLeftValueExpr(leftExpr);
        pred.setRightValueExpr(rightExpr);
        String operLiteral = JoinHelper.getComparisonLiteralFromSymbol(oper);
        PredicateComparisonOperator operEnum = PredicateComparisonOperator.get(operLiteral);
        pred.setComparisonOperator(operEnum);
        return pred;
    }

    public static QuerySearchCondition buildSearchCondition(QuerySearchCondition currentSearchCon, QueryValueExpression leftExpr, QueryValueExpression rightExpr, String oper) {
        QuerySearchCondition newCondition = null;
        PredicateBasic pred = JoinHelper.buildPredicateBasic(leftExpr, rightExpr, oper);
        if (currentSearchCon == null) {
            newCondition = pred;
        } else {
            SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
            SearchConditionCombined combined = factory.createSearchConditionCombined();
            combined.setLeftCondition(currentSearchCon);
            combined.setRightCondition(pred);
            combined.setCombinedOperator(SearchConditionCombinedOperator.get("AND"));
            newCondition = combined;
        }
        return newCondition;
    }

    public static int checkJoin(List fromClause, TableExpression sourceTable, TableExpression targetTable, ValueExpressionColumn sourceColumn, ValueExpressionColumn targetColumn, boolean isMove) {
        int resultCode = 0;
        resultCode = !JoinHelper.checkJoinType(sourceColumn, targetColumn) ? -1 : (sourceColumn == targetColumn ? 0 : (sourceTable == targetTable ? -3 : 0));
        return resultCode;
    }

    public static boolean checkJoinType(ValueExpressionColumn sourceColumn, ValueExpressionColumn targetColumn) {
        DataType targetDataType;
        String targetGenericType;
        boolean areCompatible = false;
        DataType sourceDataType = sourceColumn.getDataType();
        String sourceGenericType = JoinHelper.getGenericType(sourceDataType);
        if (sourceGenericType.equals(targetGenericType = JoinHelper.getGenericType(targetDataType = targetColumn.getDataType()))) {
            areCompatible = true;
        }
        return areCompatible;
    }

    public static boolean conditionContainsTable(QuerySearchCondition condition, TableExpression table) {
        boolean tableFound = false;
        List predList = JoinHelper.findConditionsContainingTable(condition, table);
        if (predList.size() > 0) {
            tableFound = true;
        }
        return tableFound;
    }

    public static TableJoined findClosestContainingJoin(TableExpression joinSource, TableExpression joinTarget) {
        TableJoined foundJoin = null;
        TableReference tempSource = joinSource;
        TableJoined container = null;
        while (foundJoin == null && tempSource != null) {
            container = tempSource.getTableJoinedLeft();
            if (container != null) {
                tableExprList = JoinHelper.getTablesInJoin(container);
                if (tableExprList.contains(joinTarget)) {
                    foundJoin = container;
                }
            } else {
                container = tempSource.getTableJoinedRight();
                if (container != null && (tableExprList = JoinHelper.getTablesInJoin(container)).contains(joinTarget)) {
                    foundJoin = container;
                }
            }
            tempSource = container;
        }
        return foundJoin;
    }

    public static List findConditionsContainingTable(QuerySearchCondition cond, TableExpression table) {
        ArrayList<PredicateBasic> predList = new ArrayList<PredicateBasic>();
        if (cond instanceof PredicateBasic) {
            TableExpression tableExprInPred;
            QueryValueExpression rightExpr;
            TableExpression tableExprInPred2;
            PredicateBasic predicate = (PredicateBasic)cond;
            QueryValueExpression leftExpr = predicate.getLeftValueExpr();
            if (leftExpr instanceof ValueExpressionColumn && (tableExprInPred2 = ((ValueExpressionColumn)leftExpr).getTableExpr()).equals(table)) {
                predList.add(predicate);
            }
            if (predList.size() == 0 && (rightExpr = predicate.getRightValueExpr()) instanceof ValueExpressionColumn && (tableExprInPred = ((ValueExpressionColumn)rightExpr).getTableExpr()).equals(table)) {
                predList.add(predicate);
            }
        } else if (cond instanceof SearchConditionCombined) {
            QuerySearchCondition rightCond;
            SearchConditionCombined condGroup = (SearchConditionCombined)cond;
            QuerySearchCondition leftCond = condGroup.getLeftCondition();
            if (leftCond != null) {
                predList.addAll(JoinHelper.findConditionsContainingTable(leftCond, table));
            }
            if ((rightCond = condGroup.getRightCondition()) != null) {
                predList.addAll(JoinHelper.findConditionsContainingTable(rightCond, table));
            }
        }
        return predList;
    }

    public static List findJoinsWithTableInCondition(TableExpression table, TableJoined join) {
        ArrayList<TableJoined> joinList = new ArrayList<TableJoined>();
        TableJoined currentJoin = join;
        while (currentJoin != null) {
            TableJoined tempParent;
            QuerySearchCondition onClause = currentJoin.getJoinCondition();
            if (JoinHelper.conditionContainsTable(onClause, table)) {
                joinList.add(currentJoin);
            }
            currentJoin = (tempParent = currentJoin.getTableJoinedLeft()) != null ? tempParent : currentJoin.getTableJoinedRight();
        }
        return joinList;
    }

    public static TableReference findOutermostContainingJoin(List fromClause, TableExpression targetTable) {
        TableReference foundTableRef = null;
        Iterator fromClauseIter = fromClause.iterator();
        while (fromClauseIter.hasNext() && foundTableRef == null) {
            TableJoined joinedTable;
            List tableExprList;
            TableReference tempTableRef = (TableReference)fromClauseIter.next();
            if (targetTable == tempTableRef) {
                foundTableRef = tempTableRef;
                continue;
            }
            if (tempTableRef instanceof TableNested) {
                TableNested tableNested = (TableNested)tempTableRef;
                tableExprList = JoinHelper.getTablesInNestedTable(tableNested);
                if (!tableExprList.contains(targetTable)) continue;
                foundTableRef = tableNested;
                continue;
            }
            if (!(tempTableRef instanceof TableJoined) || !(tableExprList = JoinHelper.getTablesInJoin(joinedTable = (TableJoined)tempTableRef)).contains(targetTable)) continue;
            foundTableRef = joinedTable;
        }
        return foundTableRef;
    }

    public static List getLeftJoinsForTable(TableExpression tableExpr) {
        boolean isLeft;
        ArrayList<TableJoined> list = new ArrayList<TableJoined>();
        TableJoined tempJoinTable = null;
        TableReference joinTable = tableExpr.getTableJoinedLeft();
        if (joinTable != null) {
            isLeft = true;
        } else {
            joinTable = tableExpr.getTableJoinedRight();
            isLeft = false;
        }
        while (joinTable != null) {
            TableNested nest;
            if (isLeft) {
                list.add((TableJoined)joinTable);
            }
            if ((nest = joinTable.getNest()) != null) {
                joinTable = nest;
            }
            if ((tempJoinTable = joinTable.getTableJoinedLeft()) != null) {
                isLeft = true;
                joinTable = tempJoinTable;
                continue;
            }
            joinTable = joinTable.getTableJoinedRight();
            isLeft = false;
        }
        return list;
    }

    public static TableReference getNestedTable(TableReference tableRef) {
        TableReference nestedTable = tableRef;
        if (tableRef instanceof TableNested) {
            nestedTable = ((TableNested)tableRef).getNestedTableRef();
        }
        return nestedTable;
    }

    public static List getRightJoinsForTable(TableExpression tableExpr) {
        boolean isRight;
        ArrayList<TableJoined> list = new ArrayList<TableJoined>();
        TableJoined tempJoinTable = null;
        TableReference joinTable = tableExpr.getTableJoinedRight();
        if (joinTable != null) {
            isRight = true;
        } else {
            joinTable = tableExpr.getTableJoinedLeft();
            isRight = false;
        }
        while (joinTable != null) {
            TableNested nest;
            if (isRight) {
                list.add((TableJoined)joinTable);
            }
            if ((nest = joinTable.getNest()) != null) {
                joinTable = nest;
            }
            if ((tempJoinTable = joinTable.getTableJoinedRight()) != null) {
                isRight = true;
                joinTable = tempJoinTable;
                continue;
            }
            joinTable = joinTable.getTableJoinedLeft();
            isRight = false;
        }
        return list;
    }

    public static String getGenericType(Object datatype) {
        return GENERIC_CHARACTER;
    }

    public static List getTablesInJoin(TableJoined join) {
        TableJoined tempJoin;
        TableNested tableNested;
        ArrayList<TableReference> list = new ArrayList<TableReference>();
        TableReference leftContent = join.getTableRefLeft();
        TableReference rightContent = join.getTableRefRight();
        if (leftContent instanceof TableExpression) {
            list.add(leftContent);
        } else if (leftContent instanceof TableNested) {
            tableNested = (TableNested)leftContent;
            list.addAll(JoinHelper.getTablesInNestedTable(tableNested));
        } else if (leftContent instanceof TableJoined) {
            tempJoin = (TableJoined)leftContent;
            list.addAll(JoinHelper.getTablesInJoin(tempJoin));
        }
        if (rightContent instanceof TableExpression) {
            list.add(rightContent);
        } else if (rightContent instanceof TableNested) {
            tableNested = (TableNested)rightContent;
            list.addAll(JoinHelper.getTablesInNestedTable(tableNested));
        } else if (rightContent instanceof TableJoined) {
            tempJoin = (TableJoined)rightContent;
            list.addAll(JoinHelper.getTablesInJoin(tempJoin));
        }
        return list;
    }

    public static List getTablesInNestedTable(TableNested tableNested) {
        ArrayList<TableReference> list = new ArrayList<TableReference>();
        TableReference tableRef = tableNested.getNestedTableRef();
        if (tableRef instanceof TableExpression) {
            list.add(tableRef);
        } else if (tableRef instanceof TableNested) {
            list.addAll(JoinHelper.getTablesInNestedTable((TableNested)tableRef));
        } else if (tableRef instanceof TableJoined) {
            list.addAll(JoinHelper.getTablesInJoin((TableJoined)tableRef));
        }
        return list;
    }

    public static void removeJoin(List fromClause, TableJoined joinedTable) {
        TableJoined tempJoin;
        TableNested tableNested;
        List leftTableList = new ArrayList<TableReference>();
        List rightTableList = new ArrayList<TableReference>();
        TableReference leftChild = joinedTable.getTableRefLeft();
        TableReference rightChild = joinedTable.getTableRefRight();
        if (leftChild instanceof TableExpression) {
            leftTableList.add(leftChild);
        } else if (leftChild instanceof TableNested) {
            tableNested = (TableNested)leftChild;
            leftTableList = JoinHelper.getTablesInNestedTable(tableNested);
        } else if (leftChild instanceof TableJoined) {
            tempJoin = (TableJoined)leftChild;
            leftTableList = JoinHelper.getTablesInJoin(tempJoin);
        }
        if (rightChild instanceof TableExpression) {
            rightTableList.add(rightChild);
        } else if (rightChild instanceof TableNested) {
            tableNested = (TableNested)rightChild;
            rightTableList = JoinHelper.getTablesInNestedTable(tableNested);
        } else if (rightChild instanceof TableJoined) {
            tempJoin = (TableJoined)rightChild;
            rightTableList = JoinHelper.getTablesInJoin(tempJoin);
        }
        TableJoined parentJoin = null;
        TableNested nestTable = joinedTable.getNest();
        parentJoin = nestTable != null ? nestTable.getTableJoinedLeft() : joinedTable.getTableJoinedLeft();
        boolean isRightChild = false;
        if (parentJoin == null) {
            parentJoin = nestTable != null ? nestTable.getTableJoinedRight() : joinedTable.getTableJoinedRight();
            isRightChild = true;
        }
        ArrayList leftJoinList = new ArrayList();
        ArrayList rightJoinList = new ArrayList();
        Iterator itr = leftTableList.iterator();
        if (parentJoin != null) {
            while (itr.hasNext()) {
                TableExpression table = (TableExpression)itr.next();
                leftJoinList.addAll(JoinHelper.findJoinsWithTableInCondition(table, parentJoin));
            }
            for (TableExpression table : rightTableList) {
                rightJoinList.addAll(JoinHelper.findJoinsWithTableInCondition(table, parentJoin));
            }
        }
        boolean promoteLeftChild = false;
        boolean bumpLeftChild = false;
        boolean promoteRightChild = false;
        boolean bumpRightChild = false;
        if (leftJoinList.isEmpty() && parentJoin != null) {
            bumpLeftChild = true;
        } else {
            promoteLeftChild = true;
        }
        if (rightJoinList.isEmpty() && parentJoin != null) {
            bumpRightChild = true;
        } else {
            promoteRightChild = true;
        }
        joinedTable.setTableRefLeft(null);
        joinedTable.setTableRefRight(null);
        TableReference childToPromote = null;
        if (!promoteLeftChild || !promoteRightChild) {
            if (promoteLeftChild) {
                childToPromote = leftChild;
            } else if (promoteRightChild) {
                childToPromote = rightChild;
            }
        } else if (leftJoinList.size() >= rightJoinList.size()) {
            bumpRightChild = true;
            childToPromote = leftChild;
        } else {
            bumpLeftChild = true;
            childToPromote = rightChild;
        }
        if (parentJoin != null) {
            if (childToPromote != null) {
                if (!isRightChild) {
                    parentJoin.setTableRefLeft(childToPromote);
                } else {
                    parentJoin.setTableRefRight(childToPromote);
                }
            }
        } else {
            TableNested nest = joinedTable.getNest();
            if (nest != null) {
                fromClause.remove(nest);
            } else {
                fromClause.remove(joinedTable);
            }
            if (childToPromote != null) {
                fromClause.add(childToPromote);
            }
        }
        if (bumpRightChild) {
            JoinHelper.removeJoinConditionsForTables(fromClause, rightTableList, rightJoinList);
            fromClause.add(rightChild);
        } else if (bumpLeftChild) {
            JoinHelper.removeJoinConditionsForTables(fromClause, leftTableList, leftJoinList);
            fromClause.add(0, leftChild);
        }
    }

    public static void removeJoinCondition(List fromClause, TableJoined joinedTable, PredicateBasic joinCond) {
        QuerySearchCondition onClause = joinedTable.getJoinCondition();
        if (onClause != null && joinCond != null) {
            QuerySearchCondition newCondition = JoinHelper.removePredicateFromCondition(joinCond, onClause);
            joinedTable.setJoinCondition(newCondition);
        }
        if (joinedTable.getJoinCondition() == null) {
            JoinHelper.removeJoin(fromClause, joinedTable);
        }
    }

    public static void removeJoinConditionsForTables(List fromClause, List tableList, List joinList) {
        if (tableList != null && joinList != null) {
            for (TableExpression table : tableList) {
                for (TableJoined join : joinList) {
                    QuerySearchCondition cond = join.getJoinCondition();
                    List predList = JoinHelper.findConditionsContainingTable(cond, table);
                    for (PredicateBasic pred : predList) {
                        JoinHelper.removeJoinCondition(fromClause, join, pred);
                    }
                }
            }
        }
    }

    public static void removeJoinsForTable(List fromClause, TableExpression table) {
        TableJoined joinedTable = table.getTableJoinedLeft();
        if (joinedTable == null) {
            joinedTable = table.getTableJoinedRight();
        }
        while (joinedTable != null) {
            JoinHelper.removeJoin(fromClause, joinedTable);
            joinedTable = table.getTableJoinedLeft();
            if (joinedTable != null) continue;
            joinedTable = table.getTableJoinedRight();
        }
    }

    public static QuerySearchCondition removePredicateFromCondition(Predicate pred, QuerySearchCondition searchCon) {
        if (pred.getCombinedRight() == null && pred.getCombinedLeft() == null) {
            searchCon = null;
        } else if (pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() == null) {
            searchCon = pred.getCombinedRight().getLeftCondition();
            searchCon.setCombinedLeft(null);
        } else if (pred.getCombinedLeft() != null) {
            if (pred.getCombinedLeft().getCombinedLeft() != null) {
                pred.getCombinedLeft().getCombinedLeft().setLeftCondition(pred.getCombinedLeft().getRightCondition());
            } else {
                searchCon = pred.getCombinedLeft().getRightCondition();
            }
        } else if (pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() != null) {
            SearchConditionCombined currentGroup = pred.getCombinedRight();
            pred.getCombinedRight().setRightCondition(pred.getCombinedRight().getCombinedLeft().getRightCondition());
            currentGroup.setCombinedLeft(currentGroup.getCombinedLeft().getCombinedLeft());
            if (currentGroup.getCombinedLeft() == null) {
                searchCon = currentGroup;
            }
        }
        return searchCon;
    }

    private static String getComparisonLiteralFromSymbol(String compKind) {
        String retVal = "";
        if (compKind.equalsIgnoreCase("=")) {
            retVal = "EQUAL";
        } else if (compKind.equalsIgnoreCase("<")) {
            retVal = "LESS_THAN";
        } else if (compKind.equalsIgnoreCase("<=")) {
            retVal = "LESS_THAN_OR_EQUAL";
        } else if (compKind.equalsIgnoreCase(">")) {
            retVal = "GREATER_THAN";
        } else if (compKind.equalsIgnoreCase(">=")) {
            retVal = "GREATER_THAN_OR_EQUAL";
        } else if (compKind.equalsIgnoreCase("<>")) {
            retVal = "NOT_EQUAL";
        }
        return retVal;
    }
}

