/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.modelbase.sql.query.helper;

import com.ibm.ims.datatools.modelbase.sql.query.QueryStatement;
import com.ibm.ims.datatools.modelbase.sql.query.TableInDatabase;
import com.ibm.ims.datatools.modelbase.sql.query.TableReference;
import com.ibm.ims.datatools.modelbase.sql.query.helper.StatementHelper;
import com.ibm.ims.datatools.modelbase.sql.query.helper.TableHelper;
import com.ibm.ims.datatools.modelbase.sql.routines.Procedure;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class DatabaseHelper {
    public static void resolveTableReferenceRDBTables(QueryStatement aSQLStmt, Database aDatabase, String aDefaultSchemaName) {
        List tableRefList = StatementHelper.getTablesForStatement(aSQLStmt);
        DatabaseHelper.resolveTableReferenceRDBTables(tableRefList, aDatabase, aDefaultSchemaName);
    }

    public static void resolveTableReferenceRDBTables(List aTableRefList, Database aDatabase, String aDefaultSchemaName) {
        TableInDatabase table = null;
        for (TableReference tblRef : aTableRefList) {
            if (!(tblRef instanceof TableInDatabase)) continue;
            table = (TableInDatabase)tblRef;
            DatabaseHelper.resolveTableReferenceRDBTable(table, aDatabase, aDefaultSchemaName);
        }
    }

    public static void resolveTableReferenceRDBTable(TableInDatabase aTableInDB, Database aDatabase, String aDefaultSchemaName) {
        Table rdbTable = null;
        Schema rdbSchema = null;
        String rdbSchemaName = null;
        String searchTableName = null;
        searchTableName = aTableInDB.getName();
        Table tempRdbTbl = aTableInDB.getDatabaseTable();
        Schema tempRdbSch = null;
        if (tempRdbTbl != null) {
            tempRdbSch = tempRdbTbl.getSchema();
            rdbSchemaName = tempRdbSch != null && tempRdbSch.getName() != null && tempRdbSch.getName().length() > 0 ? tempRdbSch.getName() : aDefaultSchemaName;
        }
        if ((rdbSchema = DatabaseHelper.findSchema(aDatabase, rdbSchemaName)) != null) {
            rdbTable = DatabaseHelper.findTable(rdbSchema, searchTableName);
        }
        if (rdbTable != null) {
            aTableInDB.setDatabaseTable(rdbTable);
            TableHelper.populateTableExpressionColumns(aTableInDB, rdbTable);
        }
    }

    public static Procedure findProcedure(Schema schema, String procName) {
        Procedure returnProc = null;
        if (schema != null && procName != null) {
            String dbProcName;
            Procedure dbProc;
            EList dbProcList = schema.getProcedures();
            Iterator dbProcListIter = dbProcList.iterator();
            while (dbProcListIter.hasNext() && returnProc == null) {
                dbProc = (Procedure)dbProcListIter.next();
                dbProcName = dbProc.getName();
                if (!procName.equals(dbProcName)) continue;
                returnProc = dbProc;
            }
            if (returnProc == null) {
                dbProcListIter = dbProcList.iterator();
                while (dbProcListIter.hasNext() && returnProc == null) {
                    dbProc = (Procedure)dbProcListIter.next();
                    dbProcName = dbProc.getName();
                    if (!procName.equalsIgnoreCase(dbProcName)) continue;
                    returnProc = dbProc;
                }
            }
        }
        return returnProc;
    }

    public static Schema findSchema(Database database, String schemaName) {
        Schema returnSchema = null;
        if (schemaName != null) {
            String dbSchemaName;
            Schema dbSchema;
            EList catalogList;
            Object dbSchemaList = database.getSchemas();
            if ((dbSchemaList == null || dbSchemaList.isEmpty()) && !(catalogList = database.getCatalogs()).isEmpty()) {
                dbSchemaList = new ArrayList();
                for (Catalog currentCatalog : catalogList) {
                    dbSchemaList.addAll(currentCatalog.getSchemas());
                }
            }
            Iterator dbSchemaListIter = dbSchemaList.iterator();
            while (dbSchemaListIter.hasNext() && returnSchema == null) {
                dbSchema = (Schema)dbSchemaListIter.next();
                dbSchemaName = dbSchema.getName();
                if (!schemaName.equals(dbSchemaName)) continue;
                returnSchema = dbSchema;
            }
            if (returnSchema == null) {
                dbSchemaListIter = dbSchemaList.iterator();
                while (dbSchemaListIter.hasNext() && returnSchema == null) {
                    dbSchema = (Schema)dbSchemaListIter.next();
                    dbSchemaName = dbSchema.getName();
                    if (!schemaName.equalsIgnoreCase(dbSchemaName)) continue;
                    returnSchema = dbSchema;
                }
            }
            if (returnSchema == null) {
                String trimmedSchemaName = DatabaseHelper.trimTrailing(schemaName);
                dbSchemaListIter = dbSchemaList.iterator();
                while (dbSchemaListIter.hasNext() && returnSchema == null) {
                    Schema dbSchema2 = (Schema)dbSchemaListIter.next();
                    String trimmedDBSchemaName = DatabaseHelper.trimTrailing(dbSchema2.getName());
                    if (!trimmedSchemaName.equals(trimmedDBSchemaName)) continue;
                    returnSchema = dbSchema2;
                }
            }
        }
        return returnSchema;
    }

    public static Table findTable(Schema schema, String tableName) {
        Table returnTable = null;
        if (tableName != null) {
            String dbTableName;
            Table dbTable;
            EList dbTableList = schema.getTables();
            Iterator dbTableListIter = dbTableList.iterator();
            while (dbTableListIter.hasNext() && returnTable == null) {
                dbTable = (Table)dbTableListIter.next();
                dbTableName = dbTable.getName();
                if (!tableName.equals(dbTableName)) continue;
                returnTable = dbTable;
            }
            if (returnTable == null) {
                dbTableListIter = dbTableList.iterator();
                while (dbTableListIter.hasNext() && returnTable == null) {
                    dbTable = (Table)dbTableListIter.next();
                    dbTableName = dbTable.getName();
                    if (!tableName.equalsIgnoreCase(dbTableName)) continue;
                    returnTable = dbTable;
                }
            }
        }
        return returnTable;
    }

    protected static String trimTrailing(String str) {
        return str.replaceAll("\\s+$", "");
    }
}

