/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.etools.cobol.COBOLAddressingType;
import com.ibm.etools.cobol.COBOLAlphaNumericEditedType;
import com.ibm.etools.cobol.COBOLAlphaNumericType;
import com.ibm.etools.cobol.COBOLAlphabeticType;
import com.ibm.etools.cobol.COBOLDBCSType;
import com.ibm.etools.cobol.COBOLExternalFloatType;
import com.ibm.etools.cobol.COBOLInternalFloatType;
import com.ibm.etools.cobol.COBOLNumericEditedType;
import com.ibm.etools.cobol.COBOLNumericType;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLTruncValue;
import com.ibm.etools.cobol.COBOLUnicodeType;
import com.ibm.etools.cobol.COBOLUsageValues;
import com.ibm.etools.cobol.importer.CobolTypeUtilities;
import com.ibm.etools.ctc.cobol2xsd.Cobol2XSDPlugin;
import com.ibm.etools.ctc.cobol2xsd.MessageResource;
import com.ibm.etools.ctc.cobol2xsd.typesimport.CobolTypeHelper;
import com.ibm.etools.ctc.cobol2xsd.typesimport.GeneralUtil;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.icu.text.UTF16;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class XsdHelper {
    protected static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected static XsdHelper thisInstance;
    protected XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
    protected static HashMap rangeLookup;

    static {
        rangeLookup = new HashMap();
        rangeLookup.put("short", new String[]{"-32768", "32767"});
        rangeLookup.put("unsignedShort", new String[]{"0", "65535"});
        rangeLookup.put("int", new String[]{"-2147483648", "2147483647"});
        rangeLookup.put("unsignedInt", new String[]{"0", "4294967295"});
        rangeLookup.put("long", new String[]{"-9223372036854775808", "9223372036854775807"});
        rangeLookup.put("unsignedLong", new String[]{"0", "18446744073709551615"});
    }

    public static String[] getDataTypeValueRange(String dataType) {
        return (String[])rangeLookup.get(dataType);
    }

    public void addComplexTypeOrGroupToSchema(XSDSchemaContent schemaContent, XSDSchema schema, boolean overwriteTypes) throws BaseException {
        EList schemaContents = schema.getContents();
        int pos = this.indexInContentsList((List)schemaContents, schemaContent);
        if (!(pos < 0 || pos >= 0 && overwriteTypes)) {
            String errorMsg = MessageResource._ERROR_error_types_name_collision;
            String name = "";
            if (schemaContent instanceof XSDComplexTypeDefinition) {
                name = ((XSDComplexTypeDefinition)schemaContent).getName();
            } else if (schemaContent instanceof XSDModelGroupDefinition) {
                name = ((XSDModelGroupDefinition)schemaContent).getName();
            }
            Status status = new Status(4, Cobol2XSDPlugin.getPluginID(), 4, String.valueOf(errorMsg) + ": " + name, null);
            throw new BaseException((IStatus)status);
        }
        new GeneralUtil().replaceOrAppendToList((List)schemaContents, schemaContent, pos);
    }

    protected int countLength(String picStr) {
        int len = picStr.length();
        int leftBracketPos = -1;
        int i = 0;
        while (i < picStr.length()) {
            int c = UTF16.charAt((String)picStr, (int)i);
            if (c == 86 || c == 118 || c == 80 || c == 112 || c == 115 || c == 83) {
                --len;
            } else if (c == 40) {
                --len;
                leftBracketPos = i;
            } else if (c == 41) {
                --len;
                len -= i - leftBracketPos - 1;
                if (UTF16.charAt((String)picStr, (int)(leftBracketPos - 1)) != 112 && UTF16.charAt((String)picStr, (int)(leftBracketPos - 1)) != 80) {
                    len += Integer.parseInt(picStr.substring(leftBracketPos + 1, i)) - 1;
                }
            }
            i += UTF16.getCharCount((int)c);
        }
        return len;
    }

    public XSDModelGroupDefinition createGroupDef(String name, String modelGroupType, XSDSchema xsdSchema) {
        XSDModelGroupDefinition group = this.xsdFactory.createXSDModelGroupDefinition();
        group.setName(name);
        group.setTargetNamespace(xsdSchema.getTargetNamespace());
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.get((String)modelGroupType));
        group.setModelGroup(modelGroup);
        return group;
    }

    public String createGroupNameFromRefID(String refID, String topTypeName) {
        String str = refID.substring(refID.indexOf(":") + 1);
        String path = str.substring(str.indexOf("/"));
        String childTypeName = path.replaceAll("_", "__").toLowerCase();
        str = String.valueOf(topTypeName) + childTypeName;
        return str.replace('/', '_').toLowerCase();
    }

    public XSDParticle createGroupRefParticle(XSDModelGroupDefinition group) {
        XSDModelGroupDefinition groupRef = this.xsdFactory.createXSDModelGroupDefinition();
        groupRef.setResolvedModelGroupDefinition(group);
        XSDParticle groupRefPart = this.xsdFactory.createXSDParticle();
        groupRefPart.setContent((XSDParticleContent)groupRef);
        return groupRefPart;
    }

    public XSDComplexTypeDefinition createComplexTypeWithModelGroup(String ctName, String groupType) {
        XSDComplexTypeDefinition ct = this.xsdFactory.createXSDComplexTypeDefinition();
        ct.setName(ctName);
        XSDParticle part = this.xsdFactory.createXSDParticle();
        ct.setContent((XSDComplexTypeContent)part);
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.get((String)groupType));
        part.setContent((XSDParticleContent)modelGroup);
        return ct;
    }

    public XSDParticle createComplexTypeParticle(String eleName, String ctName, XSDSchema schema) {
        XSDParticle particle = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        elementDec.setName(eleName);
        particle.setContent((XSDParticleContent)elementDec);
        elementDec.setTypeDefinition((XSDTypeDefinition)this.getXSDTypeForComplex(schema, ctName));
        return particle;
    }

    public XSDParticle createXsdElementPartWithComplexType(String eleName, int groupType, XSDModelGroup modelGroup) {
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(eleName);
        elementPart.setContent((XSDParticleContent)element);
        XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
        modelGroup.setCompositor(XSDCompositor.get((int)groupType));
        XSDParticle groupPart = this.xsdFactory.createXSDParticle();
        groupPart.setContent((XSDParticleContent)modelGroup);
        complexType.setContent((XSDComplexTypeContent)groupPart);
        element.setAnonymousTypeDefinition((XSDTypeDefinition)complexType);
        return elementPart;
    }

    public static synchronized XsdHelper getInstance() {
        if (thisInstance == null) {
            thisInstance = new XsdHelper();
        }
        return thisInstance;
    }

    protected String getMaxVal(String picStr) {
        String result = "";
        boolean countThis9 = true;
        int leftBracketPos = -1;
        if (picStr.length() > 1 && picStr.substring(0, 2).equalsIgnoreCase("sp") || picStr.substring(0, 1).equalsIgnoreCase("p")) {
            result = String.valueOf(result) + "0.";
        }
        if (picStr.length() > 1 && picStr.substring(0, 2).equalsIgnoreCase("sv") || picStr.substring(0, 1).equalsIgnoreCase("v")) {
            result = String.valueOf(result) + "0";
        }
        int i = 0;
        while (i < picStr.length()) {
            int c = UTF16.charAt((String)picStr, (int)i);
            if (c == 112 || c == 80) {
                result = String.valueOf(result) + "0";
            } else if (c == 57 && countThis9) {
                result = String.valueOf(result) + "9";
            } else if (c == 118 || c == 86) {
                result = String.valueOf(result) + ".";
            } else if (c == 40) {
                leftBracketPos = i;
                countThis9 = false;
            } else if (c == 41) {
                int j;
                if (UTF16.charAt((String)picStr, (int)(leftBracketPos - 1)) == 57) {
                    int loop9 = Integer.parseInt(picStr.substring(leftBracketPos + 1, i)) - 1;
                    j = 0;
                    while (j < loop9) {
                        result = String.valueOf(result) + "9";
                        ++j;
                    }
                } else {
                    int loop0 = Integer.parseInt(picStr.substring(leftBracketPos + 1, i)) - 1;
                    j = 0;
                    while (j < loop0) {
                        result = String.valueOf(result) + "0";
                        ++j;
                    }
                }
                countThis9 = true;
            }
            i += UTF16.getCharCount((int)c);
        }
        return result;
    }

    protected String getMinVal(String picStr) {
        if (picStr.startsWith("s") || picStr.startsWith("S")) {
            return "-" + this.getMaxVal(picStr);
        }
        return "0";
    }

    public XSDModelGroup getModelGroup(XSDSchemaContent type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return this.getModelGroup((XSDComplexTypeDefinition)type);
        }
        if (type instanceof XSDModelGroupDefinition) {
            return this.getModelGroup((XSDModelGroupDefinition)type);
        }
        return null;
    }

    public XSDModelGroup getModelGroup(XSDComplexTypeDefinition compType) {
        return (XSDModelGroup)((XSDParticle)compType.getContent()).getContent();
    }

    public XSDModelGroup getModelGroup(XSDModelGroupDefinition groupType) {
        return groupType.getModelGroup();
    }

    public List getModelGroupContents(XSDSchemaContent type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return this.getModelGroupContents((XSDComplexTypeDefinition)type);
        }
        if (type instanceof XSDModelGroupDefinition) {
            return this.getModelGroupContents((XSDModelGroupDefinition)type);
        }
        return null;
    }

    public List getModelGroupContents(XSDComplexTypeDefinition ct) {
        return ((XSDModelGroup)((XSDParticle)ct.getContent()).getContent()).getContents();
    }

    public List getModelGroupContents(XSDModelGroupDefinition group) {
        return group.getModelGroup().getContents();
    }

    public String getNameForXSDSchemaContent(XSDSchemaContent con) {
        if (con instanceof XSDElementDeclaration) {
            return ((XSDElementDeclaration)con).getName();
        }
        if (con instanceof XSDSimpleTypeDefinition) {
            return ((XSDSimpleTypeDefinition)con).getName();
        }
        if (con instanceof XSDComplexTypeDefinition) {
            return ((XSDComplexTypeDefinition)con).getName();
        }
        if (con instanceof XSDModelGroupDefinition) {
            return ((XSDModelGroupDefinition)con).getName();
        }
        return null;
    }

    public XSDSchema getXsdSchemaFromXsdIFile(IFile xsdSchemaFile) {
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(URI.createFileURI((String)xsdSchemaFile.getLocation().toOSString()));
        Resource resource = factory.createResource(URI.createFileURI((String)xsdSchemaFile.getLocation().toOSString()));
        EList list = resource.getContents();
        int i = 0;
        while (i < list.size()) {
            Object candidate = list.get(i);
            if (candidate instanceof XSDSchema) {
                return (XSDSchema)candidate;
            }
            ++i;
        }
        return null;
    }

    public XSDSimpleTypeDefinition getXSDSimpleType(COBOLSimpleType cobolSimType, XSDSchema schema, InstanceTDBase tdBase, boolean generateTotalFractionDigitsFacet) {
        XSDSimpleTypeDefinition xsdSimType = this.xsdFactory.createXSDSimpleTypeDefinition();
        if (cobolSimType instanceof COBOLAlphabeticType || cobolSimType instanceof COBOLAlphaNumericType || cobolSimType instanceof COBOLAlphaNumericEditedType || cobolSimType instanceof COBOLNumericEditedType) {
            this.setRestrictionAndLengthFacet(schema, xsdSimType, cobolSimType.getPictureString(), "string");
        } else if (cobolSimType instanceof COBOLNumericType) {
            COBOLNumericType cobolNumType = (COBOLNumericType)cobolSimType;
            COBOLUsageValues usage = cobolNumType.getUsage();
            COBOLTruncValue truncType = cobolNumType.getTrunc();
            String picStr = CobolTypeHelper.getInstance().getExpandedPictureString(cobolSimType);
            int num9 = this.countLength(picStr);
            if (picStr.indexOf("V") >= 0 || picStr.indexOf("v") >= 0 || picStr.indexOf("p") >= 0 || picStr.indexOf("P") >= 0) {
                if (usage == COBOLUsageValues.BINARY_LITERAL && truncType == COBOLTruncValue.BIN_LITERAL) {
                    if (picStr.startsWith("S") || picStr.startsWith("s")) {
                        if (num9 <= 4) {
                            this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal", "short");
                        } else if (num9 <= 9) {
                            this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal", "int");
                        } else if (num9 <= 18) {
                            this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal", "long");
                        }
                    } else if (num9 <= 4) {
                        this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal", "unsignedShort");
                    } else if (num9 <= 9) {
                        this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal", "unsignedInt");
                    } else if (num9 <= 18) {
                        this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal", "unsignedLong");
                    }
                } else {
                    this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "decimal");
                }
            } else if (num9 > 18) {
                if (num9 < 32) {
                    this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "integer");
                }
            } else {
                if (usage == COBOLUsageValues.BINARY_LITERAL && truncType == COBOLTruncValue.BIN_LITERAL) {
                    if (picStr.startsWith("S") || picStr.startsWith("s")) {
                        if (num9 <= 4) {
                            this.setXsdSimpleType(xsdSimType, schema, "short");
                        } else if (num9 <= 9) {
                            this.setXsdSimpleType(xsdSimType, schema, "int");
                        } else if (num9 <= 18) {
                            this.setXsdSimpleType(xsdSimType, schema, "long");
                        }
                    } else if (num9 <= 4) {
                        this.setXsdSimpleType(xsdSimType, schema, "unsignedShort");
                    } else if (num9 <= 9) {
                        this.setXsdSimpleType(xsdSimType, schema, "unsignedInt");
                    } else if (num9 <= 18) {
                        this.setXsdSimpleType(xsdSimType, schema, "unsignedLong");
                    }
                }
                if (usage == COBOLUsageValues.DISPLAY_LITERAL || usage == COBOLUsageValues.PACKED_DECIMAL_LITERAL || usage == COBOLUsageValues.BINARY_LITERAL && truncType != COBOLTruncValue.BIN_LITERAL) {
                    if (num9 <= 4) {
                        this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "short");
                    } else if (num9 <= 9) {
                        this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "int");
                    } else if (num9 <= 18) {
                        this.setRestrictionAndMinMaxFacet(schema, xsdSimType, picStr, "long");
                    }
                }
            }
            if (generateTotalFractionDigitsFacet) {
                this.setTotalAndFractionDigitsFacet(xsdSimType, (COBOLNumericType)cobolSimType);
            }
        } else if (cobolSimType instanceof COBOLDBCSType || cobolSimType instanceof COBOLUnicodeType) {
            this.setRestrictionAndLengthFacet(schema, xsdSimType, cobolSimType.getPictureString(), "string");
        } else if (cobolSimType instanceof COBOLExternalFloatType) {
            this.setRestrictionAndLengthFacet(schema, xsdSimType, CobolTypeHelper.getInstance().getExpandedPictureString(cobolSimType), "string");
        } else if (cobolSimType instanceof COBOLInternalFloatType) {
            COBOLUsageValues fpUsage = cobolSimType.getUsage();
            if (fpUsage == COBOLUsageValues.FLOAT_LITERAL) {
                this.setXsdSimpleType(xsdSimType, schema, "float");
            } else if (fpUsage == COBOLUsageValues.DOUBLE_LITERAL) {
                this.setXsdSimpleType(xsdSimType, schema, "double");
            }
        } else if (cobolSimType instanceof COBOLAddressingType) {
            XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
            XSDMaxLengthFacet lenFacet = xsdFactory.createXSDMaxLengthFacet();
            XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", "hexBinary");
            xsdSimType.setBaseTypeDefinition(simType);
            lenFacet.setLexicalValue(tdBase.getSize());
            xsdSimType.getFacetContents().add((Object)lenFacet);
        }
        return xsdSimType;
    }

    public XSDComplexTypeDefinition getXSDTypeForComplex(XSDSchema schema, String itemName) {
        XSDComplexTypeDefinition complexType = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").resolveComplexTypeDefinition("http://www.w3.org/2001/XMLSchema", itemName);
        complexType.setTargetNamespace(schema.getTargetNamespace());
        return complexType;
    }

    protected void setXsdSimpleType(XSDSimpleTypeDefinition xsdSimType, XSDSchema schema, String type) {
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", type);
        xsdSimType.setBaseTypeDefinition(simType);
    }

    public void removeTypeFromSchema(XSDSchema xsdSchema, Object type) {
        EList contentList = xsdSchema.getContents();
        contentList.remove(type);
    }

    public XSDComplexTypeDefinition findComplexTypeInSchema(XSDSchema xsdSchema, String complexName) {
        XSDComplexTypeDefinition complexType = null;
        EList contentList = xsdSchema.getContents();
        int i = 0;
        while (i < contentList.size()) {
            Object type = contentList.get(i);
            if (type instanceof XSDComplexTypeDefinition && ((XSDComplexTypeDefinition)type).getName().equals(complexName)) {
                complexType = (XSDComplexTypeDefinition)type;
            }
            ++i;
        }
        return complexType;
    }

    public void initializeSchema(XSDSchema schema, IFile xsdFile, String targetNS) {
        Map prefixNSMap;
        if (targetNS == null) {
            String xsdName = null;
            xsdName = xsdFile == null ? "dumXsdFileName.xsd" : xsdFile.getName();
            xsdName = xsdName.substring(0, xsdName.lastIndexOf("."));
            targetNS = "http://www." + xsdName + ".com/schemas/" + xsdName + "Interface";
        }
        if (schema.getTargetNamespace() == null) {
            schema.setTargetNamespace(targetNS);
        }
        if (!(prefixNSMap = schema.getQNamePrefixToNamespaceMap()).containsValue("http://www.w3.org/2001/XMLSchema")) {
            prefixNSMap.put(schema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        }
        if (!prefixNSMap.containsValue(schema.getTargetNamespace())) {
            prefixNSMap.put("xsd1", schema.getTargetNamespace());
        }
    }

    public int indexInContentsList(List list, Object newEle) {
        int index;
        block4: {
            block5: {
                index = -1;
                if (!(newEle instanceof XSDModelGroupDefinition)) break block5;
                XSDModelGroupDefinition newGroup = (XSDModelGroupDefinition)newEle;
                int i = 0;
                while (i < list.size()) {
                    XSDModelGroupDefinition group;
                    Object obj = list.get(i);
                    if (obj instanceof XSDModelGroupDefinition && (group = (XSDModelGroupDefinition)obj).getName().equals(newGroup.getName())) {
                        index = i;
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (!(newEle instanceof XSDComplexTypeDefinition)) break block4;
            XSDComplexTypeDefinition newCT = (XSDComplexTypeDefinition)newEle;
            int i = 0;
            while (i < list.size()) {
                XSDComplexTypeDefinition ct;
                Object obj = list.get(i);
                if (obj instanceof XSDComplexTypeDefinition && (ct = (XSDComplexTypeDefinition)obj).getName().equals(newCT.getName())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    protected void setRestrictionAndLengthFacet(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, String picStr, String base) {
        XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
        XSDMaxLengthFacet lenFacet = xsdFactory.createXSDMaxLengthFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        lenFacet.setLexicalValue(new Integer(this.countLength(picStr)).toString());
        xsdSimType.getFacetContents().add((Object)lenFacet);
    }

    protected void setRestrictionAndMinMaxFacet(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, String picStr, String base) {
        XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
        XSDMinInclusiveFacet minInclFacet = xsdFactory.createXSDMinInclusiveFacet();
        XSDMaxInclusiveFacet maxInclFacet = xsdFactory.createXSDMaxInclusiveFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        minInclFacet.setLexicalValue(this.getMinVal(picStr));
        maxInclFacet.setLexicalValue(this.getMaxVal(picStr));
        xsdSimType.getFacetContents().add((Object)minInclFacet);
        xsdSimType.getFacetContents().add((Object)maxInclFacet);
    }

    protected void setRestrictionAndMinMaxFacet(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, String picStr, String base, String valueRangeKey) {
        XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
        XSDMinInclusiveFacet minInclFacet = xsdFactory.createXSDMinInclusiveFacet();
        XSDMaxInclusiveFacet maxInclFacet = xsdFactory.createXSDMaxInclusiveFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        String[] dataTypeValueRange = XsdHelper.getDataTypeValueRange(valueRangeKey);
        int vPosition = CobolTypeUtilities.getVirtualDecimalPointLocation((String)picStr);
        String minValue = "0";
        if (!valueRangeKey.startsWith("unsigned")) {
            minValue = new BigDecimal(dataTypeValueRange[0]).movePointLeft(vPosition).toString();
        }
        String maxValue = new BigDecimal(dataTypeValueRange[1]).movePointLeft(vPosition).toString();
        minInclFacet.setLexicalValue(minValue);
        maxInclFacet.setLexicalValue(maxValue);
        xsdSimType.getFacetContents().add((Object)minInclFacet);
        xsdSimType.getFacetContents().add((Object)maxInclFacet);
    }

    protected void setTotalAndFractionDigitsFacet(XSDSimpleTypeDefinition xsdSimType, COBOLNumericType numericType) {
        if (numericType.getPictureString().toUpperCase().indexOf("P") <= -1) {
            XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
            XSDTotalDigitsFacet totalDigitsFacet = xsdFactory.createXSDTotalDigitsFacet();
            XSDFractionDigitsFacet fractionDigitsFacet = xsdFactory.createXSDFractionDigitsFacet();
            totalDigitsFacet.setLexicalValue(new Integer(numericType.getPrecision()).toString());
            xsdSimType.getFacetContents().add((Object)totalDigitsFacet);
            if (numericType.getScale() != 0) {
                fractionDigitsFacet.setLexicalValue(new Integer(numericType.getScale()).toString());
                xsdSimType.getFacetContents().add((Object)fractionDigitsFacet);
            }
        }
    }
}

