/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.typesimport;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;

public class GeneralUtil {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2011 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static boolean useDoubleUnderScore = true;
    public static final String XSD_SOAPENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private static GeneralUtil thisInstance;

    public static boolean useDoubleUnderScore() {
        return useDoubleUnderScore;
    }

    public static void setUseDoubleUnderScore(boolean underScore) {
        useDoubleUnderScore = underScore;
    }

    public static synchronized GeneralUtil getInstance() {
        if (thisInstance == null) {
            thisInstance = new GeneralUtil();
        }
        return thisInstance;
    }

    public String capitalizeFirstLetter(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() == 0) {
            return str;
        }
        int char32 = UTF16.charAt((String)str, (int)0);
        if (UCharacter.isUpperCase((int)char32)) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char32 = UCharacter.toUpperCase((int)char32);
        UTF16.append((StringBuffer)sb, (int)char32);
        sb.append(str.substring(UTF16.getCharCount((int)char32)));
        return sb.toString();
    }

    public String getJavaNameFromXMLName(String xmlName, String delims) {
        int c;
        StringBuffer buffer = new StringBuffer();
        boolean needUpperCase = false;
        int i = 0;
        int l = xmlName.length();
        while (i < l) {
            c = UTF16.charAt((String)xmlName, (int)i);
            if ((c == 46 || UCharacter.isJavaIdentifierPart((int)c)) && delims.indexOf(c) == -1) {
                if (needUpperCase) {
                    c = UCharacter.toUpperCase((int)c);
                }
                UTF16.append((StringBuffer)buffer, (int)c);
                needUpperCase = false;
            } else {
                needUpperCase = true;
            }
            i += UTF16.getCharCount((int)c);
        }
        if (buffer.length() != 0) {
            c = UTF16.charAt((StringBuffer)buffer, (int)0);
            if (!UCharacter.isJavaIdentifierStart((int)c)) {
                buffer.insert(0, "__");
            }
            boolean allDigits = true;
            int i2 = 0;
            int l2 = buffer.length();
            while (i2 < l2) {
                int ch = UTF16.charAt((StringBuffer)buffer, (int)i2);
                if (!UCharacter.isDigit((int)ch)) {
                    allDigits = false;
                    break;
                }
                i2 += UTF16.getCharCount((int)ch);
            }
            if (allDigits) {
                buffer.insert(0, "__");
            }
        }
        return buffer.toString();
    }

    public String getJavaNameFromXMLName(String xmlName) {
        return this.getJavaNameFromXMLName(xmlName, "-.:\u00b7\u0387\u06dd\u06de");
    }

    public boolean isAllUpperCase(String str) {
        boolean allUpper = true;
        int i = 0;
        while (i < str.length()) {
            int c = UTF16.charAt((String)str, (int)i);
            if (UCharacter.isLowerCase((int)c)) {
                allUpper = false;
                break;
            }
            i += UTF16.getCharCount((int)c);
        }
        return allUpper;
    }

    public void replaceOrAppendToList(List list, Object ele, int pos) {
        if (pos < 0) {
            list.add(ele);
        } else {
            list.set(pos, ele);
        }
    }

    public String stripOffLeadingChar(String str, char c) {
        while (UTF16.charAt((String)str, (int)0) == c) {
            str = str.substring(1);
        }
        return str;
    }

    public String toLowerUpperCaseToken(String str, boolean preserveCase) {
        boolean leading2Underscores = false;
        if (str.startsWith("__")) {
            leading2Underscores = true;
        }
        StringTokenizer tokens = new StringTokenizer(str, "_");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!preserveCase && this.isAllUpperCase(token)) {
                token = token.toLowerCase();
            }
            if (buf.length() > 0) {
                if (useDoubleUnderScore) {
                    buf.append("__");
                } else {
                    buf.append("_");
                }
            }
            buf.append(token);
        }
        String result = buf.toString();
        if (leading2Underscores) {
            result = "__" + result;
        }
        return result;
    }

    public String replaceSpaceWithUnicodeLiteral(String str) {
        String unicodeSpaceStr = "\\u0020";
        int index = str.indexOf(" ");
        if (index == -1) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        while (index != -1) {
            String head = str.substring(0, index);
            sb.append(head);
            sb.append(unicodeSpaceStr);
            str = str.substring(index + 1);
            index = str.indexOf(" ");
        }
        sb.append(str);
        str = sb.toString();
        return str;
    }
}

