/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.typesimport;

import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.importer.CobolSourceResource;
import com.ibm.etools.cobol.importer.CobolTypeUtilities;
import com.ibm.etools.ctc.cobol2xsd.typesimport.GeneralUtil;
import com.ibm.etools.tdlang.TDLangModelElement;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class CobolTypeHelper {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    static CobolTypeHelper fieldInstance;
    Resource importerResource;

    public static synchronized CobolTypeHelper getInstance() {
        if (fieldInstance == null) {
            fieldInstance = new CobolTypeHelper();
        }
        return fieldInstance;
    }

    public List getCobolTopElements() {
        ArrayList eleList = new ArrayList();
        if (this.importerResource == null) {
            return eleList;
        }
        for (Object possibleType : this.importerResource.getContents()) {
            COBOLClassifier childClassifier;
            if (!(possibleType instanceof COBOLElement) || !((childClassifier = ((COBOLElement)possibleType).getSharedType()) instanceof COBOLComposedType)) continue;
            eleList.add(possibleType);
        }
        return eleList;
    }

    public void importCobol(IFile typesFile, HashMap options) throws Exception {
        String fullPath = typesFile.getLocation().toOSString();
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(URI.createFileURI((String)fullPath));
        this.importerResource = factory.createResource(URI.createFileURI((String)fullPath));
        this.importerResource.load((Map)options);
    }

    public String getElementNameFromPath(String path, boolean preserveCase) {
        String name = "";
        int slashPos = path.lastIndexOf("/");
        name = slashPos < 0 ? path : path.substring(slashPos + 1);
        GeneralUtil util = new GeneralUtil();
        name = util.toLowerUpperCaseToken(name, preserveCase);
        return name;
    }

    public String getElementNameFromPathNoCaseChange(String path) {
        String name = "";
        int slashPos = path.lastIndexOf("/");
        name = slashPos < 0 ? path : path.substring(slashPos + 1);
        return name;
    }

    public String getParentPath(String path) {
        int slashPos = path.lastIndexOf("/");
        if (slashPos >= 0) {
            return path.substring(0, path.lastIndexOf("/"));
        }
        return null;
    }

    public String fixCase(String name) {
        name = name.toLowerCase();
        StringBuffer fixedName = new StringBuffer();
        boolean upper = true;
        int i = 0;
        while (i < name.length()) {
            int ch = UTF16.charAt((String)name, (int)i);
            if (upper) {
                UTF16.append((StringBuffer)fixedName, (int)UCharacter.toUpperCase((int)ch));
            } else {
                UTF16.append((StringBuffer)fixedName, (int)ch);
            }
            upper = ch == 95;
            i += UTF16.getCharCount((int)ch);
        }
        return fixedName.toString();
    }

    public String getPathFromRefID(String refID) {
        return refID.substring(refID.indexOf(":") + 1);
    }

    public String getPathFromURI(URI uri) {
        return uri.path();
    }

    public static String getID(TDLangModelElement elem) {
        String id = null;
        id = CobolSourceResource.getRefId((EObject)elem);
        id = id.replace('-', '_');
        return id;
    }

    public String getExpandedPictureString(COBOLSimpleType simpleType) {
        return CobolTypeUtilities.expandPictureString((String)simpleType.getPictureString());
    }
}

