/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.wizard.importdataset;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionUtilities;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.eclipse.common.ui.fieldassist.HistoryContentProposalRegistry;
import com.ibm.cics.eclipse.common.ui.fieldassist.HistoryDropDown;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.ui.ZOSCoreUIMessages;
import com.ibm.cics.zos.ui.views.DataEntryLabelProvider;
import com.ibm.cics.zos.ui.views.DataEntryWrapper;
import com.ibm.cics.zos.ui.views.DataSetRequestFilter;
import com.ibm.cics.zos.ui.views.NewTreeAsynchronousMediator;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class NewDataSetSelectionTree {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2025. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = NewDataSetSelectionTree.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Text filterText;
    private IZOSConnectable zOSConnectable;
    private List<DataEntry> dataEntries;
    private Tree tree;
    private NewTreeAsynchronousMediator treeMediator;
    private boolean showOnlyPartitionedDataSets;
    private List<SelectionListener> listeners;
    private final boolean multiSelect;
    private ConnectionServiceListener connectionServiceListener;
    private ToolItem refreshButton;

    public NewDataSetSelectionTree(Composite parent, boolean showOnlyPDS, boolean multiSelect) {
        this(parent, null, showOnlyPDS, multiSelect);
    }

    public NewDataSetSelectionTree(Composite parent, String initialFilter, boolean showOnlyPDS, boolean multiSelect) {
        this(parent, initialFilter, showOnlyPDS, multiSelect, ConnectionsPlugin.getDefault().getConnectionService());
    }

    NewDataSetSelectionTree(Composite parent, String initialFilter, boolean showOnlyPDS, boolean multiSelect, IConnectionService connService) {
        this.showOnlyPartitionedDataSets = showOnlyPDS;
        this.multiSelect = multiSelect;
        this.listeners = new ArrayList<SelectionListener>();
        connService.addConnectionServiceListener(this.getConnectionServiceListener());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NewDataSetSelectionTree.this.getConnectionServiceListener().makeStale();
            }
        });
        this.createContents(parent, initialFilter);
        this.setConnectable((IZOSConnectable)connService.getConnectable("com.ibm.cics.zos.comm.connection"));
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        if (this.connectionServiceListener == null) {
            this.connectionServiceListener = new ConnectionServiceListener(){

                public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (event.getConnectionCategoryId().equals("com.ibm.cics.zos.comm.connection")) {
                        if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                            NewDataSetSelectionTree.this.setConnectable((IZOSConnectable)event.getConnectable());
                        } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                            NewDataSetSelectionTree.this.setConnectable(null);
                        } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                            NewDataSetSelectionTree.this.setConnectable(null);
                        }
                    }
                }
            };
        }
        return this.connectionServiceListener;
    }

    private void setConnectable(IZOSConnectable aZOSConnectable) {
        this.zOSConnectable = aZOSConnectable;
        this.setEnabled(this.isZOSConnected());
        if (this.isZOSConnected()) {
            this.refreshTree();
        }
    }

    private void setEnabled(final boolean enabled) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewDataSetSelectionTree.this.filterText.setEnabled(enabled);
                NewDataSetSelectionTree.this.tree.setEnabled(enabled);
                NewDataSetSelectionTree.this.refreshButton.setEnabled(enabled);
            }
        });
    }

    private void createContents(Composite parent, String initialFilter) {
        logger.entering(TAG, "createContents(parent={0},initialFilter={1}", new Object[]{parent, initialFilter});
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        c.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(c, 0);
        l.setText(ZOSCoreUIMessages.SelectDataSetDialog_DataSetText_instructions);
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        this.filterText = new Text(c, 2048);
        TextInput.setAccessibleLabel((Text)this.filterText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 1;
        this.filterText.setLayoutData((Object)data);
        EnsureUppercaseListener.attach((Text)this.filterText);
        if (initialFilter == null && StringUtil.isEmpty((String)(initialFilter = HistoryContentProposalRegistry.getLastValue((String)"com.ibm.cics.eclipse.common.datasethistory"))) && this.isZOSConnected()) {
            initialFilter = ConnectionUtilities.getUserID((IConnectable)this.zOSConnectable);
        }
        this.filterText.setText(initialFilter);
        ToolBar toolBar = new ToolBar(c, 0x800000);
        data = new GridData(131072, 0x1000000, false, false);
        data.horizontalIndent = HistoryDropDown.getIndentSpace();
        toolBar.setLayoutData((Object)data);
        this.refreshButton = new ToolItem(toolBar, 0x800000);
        this.refreshButton.setImage(Activator.getImage((String)"IMG_REFRESH"));
        this.refreshButton.setToolTipText(ZOSCoreUIMessages.HFSSelectionTree_refreshButton_tooltip);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDataSetSelectionTree.this.refreshTree();
                NewDataSetSelectionTree.this.filterText.setFocus();
            }
        });
        l = new Label(c, 0);
        l.setText(ZOSCoreUIMessages.SelectDataSetDialog_DataSetsTree_title);
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewDataSetSelectionTree.this.refreshTree();
            }
        });
        int treeStyle = this.multiSelect ? 2 : 4;
        this.tree = new Tree(c, 0x10000800 | treeStyle);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 250;
        this.tree.setLayoutData((Object)gd);
        this.treeMediator = new NewTreeAsynchronousMediator(this.tree, null, (ILabelProvider)new DataEntryLabelProvider()){};
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewDataSetSelectionTree.this.tree.getSelectionCount() > 0) {
                    ArrayList<DataEntry> selectedDataEntries = new ArrayList<DataEntry>();
                    TreeItem[] treeItemArray = NewDataSetSelectionTree.this.tree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray[n2];
                        DataEntry selectedDataEntry = null;
                        Object treeData = treeItem.getData();
                        if (treeData instanceof DataEntryWrapper) {
                            selectedDataEntry = ((DataEntryWrapper)treeData).source;
                        } else if (treeData instanceof DataEntry) {
                            selectedDataEntry = (DataEntry)treeData;
                        }
                        selectedDataEntries.add(selectedDataEntry);
                        ++n2;
                    }
                    if (NewDataSetSelectionTree.this.multiSelect || selectedDataEntries.size() == 1) {
                        NewDataSetSelectionTree.this.updateSelection(selectedDataEntries, e);
                    }
                }
            }
        });
        this.treeMediator.setRoot((Object)this.getRoot());
        this.refreshTree();
        this.filterText.setFocus();
        logger.exiting(TAG, "createContents()", new Object[0]);
    }

    private DataSetRequestFilter getRoot() {
        if (this.isZOSConnected()) {
            DataSetRequestFilter filter = new DataSetRequestFilter(this.filterText.getText(), this.zOSConnectable);
            filter.includeOnlyEditableDataSets(true);
            filter.showOnlyPartitionedDataSets(this.showOnlyPartitionedDataSets);
            return filter;
        }
        return null;
    }

    private void refreshTree() {
        logger.entering(TAG, "refreshTree()", new Object[0]);
        this.tree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (StringUtil.hasContent((String)NewDataSetSelectionTree.this.filterText.getText())) {
                    NewDataSetSelectionTree.this.searchRequested(NewDataSetSelectionTree.this.filterText.getText());
                }
            }
        });
        logger.exiting(TAG, "refreshTree()", new Object[0]);
    }

    private void searchRequested(String aText) {
        logger.entering(TAG, "searchRequested(aText={0})", new Object[]{aText});
        if (this.isZOSConnected()) {
            this.treeMediator.setRoot((Object)this.getRoot());
        }
        logger.exiting(TAG, "searchRequested(String)", new Object[0]);
    }

    private void updateSelection(List<DataEntry> selectedEntries, SelectionEvent e) {
        logger.entering(TAG, "updateSelection(selectedEntries={0},e={1})", new Object[]{selectedEntries, e});
        this.dataEntries = selectedEntries;
        for (SelectionListener listener : this.listeners) {
            listener.widgetSelected(e);
        }
        logger.exiting(TAG, "updateSelection(List<DataEntry>,SelectionEvent)", new Object[0]);
    }

    public List<DataEntry> getSelections() {
        return this.dataEntries;
    }

    public void addTreeSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    private boolean isZOSConnected() {
        return this.zOSConnectable != null && this.zOSConnectable.isConnected();
    }
}

