/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.wizard.importdataset;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionStateViewer;
import com.ibm.cics.core.connections.internal.ConnectionStatus;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.zos.comm.IZOSConstants;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.DataSet;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.cics.zos.model.SequentialDataSet;
import com.ibm.cics.zos.ui.views.DataSetRequestFilter;
import com.ibm.cics.zos.ui.views.NewTreeAsynchronousMediator;
import com.ibm.ims.explorer.eclipse.common.ExplorerEclipseCommonPlugin;
import com.ibm.ims.explorer.utilities.Utility;
import com.ibm.ims.explorer.wizard.importdataset.NewDataSetSelectionTree;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportDataSetWizardPage
extends WizardPage
implements IZOSConstants,
MouseListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IZOSConnectable zOSConnectable;
    private Text filterText;
    private Label searchLabel;
    private NewDataSetSelectionTree selTree;
    private NewTreeAsynchronousMediator treeMediator;
    private ConnectionServiceListener connectionServiceListener;
    private Composite composite;
    private ConnectionWidgetManager connectionWidgetManager;
    private IConnectionService connService;
    private int wizMode;
    private Vector<Member> selectedMembers;
    private Vector<PartitionedDataSet> impliedPdsList;
    private HashMap<PartitionedDataSet, Vector<Member>> impliedPdsMembers;
    private String dsName;

    public ImportDataSetWizardPage(int wizMode, boolean importSource) {
        super("Import from data set wizard");
        this.wizMode = wizMode;
        this.setTitle(ExplorerEclipseCommonPlugin.getLabel().getString("IMPORT_DATASET_WIZARD_PAGE_TITLE"));
        if (importSource) {
            if (wizMode == 3) {
                this.setDescription(ExplorerEclipseCommonPlugin.getDescription().getString("IMPORT_DATASET_INSTR_SRC_SEARCH_PDS"));
            } else {
                this.setDescription(ExplorerEclipseCommonPlugin.getDescription().getString("IMPORT_DATASET_INSTR_SRC"));
            }
        } else {
            this.setDescription(ExplorerEclipseCommonPlugin.getDescription().getString("IMPORT_DATASET_INSTR_COPYBOOKS"));
        }
        this.setImageDescriptor(Utility.getImageDescriptor("host_connect_import_wizard_64.gif"));
        this.impliedPdsList = new Vector();
        this.impliedPdsMembers = new HashMap();
        this.zOSConnectable = (IZOSConnectable)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.zos.comm.connection");
    }

    public ImportDataSetWizardPage(int wizMode, boolean importSource, String dsName) {
        super("Import from data set wizard");
        this.wizMode = wizMode;
        this.setTitle(ExplorerEclipseCommonPlugin.getLabel().getString("IMPORT_DATASET_WIZARD_PAGE_TITLE"));
        if (importSource) {
            if (wizMode == 3) {
                this.setDescription(ExplorerEclipseCommonPlugin.getDescription().getString("IMPORT_DATASET_INSTR_SRC_SEARCH_PDS"));
            } else {
                this.setDescription(ExplorerEclipseCommonPlugin.getDescription().getString("IMPORT_DATASET_INSTR_SRC"));
            }
        } else {
            this.setDescription(ExplorerEclipseCommonPlugin.getDescription().getString("IMPORT_DATASET_INSTR_COPYBOOKS"));
        }
        this.setImageDescriptor(Utility.getImageDescriptor("host_connect_import_wizard_64.gif"));
        this.impliedPdsList = new Vector();
        this.impliedPdsMembers = new HashMap();
        this.zOSConnectable = (IZOSConnectable)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.zos.comm.connection");
        this.dsName = dsName;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)data);
        this.setControl((Control)this.composite);
        GridLayout gridLayout = new GridLayout(2, false);
        this.composite.setLayout((Layout)gridLayout);
        this.createConnectableArea(this.composite);
        this.createDataSetsArea(this.composite);
        this.initWidgets();
    }

    private void initWidgets() {
        this.setConnectable((IZOSConnectable)this.connService.getConnectable("com.ibm.cics.zos.comm.connection"));
    }

    public boolean isPageComplete() {
        List<DataEntry> selectedItems = this.selTree.getSelections();
        return selectedItems != null && selectedItems.size() > 0;
    }

    private void createDataSetsArea(Composite composite) {
        Composite subComposite = new Composite(composite, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        subComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        subComposite.setLayout((Layout)gridLayout);
        boolean multiSelect = false;
        if (this.wizMode == 2) {
            multiSelect = true;
        }
        boolean showOnlyPds = false;
        if (this.wizMode == 3) {
            showOnlyPds = true;
        }
        this.selTree = this.dsName == null ? new NewDataSetSelectionTree(subComposite, showOnlyPds, multiSelect) : new NewDataSetSelectionTree(subComposite, this.dsName, showOnlyPds, multiSelect);
        this.selTree.addTreeSelectionListener(this);
    }

    public void processSelection() throws FileNotFoundException, PermissionDeniedException, ConnectionException {
        List<DataEntry> selectedItems = this.selTree.getSelections();
        this.selectedMembers = new Vector(selectedItems.size());
        for (DataEntry selectedTreeItem : selectedItems) {
            if (selectedTreeItem instanceof PartitionedDataSet) {
                PartitionedDataSet parentPds = (PartitionedDataSet)selectedTreeItem;
                if (this.pdsAlreadyInList(parentPds)) continue;
                this.impliedPdsList.add(parentPds);
                IZOSConnectable zosConn = parentPds.getZOSConnectable();
                List memberList = zosConn.getMembers(parentPds);
                Vector<Member> allChildMembers = new Vector<Member>(memberList.size());
                for (Member currMember : memberList) {
                    allChildMembers.add(currMember);
                }
                this.impliedPdsMembers.put(parentPds, allChildMembers);
                continue;
            }
            if (selectedTreeItem instanceof Member) {
                Member member = (Member)selectedTreeItem;
                this.selectedMembers.add(member);
                String parentPdsPathStr = member.getParentPath();
                IZOSConnectable zosConn = member.getZOSConnectable();
                DataSet parentPds = zosConn.getDataSet(parentPdsPathStr);
                if (!(parentPds instanceof PartitionedDataSet) || this.pdsAlreadyInList((PartitionedDataSet)parentPds)) continue;
                this.impliedPdsList.add((PartitionedDataSet)parentPds);
                List memberList = zosConn.getMembers((PartitionedDataSet)parentPds);
                Vector<Member> allChildMembers = new Vector<Member>(memberList.size());
                for (Member currMember : memberList) {
                    allChildMembers.add(currMember);
                }
                this.impliedPdsMembers.put((PartitionedDataSet)parentPds, allChildMembers);
                continue;
            }
            if (!(selectedTreeItem instanceof SequentialDataSet)) continue;
            SequentialDataSet seqDs = (SequentialDataSet)selectedTreeItem;
            this.selectedMembers.add(new Member(seqDs.getParentPath(), seqDs.getName(), seqDs.getZOSConnectable()));
        }
    }

    private boolean pdsAlreadyInList(PartitionedDataSet pds) {
        boolean retVal = false;
        int i = 0;
        while (i < this.impliedPdsList.size()) {
            if (pds.equals((Object)this.impliedPdsList.get(i))) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public Vector<Member> getSelectedMembers() {
        return this.selectedMembers;
    }

    private void updateItemCount() {
        int itemCount = this.selTree.getSelections().size();
        if (itemCount == 0) {
            this.clearSearchCount();
        } else {
            this.setSearchCount(itemCount);
        }
    }

    private void clearSearchCount() {
        this.searchLabel.setVisible(true);
        this.setSearchCount(0);
    }

    private void setSearchCount(int searchCount) {
        this.searchLabel.setVisible(true);
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(String.valueOf(searchCount));
        sb.append(")");
        this.searchLabel.setText(sb.toString());
        this.searchLabel.getParent().layout();
    }

    private void refresh() {
        this.searchLabel.setVisible(false);
        this.treeMediator.setRoot((Object)this.getRoot());
    }

    private DataSetRequestFilter getRoot() {
        if (this.zOSConnectable != null) {
            return new DataSetRequestFilter(this.filterText.getText().trim(), this.zOSConnectable);
        }
        return null;
    }

    private void createConnectableArea(Composite composite) {
        Label l = new Label(composite, 0);
        l.setText(ExplorerEclipseCommonPlugin.getLabel().getString("IMPORT_DATASET_CONN_LABEL") + ExplorerEclipseCommonPlugin.getColon().getString("COLON"));
        this.connService = ConnectionsPlugin.getDefault().getConnectionService();
        this.connectionWidgetManager = new ConnectionWidgetManager(this.connService);
        ConnectionStatus connectionStatus = new ConnectionStatus(composite, 0, this.connectionWidgetManager.getConnectionStatusController());
        this.connService.addConnectionServiceListener(this.getConnectionServiceListener());
        this.connectionWidgetManager.setConnectionStateViewer((IConnectionStateViewer)connectionStatus);
        GridData data = new GridData(16384, 0x1000000, true, false);
        connectionStatus.setLayoutData((Object)data);
        this.connectionWidgetManager.setCurrentCategory("com.ibm.cics.zos.comm.connection");
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImportDataSetWizardPage.this.connectionWidgetManager.dispose();
                ImportDataSetWizardPage.this.getConnectionServiceListener().makeStale();
            }
        });
    }

    private void setConnectable(IZOSConnectable aZOSConnectable) {
        this.zOSConnectable = aZOSConnectable;
        if (this.filterText == null) {
            return;
        }
        if (this.zOSConnectable == null || this.zOSConnectable.getConnection() == null) {
            this.treeMediator.setRoot(null);
            this.filterText.setEnabled(false);
            this.searchLabel.setVisible(false);
        } else {
            this.filterText.setEnabled(true);
            if (!Utilities.hasContent((String)this.filterText.getText())) {
                this.filterText.setText(this.zOSConnectable.getConnection().getConfiguration().getUserID());
            }
            this.refresh();
        }
        this.getWizard().getContainer().updateButtons();
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        if (this.connectionServiceListener == null) {
            this.connectionServiceListener = new ConnectionServiceListener(){

                public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (event.getConnectionCategoryId().equals("com.ibm.cics.zos.comm.connection")) {
                        ImportDataSetWizardPage.this.composite.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                                    ImportDataSetWizardPage.this.setConnectable(null);
                                    ImportDataSetWizardPage.this.setErrorMessage(((ConnectionServiceListener.ExceptionEvent)event).getException().getMessage());
                                } else if (!(event instanceof ConnectionServiceListener.ConnectingEvent)) {
                                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                        ImportDataSetWizardPage.this.setConnectable((IZOSConnectable)event.getConnectable());
                                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                        ImportDataSetWizardPage.this.setConnectable(null);
                                    }
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.connectionServiceListener;
    }

    public Vector<PartitionedDataSet> getImpliedPdsList() {
        return this.impliedPdsList;
    }

    public HashMap<PartitionedDataSet, Vector<Member>> getImpliedPdsMembers() {
        return this.impliedPdsMembers;
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.setPageComplete(this.isPageComplete());
    }
}

