/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.utilities;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.ExplorerEclipseCommonPlugin;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static Map<String, ImageDescriptor> imageCache;
    private static char[] specialChar;

    static {
        specialChar = new char[]{'<', '>', '&', '\\', '/', '!', '%', '(', ')', '*', '|', '+', '-', ',', '.', ':', ';', '=', '?', '[', ']', '{', '}', '^', '`', '~', ' ', '\"', '\''};
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        ImageDescriptor img;
        if (imageCache == null) {
            imageCache = new HashMap<String, ImageDescriptor>();
        }
        if ((img = imageCache.get(fileName)) == null) {
            Bundle bundle = ExplorerEclipseCommonPlugin.getDefault().getBundle();
            Path iconPath = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)bundle, (IPath)iconPath, null);
            img = ImageDescriptor.createFromURL((URL)url);
            imageCache.put(fileName, img);
        }
        return img;
    }

    public static URL getURL(String path) {
        try {
            ExplorerEclipseCommonPlugin plugin = ExplorerEclipseCommonPlugin.getDefault();
            URL installURL = plugin.getBundle().getEntry(File.separator);
            URL url = FileLocator.resolve((URL)installURL);
            return new URL(url, path);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static String removeFileExt(String name) {
        int marker = name.indexOf(".");
        if (marker > -1) {
            return name.substring(0, marker);
        }
        return name;
    }

    public static boolean isValidName(String name) {
        Object invalidChars = "";
        char[] cArray = specialChar;
        int n = specialChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            invalidChars = (String)invalidChars + c;
            ++n2;
        }
        int i = 0;
        while (i < name.length()) {
            if (((String)invalidChars).contains(String.valueOf(name.charAt(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

