/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.files;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.utilities.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ProjectTreeFileHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String JAVA_METADATA_FOLDER = "IMS Universal Drivers Metadata";
    public static final String PSB_FOLDER = "PSB";

    public static IFolder getTopJavaMetadataFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder retVal = project.getFolder(JAVA_METADATA_FOLDER);
        return retVal;
    }

    public static IProject getProjectFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject retVal = wsRoot.getProject(projectName);
        return retVal;
    }

    public static String getCurrentDir() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public static ArrayList<String> getProjectList(String[] projectNature) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> projectNames = new ArrayList<String>();
        IResource[] resources = root.members();
        if (resources.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            try {
                IProject temp = (IProject)resources[i];
                boolean strCompare = Arrays.equals(temp.getDescription().getNatureIds(), projectNature);
                if (resources[i] instanceof IProject && strCompare) {
                    projectNames.add(temp.getName());
                }
            }
            catch (Throwable e) {
                logger.throwing("ProjectTreeFileHelper", "getProjectList(String[] projectNature)", e);
            }
            ++i;
        }
        return projectNames;
    }

    public static Vector<String> getDatabaseViewPSBNames(String projectName) throws CoreException {
        Vector<String> retVal = new Vector<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dbViewFolder = project.getFolder(JAVA_METADATA_FOLDER);
        if (dbViewFolder.exists()) {
            IResource[] members = dbViewFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IFolder && ((IFolder)member).members().length > 0) {
                    String psbName = member.getName();
                    retVal.addElement(psbName.toUpperCase());
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Vector<String> getPSBNames(String projectName) throws CoreException {
        Vector<String> retVal = new Vector<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder psbFolder = project.getFolder(PSB_FOLDER);
        if (psbFolder.exists()) {
            IResource[] members = psbFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IFile) {
                    String psbName = Utility.removeFileExt(member.getName());
                    retVal.addElement(psbName.toUpperCase());
                }
                ++i;
            }
        }
        return retVal;
    }
}

