/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.eclipse.common.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class GridDataBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Integer horizontalAlignment;
    private Integer verticalAlignment;
    private Boolean grabExcessHorizontalSpace;
    private Boolean grabExcessVerticalSpace;
    private Integer horizontalSpan;
    private Integer verticalSpan;
    private Integer horizontalIndent;
    private Integer verticalIndent;
    private Integer heightHint;
    private Integer widthHint;
    private Integer minimumHeight;
    private Integer minimumWidth;

    public GridData build() {
        GridData gridData = new GridData(this.horizontalAlignment == null ? 4 : this.horizontalAlignment, this.verticalAlignment == null ? 4 : this.verticalAlignment, this.grabExcessHorizontalSpace == null ? false : this.grabExcessHorizontalSpace, this.grabExcessVerticalSpace == null ? false : this.grabExcessVerticalSpace, this.horizontalSpan == null ? 1 : this.horizontalSpan, this.verticalSpan == null ? 1 : this.verticalSpan);
        if (this.horizontalIndent != null) {
            gridData.horizontalIndent = this.horizontalIndent;
        }
        if (this.verticalIndent != null) {
            gridData.verticalIndent = this.verticalIndent;
        }
        if (this.heightHint != null) {
            gridData.heightHint = this.heightHint;
        }
        if (this.widthHint != null) {
            gridData.widthHint = this.widthHint;
        }
        if (this.minimumHeight != null) {
            gridData.minimumHeight = this.minimumHeight;
        }
        if (this.minimumWidth != null) {
            gridData.minimumWidth = this.minimumWidth;
        }
        return gridData;
    }

    public GridDataBuilder horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public GridDataBuilder verticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public GridDataBuilder grabExcessHorizontalSpace(boolean grabExcessHorizontalSpace) {
        this.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        return this;
    }

    public GridDataBuilder grabExcessVerticalSpace(boolean grabExcessVerticalSpace) {
        this.grabExcessVerticalSpace = grabExcessVerticalSpace;
        return this;
    }

    public GridDataBuilder horizontalSpan(int horizontalSpan) {
        this.horizontalSpan = horizontalSpan;
        return this;
    }

    public GridDataBuilder verticalSpan(int verticalSpan) {
        this.verticalSpan = verticalSpan;
        return this;
    }

    public GridDataBuilder horizontalIndent(int horizontalIndent) {
        this.horizontalIndent = horizontalIndent;
        return this;
    }

    public GridDataBuilder verticalIndent(int verticalIndent) {
        this.verticalIndent = verticalIndent;
        return this;
    }

    public GridDataBuilder heightHint(int heightHint) {
        this.heightHint = heightHint;
        return this;
    }

    public GridDataBuilder widthHint(int widthHint) {
        this.widthHint = widthHint;
        return this;
    }

    public GridDataBuilder minimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
        return this;
    }

    public GridDataBuilder minimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
        return this;
    }

    public boolean isSetHorizontalAlignment() {
        return this.horizontalAlignment != null;
    }

    public boolean isSetVerticalAlignment() {
        return this.verticalAlignment != null;
    }

    public boolean isSetGrabExcessHorizontalSpace() {
        return this.grabExcessHorizontalSpace != null;
    }

    public boolean isSetGrabExcessVerticalSpace() {
        return this.grabExcessVerticalSpace != null;
    }

    public boolean isSetHorizontalSpan() {
        return this.horizontalSpan != null;
    }

    public boolean isSetVerticalSpan() {
        return this.verticalSpan != null;
    }

    public boolean isSetHorizontalIndent() {
        return this.horizontalIndent != null;
    }

    public boolean isSetVerticalIndent() {
        return this.verticalIndent != null;
    }

    public boolean isSetHeightHint() {
        return this.heightHint != null;
    }

    public boolean isSetWidthHint() {
        return this.widthHint != null;
    }

    public boolean isSetMinimumHeight() {
        return this.minimumHeight != null;
    }

    public boolean isSetMinimumWidth() {
        return this.minimumWidth != null;
    }

    public static boolean setWidthHint(Control control, int widthHint) {
        if (control != null && control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).widthHint = widthHint;
        }
        return false;
    }

    public static boolean setHeightHint(Control control, int heightHint) {
        if (control != null && control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).heightHint = heightHint;
        }
        return false;
    }
}

