/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.eclipse.common.swt;

import com.ibm.ims.explorer.eclipse.common.swt.AbstractFormControlBuilder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FormSectionBuilder
extends AbstractFormControlBuilder<Section> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private Boolean expanded;
    private Integer clientVerticalSpacing;
    private Integer descriptionVerticalSpacing;

    public FormSectionBuilder(FormToolkit toolkit) {
        super(toolkit);
    }

    public FormSectionBuilder text(String text) {
        this.text = text;
        return this;
    }

    public FormSectionBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    public FormSectionBuilder expanded(Boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public FormSectionBuilder clientVerticalSpacing(Integer clientVerticalSpacing) {
        this.clientVerticalSpacing = clientVerticalSpacing;
        return this;
    }

    public FormSectionBuilder descriptionVerticalSpacing(Integer descriptionVerticalSpacing) {
        this.descriptionVerticalSpacing = descriptionVerticalSpacing;
        return this;
    }

    @Override
    public Section build(Composite parent) {
        Section control = this.getToolkit().createSection(parent, this.getStyle().intValue());
        GridData gridData = this.getGridDataBuilder().build();
        control.setLayoutData((Object)gridData);
        control.clientVerticalSpacing = 0;
        control.descriptionVerticalSpacing = 0;
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        if (this.expanded != null) {
            control.setExpanded(this.expanded.booleanValue());
        }
        if (this.clientVerticalSpacing != null) {
            control.clientVerticalSpacing = this.clientVerticalSpacing;
        }
        if (this.descriptionVerticalSpacing != null) {
            control.descriptionVerticalSpacing = this.descriptionVerticalSpacing;
        }
        this.setCommonAttrs((Control)control, this);
        return control;
    }
}

