/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.eclipse.common.swt;

import com.ibm.ims.explorer.eclipse.common.swt.AbstractControlBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.GridDataBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBuilder
extends AbstractControlBuilder<Combo> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private List<String> items = new ArrayList<String>();

    public ComboBuilder text(String text) {
        this.text = text;
        return this;
    }

    public ComboBuilder item(String item) {
        this.items.add(item);
        return this;
    }

    public ComboBuilder items(String[] items) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.items.add(item);
            ++n2;
        }
        return this;
    }

    public ComboBuilder items(List<String> items) {
        this.items.addAll(items);
        return this;
    }

    public ComboBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    @Override
    public Combo build(Composite parent) {
        Combo control = new Combo(parent, this.getStyle().intValue());
        GridDataBuilder gridDataBuilder = this.getGridDataBuilder();
        GridData gridData = gridDataBuilder.build();
        control.setLayoutData((Object)gridData);
        if (!this.items.isEmpty()) {
            for (String item : this.items) {
                control.add(item);
            }
        }
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

