/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.eclipse.common.swt;

import com.ibm.ims.explorer.eclipse.common.swt.AbstractControlBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.GridDataBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ButtonBuilder
extends AbstractControlBuilder<Button> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private Image image;
    private Boolean checked;

    public ButtonBuilder text(String text) {
        this.text = text;
        return this;
    }

    public ButtonBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    public ButtonBuilder image(Image image) {
        this.image = image;
        return this;
    }

    public ButtonBuilder checked(Boolean checked) {
        this.checked = checked;
        return this;
    }

    @Override
    public Button build(Composite parent) {
        Button control = new Button(parent, this.getStyle().intValue());
        GridDataBuilder gridDataBuilder = this.getGridDataBuilder();
        GridData gridData = gridDataBuilder.build();
        control.setLayoutData((Object)gridData);
        if (this.text != null) {
            control.setText(this.text);
        }
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        if (this.image != null) {
            control.setImage(this.image);
        }
        if (this.checked != null) {
            control.setSelection(this.checked.booleanValue());
        }
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

