/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.eclipse.common.preferences;

import com.ibm.ims.explorer.eclipse.common.ExplorerEclipseCommonPlugin;
import com.ibm.ims.explorer.eclipse.common.preferences.LoggingPreferenceConstants;
import com.ibm.ims.explorer.eclipse.common.swt.ButtonBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.CompositeBuilder;
import com.ibm.ims.explorer.eclipse.common.swt.GroupBuilder;
import java.util.logging.Level;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LoggingPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
LoggingPreferenceConstants {
    private static IPreferenceStore prefStore = ExplorerEclipseCommonPlugin.getDefault().getPreferenceStore();
    private String loggingLevelName;
    private Button severeLevelBtn;
    private Button warningLevelBtn;
    private Button infoLevelBtn;
    private Button configLevelBtn;
    private Button fineLevelBtn;
    private Button finerLevelBtn;
    private Button finestLevelBtn;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite body = (Composite)new CompositeBuilder().numColumns(1).grabExcessHorizontalSpace(true).build(parent);
        Group selectLevelGroup = (Group)new GroupBuilder().text(LoggingPreferencesPage.getLabel("LOGGING_CONFIG_LEVEL_TITLE")).grabExcessHorizontalSpace(true).build(body);
        this.severeLevelBtn = (Button)new ButtonBuilder().text(Level.SEVERE.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.SEVERE.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.warningLevelBtn = (Button)new ButtonBuilder().text(Level.WARNING.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.WARNING.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.infoLevelBtn = (Button)new ButtonBuilder().text(Level.INFO.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.INFO.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.configLevelBtn = (Button)new ButtonBuilder().text(Level.CONFIG.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.CONFIG.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.fineLevelBtn = (Button)new ButtonBuilder().text(Level.FINE.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.FINE.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.finerLevelBtn = (Button)new ButtonBuilder().text(Level.FINER.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.FINER.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.finestLevelBtn = (Button)new ButtonBuilder().text(Level.FINEST.getName()).style(16).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferencesPage.this.loggingLevelName = Level.FINEST.getName();
            }
        }).build((Composite)selectLevelGroup);
        this.loggingLevelName = prefStore.getString("LOGGING_LEVEL");
        Level currentLevel = Level.parse(this.loggingLevelName);
        this.updateLevelSelection(currentLevel);
        return body;
    }

    private void updateLevelSelection(Level level) {
        this.severeLevelBtn.setSelection(false);
        this.warningLevelBtn.setSelection(false);
        this.infoLevelBtn.setSelection(false);
        this.configLevelBtn.setSelection(false);
        this.fineLevelBtn.setSelection(false);
        this.finerLevelBtn.setSelection(false);
        this.finestLevelBtn.setSelection(false);
        if (Level.SEVERE.equals(level)) {
            this.severeLevelBtn.setSelection(true);
        } else if (Level.WARNING.equals(level)) {
            this.warningLevelBtn.setSelection(true);
        } else if (Level.INFO.equals(level)) {
            this.infoLevelBtn.setSelection(true);
        } else if (Level.CONFIG.equals(level)) {
            this.configLevelBtn.setSelection(true);
        } else if (Level.FINE.equals(level)) {
            this.fineLevelBtn.setSelection(true);
        } else if (Level.FINER.equals(level)) {
            this.finerLevelBtn.setSelection(true);
        } else if (Level.FINEST.equals(level)) {
            this.finestLevelBtn.setSelection(true);
        }
    }

    protected void performDefaults() {
        String defaultLevelName = prefStore.getDefaultString("LOGGING_LEVEL");
        Level defaultLevel = Level.parse(defaultLevelName);
        this.updateLevelSelection(defaultLevel);
    }

    protected void performApply() {
        prefStore.setValue("LOGGING_LEVEL", this.loggingLevelName);
        super.performApply();
    }

    public boolean performOk() {
        prefStore.setValue("LOGGING_LEVEL", this.loggingLevelName);
        return super.performOk();
    }

    private static String getLabel(String key) {
        return ExplorerEclipseCommonPlugin.getLabel().getString(key);
    }
}

