/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.explorer.eclipse.common.logger;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.ExplorerEclipseCommonPlugin;
import com.ibm.ims.explorer.eclipse.common.preferences.LoggingPreferenceConstants;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class ExplorerLogger
implements IExplorerLogger,
LoggingPreferenceConstants {
    private static IPreferencesService prefServ = Platform.getPreferencesService();
    private static ExplorerLogger instance;

    public static ExplorerLogger instance() {
        if (instance == null) {
            instance = new ExplorerLogger();
        }
        return instance;
    }

    private ExplorerLogger() {
    }

    public boolean isLoggable(Level level) {
        boolean loggable = false;
        if (this.getLoggingLevel().intValue() <= level.intValue()) {
            loggable = true;
        }
        return loggable;
    }

    public IStatus entering(String className, String method, Object ... args) {
        if (!this.isLoggable(Level.FINER)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Long threadId = Thread.currentThread().getId();
        Object message = "Thread " + String.valueOf(threadId) + " entering " + className + "#" + method + " at " + String.valueOf(currTime) + "...";
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus entering() {
        if (!this.isLoggable(Level.FINER)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Thread currThread = Thread.currentThread();
        Long threadId = currThread.getId();
        String callerQName = this.getCallerCanonicalName(currThread);
        String message = "Thread " + String.valueOf(threadId) + " entering " + callerQName + " at " + String.valueOf(currTime) + "...";
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus info(String msg, Object ... args) {
        Object message;
        if (!this.isLoggable(Level.INFO)) {
            return Status.OK_STATUS;
        }
        Object object = message = msg == null ? "" : msg;
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus info(String msg, Throwable throwable, Object ... args) {
        Object message;
        if (!this.isLoggable(Level.INFO)) {
            return Status.OK_STATUS;
        }
        Object object = message = msg == null ? "" : msg;
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message, throwable);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus warn(String msg, Object ... args) {
        Object message;
        if (!this.isLoggable(Level.WARNING)) {
            return Status.OK_STATUS;
        }
        Object object = message = msg == null ? "" : msg;
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(2, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus warn(String msg, Throwable throwable, Object ... args) {
        Object message;
        if (!this.isLoggable(Level.WARNING)) {
            return Status.OK_STATUS;
        }
        Object object = message = msg == null ? "" : msg;
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(2, "com.ibm.ims.explorer.eclipse.common", (String)message, throwable);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus error(String msg, Object ... args) {
        Object message;
        if (!this.isLoggable(Level.SEVERE)) {
            return Status.OK_STATUS;
        }
        Object object = message = msg == null ? "" : msg;
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(4, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus error(String msg, Throwable throwable, Object ... args) {
        Object message;
        if (!this.isLoggable(Level.SEVERE)) {
            return Status.OK_STATUS;
        }
        Object object = message = msg == null ? "" : msg;
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(4, "com.ibm.ims.explorer.eclipse.common", (String)message, throwable);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus throwing(String className, String method, Throwable throwable) {
        if (!this.isLoggable(Level.INFO)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Long threadId = Thread.currentThread().getId();
        String message = "Thread " + String.valueOf(threadId) + " in " + className + "#" + method + " throwing exception " + String.valueOf(throwable) + " at " + String.valueOf(currTime) + "...";
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus error(Throwable t) {
        if (!this.isLoggable(Level.SEVERE) || t == null) {
            return Status.OK_STATUS;
        }
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        String message = callerQName + ": " + t.getMessage();
        Status status = new Status(4, "com.ibm.ims.explorer.eclipse.common", message, t);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus exiting(String className, String method, Object ... args) {
        if (!this.isLoggable(Level.FINER)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Long threadId = Thread.currentThread().getId();
        Object message = "Thread " + String.valueOf(threadId) + " exiting " + className + "#" + method + " at " + String.valueOf(currTime) + "...";
        if (args != null && args.length > 0) {
            String patternMsg = this.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus exiting() {
        if (!this.isLoggable(Level.FINER)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Thread currThread = Thread.currentThread();
        Long threadId = currThread.getId();
        String callerQName = this.getCallerCanonicalName(currThread);
        String message = "Thread " + String.valueOf(threadId) + " exiting " + callerQName + " at " + String.valueOf(currTime) + "...";
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus fine(String msg) {
        if (!this.isLoggable(Level.FINE)) {
            return Status.OK_STATUS;
        }
        Object message = msg == null ? "" : msg;
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus finer(String msg) {
        if (!this.isLoggable(Level.FINER)) {
            return Status.OK_STATUS;
        }
        Object message = msg == null ? "" : msg;
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    public IStatus finest(String msg) {
        if (!this.isLoggable(Level.FINEST)) {
            return Status.OK_STATUS;
        }
        Object message = msg == null ? "" : msg;
        String callerQName = this.getCallerCanonicalName(Thread.currentThread());
        message = callerQName + ": " + (String)message;
        Status status = new Status(1, "com.ibm.ims.explorer.eclipse.common", (String)message);
        this.getLog().log((IStatus)status);
        return status;
    }

    private ILog getLog() {
        return ExplorerEclipseCommonPlugin.getDefault().getLog();
    }

    public String insertArgumentPlaceholders(String msg, int numOfInserts) {
        if (numOfInserts == 0) {
            return msg;
        }
        if (msg.contains("{0}")) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg);
        sb.append(" [");
        int i = 0;
        while (i < numOfInserts) {
            sb.append(" {" + i + "} ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public IStatus createMultiStatus(int severity, String message, Throwable exception) {
        ArrayList<Status> childStatus = new ArrayList<Status>();
        if (exception == null) {
            exception = new Exception();
        }
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ele = stackTraceElementArray[n2];
            childStatus.add(new Status(4, "com.ibm.ims.explorer.eclipse.common", this.getExternalMessage(ele)));
            ++n2;
        }
        MultiStatus status = new MultiStatus("com.ibm.ims.explorer.eclipse.common", 4, childStatus.toArray(new IStatus[0]), message, exception);
        return status;
    }

    public IStatus createMultiStatus(int severity, String message, List<Throwable> errors) {
        if (errors == null || errors.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.ims.explorer.eclipse.common", severity, message, errors.get(0));
        for (Throwable t : errors) {
            multiStatus.add((IStatus)new Status(severity, "com.ibm.ims.explorer.eclipse.common", t.getMessage(), t));
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                multiStatus.add((IStatus)new Status(severity, "com.ibm.ims.explorer.eclipse.common", "    at " + ste.toString()));
                ++n2;
            }
        }
        return multiStatus;
    }

    public String getExternalMessage(StackTraceElement ele) {
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append(ele.getClassName());
        msgBuf.append(".");
        msgBuf.append(ele.getMethodName());
        msgBuf.append("(");
        if (ele.isNativeMethod()) {
            msgBuf.append("Native Method");
        } else if (ele.getFileName() != null) {
            msgBuf.append(ele.getFileName());
            if (ele.getLineNumber() >= 0) {
                msgBuf.append(":");
                msgBuf.append(ele.getLineNumber());
            }
        } else {
            msgBuf.append("Unknown Source");
        }
        msgBuf.append(")");
        return msgBuf.toString();
    }

    private String getCallerCanonicalName(Thread thread) {
        StringBuilder canonName = new StringBuilder();
        StackTraceElement[] stackTrace = thread.getStackTrace();
        if (stackTrace.length > 3) {
            StackTraceElement callerElement = stackTrace[3];
            canonName.append(callerElement.getClassName());
            canonName.append("#");
            canonName.append(callerElement.getMethodName());
        } else {
            canonName.append("Unknown");
        }
        return canonName.toString();
    }

    public Level getLoggingLevel() {
        String levelName = prefServ.getString("com.ibm.ims.explorer.eclipse.common", "LOGGING_LEVEL", DEFAULT_LOGGING_LEVEL_NAME, null);
        if (levelName == null || levelName.isBlank()) {
            levelName = DEFAULT_LOGGING_LEVEL_NAME;
        }
        return Level.parse(levelName);
    }
}

