/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.wizards;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.datastores.DynamicPropStore;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUINestedLayoutInfoWrapper;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class MessageBundleWizardDynamicPage_PropertyGroup
extends MessageBundleWizardDynamicPage {
    protected PropertyUIComposite uiComposite_;

    public MessageBundleWizardDynamicPage_PropertyGroup(String name) {
        super(name);
    }

    public MessageBundleWizardDynamicPage_PropertyGroup(String name, PropertyUIMessageBundle newBundle) {
        super(name, newBundle);
    }

    @Override
    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        this.setPageComplete(false);
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.uiComposite_ != null) {
            this.uiComposite_.dispose();
        }
    }

    @Override
    public ArrayList<PropertyUIWidget> getUIWidgets() {
        if (this.uiComposite_ != null) {
            return this.uiComposite_.getUIWidgets();
        }
        return null;
    }

    public IPropertyGroup getPropertyGroup() {
        if (this.uiComposite_ != null) {
            return this.uiComposite_.getPropertyGroup();
        }
        return null;
    }

    public PropertyUIComposite getPropertyUICompoiste() {
        return this.uiComposite_;
    }

    public void generateDynamicLayout(Composite container, PropertyUIFactory uiFactory, IPropertyGroup properties) {
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        String helpContextIdPrefix = this.getHelpContextIdPrefix();
        if (helpContextIdPrefix == null) {
            helpContextIdPrefix = "other";
        }
        StringBuffer helpid = new StringBuffer(helpContextIdPrefix);
        helpid.append("_");
        helpid.append(PropertyUtil.getPropertyNameForHelp((IPropertyDescriptor)properties));
        this.cleanCurrentPropertyUIComposite();
        this.uiComposite_ = uiFactory.generatePropertyUI(container, properties);
        this.uiComposite_.addPropertyUIChangeListener(this);
        if (container instanceof SharedScrolledComposite) {
            ((SharedScrolledComposite)container).setContent((Control)this.uiComposite_.getComposite());
            ((SharedScrolledComposite)container).reflow(true);
        } else if (container instanceof ScrolledComposite) {
            Composite main = this.uiComposite_.getComposite();
            ((ScrolledComposite)container).setContent((Control)main);
            Point p = main.computeSize(-1, -1);
            main.setSize(p.x, p.y);
            ((ScrolledComposite)container).setMinSize(p);
            whs.setHelp((Control)main, helpid.toString());
        }
        this.handleAdvancedSection(properties, whs, helpid.toString());
    }

    protected void handleAdvancedSection(final IPropertyGroup aProperties, IWorkbenchHelpSystem whs, String helpid) {
        ArrayList<PropertyUINestedLayoutInfoWrapper> nestedUIInfo;
        Button advancedButton = this.uiComposite_.getAdvancedButton();
        if (advancedButton != null) {
            whs.setHelp((Control)advancedButton, helpid.toString());
            advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessageBundleWizardDynamicPage_PropertyGroup.this.showAdvancedSection(MessageBundleWizardDynamicPage_PropertyGroup.this.uiComposite_.isShowingAll(), aProperties);
                }
            });
        }
        if ((nestedUIInfo = this.uiComposite_.getNestedLayoutInfo()) != null && !nestedUIInfo.isEmpty()) {
            int i = 0;
            while (i < nestedUIInfo.size()) {
                final PropertyUIComposite uiComposite = (PropertyUIComposite)nestedUIInfo.get(i).getNestedLayoutInfo();
                advancedButton = uiComposite.getAdvancedButton();
                if (advancedButton != null) {
                    whs.setHelp((Control)advancedButton, helpid.toString());
                    advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MessageBundleWizardDynamicPage_PropertyGroup.this.showAdvancedSection(uiComposite.isShowingAll(), aProperties, uiComposite);
                        }
                    });
                }
                ++i;
            }
        }
    }

    protected void cleanCurrentPropertyUIComposite() {
        if (this.uiComposite_ != null) {
            this.uiComposite_.dispose();
        }
    }

    public void saveToStore() {
        this.savePropertiesToStore(this.getName(), this.getPropertyGroup());
    }

    @Override
    public void saveToStore(IProgressMonitor monitor) {
        this.savePropertiesToStore(this.getName(), this.getPropertyGroup());
    }

    protected void savePropertiesToStore(String key, IPropertyGroup properties) {
        DynamicPropStore store = this.getDynamicPropStore(true);
        if (store != null) {
            store.storePropertyValues(key, properties);
        }
    }

    protected void restorePropertiesFromStore(String key, ArrayList<PropertyUIWidget> widgets, IPropertyGroup properties) {
        DynamicPropStore store;
        if (widgets != null && !widgets.isEmpty() && (store = this.getDynamicPropStore(true)) != null) {
            store.restoreSuggestionsOnWidgets(key, widgets);
        }
    }

    public void displayPage(IPropertyGroup properties) {
        SharedScrolledComposite parent = (SharedScrolledComposite)this.getControl();
        this.displayPage((Composite)parent, properties);
    }

    protected void displayPage(Composite container, IPropertyGroup properties) {
        if (properties == null) {
            return;
        }
        IPropertyGroup oldProperties = this.getPropertyGroup();
        if (!properties.equals(oldProperties)) {
            Shell shell = this.getShell();
            Cursor cur = null;
            if (shell != null) {
                Display d = shell.getDisplay();
                cur = new Cursor((Device)d, 1);
                shell.setCursor(cur);
            }
            PropertyUIFactory uiFactory = this.getPropertyUIFactory();
            this.generateDynamicLayout(container, uiFactory, properties);
            this.loadPropertyDefaultValue();
            if (shell != null) {
                shell.setCursor(null);
            }
            if (cur != null) {
                cur.dispose();
            }
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    public PropertyUIFactory getPropertyUIFactory() {
        PropertyUIFactory factory = PropertyUIFactory.instance();
        if (this.contextPrefix_ != null) {
            factory.setHelpContextIdPrefix(this.contextPrefix_);
        }
        factory.setRootGroupingStyle(1);
        return factory;
    }

    public void loadPropertyDefaultValue() {
        this.restorePropertiesFromStore(this.getName(), this.getUIWidgets(), this.getPropertyGroup());
    }

    public void showAdvancedSection(boolean show, IPropertyGroup properties) {
        this.showAdvancedSection(show, properties, this.uiComposite_);
    }

    protected void showAdvancedSection(boolean show, IPropertyGroup properties, PropertyUIComposite uiComposite) {
        this.FirstOpens_ = false;
        if (show) {
            this.restorePropertiesFromStore(this.getName(), this.getUIWidgets(), properties);
            if (uiComposite != null && uiComposite.getAdvancedArea() != null && uiComposite.getRootGroupingStyle() != 0 && uiComposite.getAdvancedArea().getChildren().length > 1) {
                ((IWizardContainer2)this.getWizard().getContainer()).updateSize();
            }
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    @Override
    public void propertyUIChange(PropertyUIChangeEvent evt) {
        super.propertyUIChange(evt);
        if (evt.getSource() instanceof PropertyUIComposite.PropertyUIWidgetPG) {
            this.restorePropertiesFromStore(this.getName(), this.getUIWidgets(), this.getPropertyGroup());
        }
    }
}

